
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt

SLIDE_WIN=10
ALPHA=.2

def sliding_avg(input_data, slide_win=5):
    input_len = len(input_data)
    output_data = []
    output_data.append(input_data[0])
    for x in range(slide_win, input_len, slide_win):
        avg_value = np.mean(input_data[x:x+slide_win])
        output_data.append(avg_value)
        pass
    output_axis = np.linspace(0, input_len, len(output_data))
    return output_axis, output_data


def draw_icml(Fed_E2S,Fed_E2E,Base_FedAvg,Base_FedCyCP,sfl,file_name,loc):
    mpl.rcParams['lines.linewidth'] = 2
    x = np.arange(0,1000)

    xys = make_interp_spline(x,Fed_E2S)
    x_z = np.linspace(0, 999, 1000)
    FedE2S_s = xys(x_z)
    
    xys = make_interp_spline(x,Fed_E2E)
    x_e = np.linspace(0, 999, 1000)
    Fed_E2E_s = xys(x_e)

    xys = make_interp_spline(x,Base_FedAvg)
    x_f = np.linspace(0,999, 1000)
    Base_FedAvg_s = xys(x_f)

    xys = make_interp_spline(x,Base_FedCyCP)
    x_c = np.linspace(0, 999, 1000)
    Base_FedCyCP_s = xys(x_c)
    
    xys = make_interp_spline(x,sfl)
    x_sf = np.linspace(0,999,1000)
    sfl_s = xys(x_sf)

    fig0 = plt.figure(figsize=plt.figaspect(1))
    ax0 = fig0.add_subplot(1,1,1)
    ax0.grid(linestyle='-')
    fig0.set_figwidth(4)
    fig0.set_figheight(4)

    #line1=ax0.plot(x_m,m_3_test_s,color="C1",linestyle='solid',label='Mean Imputation',markersize = 15, marker=".",markevery=50)
#     ax0.plot(x_z,FedE2S_s,color='C2',linestyle='solid',label='HFL-E2S')
#     ax0.plot(x_e,Fed_E2E_s,color='C3',linestyle='solid',label='HFL-E2E',)
#     ax0.plot(x_f,Base_FedAvg_s,color="C0",linestyle='solid',label='Base_FedAvg')
#     ax0.plot(x_c,Base_FedCyCP_s,color="#b28c6e",linestyle='solid',label='Base_FedCyCP')
    
    
    avg_x_z, avg_FedE2S_s = sliding_avg(FedE2S_s, slide_win=SLIDE_WIN)
    avg_x_e, avg_Fed_E2E_s = sliding_avg(Fed_E2E_s, slide_win=SLIDE_WIN)
    avg_x_f, avg_Base_FedAvg_s = sliding_avg(Base_FedAvg_s, slide_win=SLIDE_WIN)
    avg_x_c, avg_Base_FedCyCP_s = sliding_avg(Base_FedCyCP_s, slide_win=SLIDE_WIN)
    avg_x_sfl, avg_sfl_s = sliding_avg(sfl_s, slide_win=SLIDE_WIN)
    

    ax0.plot(avg_x_z, avg_FedE2S_s, color = 'C2', linestyle = 'solid', label = 'HFL-E2S')
    ax0.plot(avg_x_e, avg_Fed_E2E_s, color = 'C3', linestyle = 'solid', label = 'HFL-E2E')
    ax0.plot(avg_x_f, avg_Base_FedAvg_s, color = "C0", linestyle = 'solid', label = 'Base_FedAvg')
    ax0.plot(avg_x_c, avg_Base_FedCyCP_s, color = "C4", linestyle = 'solid', label = 'Base_FedCyCP')
    ax0.plot(avg_x_sfl, avg_sfl_s, color = "C1", linestyle = 'solid', label = 'SFL')

    #legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5,bbox_to_anchor=[1, 0.7])
    legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5)

    ax0.set_xlim(0,999)
    ax0.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
    ax0.set_xticklabels(['0','100','200','300','400','500','600','700','800','900','1000'])
    ax0.set_xlabel('Communication Rounds',fontsize='large',fontweight='bold')
    ax0.set_ylabel('Test Accuracy',fontsize='large',fontweight='bold')
    ax0.set_ylim(0.3,1) #(0.4-1) 
    
    fig0.savefig(file_name,dpi=500,bbox_inches = 'tight')
#icml_24_400=[0.1009,0.0974,0.0974,0.1009,0.0892,0.0892,0.1028,0.0982,0.1028,0.0974,0.1705,0.1347,0.0974,0.1009,0.2356,0.1305,0.1829,0.1214,0.2643,0.1606,0.0892,0.1862,0.1061,0.1975,0.2047,0.3028,0.0974,0.114,0.0998,0.1822,0.1889,0.1942,0.2406,0.3139,0.2951,0.2748,0.2974,0.1062,0.1495,0.4265,0.2547,0.3616,0.1581,0.4512,0.4001,0.3687,0.2403,0.3547,0.3507,0.2297,0.4441,0.1247,0.371,0.3869,0.2443,0.2835,0.4172,0.425,0.414,0.436,0.4962,0.4247,0.4155,0.4877,0.4495,0.378,0.1358,0.4562,0.4212,0.4704,0.4763,0.4717,0.2223,0.4477,0.3686,0.2542,0.531,0.6428,0.5013,0.5487,0.2281,0.6381,0.5242,0.6225,0.6032,0.4201,0.4503,0.4624,0.5585,0.5827,0.4438,0.4273,0.3709,0.4714,0.4034,0.5321,0.5029,0.6018,0.5419,0.2401,0.5949,0.5283,0.591,0.4646,0.5854,0.2891,0.602,0.6018,0.5851,0.6394,0.585,0.605,0.5838,0.6337,0.577,0.35,0.5995,0.6086,0.5729,0.5034,0.6024,0.6658,0.6224,0.6567,0.5986,0.6285,0.6174,0.6129,0.5265,0.516,0.5685,0.3348,0.6012,0.5118,0.4654,0.6287,0.28,0.3282,0.5362,0.5236,0.5932,0.5662,0.664,0.6911,0.6119,0.6261,0.5959,0.5995,0.5891,0.5704,0.6537,0.5178,0.7066,0.6245,0.6757,0.6974,0.6188,0.4154,0.437,0.7135,0.6485,0.5898,0.6376,0.6458,0.6601,0.6883,0.5766,0.6516,0.6434,0.6814,0.6551,0.663,0.6365,0.6279,0.6273,0.4387,0.5035,0.5659,0.613,0.6359,0.6298,0.6383,0.647,0.618,0.5664,0.6156,0.5881,0.6548,0.6464,0.5852,0.6453,0.589,0.5626,0.5693,0.6405,0.669,0.6526,0.4737,0.6663,0.6594,0.4915,0.6486,0.6263,0.5172,0.6579,0.6517,0.5347,0.7071,0.5963,0.6616,0.6064,0.6758,0.5266,0.6265,0.6817,0.6102,0.6507,0.6836,0.6628,0.6633,0.6644,0.7248,0.6932,0.6866,0.7278,0.5817,0.7157,0.6997,0.7007,0.6618,0.6668,0.6613,0.5531,0.6572,0.6488,0.7004,0.6955,0.5297,0.6322,0.5479,0.6376,0.7076,0.6926,0.6479,0.7371,0.7308,0.5863,0.5801,0.7338,0.6493,0.6519,0.6442,0.7304,0.5391,0.6526,0.5618,0.6835,0.6789,0.6918,0.7003,0.682,0.6017,0.6539,0.669,0.6455,0.6784,0.7033,0.6824,0.5701,0.6893,0.6739,0.6318,0.6753,0.6828,0.705,0.6275,0.6216,0.6711,0.705,0.6722,0.6309,0.7006,0.6799,0.7359,0.7121,0.7157,0.7382,0.6584,0.6718,0.7415,0.7166,0.6986,0.6521,0.7082,0.6731,0.6593,0.7322,0.7177,0.7168,0.6819,0.6919,0.7196,0.6709,0.6584,0.6447,0.6774,0.7021,0.668,0.5959,0.6803,0.6602,0.6305,0.5647,0.5697,0.6754,0.7205,0.7174,0.6935,0.6918,0.6824,0.7121,0.6594,0.6741,0.7553,0.6989,0.732,0.7135,0.7352,0.6534,0.6717,0.6547,0.684,0.6616,0.7069,0.7172,0.7534,0.7048,0.734,0.6864,0.6849,0.706,0.7532,0.7208,0.746,0.7105,0.7157,0.7141,0.6764,0.6043,0.6886,0.7132,0.7424,0.6985,0.6352,0.6966,0.7327,0.7241,0.6936,0.7132,0.7084,0.6871,0.6687,0.6586,0.6687,0.7053,0.6307,0.693,0.6724,0.6756,0.6904,0.673,0.6211,0.6983,0.6651,0.7065,0.6697,0.7326,0.7282,0.6997,0.6809,0.7293,0.7219,0.6923,0.6817,0.682,0.6911,0.7237,0.7375,0.7528,0.7406,0.6903,0.7058,0.7538,0.7368,0.7183,0.7478,0.7131,0.6699,0.694,0.6675]
e2e_pc1=[0.101,0.101,0.0892,0.0892,0.1028,0.101,0.1032,0.2088,0.1784,0.1098,0.2238,0.4082,0.5061,0.2468,0.4378,0.4816,0.487,0.4613,0.4479,0.4945,0.3032,0.6577,0.5772,0.5844,0.4911,0.6576,0.717,0.6943,0.5859,0.7584,0.76,0.6657,0.6166,0.6231,0.6208,0.7366,0.7058,0.7528,0.5883,0.7356,0.7258,0.79,0.8356,0.762,0.8056,0.8251,0.8007,0.7908,0.713,0.8175,0.8532,0.8528,0.8099,0.7877,0.8713,0.8311,0.8106,0.8619,0.8241,0.8276,0.8217,0.8066,0.7403,0.8321,0.8839,0.7481,0.8748,0.8676,0.8458,0.8847,0.8573,0.8558,0.8737,0.8308,0.882,0.9099,0.8276,0.8251,0.8986,0.8383,0.8522,0.9087,0.8821,0.8871,0.8726,0.9104,0.9078,0.8166,0.8453,0.8975,0.8972,0.9198,0.8915,0.9031,0.8016,0.8731,0.8845,0.8442,0.8143,0.891,0.9027,0.9191,0.8897,0.8754,0.8454,0.9096,0.8985,0.9313,0.8946,0.9178,0.934,0.9067,0.8891,0.9194,0.8991,0.9135,0.8335,0.8906,0.9261,0.926,0.8771,0.9264,0.9348,0.8853,0.8799,0.887,0.9469,0.8793,0.8703,0.9241,0.875,0.9032,0.9121,0.9318,0.9003,0.8997,0.9127,0.8437,0.904,0.9221,0.9059,0.927,0.8905,0.9236,0.9131,0.9264,0.9251,0.8877,0.9342,0.884,0.9133,0.9457,0.9394,0.8099,0.9329,0.9071,0.9056,0.8523,0.9027,0.8781,0.8918,0.9188,0.9242,0.9112,0.8879,0.8834,0.9035,0.9042,0.9133,0.8842,0.9409,0.9004,0.9168,0.9503,0.9194,0.9193,0.9256,0.9293,0.9103,0.9245,0.9038,0.8754,0.9039,0.9528,0.9159,0.9333,0.9398,0.933,0.9093,0.926,0.9307,0.9366,0.9215,0.9401,0.9264,0.9458,0.9227,0.9313,0.9425,0.9078,0.927,0.929,0.9303,0.9279,0.9229,0.9291,0.9528,0.9294,0.9464,0.939,0.9494,0.9065,0.9275,0.9381,0.921,0.912,0.91,0.882,0.9277,0.9459,0.9431,0.9026,0.9344,0.9328,0.917,0.9349,0.9169,0.9442,0.949,0.8944,0.9146,0.9295,0.9203,0.9407,0.9499,0.9581,0.9605,0.9528,0.9508,0.9633,0.949,0.935,0.9358,0.8934,0.9313,0.9211,0.9512,0.9597,0.9313,0.947,0.91,0.9328,0.9343,0.9335,0.9331,0.9434,0.9384,0.9486,0.9607,0.92,0.9473,0.9441,0.9434,0.9114,0.9355,0.9399,0.9448,0.9334,0.9447,0.9605,0.954,0.9514,0.9496,0.9478,0.9309,0.9474,0.9238,0.9361,0.9612,0.9683,0.9506,0.9245,0.9183,0.9403,0.9354,0.9371,0.9608,0.9512,0.9363,0.9554,0.96,0.9375,0.9517,0.9568,0.9277,0.9337,0.9407,0.947,0.9356,0.9512,0.9475,0.9512,0.9344,0.9548,0.9499,0.9598,0.9417,0.9431,0.9621,0.9437,0.9491,0.951,0.947,0.9434,0.9451,0.9264,0.9091,0.9172,0.943,0.8973,0.9072,0.9449,0.917,0.9217,0.9476,0.9499,0.9573,0.9547,0.9248,0.9453,0.932,0.9248,0.9279,0.9678,0.9562,0.9672,0.9394,0.9431,0.9511,0.9551,0.9482,0.9339,0.9483,0.9601,0.9609,0.9326,0.9604,0.9081,0.9294,0.9373,0.9427,0.9389,0.9432,0.9199,0.935,0.9136,0.9217,0.9185,0.9311,0.9558,0.9285,0.9303,0.9607,0.9627,0.9174,0.9179,0.9367,0.8997,0.9214,0.9498,0.9692,0.9534,0.9426,0.9206,0.9546,0.9364,0.94,0.9468,0.9485,0.9643,0.9641,0.9691,0.9458,0.922,0.9566,0.9493,0.9448,0.9516,0.9371,0.9621,0.9589,0.9568,0.9605,0.968,0.9508,0.962,0.9396,0.9287,0.9694,0.9437,0.9434,0.9197,0.946,0.9337,0.9533,0.9515,0.9593,0.9424,0.9416,0.9451,0.96,0.966,0.9497,0.9696,0.9529,0.9353,0.9397,0.9674,0.9364,0.9449,0.9346,0.9289,0.9319,0.9376,0.9452,0.9377,0.9688,0.955,0.9693,0.9498,0.9244,0.954,0.9435,0.9607,0.9625,0.9409,0.9449,0.941,0.9316,0.9387,0.9714,0.955,0.9402,0.9503,0.9644,0.9569,0.9552,0.933,0.9535,0.9613,0.9675,0.9596,0.9334,0.949,0.9474,0.9496,0.9326,0.9595,0.9388,0.9332,0.9619,0.9575,0.9538,0.9589,0.9457,0.9512,0.9709,0.9684,0.9577,0.9601,0.963,0.9577,0.9596,0.9424,0.9451,0.9442,0.9427,0.949,0.9376,0.9501,0.9434,0.9584,0.9452,0.9482,0.9587,0.9436,0.9461,0.9707,0.9619,0.9613,0.946,0.9613,0.9562,0.9592,0.9555,0.9595,0.9507,0.9566,0.9561,0.9599,0.9686,0.9619,0.9522,0.9712,0.9516,0.9344,0.9393,0.9361,0.9419,0.9458,0.9357,0.9614,0.931,0.9153,0.9428,0.9675,0.9546,0.9703,0.9365,0.965,0.9634,0.9469,0.9083,0.9541,0.9747,0.9454,0.9347,0.9336,0.9259,0.9442,0.9652,0.9681,0.9583,0.955,0.9524,0.9451,0.9491,0.9494,0.9555,0.9316,0.9301,0.9647,0.9489,0.9645,0.9401,0.9582,0.9671,0.9579,0.9684,0.9658,0.9514,0.9728,0.9619,0.9463,0.9429,0.9529,0.933,0.9457,0.9582,0.9452,0.9656,0.9587,0.9716,0.9623,0.9243,0.9661,0.966,0.9557,0.955,0.905,0.9406,0.9633,0.9518,0.9677,0.9628,0.9549,0.9578,0.9416,0.9593,0.9703,0.9677,0.9687,0.9658,0.9652,0.9523,0.9634,0.9375,0.9431,0.9572,0.9312,0.9774,0.9492,0.9607,0.9608,0.9465,0.9542,0.9609,0.9699,0.9706,0.9475,0.9706,0.9464,0.9542,0.9697,0.9479,0.9601,0.9669,0.9584,0.944,0.9436,0.9434,0.9525,0.9607,0.939,0.9443,0.9582,0.9498,0.9335,0.9613,0.9722,0.9647,0.9554,0.9437,0.942,0.9601,0.9415,0.9443,0.9669,0.9769,0.944,0.973,0.9576,0.9696,0.9576,0.9702,0.9654,0.9769,0.9502,0.9524,0.9746,0.9461,0.9602,0.9614,0.9509,0.9615,0.9708,0.9444,0.9743,0.9669,0.9501,0.975,0.9534,0.9393,0.9487,0.9453,0.9358,0.9151,0.9135,0.9538,0.947,0.9725,0.9674,0.961,0.9675,0.96,0.9506,0.9597,0.9519,0.9678,0.9533,0.958,0.9764,0.9541,0.9432,0.9628,0.9625,0.9618,0.9668,0.9653,0.9391,0.9535,0.9712,0.9675,0.9567,0.9637,0.9682,0.9612,0.9676,0.9637,0.9585,0.9579,0.9543,0.9703,0.9572,0.9621,0.9702,0.9394,0.9702,0.9712,0.9706,0.9803,0.9674,0.9602,0.9556,0.9666,0.9599,0.962,0.963,0.9644,0.9535,0.9687,0.953,0.957,0.9725,0.9667,0.9642,0.9713,0.9493,0.9654,0.9486,0.9525,0.9193,0.9606,0.9687,0.9577,0.9464,0.9712,0.9627,0.9675,0.9702,0.9572,0.9685,0.9515,0.9546,0.9729,0.9662,0.9594,0.9736,0.9681,0.9621,0.9709,0.9561,0.9758,0.9716,0.973,0.9777,0.9502,0.9687,0.9612,0.9657,0.9678,0.9584,0.9424,0.9589,0.9695,0.9572,0.9642,0.9568,0.9621,0.9606,0.9724,0.9574,0.9662,0.9537,0.9687,0.9748,0.9682,0.9627,0.9338,0.9413,0.9629,0.9431,0.9701,0.9595,0.9746,0.9647,0.966,0.9451,0.9223,0.9721,0.971,0.96,0.9521,0.9622,0.9593,0.9717,0.9654,0.9569,0.9472,0.9647,0.9596,0.9641,0.9426,0.9632,0.9481,0.9617,0.9686,0.9555,0.9603,0.9705,0.9678,0.9536,0.9622,0.966,0.9409,0.9493,0.9456,0.9418,0.9451,0.942,0.9538,0.9096,0.902,0.9669,0.9657,0.9658,0.9523,0.9632,0.9168,0.9522,0.927,0.9765,0.958,0.9615,0.9574,0.9682,0.9682,0.9532,0.9638,0.9675,0.9705,0.9355,0.9581,0.9642,0.9721,0.952,0.961,0.9623,0.9605,0.9529,0.962,0.9638,0.9758,0.968,0.9625,0.9557,0.9747,0.9729,0.9265,0.963,0.9539,0.9644,0.9492,0.9737,0.9465,0.968,0.9633,0.9567,0.9683,0.961,0.9789,0.9575,0.9679,0.964,0.9628,0.9692,0.9543,0.9475,0.9346,0.9523,0.9542,0.959,0.9496,0.9664,0.9652,0.9634,0.9349,0.9731,0.9618,0.9755,0.9763,0.9687,0.9642,0.9757,0.9571,0.968,0.9608,0.9683,0.9609,0.9642,0.9543,0.9319,0.9625,0.9641,0.9602,0.9525,0.9465,0.9694,0.973,0.9645,0.9644,0.9666,0.9545,0.9386,0.9332,0.9468,0.9745,0.9706,0.9604,0.964,0.9448,0.9665,0.9626,0.9617,0.9522,0.9601,0.9258,0.9565,0.9582,0.9601,0.9634,0.9746,0.9649,0.9734,0.9767,0.971,0.9739,0.9405,0.9648,0.9697,0.9344,0.9715,0.9395,0.9329,0.9572,0.9585,0.9702,0.9693,0.9718,0.9738,0.9645,0.9447,0.9604,0.9693,0.9547,0.9642,0.9723,0.9568,0.962,0.9576,0.9608,0.9591,0.9588,0.9636,0.9464,0.9662,0.9671,0.961,0.9686,0.9584,0.9643,0.9723,0.9602,0.9607,0.9516,0.973,0.9754,0.9671,0.9753,0.9691,0.9593,0.9471,0.9732,0.9751,0.9527,0.9714,0.9655,0.9515,0.9632,0.9688,0.9648,0.9662,0.9669,0.9612,0.953,0.9578,0.9745,0.9591,0.9749,0.9539,0.9685,0.965,0.9616,0.9727,0.9666,0.9681,0.965,0.9722,0.9711,0.964]
e2s_pc1=[0.1174,0.098,0.1229,0.2165,0.1144,0.1834,0.2292,0.1651,0.337,0.1696,0.1526,0.0974,0.0986,0.2692,0.1558,0.1174,0.3194,0.1821,0.3794,0.1142,0.2053,0.2401,0.163,0.459,0.3625,0.1887,0.2249,0.3393,0.2175,0.3783,0.3188,0.3183,0.1594,0.369,0.314,0.285,0.2917,0.3712,0.3064,0.5363,0.5467,0.3762,0.4373,0.5534,0.4517,0.6068,0.4964,0.3138,0.4421,0.4833,0.2096,0.4545,0.2781,0.2987,0.4414,0.4284,0.5214,0.5341,0.5753,0.4497,0.2863,0.5092,0.3999,0.5467,0.6543,0.3785,0.4939,0.4599,0.5283,0.4122,0.5029,0.4808,0.6338,0.4952,0.6092,0.6743,0.6934,0.5274,0.6786,0.5967,0.6316,0.6136,0.6851,0.6944,0.6783,0.6871,0.6034,0.602,0.6189,0.4877,0.2751,0.6781,0.6737,0.6441,0.4815,0.6278,0.6303,0.6687,0.5437,0.658,0.6676,0.6497,0.7494,0.3988,0.6817,0.7821,0.5653,0.3659,0.43,0.653,0.5263,0.5868,0.745,0.7646,0.6263,0.7189,0.6446,0.6275,0.5715,0.5133,0.7116,0.7234,0.4235,0.5842,0.5334,0.5863,0.6056,0.5044,0.5949,0.3865,0.6475,0.8183,0.6814,0.7758,0.6333,0.7704,0.7256,0.6897,0.6493,0.7282,0.6351,0.639,0.6109,0.7794,0.6763,0.6483,0.7845,0.7983,0.7336,0.7595,0.8069,0.5742,0.5345,0.7589,0.7561,0.6425,0.7492,0.6214,0.5512,0.6407,0.8004,0.7166,0.6331,0.6425,0.7528,0.754,0.7311,0.7749,0.7546,0.7389,0.675,0.7394,0.6324,0.65,0.7158,0.781,0.8032,0.5595,0.6598,0.6183,0.5704,0.6167,0.7156,0.6289,0.6375,0.7224,0.7649,0.7909,0.6636,0.4556,0.7544,0.7067,0.6979,0.6903,0.7105,0.8213,0.7749,0.5218,0.786,0.8439,0.8234,0.7514,0.6969,0.5465,0.7348,0.8322,0.6802,0.7979,0.6133,0.7064,0.7425,0.7537,0.8206,0.5065,0.7373,0.7528,0.7042,0.7143,0.7877,0.7517,0.629,0.6412,0.6783,0.6649,0.7542,0.6649,0.8235,0.822,0.7778,0.6998,0.787,0.552,0.7526,0.7368,0.6793,0.847,0.8356,0.8328,0.7836,0.6921,0.7663,0.7387,0.8473,0.8313,0.5635,0.4525,0.7469,0.8815,0.8052,0.6572,0.8435,0.8046,0.7708,0.5075,0.7571,0.5209,0.6099,0.865,0.7773,0.7843,0.6763,0.8032,0.7338,0.8632,0.7675,0.8247,0.6965,0.7546,0.769,0.7674,0.8598,0.7312,0.7617,0.7358,0.862,0.8084,0.728,0.7755,0.6426,0.8649,0.7831,0.7689,0.7585,0.7605,0.7234,0.8432,0.769,0.8155,0.7955,0.5058,0.725,0.8194,0.7015,0.6268,0.8253,0.8774,0.8117,0.6106,0.7465,0.7177,0.7554,0.6684,0.8963,0.8499,0.7643,0.4853,0.7104,0.7991,0.8676,0.8454,0.8542,0.7935,0.8827,0.8454,0.8027,0.7683,0.7833,0.7743,0.8246,0.7013,0.7909,0.8541,0.8224,0.6924,0.889,0.825,0.7501,0.8021,0.8113,0.7048,0.7443,0.7097,0.8523,0.8268,0.8449,0.5824,0.8097,0.7885,0.8561,0.9009,0.8272,0.7427,0.737,0.731,0.8813,0.8184,0.8538,0.8694,0.8354,0.8619,0.7965,0.5951,0.8039,0.8711,0.7477,0.863,0.76,0.8032,0.8116,0.7931,0.8992,0.8637,0.8735,0.8459,0.8628,0.8082,0.7564,0.7921,0.8307,0.7887,0.856,0.8224,0.785,0.8524,0.7657,0.7566,0.891,0.8099,0.8,0.8519,0.6292,0.8564,0.8035,0.7534,0.8229,0.7332,0.7717,0.7906,0.882,0.8179,0.6819,0.8554,0.8656,0.7692,0.8081,0.8743,0.7474,0.5734,0.8812,0.8695,0.8285,0.7916,0.7301,0.772,0.8527,0.9056,0.8579,0.8017,0.8215,0.8541,0.8872,0.8302,0.7345,0.7813,0.704,0.7288,0.6672,0.8877,0.8841,0.8332,0.7171,0.8782,0.8229,0.8483,0.7347,0.8912,0.6524,0.8519,0.8554,0.8667,0.8989,0.8049,0.9033,0.8098,0.8595,0.8698,0.8381,0.8442,0.866,0.9156,0.8923,0.8882,0.8705,0.8071,0.7977,0.8395,0.8884,0.8168,0.9056,0.8255,0.8745,0.9011,0.7517,0.7901,0.9007,0.8014,0.6787,0.8022,0.847,0.8186,0.9148,0.9088,0.8651,0.8947,0.9096,0.8581,0.8931,0.9135,0.8655,0.6698,0.7509,0.814,0.8084,0.7956,0.816,0.8981,0.86,0.853,0.8073,0.8181,0.8526,0.8702,0.8794,0.8205,0.8803,0.8717,0.8116,0.892,0.8774,0.7957,0.8712,0.9133,0.8864,0.8292,0.8583,0.8401,0.7824,0.9186,0.9193,0.9044,0.9157,0.8803,0.8111,0.9231,0.8915,0.7436,0.8704,0.8761,0.8372,0.8448,0.8609,0.7086,0.8467,0.8868,0.9105,0.905,0.8975,0.7979,0.6577,0.8688,0.8413,0.8395,0.75,0.8778,0.8729,0.9177,0.842,0.9,0.8438,0.8062,0.8457,0.7483,0.8278,0.8309,0.8476,0.8912,0.8641,0.9026,0.8428,0.8673,0.8684,0.8437,0.9258,0.9153,0.7875,0.9204,0.8787,0.735,0.8617,0.8309,0.8997,0.8971,0.8655,0.84,0.899,0.7144,0.8498,0.8718,0.8932,0.8957,0.844,0.8743,0.8455,0.7901,0.8512,0.7875,0.8207,0.6257,0.9337,0.8599,0.8599,0.9147,0.8323,0.8424,0.7978,0.9186,0.8596,0.913,0.891,0.9184,0.8464,0.8581,0.9079,0.8855,0.9209,0.8671,0.8532,0.9124,0.7235,0.8446,0.9146,0.9302,0.9219,0.8077,0.9043,0.8586,0.811,0.8112,0.9177,0.87,0.9149,0.7931,0.8645,0.8758,0.9156,0.8986,0.8926,0.8794,0.92,0.7284,0.8443,0.9091,0.8743,0.8059,0.8762,0.8586,0.8132,0.8276,0.9139,0.9044,0.836,0.8323,0.85,0.8844,0.8244,0.8925,0.8616,0.7714,0.9243,0.9467,0.8905,0.8543,0.7438,0.9273,0.859,0.8425,0.9332,0.918,0.8883,0.8686,0.9277,0.9055,0.8909,0.8669,0.9055,0.9228,0.8674,0.8865,0.9229,0.8828,0.8961,0.835,0.9145,0.8981,0.9075,0.9123,0.8692,0.9159,0.8889,0.855,0.8206,0.7003,0.6027,0.8394,0.8771,0.8563,0.9069,0.9081,0.9294,0.9167,0.9173,0.7258,0.8601,0.6552,0.8767,0.8378,0.854,0.9277,0.9327,0.9256,0.9392,0.7843,0.6696,0.9192,0.9299,0.8811,0.8996,0.8652,0.9421,0.928,0.9115,0.9028,0.858,0.8637,0.8741,0.9248,0.892,0.8483,0.9253,0.9042,0.8605,0.8261,0.8683,0.8411,0.9234,0.9384,0.9381,0.8958,0.9074,0.8608,0.8369,0.9336,0.8967,0.9047,0.8421,0.8783,0.828,0.8727,0.8623,0.8465,0.8528,0.9193,0.9255,0.8851,0.6945,0.8025,0.8724,0.8481,0.8513,0.8983,0.7781,0.8492,0.8434,0.8893,0.9222,0.8975,0.9453,0.9168,0.9124,0.8023,0.8939,0.8797,0.912,0.9392,0.8609,0.7937,0.8715,0.8624,0.8973,0.9185,0.7868,0.9028,0.9443,0.9239,0.9023,0.93,0.8861,0.9144,0.8666,0.8327,0.7983,0.8821,0.8583,0.8072,0.8656,0.8515,0.8071,0.9368,0.9041,0.8852,0.9395,0.9056,0.913,0.9285,0.8668,0.9167,0.8963,0.9433,0.8565,0.8925,0.925,0.8872,0.8508,0.867,0.8793,0.9497,0.8804,0.887,0.8621,0.8424,0.7731,0.9337,0.8861,0.913,0.8976,0.8745,0.823,0.9279,0.9154,0.9254,0.9156,0.8215,0.7219,0.8872,0.8132,0.9078,0.9371,0.9133,0.8873,0.8557,0.8528,0.7872,0.8936,0.8532,0.9078,0.8975,0.8871,0.8849,0.9412,0.8895,0.8859,0.7536,0.8882,0.9316,0.8921,0.8874,0.7422,0.9303,0.9116,0.898,0.9113,0.9297,0.9346,0.9309,0.8935,0.876,0.8797,0.9066,0.8925,0.887,0.888,0.898,0.763,0.8983,0.9468,0.9226,0.8858,0.9191,0.9425,0.8946,0.9245,0.9191,0.8985,0.9023,0.9135,0.8535,0.9237,0.9088,0.8907,0.9158,0.9068,0.9414,0.9294,0.8562,0.8782,0.7994,0.9115,0.8779,0.9167,0.9019,0.8927,0.8336,0.8384,0.878,0.874,0.9257,0.9268,0.9316,0.9336,0.9079,0.8888,0.9483,0.9471,0.9271,0.9315,0.9098,0.8861,0.8825,0.9368,0.9114,0.947,0.9396,0.8982,0.8777,0.9169,0.915,0.8648,0.9116,0.9032,0.8476,0.9421,0.8779,0.9466,0.9471,0.8958,0.8918,0.8926,0.9084,0.8473,0.8959,0.8438,0.9358,0.915,0.8527,0.8697,0.919,0.8629,0.9002,0.9194,0.8669,0.9063,0.8657,0.9288,0.9457,0.9021,0.9211,0.9151,0.8959,0.8632,0.8818,0.9321,0.9377,0.9368,0.9334,0.8819,0.9299,0.8158,0.8498,0.8837,0.9185,0.8763,0.9064,0.9147,0.9362,0.8883,0.9391,0.9319,0.9399,0.9117,0.9293,0.8522,0.9,0.8717,0.7946,0.8816,0.866,0.8737,0.9503,0.9163,0.9304,0.9114,0.9039,0.9237,0.8936,0.9313,0.8724,0.9328,0.8999,0.8785,0.9186,0.8695,0.9558,0.9241,0.9201,0.8772,0.7677,0.7286,0.8244,0.9405,0.9261,0.9251,0.8949,0.8968,0.8974,0.9244,0.9483,0.9469,0.9338,0.8729,0.8844,0.7934,0.9159,0.9086,0.8519,0.9145,0.8874,0.924,0.9248,0.9158,0.9254]
bfc_pc1=[0.1032,0.1032,0.1032,0.1032,0.098,0.1028,0.0892,0.2231,0.2783,0.2581,0.1903,0.2216,0.2796,0.2276,0.4949,0.4547,0.4084,0.39,0.4716,0.3985,0.4618,0.4441,0.6373,0.6891,0.5345,0.5418,0.7691,0.6548,0.6931,0.5904,0.8676,0.719,0.7749,0.7381,0.7814,0.7609,0.7075,0.6619,0.5671,0.6772,0.7399,0.6352,0.5836,0.8184,0.7658,0.8301,0.765,0.8139,0.8179,0.7111,0.8062,0.8531,0.8579,0.6635,0.8827,0.8149,0.7269,0.8134,0.7031,0.7682,0.8213,0.8533,0.8728,0.7679,0.8184,0.786,0.8173,0.7899,0.7932,0.8104,0.7669,0.8917,0.8596,0.9071,0.7838,0.8689,0.8368,0.9339,0.8809,0.8337,0.898,0.8935,0.8009,0.9309,0.909,0.8607,0.7766,0.9058,0.8982,0.846,0.7408,0.8828,0.8622,0.908,0.9169,0.8438,0.8883,0.8687,0.8144,0.8239,0.8289,0.9027,0.9292,0.7932,0.8293,0.8228,0.8463,0.815,0.8125,0.7552,0.831,0.8372,0.7504,0.8165,0.8295,0.8323,0.8473,0.8323,0.8311,0.786,0.7918,0.8432,0.7167,0.8879,0.9008,0.9144,0.9074,0.865,0.8308,0.9447,0.8429,0.8694,0.926,0.8869,0.9072,0.925,0.9006,0.879,0.8304,0.8803,0.8303,0.9199,0.8625,0.8414,0.9178,0.9304,0.8919,0.8834,0.8539,0.8468,0.8761,0.8996,0.9139,0.9103,0.959,0.8445,0.941,0.9298,0.9071,0.8998,0.8967,0.9088,0.9298,0.8922,0.9213,0.9146,0.8901,0.9169,0.9353,0.9203,0.9174,0.8702,0.9486,0.9124,0.9399,0.9588,0.9518,0.9477,0.9478,0.8873,0.9053,0.8985,0.8676,0.9182,0.9013,0.8718,0.8798,0.8555,0.8789,0.8315,0.8501,0.812,0.8989,0.8793,0.8944,0.8633,0.918,0.9169,0.9304,0.8872,0.9546,0.9074,0.8883,0.9049,0.9294,0.911,0.9392,0.9389,0.9323,0.8899,0.9483,0.9093,0.946,0.9651,0.9305,0.9151,0.9593,0.9564,0.9205,0.8997,0.9438,0.9383,0.8973,0.9342,0.9244,0.8967,0.9473,0.8842,0.9194,0.8817,0.9207,0.9324,0.9433,0.9297,0.954,0.87,0.89,0.9417,0.9475,0.9561,0.9533,0.9064,0.8843,0.9581,0.9507,0.9459,0.9379,0.9505,0.9602,0.9428,0.9497,0.8715,0.925,0.9495,0.9299,0.9214,0.9331,0.9139,0.9552,0.9404,0.9391,0.9333,0.9024,0.8589,0.9267,0.9591,0.9732,0.9589,0.965,0.944,0.9372,0.9617,0.9499,0.9458,0.9286,0.9237,0.9491,0.9712,0.934,0.9267,0.9628,0.9447,0.9419,0.968,0.9182,0.9332,0.9621,0.943,0.927,0.9325,0.9649,0.9125,0.9168,0.9137,0.9247,0.8936,0.935,0.9718,0.9157,0.9595,0.8821,0.9249,0.9114,0.9251,0.9485,0.9539,0.8833,0.8873,0.9517,0.9563,0.9501,0.9065,0.9512,0.9021,0.8817,0.9585,0.9477,0.9708,0.9715,0.9609,0.9513,0.9043,0.8931,0.91,0.8963,0.8975,0.9554,0.9591,0.9102,0.9177,0.9336,0.9428,0.955,0.9705,0.9544,0.9184,0.8973,0.9181,0.9658,0.9262,0.9505,0.9408,0.9692,0.9509,0.9653,0.9482,0.9505,0.9321,0.9416,0.9144,0.9202,0.968,0.9622,0.9445,0.9409,0.9103,0.8787,0.9043,0.8969,0.9637,0.9509,0.9509,0.9409,0.9161,0.9194,0.9301,0.9532,0.9375,0.9138,0.9724,0.9176,0.9457,0.9449,0.9417,0.9538,0.9479,0.9472,0.9122,0.8972,0.8791,0.9579,0.936,0.9271,0.8716,0.9455,0.9082,0.9252,0.8745,0.9366,0.9554,0.9379,0.8977,0.966,0.9406,0.8973,0.9533,0.9406,0.8863,0.9672,0.9411,0.9678,0.9713,0.9527,0.9299,0.9336,0.9207,0.9581,0.9096,0.965,0.9452,0.8888,0.9163,0.9718,0.9413,0.9694,0.9558,0.9396,0.9423,0.9291,0.951,0.9252,0.9557,0.9569,0.9284,0.9637,0.9466,0.9541,0.9414,0.9324,0.9162,0.9485,0.9524,0.9666,0.9454,0.9594,0.966,0.9532,0.9401,0.933,0.9445,0.9502,0.9404,0.9511,0.955,0.9265,0.9394,0.9225,0.9261,0.9697,0.9383,0.9382,0.9647,0.9418,0.9011,0.9466,0.941,0.9513,0.9563,0.9028,0.9541,0.9524,0.9589,0.9431,0.9128,0.9046,0.8942,0.943,0.9504,0.9623,0.9369,0.9401,0.9484,0.9151,0.9641,0.9328,0.9727,0.9439,0.9495,0.9491,0.9406,0.923,0.9678,0.9484,0.9466,0.9241,0.9735,0.9452,0.9374,0.9339,0.9714,0.9531,0.9527,0.9417,0.9688,0.949,0.9513,0.9708,0.9598,0.9456,0.9332,0.9486,0.9399,0.9486,0.9334,0.9083,0.8612,0.9271,0.9733,0.9331,0.9188,0.9405,0.9026,0.9064,0.8819,0.893,0.9002,0.9298,0.9694,0.9657,0.9522,0.9482,0.9491,0.9602,0.9491,0.9413,0.9414,0.9216,0.9588,0.935,0.892,0.9481,0.9717,0.9557,0.9329,0.9399,0.939,0.9594,0.949,0.9069,0.9398,0.8887,0.9353,0.9682,0.9305,0.9736,0.9594,0.9526,0.9581,0.9637,0.9416,0.9492,0.9052,0.9207,0.9098,0.973,0.9337,0.9637,0.9703,0.9415,0.8967,0.9752,0.977,0.9738,0.957,0.966,0.9652,0.9726,0.9465,0.9747,0.9479,0.9536,0.9377,0.9406,0.9444,0.9485,0.9202,0.9022,0.9155,0.899,0.9232,0.9368,0.9429,0.9636,0.9375,0.9679,0.9689,0.9483,0.9055,0.9526,0.9494,0.929,0.9387,0.9122,0.9249,0.908,0.9487,0.9774,0.9588,0.9614,0.9144,0.9736,0.9642,0.9569,0.9425,0.9073,0.948,0.9125,0.9153,0.9694,0.9524,0.9445,0.9354,0.9555,0.9421,0.9301,0.9688,0.9518,0.9617,0.9654,0.9254,0.9493,0.9675,0.9685,0.9625,0.9492,0.9272,0.9389,0.9376,0.9278,0.933,0.9173,0.9471,0.9527,0.9364,0.9513,0.9495,0.9456,0.9582,0.9733,0.9629,0.9654,0.9464,0.8782,0.9258,0.9181,0.8778,0.9613,0.9264,0.9207,0.9485,0.9523,0.9679,0.9685,0.9419,0.9272,0.9717,0.9663,0.9658,0.9299,0.9226,0.9287,0.9439,0.9539,0.9717,0.9606,0.9674,0.9557,0.9345,0.9582,0.9429,0.958,0.9756,0.9515,0.9466,0.9603,0.9292,0.9474,0.9384,0.9741,0.9553,0.9643,0.955,0.948,0.9106,0.9387,0.9362,0.9469,0.946,0.9669,0.9624,0.9392,0.9218,0.9384,0.9806,0.964,0.9553,0.9654,0.9678,0.9376,0.9518,0.9421,0.9542,0.9464,0.9255,0.9525,0.9429,0.9782,0.9376,0.9379,0.9695,0.9585,0.9418,0.9238,0.9568,0.9392,0.9628,0.9425,0.9211,0.8969,0.874,0.8715,0.9701,0.9624,0.9336,0.9604,0.9491,0.9427,0.9525,0.9441,0.9686,0.9344,0.9476,0.9299,0.9081,0.9052,0.9666,0.9408,0.9579,0.9503,0.9181,0.9534,0.9206,0.8559,0.8731,0.8812,0.9361,0.9772,0.9684,0.9545,0.9558,0.9573,0.9589,0.9334,0.959,0.9496,0.9368,0.9149,0.9721,0.953,0.9724,0.9687,0.9378,0.9754,0.9678,0.9592,0.9548,0.9334,0.9609,0.9564,0.9604,0.9424,0.9493,0.9613,0.9701,0.9561,0.9599,0.9594,0.9579,0.9334,0.8978,0.9266,0.9491,0.9442,0.9419,0.9035,0.8954,0.9478,0.9385,0.9132,0.9578,0.9669,0.9451,0.9714,0.9587,0.9483,0.9609,0.9372,0.9418,0.9255,0.9303,0.9388,0.9642,0.9679,0.9572,0.9521,0.9267,0.9139,0.9145,0.9267,0.8978,0.9117,0.9606,0.9511,0.9546,0.947,0.9212,0.916,0.9459,0.9625,0.9394,0.9401,0.9501,0.9648,0.9597,0.9765,0.9559,0.9503,0.9527,0.9316,0.9472,0.9299,0.9096,0.9201,0.9068,0.9375,0.9657,0.9345,0.9158,0.9416,0.9395,0.9345,0.9096,0.9316,0.8945,0.8813,0.9439,0.9228,0.9524,0.921,0.9489,0.9473,0.9378,0.9308,0.9028,0.9128,0.8947,0.9463,0.9518,0.9599,0.9507,0.9499,0.9517,0.9209,0.9601,0.9451,0.9754,0.9321,0.9613,0.9744,0.9744,0.9551,0.9635,0.9573,0.9604,0.9577,0.9723,0.9542,0.9587,0.967,0.972,0.9687,0.9595,0.9374,0.9655,0.9548,0.9546,0.9416,0.9647,0.9437,0.9555,0.9464,0.8978,0.955,0.9602,0.9655,0.9547,0.9274,0.9423,0.9645,0.9524,0.9421,0.9577,0.9465,0.9245,0.9348,0.9083,0.9072,0.9638,0.9752,0.9282,0.9562,0.9429,0.933,0.959,0.9332,0.9398,0.8997,0.9763,0.9645,0.9738,0.9528,0.967,0.9541,0.9489,0.9431,0.9748,0.9446,0.9624,0.9733,0.9465,0.9696,0.9567,0.9427,0.9621,0.8923,0.9515,0.9499,0.9356,0.9617,0.9518,0.9701,0.9709,0.9104,0.9168,0.9721,0.976,0.9615,0.9723,0.9714,0.9653,0.9621,0.9648,0.967,0.9445,0.9583,0.966,0.9681,0.9065,0.9108,0.9349,0.9569,0.957,0.958,0.9565,0.9701,0.9723,0.9632,0.961,0.9413,0.9309,0.9617,0.9528,0.9219,0.9223,0.9689,0.9693,0.9716,0.9593,0.9546,0.9559,0.9483,0.9629,0.9397,0.9047,0.9576,0.9617,0.948,0.9448,0.9546,0.9473,0.9493,0.9395,0.9388,0.9728,0.9554,0.9679,0.9695,0.9516,0.9539,0.9612]
bf_pc1=[0.164,0.0982,0.1213,0.1044,0.1341,0.0984,0.0982,0.101,0.2408,0.0931,0.1806,0.1539,0.2117,0.1056,0.0892,0.0974,0.2166,0.1523,0.132,0.0974,0.2021,0.1021,0.0976,0.1694,0.3167,0.2639,0.2532,0.3559,0.2649,0.1379,0.2407,0.1338,0.1055,0.2735,0.1893,0.2209,0.2869,0.4371,0.3856,0.4702,0.3748,0.1786,0.1904,0.265,0.3474,0.1913,0.2513,0.2341,0.2954,0.2499,0.2068,0.4634,0.2643,0.3805,0.416,0.1676,0.1892,0.2576,0.3649,0.4496,0.4374,0.3955,0.3978,0.438,0.3714,0.4077,0.1816,0.3583,0.4143,0.353,0.4477,0.5472,0.5623,0.4575,0.5659,0.5243,0.4693,0.5713,0.577,0.3704,0.5387,0.5168,0.4719,0.5141,0.5303,0.351,0.5736,0.5568,0.4944,0.5685,0.5092,0.3962,0.5958,0.4421,0.5956,0.6133,0.6732,0.5814,0.6897,0.6286,0.4925,0.4941,0.5013,0.5624,0.4632,0.5148,0.5217,0.5466,0.4916,0.4916,0.5788,0.6529,0.4953,0.6178,0.4842,0.5472,0.6624,0.3963,0.4814,0.4495,0.6364,0.5648,0.3768,0.6098,0.4872,0.6672,0.7602,0.752,0.7064,0.6817,0.7072,0.6019,0.6043,0.663,0.6685,0.5285,0.4054,0.6261,0.6049,0.7124,0.6744,0.5494,0.6946,0.6572,0.542,0.663,0.5573,0.6706,0.556,0.6398,0.6234,0.7058,0.6632,0.6565,0.6765,0.6044,0.5787,0.7436,0.6967,0.7185,0.5935,0.5838,0.6707,0.7281,0.7949,0.7165,0.6972,0.7329,0.6682,0.6604,0.6275,0.6895,0.6886,0.7492,0.6975,0.7143,0.7208,0.7946,0.7853,0.5758,0.6135,0.7543,0.647,0.7243,0.7733,0.6961,0.4749,0.727,0.7883,0.7177,0.6978,0.7148,0.7448,0.7334,0.6601,0.659,0.6548,0.5864,0.7507,0.733,0.779,0.7468,0.6974,0.7393,0.7944,0.7617,0.736,0.724,0.7547,0.721,0.6998,0.7895,0.761,0.741,0.7094,0.7057,0.6922,0.7927,0.7896,0.7267,0.7868,0.7564,0.6828,0.8276,0.7188,0.5372,0.7322,0.832,0.8178,0.8132,0.86,0.7816,0.705,0.5013,0.5358,0.7438,0.8136,0.7453,0.8381,0.7825,0.6165,0.7771,0.6855,0.732,0.7246,0.6503,0.6933,0.664,0.6494,0.7257,0.8196,0.544,0.6367,0.6551,0.7048,0.7512,0.7832,0.7503,0.7357,0.7462,0.7037,0.6516,0.7667,0.741,0.7526,0.7234,0.7788,0.7155,0.7623,0.8594,0.7635,0.5752,0.7012,0.7836,0.834,0.6545,0.8387,0.689,0.7427,0.8256,0.7739,0.6843,0.7696,0.7822,0.7215,0.7215,0.7473,0.7744,0.7336,0.8066,0.822,0.7685,0.7267,0.7776,0.7234,0.7947,0.7951,0.7835,0.6912,0.777,0.7418,0.7597,0.7819,0.7954,0.7159,0.7076,0.7091,0.751,0.7888,0.7509,0.7964,0.6295,0.7134,0.7397,0.7466,0.8302,0.844,0.8627,0.8384,0.8143,0.8413,0.692,0.6808,0.7585,0.7437,0.8529,0.7665,0.8135,0.8173,0.7375,0.7752,0.7969,0.7095,0.7997,0.758,0.7898,0.8074,0.7744,0.7043,0.5705,0.7494,0.8823,0.7979,0.713,0.5835,0.7431,0.8306,0.8112,0.839,0.7787,0.8017,0.7614,0.7718,0.7693,0.772,0.7824,0.8744,0.8672,0.7585,0.6973,0.6607,0.7242,0.8774,0.8974,0.8489,0.8754,0.7733,0.7568,0.6919,0.8664,0.8844,0.8456,0.7755,0.8167,0.7649,0.8787,0.7917,0.7914,0.8484,0.8273,0.6712,0.7703,0.7571,0.7422,0.7278,0.8482,0.7816,0.8069,0.8182,0.7765,0.7769,0.7793,0.7482,0.8103,0.7703,0.8806,0.8367,0.7767,0.7939,0.7725,0.8467,0.7623,0.7578,0.889,0.8414,0.7673,0.892,0.7971,0.7419,0.8031,0.8654,0.8707,0.7476,0.8435,0.8207,0.797,0.7613,0.7416,0.7022,0.7669,0.7352,0.7461,0.8201,0.8483,0.8209,0.8351,0.8886,0.8854,0.8911,0.7983,0.8211,0.8752,0.8652,0.8757,0.8085,0.8426,0.8848,0.8243,0.7393,0.7973,0.8756,0.8381,0.7905,0.8698,0.8916,0.8834,0.8711,0.8085,0.8763,0.7969,0.8736,0.8356,0.8165,0.8024,0.7639,0.7494,0.7935,0.7859,0.7646,0.8494,0.8273,0.7209,0.8279,0.9028,0.8761,0.8137,0.8359,0.8079,0.8523,0.8622,0.7833,0.7754,0.8596,0.8304,0.8776,0.8311,0.7658,0.7677,0.8249,0.7384,0.7107,0.885,0.8449,0.8045,0.8703,0.8854,0.8682,0.8192,0.7517,0.7759,0.8616,0.8784,0.8943,0.8696,0.8553,0.7598,0.8811,0.7344,0.7935,0.7872,0.7715,0.8886,0.8607,0.8556,0.8083,0.8944,0.8404,0.9151,0.8727,0.8054,0.7014,0.8664,0.8063,0.8169,0.8981,0.8807,0.8147,0.8097,0.7112,0.8325,0.8413,0.8934,0.9015,0.91,0.8209,0.7309,0.8225,0.8655,0.9253,0.8473,0.8672,0.82,0.8602,0.8794,0.8779,0.8749,0.8787,0.8223,0.8275,0.8549,0.8208,0.8277,0.8632,0.8492,0.8151,0.7871,0.8117,0.8716,0.8192,0.8404,0.8323,0.803,0.8253,0.9087,0.8854,0.8416,0.8115,0.7659,0.8208,0.8255,0.8467,0.8067,0.8183,0.854,0.8827,0.8024,0.9027,0.8701,0.8761,0.8349,0.8458,0.8952,0.8827,0.9174,0.918,0.8741,0.8084,0.9203,0.9009,0.8752,0.731,0.9118,0.8808,0.8546,0.8021,0.7342,0.8203,0.9137,0.8702,0.8892,0.8998,0.8756,0.8854,0.8348,0.8298,0.9034,0.9316,0.887,0.8452,0.8541,0.9116,0.9004,0.8676,0.7952,0.8733,0.8889,0.8552,0.8894,0.9163,0.8857,0.8744,0.9013,0.925,0.8901,0.8503,0.9236,0.9169,0.8927,0.8741,0.9156,0.8982,0.8816,0.8137,0.8171,0.903,0.9155,0.8294,0.8383,0.8414,0.9102,0.8928,0.8448,0.8977,0.8186,0.8377,0.9244,0.8512,0.9173,0.8056,0.7877,0.8039,0.8768,0.861,0.9068,0.9068,0.92,0.8341,0.8821,0.8025,0.8758,0.9047,0.8942,0.8844,0.9321,0.8829,0.9178,0.8731,0.8541,0.8364,0.8327,0.8873,0.8964,0.8765,0.8642,0.8237,0.9179,0.902,0.8819,0.91,0.89,0.8429,0.8933,0.8916,0.8709,0.8048,0.77,0.8877,0.9198,0.9025,0.8646,0.8759,0.8377,0.8835,0.866,0.9143,0.9222,0.9219,0.9195,0.8713,0.9062,0.8927,0.8579,0.8624,0.7478,0.816,0.8383,0.8625,0.8894,0.9259,0.9163,0.8935,0.9097,0.831,0.7614,0.8102,0.8701,0.8655,0.8461,0.9084,0.9067,0.9123,0.8843,0.8933,0.8337,0.8275,0.8264,0.8239,0.8929,0.8662,0.9242,0.841,0.9138,0.8969,0.9057,0.8952,0.8871,0.8578,0.8886,0.8697,0.94,0.9237,0.9248,0.9358,0.9194,0.9222,0.9042,0.8548,0.8076,0.8953,0.8932,0.891,0.8889,0.9079,0.896,0.8915,0.804,0.9011,0.8234,0.7976,0.902,0.8782,0.9184,0.8491,0.9037,0.8763,0.8199,0.7326,0.8433,0.7976,0.9018,0.9168,0.8469,0.8466,0.8566,0.9069,0.9233,0.8437,0.8253,0.8225,0.8987,0.9229,0.9368,0.9398,0.9027,0.9163,0.896,0.9152,0.8788,0.8633,0.9268,0.856,0.8415,0.8931,0.8875,0.9205,0.911,0.8452,0.8776,0.8242,0.8423,0.7782,0.8508,0.8861,0.8935,0.9186,0.8508,0.8416,0.7893,0.8417,0.9289,0.8978,0.8949,0.947,0.908,0.8646,0.9154,0.8854,0.8652,0.8797,0.9226,0.914,0.8968,0.9292,0.9289,0.9207,0.8658,0.8673,0.8794,0.8345,0.7499,0.7761,0.8528,0.9405,0.8861,0.93,0.8703,0.9446,0.9055,0.9331,0.9104,0.8862,0.9105,0.9003,0.9168,0.8689,0.9353,0.8369,0.9176,0.8681,0.8429,0.9003,0.9271,0.9175,0.8866,0.8673,0.865,0.9077,0.9407,0.8997,0.9213,0.9039,0.8874,0.8955,0.9428,0.9124,0.9045,0.8689,0.8707,0.9097,0.8852,0.9321,0.8849,0.8914,0.7939,0.9193,0.9441,0.9256,0.9044,0.8836,0.9356,0.9103,0.9141,0.8977,0.88,0.917,0.9324,0.9371,0.835,0.8688,0.8644,0.8213,0.7922,0.8815,0.9137,0.9226,0.8755,0.8473,0.855,0.9263,0.9208,0.889,0.9321,0.919,0.834,0.8522,0.8494,0.9147,0.8871,0.8994,0.9204,0.9464,0.9102,0.9241,0.9182,0.9405,0.9517,0.9102,0.8716,0.8602,0.807,0.8898,0.9125,0.8589,0.8523,0.8459,0.854,0.7856,0.7938,0.8696,0.8274,0.8696,0.8503,0.897,0.8688,0.9088,0.9295,0.8222,0.9272,0.8605,0.9402,0.8162,0.9162,0.8748,0.8467,0.8587,0.9023,0.9097,0.8395,0.7189,0.7323,0.9038,0.9287,0.916,0.9184,0.9094,0.942,0.9011,0.9266,0.9216,0.9091,0.9005,0.9131,0.8857,0.9092,0.8944,0.8722,0.9069,0.8115,0.7566,0.9331,0.9421,0.8579,0.9305,0.8669,0.855,0.8309,0.8461,0.7714,0.7184,0.8226,0.8881,0.8766,0.899,0.907,0.8832,0.9301,0.9255,0.8692,0.8252,0.8395,0.8444,0.9188,0.9028,0.8822,0.9281,0.8951,0.9282,0.8767,0.8767,0.8839,0.8623,0.86,0.9226,0.9431,0.8998,0.9156,0.9034,0.8887,0.8593,0.8807]
sfl_pc1=[0.7603,0.7747,0.7789,0.7824,0.7833,0.7846,0.7858,0.7878,0.7877,0.7894,0.7903,0.7899,0.7892,0.7921,0.7912,0.7928,0.793,0.7926,0.793,0.7928,0.7934,0.7933,0.7931,0.7936,0.7941,0.7928,0.7943,0.7944,0.7941,0.7935,0.7938,0.7948,0.795,0.7943,0.7936,0.7942,0.794,0.7953,0.795,0.7948,0.7943,0.7949,0.7946,0.7946,0.7937,0.7945,0.7941,0.7957,0.7954,0.7953,0.7957,0.7956,0.7952,0.7951,0.7956,0.7955,0.7948,0.7954,0.7958,0.7954,0.7951,0.7952,0.7943,0.7954,0.795,0.7958,0.7959,0.7953,0.7954,0.7959,0.7956,0.7958,0.7958,0.7958,0.7963,0.7959,0.7959,0.7962,0.7957,0.7962,0.7961,0.7954,0.7957,0.7964,0.7964,0.7963,0.7962,0.7962,0.7965,0.796,0.7961,0.7963,0.796,0.7961,0.7953,0.7961,0.7955,0.7959,0.796,0.7951,0.7957,0.7952,0.7968,0.7958,0.7957,0.7952,0.7959,0.796,0.7963,0.7959,0.7959,0.7959,0.7962,0.7964,0.7958,0.7962,0.7961,0.7961,0.7959,0.7962,0.7948,0.7962,0.7962,0.7963,0.7953,0.7963,0.7962,0.7962,0.7956,0.7959,0.7965,0.7963,0.7964,0.7959,0.7959,0.7957,0.7959,0.7958,0.796,0.7958,0.7963,0.7964,0.7961,0.7968,0.7962,0.7966,0.796,0.7963,0.7965,0.7962,0.7961,0.796,0.7964,0.7959,0.7964,0.7965,0.7958,0.796,0.7954,0.7963,0.7962,0.7965,0.7964,0.7961,0.7962,0.7965,0.7961,0.7965,0.7961,0.7963,0.7964,0.7956,0.7964,0.7962,0.7962,0.7956,0.7963,0.7966,0.7962,0.7968,0.796,0.7952,0.7966,0.7962,0.7966,0.7963,0.7967,0.7963,0.7962,0.7965,0.7965,0.7967,0.7962,0.7961,0.797,0.7961,0.7964,0.7963,0.7968,0.7966,0.7968,0.7964,0.7963,0.7959,0.7968,0.7971,0.7964,0.7962,0.7958,0.7967,0.7962,0.7968,0.7972,0.7966,0.7965,0.7971,0.7966,0.796,0.7962,0.7965,0.7964,0.7964,0.7963,0.7964,0.7965,0.7956,0.7962,0.7963,0.7963,0.7967,0.7962,0.7963,0.7964,0.7957,0.7968,0.7964,0.7961,0.7963,0.7961,0.7958,0.7955,0.7957,0.7963,0.7962,0.7965,0.7966,0.796,0.7962,0.7965,0.7959,0.7963,0.7963,0.7963,0.7962,0.7963,0.7958,0.796,0.7962,0.7964,0.7964,0.7957,0.7961,0.7965,0.7964,0.7957,0.796,0.7957,0.796,0.7963,0.7961,0.7962,0.7967,0.7968,0.7964,0.7965,0.7966,0.7965,0.797,0.7965,0.7969,0.796,0.7963,0.7958,0.7963,0.7962,0.7959,0.7967,0.7961,0.7964,0.796,0.7956,0.7965,0.7963,0.7967,0.7959,0.7965,0.7953,0.7958,0.7958,0.7954,0.7959,0.7961,0.796,0.7963,0.7963,0.7963,0.7961,0.796,0.7964,0.7967,0.7963,0.7965,0.7961,0.7962,0.7963,0.7961,0.7962,0.7966,0.7964,0.7964,0.7961,0.7966,0.7959,0.7962,0.7965,0.796,0.7958,0.7961,0.7957,0.7959,0.7963,0.7959,0.7967,0.7961,0.7962,0.7962,0.796,0.7965,0.7961,0.7961,0.7961,0.7958,0.7963,0.7959,0.7962,0.7962,0.7967,0.7959,0.7961,0.7959,0.7959,0.7965,0.7967,0.7963,0.7964,0.7962,0.7959,0.7962,0.7966,0.7964,0.7959,0.7961,0.7962,0.7953,0.7959,0.7958,0.7966,0.7964,0.7963,0.7965,0.7963,0.7965,0.7959,0.7963,0.7969,0.7962,0.7963,0.7966,0.7966,0.797,0.7967,0.7966,0.7967,0.7961,0.7964,0.7965,0.7963,0.7962,0.7962,0.7966,0.7958,0.7967,0.7969,0.7962,0.7965,0.7961,0.7961,0.7958,0.7961,0.7967,0.796,0.7958,0.7959,0.7962,0.7961,0.7959,0.7965,0.7968,0.796,0.7965,0.7965,0.7963,0.7966,0.7964,0.7961,0.7963,0.7956,0.7964,0.796,0.7959,0.796,0.7961,0.7965,0.7962,0.7957,0.7959,0.7967,0.7965,0.7965,0.7959,0.7965,0.7965,0.7962,0.7963,0.7966,0.7965,0.7963,0.7965,0.7961,0.7962,0.7966,0.7961,0.7968,0.796,0.7962,0.7963,0.7957,0.7962,0.7964,0.7963,0.7967,0.7965,0.7968,0.7962,0.7964,0.7959,0.7969,0.7961,0.7965,0.7971,0.7961,0.7965,0.7963,0.7962,0.7961,0.7968,0.797,0.7966,0.7962,0.7964,0.7964,0.7961,0.7962,0.7966,0.7959,0.7962,0.7962,0.7964,0.7961,0.7965,0.7959,0.7962,0.7963,0.7961,0.7965,0.7964,0.7958,0.796,0.7962,0.7963,0.7965,0.7962,0.7963,0.7966,0.7965,0.7967,0.7961,0.7964,0.7972,0.7963,0.7963,0.797,0.7961,0.7961,0.7962,0.7963,0.7963,0.7959,0.7961,0.7959,0.7963,0.7965,0.7959,0.7956,0.7957,0.7966,0.7967,0.7964,0.796,0.7963,0.796,0.7963,0.7963,0.7967,0.7958,0.7963,0.7965,0.7965,0.7964,0.7967,0.7956,0.7959,0.7963,0.7967,0.7964,0.7962,0.7965,0.7962,0.7968,0.7964,0.7961,0.7967,0.7962,0.7965,0.7964,0.7964,0.7963,0.7969,0.7962,0.7965,0.7961,0.7963,0.7967,0.7964,0.7962,0.796,0.7961,0.7967,0.796,0.7964,0.7962,0.7962,0.7967,0.7966,0.7966,0.7963,0.7964,0.7962,0.796,0.7961,0.796,0.7959,0.7962,0.7963,0.7965,0.7962,0.7965,0.7965,0.796,0.7961,0.7967,0.7957,0.7962,0.7967,0.7963,0.7958,0.7958,0.7963,0.796,0.7966,0.796,0.7961,0.7962,0.7961,0.7962,0.7966,0.7961,0.796,0.7958,0.7959,0.7963,0.796,0.7961,0.7963,0.796,0.7965,0.7963,0.7964,0.7961,0.7966,0.7961,0.796,0.7961,0.7967,0.7961,0.7964,0.7963,0.7963,0.7956,0.7959,0.7957,0.7963,0.7958,0.7961,0.7962,0.7956,0.7964,0.7964,0.7966,0.7968,0.7969,0.7967,0.7961,0.7967,0.7962,0.7961,0.7961,0.7964,0.7971,0.7964,0.7966,0.7965,0.7966,0.7965,0.7962,0.7964,0.7957,0.7958,0.7963,0.7962,0.7961,0.7961,0.7963,0.7969,0.7973,0.7968,0.7963,0.7961,0.7964,0.7966,0.7958,0.7963,0.7965,0.7968,0.7962,0.7966,0.7967,0.7961,0.7966,0.796,0.7962,0.7965,0.7962,0.7966,0.7964,0.7965,0.7964,0.7961,0.7962,0.7957,0.7956,0.7965,0.7958,0.7964,0.7962,0.7958,0.7965,0.7963,0.7957,0.7959,0.796,0.7959,0.7969,0.7958,0.7958,0.7961,0.7968,0.7964,0.7965,0.7965,0.7967,0.7964,0.7963,0.7967,0.7958,0.7967,0.7969,0.7965,0.797,0.7974,0.7967,0.7966,0.7967,0.7961,0.7957,0.7965,0.7966,0.7965,0.7963,0.7965,0.7966,0.7962,0.7959,0.7967,0.7964,0.7966,0.7961,0.7963,0.7961,0.7957,0.7964,0.7967,0.7968,0.7967,0.7964,0.7966,0.7965,0.7963,0.7969,0.7963,0.796,0.7964,0.7963,0.7968,0.7964,0.796,0.7964,0.7969,0.7963,0.797,0.7969,0.7961,0.7959,0.7964,0.7964,0.7964,0.7963,0.7971,0.7962,0.7964,0.7961,0.796,0.7964,0.7964,0.7966,0.7968,0.7963,0.7962,0.7963,0.796,0.7967,0.7963,0.7961,0.7966,0.7957,0.7962,0.7964,0.7961,0.7963,0.796,0.7963,0.7962,0.7963,0.7963,0.7964,0.796,0.7963,0.7959,0.7967,0.7964,0.7961,0.7967,0.7963,0.7964,0.7964,0.7962,0.7956,0.7959,0.796,0.796,0.7959,0.7962,0.7961,0.796,0.797,0.7965,0.7966,0.7961,0.7959,0.7962,0.7963,0.7963,0.796,0.7962,0.7966,0.7961,0.7965,0.7961,0.7965,0.7964,0.797,0.7966,0.7968,0.7965,0.7963,0.7965,0.7958,0.7965,0.7963,0.7967,0.7965,0.7969,0.7967,0.7969,0.7961,0.7962,0.7964,0.796,0.7965,0.7965,0.7969,0.7966,0.7967,0.7964,0.7964,0.796,0.7968,0.7963,0.7965,0.7966,0.7961,0.7967,0.7965,0.7968,0.7965,0.7973,0.7965,0.7963,0.7969,0.7963,0.7966,0.7968,0.7966,0.7965,0.7962,0.7964,0.7963,0.7964,0.7961,0.7967,0.7962,0.7959,0.7964,0.7961,0.7962,0.796,0.7969,0.7964,0.7963,0.7966,0.7966,0.7965,0.7968,0.7963,0.7961,0.7967,0.7968,0.7967,0.7958,0.7966,0.7957,0.7968,0.7964,0.7968,0.7964,0.7968,0.7962,0.7967,0.7967,0.7969,0.7968,0.7969,0.7966,0.7963,0.7965,0.7968,0.7967,0.7962,0.7968,0.7966,0.7966,0.7964,0.7971,0.7966,0.7965,0.7962,0.7961,0.796,0.7967,0.7966,0.7964,0.797,0.7962,0.7968,0.7967,0.7965,0.7968,0.7968,0.7967,0.7964,0.7965,0.7966,0.7965,0.7965,0.7965,0.7965,0.7961,0.7968,0.7969,0.7968,0.7965,0.796,0.7963,0.796,0.7963,0.7968,0.7962,0.7961,0.7962,0.7966,0.796,0.7971,0.797,0.7965,0.7967,0.7963,0.7967,0.7965,0.7968,0.7968,0.7968,0.7961,0.7967,0.7967,0.7965,0.7966,0.7971,0.797,0.7967,0.7967,0.7961,0.7963,0.7963,0.7963,0.7961,0.7959,0.7965,0.7966,0.7961,0.7962,0.7962,0.7962,0.7962,0.7961,0.7957,0.7961,0.796,0.796,0.7966,0.7964,0.7965,0.7968,0.7968,0.7962,0.7962,0.7963,0.7969,0.7966,0.7965,0.7961]

draw_icml(e2s_pc1,e2e_pc1,bf_pc1,bfc_pc1,sfl_pc1,'mnist_50_pc1.pdf','lower right')