#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt

SLIDE_WIN=10
ALPHA=.2

def sliding_avg(input_data, slide_win=5):
    input_len = len(input_data)
    output_data = []
    output_data.append(input_data[0])
    for x in range(slide_win, input_len, slide_win):
        avg_value = np.mean(input_data[x:x+slide_win])
        output_data.append(avg_value)
        pass
    output_axis = np.linspace(0, input_len, len(output_data))
    return output_axis, output_data

#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt
def draw_icml(Fed_E2S,Fed_E2E,Base_FedAvg,Base_FedCyCP,sfl,file_name,loc):
    mpl.rcParams['lines.linewidth'] = 2
    x = np.arange(0,1000)

    xys = make_interp_spline(x,Fed_E2S)
    x_z = np.linspace(0, 999, 1000)
    FedE2S_s = xys(x_z)
    
    xys = make_interp_spline(x,Fed_E2E)
    x_e = np.linspace(0, 999, 1000)
    Fed_E2E_s = xys(x_e)

    xys = make_interp_spline(x,Base_FedAvg)
    x_f = np.linspace(0,999, 1000)
    Base_FedAvg_s = xys(x_f)

    xys = make_interp_spline(x,Base_FedCyCP)
    x_c = np.linspace(0, 999, 1000)
    Base_FedCyCP_s = xys(x_c)
    
    xys = make_interp_spline(x,sfl)
    x_sf = np.linspace(0,999,1000)
    sfl_s = xys(x_sf)

    fig0 = plt.figure(figsize=plt.figaspect(1))
    ax0 = fig0.add_subplot(1,1,1)
    ax0.grid(linestyle='-')
    fig0.set_figwidth(4)
    fig0.set_figheight(4)
    
    avg_x_z, avg_FedE2S_s = sliding_avg(FedE2S_s, slide_win=SLIDE_WIN)
    avg_x_e, avg_Fed_E2E_s = sliding_avg(Fed_E2E_s, slide_win=SLIDE_WIN)
    avg_x_f, avg_Base_FedAvg_s = sliding_avg(Base_FedAvg_s, slide_win=SLIDE_WIN)
    avg_x_c, avg_Base_FedCyCP_s = sliding_avg(Base_FedCyCP_s, slide_win=SLIDE_WIN)
    avg_x_sfl, avg_sfl_s = sliding_avg(sfl_s, slide_win=SLIDE_WIN)
    

    ax0.plot(avg_x_z, avg_FedE2S_s, color = 'C2', linestyle = 'solid', label = 'HFL-E2S')
    ax0.plot(avg_x_e, avg_Fed_E2E_s, color = 'C3', linestyle = 'solid', label = 'HFL-E2E')
    ax0.plot(avg_x_f, avg_Base_FedAvg_s, color = "C0", linestyle = 'solid', label = 'Base_FedAvg')
    ax0.plot(avg_x_c, avg_Base_FedCyCP_s, color = "C4", linestyle = 'solid', label = 'Base_FedCyCP')
    ax0.plot(avg_x_sfl, avg_sfl_s, color = "C1", linestyle = 'solid', label = 'SFL')

    #line1=ax0.plot(x_m,m_3_test_s,color="C1",linestyle='solid',label='Mean Imputation',markersize = 15, marker=".",markevery=50)
#     ax0.plot(x_z,FedE2S_s,color='C2',linestyle='solid',label='HFL-E2S')
#     ax0.plot(x_e,Fed_E2E_s,color='C3',linestyle='solid',label='HFL-E2E',)
#     ax0.plot(x_f,Base_FedAvg_s,color="C0",linestyle='solid',label='Base_FedAvg')
#     ax0.plot(x_c,Base_FedCyCP_s,color="#b28c6e",linestyle='solid',label='Base_FedCyCP')

    #legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5,bbox_to_anchor=[1, 0.7])
    legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5)

    ax0.set_xlim(0,999)
    ax0.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
    ax0.set_xticklabels(['0','100','200','300','400','500','600','700','800','900','1000'])
    ax0.set_xlabel('Communication Rounds',fontsize='large',fontweight='bold')
    ax0.set_ylabel('Test Accuracy',fontsize='large',fontweight='bold')
    ax0.set_ylim(0.3,1) #(0.4-1) 
    
    fig0.savefig(file_name,dpi=500,bbox_inches = 'tight')
#icml_24_400=[0.1009,0.0974,0.0974,0.1009,0.0892,0.0892,0.1028,0.0982,0.1028,0.0974,0.1705,0.1347,0.0974,0.1009,0.2356,0.1305,0.1829,0.1214,0.2643,0.1606,0.0892,0.1862,0.1061,0.1975,0.2047,0.3028,0.0974,0.114,0.0998,0.1822,0.1889,0.1942,0.2406,0.3139,0.2951,0.2748,0.2974,0.1062,0.1495,0.4265,0.2547,0.3616,0.1581,0.4512,0.4001,0.3687,0.2403,0.3547,0.3507,0.2297,0.4441,0.1247,0.371,0.3869,0.2443,0.2835,0.4172,0.425,0.414,0.436,0.4962,0.4247,0.4155,0.4877,0.4495,0.378,0.1358,0.4562,0.4212,0.4704,0.4763,0.4717,0.2223,0.4477,0.3686,0.2542,0.531,0.6428,0.5013,0.5487,0.2281,0.6381,0.5242,0.6225,0.6032,0.4201,0.4503,0.4624,0.5585,0.5827,0.4438,0.4273,0.3709,0.4714,0.4034,0.5321,0.5029,0.6018,0.5419,0.2401,0.5949,0.5283,0.591,0.4646,0.5854,0.2891,0.602,0.6018,0.5851,0.6394,0.585,0.605,0.5838,0.6337,0.577,0.35,0.5995,0.6086,0.5729,0.5034,0.6024,0.6658,0.6224,0.6567,0.5986,0.6285,0.6174,0.6129,0.5265,0.516,0.5685,0.3348,0.6012,0.5118,0.4654,0.6287,0.28,0.3282,0.5362,0.5236,0.5932,0.5662,0.664,0.6911,0.6119,0.6261,0.5959,0.5995,0.5891,0.5704,0.6537,0.5178,0.7066,0.6245,0.6757,0.6974,0.6188,0.4154,0.437,0.7135,0.6485,0.5898,0.6376,0.6458,0.6601,0.6883,0.5766,0.6516,0.6434,0.6814,0.6551,0.663,0.6365,0.6279,0.6273,0.4387,0.5035,0.5659,0.613,0.6359,0.6298,0.6383,0.647,0.618,0.5664,0.6156,0.5881,0.6548,0.6464,0.5852,0.6453,0.589,0.5626,0.5693,0.6405,0.669,0.6526,0.4737,0.6663,0.6594,0.4915,0.6486,0.6263,0.5172,0.6579,0.6517,0.5347,0.7071,0.5963,0.6616,0.6064,0.6758,0.5266,0.6265,0.6817,0.6102,0.6507,0.6836,0.6628,0.6633,0.6644,0.7248,0.6932,0.6866,0.7278,0.5817,0.7157,0.6997,0.7007,0.6618,0.6668,0.6613,0.5531,0.6572,0.6488,0.7004,0.6955,0.5297,0.6322,0.5479,0.6376,0.7076,0.6926,0.6479,0.7371,0.7308,0.5863,0.5801,0.7338,0.6493,0.6519,0.6442,0.7304,0.5391,0.6526,0.5618,0.6835,0.6789,0.6918,0.7003,0.682,0.6017,0.6539,0.669,0.6455,0.6784,0.7033,0.6824,0.5701,0.6893,0.6739,0.6318,0.6753,0.6828,0.705,0.6275,0.6216,0.6711,0.705,0.6722,0.6309,0.7006,0.6799,0.7359,0.7121,0.7157,0.7382,0.6584,0.6718,0.7415,0.7166,0.6986,0.6521,0.7082,0.6731,0.6593,0.7322,0.7177,0.7168,0.6819,0.6919,0.7196,0.6709,0.6584,0.6447,0.6774,0.7021,0.668,0.5959,0.6803,0.6602,0.6305,0.5647,0.5697,0.6754,0.7205,0.7174,0.6935,0.6918,0.6824,0.7121,0.6594,0.6741,0.7553,0.6989,0.732,0.7135,0.7352,0.6534,0.6717,0.6547,0.684,0.6616,0.7069,0.7172,0.7534,0.7048,0.734,0.6864,0.6849,0.706,0.7532,0.7208,0.746,0.7105,0.7157,0.7141,0.6764,0.6043,0.6886,0.7132,0.7424,0.6985,0.6352,0.6966,0.7327,0.7241,0.6936,0.7132,0.7084,0.6871,0.6687,0.6586,0.6687,0.7053,0.6307,0.693,0.6724,0.6756,0.6904,0.673,0.6211,0.6983,0.6651,0.7065,0.6697,0.7326,0.7282,0.6997,0.6809,0.7293,0.7219,0.6923,0.6817,0.682,0.6911,0.7237,0.7375,0.7528,0.7406,0.6903,0.7058,0.7538,0.7368,0.7183,0.7478,0.7131,0.6699,0.694,0.6675]
e2e_pc1=[0.7764,0.781,0.7858,0.785,0.7877,0.7862,0.7906,0.7917,0.792,0.7923,0.7905,0.7926,0.7916,0.7934,0.7931,0.7936,0.7938,0.794,0.7939,0.7938,0.7942,0.7948,0.7942,0.795,0.7949,0.7945,0.7933,0.7941,0.7943,0.7947,0.7943,0.795,0.7954,0.795,0.7952,0.7954,0.7957,0.7953,0.7944,0.7953,0.7966,0.7955,0.7956,0.7954,0.7954,0.7964,0.7968,0.7961,0.7957,0.7963,0.7957,0.7952,0.7962,0.795,0.796,0.7956,0.7951,0.7956,0.7963,0.7963,0.7966,0.7961,0.7965,0.7957,0.7961,0.7965,0.7954,0.7963,0.796,0.796,0.796,0.7954,0.7953,0.7962,0.7961,0.7963,0.7966,0.7961,0.7968,0.7965,0.7964,0.7953,0.7964,0.7961,0.7965,0.7957,0.7966,0.7965,0.7956,0.7967,0.7965,0.7963,0.7962,0.7965,0.7965,0.7967,0.7959,0.7964,0.797,0.7964,0.7965,0.7962,0.7964,0.7964,0.7966,0.797,0.796,0.7958,0.796,0.7959,0.7964,0.7966,0.7967,0.797,0.7966,0.7959,0.7958,0.7963,0.7964,0.7954,0.7961,0.7966,0.7965,0.7965,0.7967,0.7965,0.796,0.7958,0.7964,0.796,0.7966,0.796,0.7962,0.7968,0.7961,0.7962,0.7965,0.7956,0.7961,0.7966,0.7957,0.7958,0.7964,0.7964,0.7968,0.7972,0.7964,0.7969,0.7965,0.7961,0.7964,0.7966,0.7972,0.7959,0.7966,0.7963,0.7964,0.7957,0.797,0.7963,0.7965,0.7958,0.7961,0.7962,0.7963,0.797,0.7962,0.7973,0.797,0.7966,0.7962,0.7963,0.7964,0.7959,0.7964,0.7966,0.7959,0.796,0.7963,0.7965,0.7962,0.7963,0.7967,0.7967,0.7963,0.7967,0.7965,0.7968,0.7965,0.7969,0.7971,0.7969,0.7968,0.7963,0.797,0.7971,0.7965,0.7966,0.7965,0.7967,0.7957,0.7962,0.797,0.7965,0.796,0.7965,0.796,0.795,0.7968,0.7968,0.7972,0.7966,0.7966,0.797,0.7968,0.7966,0.797,0.7964,0.7968,0.797,0.7968,0.797,0.7972,0.797,0.7959,0.7969,0.7962,0.7973,0.7973,0.7962,0.7965,0.7959,0.7966,0.7966,0.7972,0.7963,0.7962,0.796,0.7962,0.7969,0.7967,0.7967,0.7971,0.7977,0.7969,0.7956,0.7969,0.7971,0.797,0.7973,0.7971,0.7968,0.7968,0.7972,0.7974,0.7969,0.7967,0.7969,0.7971,0.7975,0.7967,0.797,0.7969,0.7966,0.7961,0.7965,0.797,0.7973,0.7972,0.7972,0.7968,0.7967,0.797,0.7974,0.7977,0.7968,0.7975,0.797,0.7974,0.7969,0.797,0.7972,0.7971,0.7976,0.7966,0.7976,0.7973,0.7967,0.7968,0.7971,0.797,0.7969,0.7966,0.7971,0.7962,0.7967,0.7969,0.7963,0.7971,0.7971,0.797,0.7975,0.7966,0.7966,0.7973,0.7979,0.7968,0.7969,0.7969,0.7968,0.797,0.7962,0.7968,0.7971,0.7969,0.7976,0.7965,0.7968,0.7966,0.7966,0.7968,0.7971,0.7969,0.7967,0.7966,0.7969,0.797,0.7965,0.7967,0.797,0.7971,0.7976,0.7965,0.7968,0.7973,0.797,0.7963,0.797,0.797,0.7969,0.7964,0.7964,0.7967,0.7972,0.7972,0.7968,0.7969,0.7971,0.7975,0.7975,0.7972,0.7971,0.7965,0.7961,0.797,0.7968,0.7972,0.7971,0.7974,0.7972,0.7971,0.797,0.7972,0.7966,0.7972,0.7976,0.7978,0.7975,0.7973,0.7971,0.7977,0.7973,0.7966,0.7972,0.7971,0.7969,0.7969,0.7966,0.7971,0.7975,0.797,0.7965,0.7969,0.7972,0.7966,0.7973,0.797,0.7965,0.797,0.7972,0.7968,0.797,0.7967,0.7969,0.7968,0.7969,0.7968,0.7972,0.797,0.7969,0.7971,0.7972,0.7968,0.7972,0.7969,0.7966,0.7963,0.797,0.7971,0.7969,0.7968,0.7968,0.7966,0.7968,0.7966,0.7968,0.7966,0.7963,0.7966,0.7966,0.7974,0.7967,0.7971,0.7969,0.7963,0.7967,0.7969,0.7965,0.7966,0.7971,0.797,0.797,0.7968,0.7962,0.7966,0.7963,0.7974,0.7972,0.7971,0.7969,0.797,0.797,0.797,0.7973,0.7975,0.7974,0.7972,0.7963,0.7968,0.797,0.7965,0.7969,0.797,0.7966,0.7966,0.7967,0.797,0.7964,0.7969,0.7973,0.797,0.797,0.7962,0.7971,0.7967,0.7971,0.7968,0.797,0.7966,0.7961,0.7967,0.7969,0.7971,0.7974,0.7968,0.7968,0.7974,0.7963,0.7967,0.797,0.7968,0.7967,0.7967,0.7967,0.797,0.7971,0.7968,0.797,0.797,0.7969,0.7968,0.7971,0.7965,0.797,0.7968,0.7969,0.7969,0.797,0.7966,0.7961,0.7972,0.7968,0.7967,0.7968,0.7964,0.7962,0.7965,0.7967,0.796,0.7965,0.796,0.7961,0.7967,0.797,0.7967,0.7967,0.7973,0.7969,0.7965,0.7967,0.7968,0.7968,0.797,0.7969,0.7965,0.7971,0.7965,0.7972,0.7967,0.7963,0.7962,0.7964,0.7969,0.7969,0.797,0.7966,0.7969,0.7963,0.797,0.7961,0.7965,0.7967,0.797,0.797,0.7961,0.7963,0.7969,0.7968,0.7971,0.797,0.7964,0.797,0.7963,0.7964,0.7969,0.7969,0.7968,0.7973,0.7969,0.7968,0.7971,0.797,0.7964,0.7969,0.7968,0.7962,0.7967,0.7967,0.7973,0.7962,0.7968,0.7966,0.7966,0.7966,0.7968,0.7961,0.7965,0.7968,0.7965,0.7964,0.7967,0.7967,0.7967,0.7961,0.7967,0.7957,0.7963,0.7964,0.7966,0.7968,0.7964,0.7967,0.7967,0.797,0.7964,0.7967,0.7969,0.7967,0.7971,0.796,0.7965,0.7964,0.7965,0.7973,0.7964,0.7971,0.7965,0.7965,0.7965,0.7967,0.7966,0.7968,0.7971,0.7968,0.7967,0.7964,0.7971,0.7969,0.7973,0.7959,0.797,0.7966,0.7963,0.7969,0.797,0.7964,0.7968,0.7967,0.7967,0.7966,0.7967,0.797,0.7969,0.7967,0.7968,0.7968,0.7972,0.7969,0.7962,0.7969,0.7965,0.7967,0.7966,0.7975,0.7973,0.7971,0.797,0.7966,0.7968,0.7967,0.797,0.7968,0.7965,0.7965,0.7966,0.7968,0.7965,0.7968,0.797,0.7968,0.7969,0.7971,0.7965,0.7967,0.7967,0.7976,0.7967,0.7968,0.797,0.7959,0.7954,0.7967,0.7968,0.7969,0.7967,0.7971,0.7964,0.7967,0.7965,0.7971,0.7965,0.7959,0.7962,0.7969,0.7963,0.7976,0.7967,0.7964,0.7968,0.7967,0.7962,0.7968,0.7969,0.7961,0.7961,0.7963,0.7965,0.7965,0.7965,0.7969,0.7962,0.7965,0.7969,0.7962,0.7962,0.7969,0.7969,0.7964,0.7966,0.797,0.7972,0.7966,0.7968,0.7971,0.7974,0.7964,0.7966,0.797,0.7972,0.7969,0.7967,0.796,0.7972,0.7972,0.7971,0.7966,0.7974,0.7967,0.7961,0.7965,0.7967,0.7963,0.7975,0.7964,0.7968,0.797,0.7968,0.7963,0.797,0.7968,0.7966,0.7963,0.7966,0.7971,0.7968,0.7961,0.7965,0.7971,0.7967,0.7964,0.7966,0.7972,0.7967,0.7968,0.7969,0.7969,0.7972,0.7963,0.7972,0.7974,0.7966,0.7966,0.7962,0.7971,0.797,0.7971,0.797,0.7966,0.7962,0.7967,0.7973,0.7974,0.7971,0.7976,0.7969,0.7969,0.7964,0.7964,0.7973,0.7965,0.7968,0.7964,0.7971,0.7971,0.7968,0.7968,0.797,0.7968,0.7967,0.7967,0.7967,0.7967,0.7972,0.7971,0.7965,0.7968,0.7969,0.7959,0.7966,0.7969,0.7971,0.7961,0.7965,0.7967,0.7965,0.7969,0.7966,0.7969,0.7965,0.797,0.7959,0.7969,0.7967,0.7969,0.797,0.7963,0.7966,0.7964,0.7969,0.7964,0.7969,0.7966,0.7962,0.7968,0.7964,0.7969,0.7965,0.796,0.7967,0.7964,0.7965,0.7969,0.7972,0.7969,0.797,0.797,0.7967,0.7964,0.7965,0.7965,0.7965,0.7968,0.7967,0.7967,0.7964,0.7961,0.7959,0.7967,0.7961,0.796,0.7961,0.7962,0.7959,0.7958,0.7964,0.7967,0.7965,0.7968,0.7972,0.7956,0.7968,0.7969,0.7964,0.7962,0.7967,0.7973,0.7974,0.797,0.7968,0.7966,0.7964,0.7963,0.7965,0.7967,0.7969,0.7959,0.7968,0.7966,0.7961,0.7968,0.797,0.7966,0.7966,0.7967,0.7967,0.7969,0.7973,0.7964,0.797,0.7967,0.7971,0.7969,0.7966,0.7964,0.7964,0.7968,0.7964,0.7966,0.7967,0.7968,0.7965,0.7967,0.7968,0.7965,0.7964,0.7969,0.7971,0.7969,0.7961,0.796,0.7969,0.7967,0.797,0.797,0.7972,0.7966,0.7967,0.7964,0.7973,0.7971,0.7968,0.7965,0.7966,0.7968,0.7963,0.797,0.7971,0.7963,0.7967,0.7967,0.797,0.7966,0.7968,0.797,0.7967,0.7967,0.7969,0.7963,0.7962,0.7967,0.7966,0.7966,0.7961,0.7969,0.7964,0.797,0.7967,0.7963,0.797,0.797,0.7964,0.7968,0.7965,0.7964,0.7969,0.7966,0.7965,0.7967,0.797,0.7961,0.7967,0.7964,0.7968,0.7968,0.7958,0.7969,0.7969,0.7964,0.7972,0.7975,0.7969,0.7969,0.7969,0.7972,0.797,0.7973,0.7972,0.7968,0.7973,0.7972,0.7973,0.7967,0.796,0.7972,0.7968,0.7971,0.7967,0.7969,0.7972,0.7969,0.797,0.7967,0.7966,0.7969,0.7971,0.797,0.7962,0.7965,0.7969,0.7965]
e2s_pc1=[0.6973,0.7361,0.7511,0.7585,0.765,0.7693,0.771,0.7745,0.7759,0.7773,0.7774,0.7783,0.7793,0.78,0.7805,0.7809,0.7811,0.7821,0.7826,0.7823,0.7827,0.7832,0.7829,0.7838,0.7845,0.7839,0.7843,0.7853,0.7852,0.7851,0.7855,0.7861,0.7857,0.7867,0.7865,0.7866,0.787,0.7873,0.7884,0.7878,0.7879,0.7879,0.7883,0.7881,0.7874,0.7884,0.7885,0.7891,0.7892,0.7892,0.7895,0.789,0.7891,0.7896,0.7896,0.7897,0.79,0.7898,0.79,0.7899,0.7895,0.7897,0.7898,0.7906,0.7903,0.7902,0.7904,0.7905,0.791,0.791,0.7909,0.7907,0.7911,0.7908,0.7911,0.7904,0.7915,0.7914,0.7906,0.7905,0.7914,0.7914,0.7912,0.7907,0.7909,0.7915,0.7918,0.7921,0.7917,0.792,0.7928,0.7922,0.7924,0.7922,0.7919,0.7917,0.7922,0.7926,0.7922,0.7925,0.7929,0.792,0.7924,0.7922,0.7929,0.7927,0.7928,0.7928,0.7932,0.7927,0.7931,0.7928,0.7922,0.7925,0.7932,0.7927,0.793,0.7931,0.7925,0.7936,0.7931,0.7933,0.7925,0.7931,0.7928,0.7929,0.7933,0.7939,0.7936,0.7933,0.7937,0.7936,0.7941,0.7939,0.7939,0.7939,0.7937,0.7939,0.7936,0.7936,0.7942,0.7935,0.794,0.794,0.7941,0.7942,0.7943,0.7944,0.7943,0.795,0.7945,0.795,0.7944,0.7941,0.7941,0.7933,0.7938,0.7942,0.7949,0.7942,0.7941,0.7943,0.7946,0.7947,0.7947,0.7949,0.7942,0.7946,0.795,0.7946,0.7946,0.795,0.795,0.7952,0.7945,0.7949,0.7952,0.7948,0.7945,0.795,0.7949,0.7949,0.7949,0.7952,0.795,0.795,0.795,0.795,0.7948,0.795,0.795,0.7949,0.7954,0.7954,0.7959,0.7949,0.7952,0.7957,0.7959,0.7955,0.7953,0.7953,0.7956,0.7955,0.7953,0.7952,0.7953,0.7953,0.7957,0.7955,0.7951,0.7949,0.7953,0.7952,0.7953,0.7956,0.7958,0.7959,0.7959,0.7957,0.7959,0.7958,0.7954,0.7956,0.7959,0.7958,0.7955,0.7958,0.7959,0.7958,0.7961,0.7956,0.7962,0.7961,0.796,0.7956,0.7958,0.7953,0.796,0.7958,0.7957,0.796,0.7954,0.7959,0.7962,0.7954,0.7955,0.7955,0.7959,0.7955,0.7957,0.7954,0.796,0.7951,0.7958,0.7961,0.7957,0.7955,0.7959,0.7956,0.7957,0.796,0.7956,0.7962,0.7956,0.7957,0.7961,0.7963,0.7966,0.7961,0.7962,0.796,0.7957,0.7957,0.7956,0.7956,0.7957,0.7956,0.7956,0.7961,0.796,0.7958,0.7955,0.7962,0.7956,0.7957,0.7958,0.7957,0.7964,0.7962,0.7959,0.7955,0.7955,0.7958,0.7958,0.796,0.7962,0.7962,0.7962,0.7965,0.7965,0.7961,0.7963,0.796,0.7963,0.7959,0.7961,0.7962,0.7957,0.7965,0.7959,0.7962,0.7961,0.7964,0.7964,0.7963,0.7963,0.7959,0.7965,0.7963,0.796,0.7962,0.7956,0.7962,0.7963,0.796,0.7955,0.7958,0.7957,0.7958,0.7961,0.7961,0.796,0.7961,0.796,0.7962,0.796,0.7965,0.7962,0.7961,0.7956,0.7966,0.7962,0.7963,0.7962,0.7959,0.796,0.796,0.7962,0.7966,0.7958,0.7962,0.7958,0.7961,0.7963,0.7964,0.796,0.7968,0.796,0.7966,0.7964,0.7961,0.7961,0.7961,0.7961,0.7958,0.7962,0.7955,0.7961,0.7965,0.7962,0.7961,0.7965,0.7959,0.7966,0.796,0.7967,0.7961,0.7963,0.7959,0.7964,0.7962,0.7963,0.7959,0.7959,0.7959,0.7964,0.7961,0.796,0.7963,0.7961,0.7962,0.7963,0.7963,0.7966,0.7962,0.7966,0.7963,0.7965,0.7962,0.7965,0.796,0.7965,0.7963,0.7964,0.7969,0.797,0.7966,0.7966,0.7964,0.7966,0.7962,0.7959,0.7964,0.7963,0.7968,0.7966,0.7965,0.7963,0.7967,0.7965,0.7964,0.7964,0.7963,0.7969,0.7965,0.7959,0.7966,0.7965,0.7968,0.7966,0.7965,0.7959,0.7964,0.7963,0.7967,0.7968,0.796,0.7963,0.7966,0.7965,0.796,0.7963,0.7966,0.797,0.7966,0.7972,0.7968,0.797,0.7969,0.797,0.7965,0.7969,0.7969,0.7966,0.7966,0.7967,0.7967,0.7966,0.7966,0.7967,0.797,0.7968,0.7968,0.7964,0.7965,0.7964,0.7964,0.7968,0.7969,0.7966,0.7968,0.7962,0.7967,0.7971,0.7971,0.797,0.7967,0.7963,0.7967,0.797,0.7974,0.797,0.7969,0.7968,0.7972,0.7974,0.7973,0.7973,0.7968,0.7973,0.7968,0.7967,0.7972,0.7972,0.7969,0.7969,0.7973,0.7971,0.7967,0.7971,0.7967,0.7962,0.7963,0.7967,0.797,0.7969,0.7967,0.7966,0.7967,0.797,0.7973,0.7971,0.7971,0.7971,0.7968,0.797,0.7969,0.7969,0.7967,0.797,0.7971,0.7971,0.7967,0.7969,0.7971,0.7971,0.7969,0.7971,0.7966,0.7967,0.7969,0.7969,0.7969,0.7969,0.797,0.7971,0.7968,0.7971,0.797,0.7971,0.7967,0.7972,0.7966,0.7972,0.7972,0.7964,0.7967,0.7964,0.7967,0.797,0.7971,0.7968,0.7967,0.7966,0.7967,0.7971,0.797,0.7966,0.7967,0.7966,0.797,0.7967,0.7972,0.7971,0.797,0.7972,0.7969,0.797,0.7966,0.7966,0.7966,0.797,0.7973,0.7973,0.7972,0.797,0.7971,0.7971,0.7972,0.7971,0.7971,0.7974,0.7973,0.7973,0.7973,0.7972,0.7967,0.7971,0.7972,0.7969,0.7973,0.7971,0.7972,0.7972,0.7972,0.7973,0.7974,0.797,0.7974,0.7974,0.7974,0.7975,0.797,0.7975,0.7972,0.7973,0.7973,0.7972,0.7967,0.7964,0.7967,0.7971,0.797,0.7971,0.7965,0.7974,0.7973,0.7972,0.7972,0.7969,0.797,0.7973,0.797,0.7972,0.7974,0.7972,0.7972,0.797,0.7969,0.7972,0.7971,0.7974,0.7969,0.7972,0.7968,0.7968,0.7968,0.7969,0.797,0.797,0.7973,0.7973,0.7969,0.7967,0.7969,0.7971,0.7969,0.797,0.7969,0.797,0.7972,0.7971,0.797,0.7972,0.7974,0.7973,0.7967,0.797,0.7972,0.7972,0.7971,0.7972,0.7971,0.7972,0.7974,0.797,0.7971,0.7969,0.7968,0.7965,0.7965,0.7964,0.7973,0.7973,0.797,0.7968,0.7969,0.7971,0.7972,0.7974,0.7973,0.797,0.7971,0.7967,0.7969,0.7969,0.7972,0.7971,0.7968,0.7971,0.7968,0.7972,0.7971,0.7972,0.7973,0.7976,0.7973,0.7976,0.7972,0.7973,0.7969,0.7968,0.7973,0.7973,0.7968,0.797,0.7971,0.797,0.797,0.7972,0.7973,0.7974,0.7971,0.7974,0.7974,0.7974,0.7974,0.7972,0.7975,0.7973,0.7972,0.7971,0.7967,0.7968,0.797,0.7972,0.7975,0.7971,0.7974,0.7973,0.7973,0.7971,0.7973,0.7973,0.7972,0.7971,0.7974,0.7976,0.7971,0.797,0.7973,0.7975,0.7974,0.7973,0.7975,0.7976,0.797,0.7971,0.7971,0.7971,0.7975,0.7973,0.7976,0.7974,0.7973,0.7974,0.7966,0.7973,0.7975,0.7975,0.7971,0.7973,0.7971,0.7973,0.7972,0.7972,0.7969,0.7965,0.7968,0.7967,0.7973,0.7969,0.7968,0.797,0.7972,0.7971,0.7972,0.7968,0.7971,0.7969,0.7965,0.7966,0.7968,0.797,0.7968,0.7973,0.797,0.7971,0.7967,0.7972,0.7969,0.7967,0.7967,0.7965,0.7969,0.7966,0.7968,0.7971,0.7966,0.7971,0.7972,0.7968,0.7965,0.7967,0.7971,0.7968,0.797,0.7971,0.7973,0.797,0.7971,0.7969,0.7971,0.797,0.7965,0.7971,0.7967,0.7967,0.7969,0.7968,0.7971,0.7972,0.7973,0.797,0.7972,0.7971,0.7972,0.7971,0.7973,0.7972,0.7972,0.7972,0.797,0.7974,0.7971,0.7974,0.797,0.7966,0.7969,0.797,0.7971,0.7967,0.7966,0.7969,0.797,0.7968,0.7968,0.7972,0.797,0.7972,0.7972,0.7974,0.797,0.7972,0.7972,0.7974,0.797,0.7971,0.7966,0.7972,0.797,0.7969,0.7969,0.7972,0.7973,0.7971,0.7974,0.7972,0.7971,0.797,0.7968,0.7975,0.7975,0.7972,0.7973,0.7971,0.7971,0.7969,0.7973,0.7965,0.7969,0.7971,0.7973,0.7969,0.7969,0.7972,0.7967,0.7968,0.7972,0.797,0.7971,0.7971,0.7969,0.7972,0.7966,0.7968,0.7968,0.797,0.7967,0.7968,0.7966,0.7969,0.7969,0.7971,0.797,0.7969,0.7973,0.7973,0.7973,0.7971,0.7967,0.7972,0.7971,0.7972,0.7969,0.7968,0.797,0.7971,0.7972,0.7972,0.7971,0.797,0.7971,0.7972,0.7971,0.7971,0.7972,0.7973,0.797,0.7973,0.7969,0.7965,0.797,0.7967,0.797,0.797,0.7968,0.7966,0.7971,0.7972,0.7969,0.7971,0.7969,0.7967,0.7964,0.7969,0.7965,0.7966,0.7971,0.7972,0.7971,0.7975,0.7971,0.7969,0.7966,0.7971,0.7974,0.7973,0.7971,0.7971,0.7976,0.7977,0.7974,0.7973,0.7968,0.7973,0.7971,0.7969,0.7971,0.7967,0.7969,0.7967,0.7967,0.7969,0.797,0.7972,0.797,0.7972,0.7969,0.797,0.7971,0.7971,0.7968,0.7969,0.797,0.7971,0.7973,0.7968,0.7969,0.7972,0.7967,0.7969,0.797,0.7968,0.7967,0.7972,0.7971,0.7973,0.7974]
bfc_pc1=[0.7669,0.7779,0.7816,0.7828,0.7848,0.7871,0.7873,0.7888,0.7886,0.7892,0.7911,0.7905,0.7907,0.7912,0.7918,0.7921,0.7923,0.7926,0.7933,0.7935,0.793,0.7934,0.7933,0.7932,0.7944,0.794,0.7931,0.7944,0.7943,0.7944,0.7948,0.7945,0.7949,0.7941,0.796,0.7955,0.7946,0.7959,0.795,0.7953,0.795,0.7948,0.7953,0.7954,0.7953,0.795,0.7952,0.7947,0.795,0.7955,0.7955,0.7963,0.7953,0.7953,0.7955,0.7962,0.7958,0.7956,0.7957,0.7953,0.7961,0.7954,0.796,0.7962,0.7951,0.7952,0.7961,0.7954,0.7956,0.7958,0.7959,0.7956,0.796,0.7955,0.7958,0.7958,0.7955,0.7956,0.7951,0.7964,0.7956,0.7956,0.7963,0.7957,0.7957,0.7961,0.7957,0.7964,0.7953,0.7959,0.7957,0.7963,0.7956,0.7962,0.7954,0.7962,0.7962,0.7955,0.7959,0.7962,0.7963,0.7956,0.7957,0.7956,0.7959,0.7956,0.7961,0.7959,0.7961,0.7959,0.7961,0.7951,0.7959,0.796,0.7958,0.7963,0.7959,0.7966,0.7963,0.7966,0.7963,0.7963,0.7962,0.7965,0.7964,0.7968,0.7968,0.7962,0.7962,0.7968,0.7963,0.7966,0.7957,0.7965,0.796,0.7959,0.7968,0.796,0.7959,0.7963,0.7963,0.7962,0.796,0.7954,0.7954,0.7962,0.7966,0.7961,0.7961,0.7962,0.7957,0.7967,0.7967,0.7966,0.7964,0.7961,0.7963,0.7966,0.7964,0.7966,0.7962,0.7965,0.7963,0.7968,0.7963,0.796,0.7962,0.7968,0.7965,0.7962,0.7968,0.7962,0.7966,0.7968,0.7964,0.7961,0.7967,0.7957,0.7962,0.7968,0.7968,0.7966,0.7953,0.7959,0.7965,0.7965,0.7969,0.7964,0.7963,0.7969,0.7967,0.7966,0.7961,0.796,0.7963,0.7963,0.7964,0.7961,0.7964,0.7965,0.7963,0.796,0.7966,0.7965,0.7968,0.796,0.7965,0.7966,0.7956,0.7966,0.7963,0.7965,0.7963,0.7963,0.7964,0.7965,0.7966,0.7964,0.7967,0.7968,0.7969,0.7961,0.796,0.795,0.7961,0.7965,0.7964,0.7953,0.7959,0.7962,0.7955,0.7959,0.796,0.7957,0.7964,0.796,0.7964,0.7964,0.7961,0.7963,0.7967,0.797,0.7966,0.7961,0.7967,0.7964,0.7963,0.7967,0.7964,0.7964,0.7964,0.7967,0.797,0.7964,0.7966,0.7965,0.7962,0.7962,0.7963,0.7966,0.7966,0.7971,0.7968,0.796,0.7958,0.7965,0.7967,0.796,0.7963,0.7967,0.7967,0.7965,0.7961,0.7967,0.7967,0.7966,0.7968,0.7971,0.7974,0.7966,0.7968,0.7971,0.7965,0.7969,0.7966,0.7965,0.7967,0.7975,0.7964,0.7969,0.7957,0.7962,0.7964,0.7961,0.797,0.7969,0.7969,0.7968,0.7967,0.7967,0.7959,0.7966,0.7965,0.7962,0.7962,0.7969,0.7968,0.7967,0.7965,0.797,0.7967,0.797,0.7967,0.7965,0.7963,0.7967,0.7963,0.7968,0.7966,0.7967,0.7966,0.7968,0.7966,0.7966,0.7965,0.797,0.7971,0.7965,0.7968,0.7968,0.7965,0.7963,0.7968,0.7967,0.7967,0.7968,0.7972,0.7966,0.7968,0.7974,0.796,0.7968,0.7971,0.7964,0.7965,0.7966,0.7967,0.7969,0.7961,0.7968,0.7967,0.7964,0.7968,0.7969,0.7969,0.7967,0.7965,0.7967,0.7972,0.7974,0.7968,0.7967,0.7962,0.7967,0.7967,0.797,0.7969,0.7967,0.7978,0.7975,0.7978,0.7969,0.7974,0.7973,0.7967,0.7965,0.7967,0.7971,0.7968,0.797,0.797,0.7972,0.7965,0.7968,0.7962,0.7972,0.797,0.7966,0.797,0.7974,0.7966,0.7969,0.7967,0.7973,0.7967,0.7969,0.797,0.7972,0.7974,0.7968,0.7968,0.7969,0.7975,0.7966,0.7968,0.797,0.7969,0.7971,0.7969,0.797,0.7966,0.7967,0.7968,0.7968,0.7971,0.7964,0.797,0.797,0.7962,0.7959,0.7971,0.7963,0.797,0.797,0.797,0.7968,0.7966,0.796,0.7969,0.7964,0.7966,0.7966,0.7961,0.7963,0.7964,0.7962,0.7964,0.796,0.7967,0.7968,0.7963,0.7959,0.7965,0.7969,0.7965,0.7967,0.7968,0.7971,0.7971,0.797,0.7966,0.7961,0.7962,0.7967,0.7964,0.7967,0.7959,0.7964,0.7965,0.7963,0.7966,0.7968,0.7965,0.7962,0.7965,0.797,0.7967,0.7966,0.7963,0.7963,0.7966,0.7963,0.7965,0.7964,0.7966,0.7967,0.797,0.7968,0.7967,0.7973,0.7969,0.797,0.7968,0.7969,0.7968,0.797,0.7964,0.7964,0.797,0.7966,0.7964,0.7966,0.7968,0.7964,0.7973,0.7971,0.7967,0.7966,0.7967,0.7964,0.7969,0.7967,0.7972,0.7966,0.7962,0.796,0.7969,0.7966,0.7967,0.7973,0.7965,0.7964,0.7966,0.7965,0.7962,0.7961,0.7965,0.7968,0.7968,0.7962,0.7972,0.797,0.7972,0.7968,0.7971,0.7967,0.7967,0.7967,0.797,0.797,0.7967,0.7965,0.797,0.7969,0.7971,0.797,0.7965,0.7969,0.7967,0.7961,0.7965,0.7968,0.7963,0.7964,0.797,0.7966,0.7971,0.7971,0.7962,0.7963,0.7961,0.7964,0.7965,0.7964,0.7965,0.7969,0.7973,0.7972,0.797,0.7965,0.7969,0.7965,0.7972,0.7968,0.7973,0.7962,0.7966,0.797,0.7966,0.7966,0.7968,0.7968,0.7971,0.7967,0.7971,0.7973,0.7961,0.7968,0.7968,0.7966,0.7965,0.7964,0.7966,0.7967,0.7962,0.7969,0.7965,0.7968,0.7973,0.7969,0.7963,0.7964,0.7963,0.7966,0.7964,0.7967,0.7961,0.7965,0.7963,0.7965,0.7964,0.7961,0.7965,0.7966,0.7965,0.7966,0.7971,0.7963,0.7969,0.7973,0.7963,0.7962,0.7965,0.7961,0.7962,0.7968,0.7967,0.797,0.7965,0.7968,0.7971,0.7966,0.7966,0.796,0.7971,0.7969,0.7964,0.796,0.7974,0.7971,0.7971,0.7969,0.7962,0.7972,0.7971,0.7966,0.7965,0.7961,0.7965,0.7957,0.797,0.7971,0.7969,0.7966,0.7961,0.7965,0.797,0.7965,0.7968,0.7964,0.7968,0.7971,0.7971,0.7972,0.7962,0.7968,0.7961,0.7966,0.7962,0.7962,0.7966,0.7971,0.7966,0.7965,0.7965,0.7969,0.7971,0.7969,0.7971,0.7973,0.7971,0.7967,0.797,0.7971,0.7968,0.7967,0.7971,0.796,0.7965,0.7969,0.7964,0.7962,0.7963,0.7967,0.7969,0.7965,0.7968,0.7971,0.7966,0.7966,0.796,0.7961,0.7966,0.7971,0.7967,0.797,0.7966,0.7975,0.7967,0.7971,0.7971,0.7964,0.797,0.7964,0.7968,0.7968,0.797,0.7969,0.7966,0.7966,0.7969,0.7964,0.797,0.7968,0.7971,0.7972,0.7967,0.7972,0.7968,0.7971,0.7967,0.7974,0.7969,0.7964,0.7966,0.7971,0.797,0.797,0.7966,0.7973,0.7968,0.7963,0.7969,0.7966,0.797,0.7963,0.7961,0.7964,0.7972,0.7964,0.7974,0.7969,0.7975,0.7971,0.7973,0.7977,0.7968,0.7971,0.797,0.7971,0.7964,0.7972,0.7967,0.7971,0.7965,0.7968,0.7964,0.7971,0.7974,0.7969,0.7968,0.7968,0.7965,0.7967,0.7967,0.797,0.797,0.7969,0.7965,0.7969,0.7967,0.7971,0.797,0.7964,0.7971,0.797,0.7972,0.7969,0.796,0.7969,0.7964,0.7966,0.7964,0.7965,0.7964,0.7964,0.7968,0.7973,0.7967,0.7972,0.7973,0.7967,0.797,0.7969,0.7962,0.7971,0.7972,0.7973,0.7972,0.7961,0.7967,0.7968,0.7964,0.7965,0.7964,0.7965,0.797,0.7967,0.7966,0.7964,0.7967,0.7971,0.7967,0.7966,0.7971,0.7964,0.7971,0.7969,0.7973,0.7968,0.7964,0.7965,0.7969,0.797,0.7964,0.797,0.7963,0.7967,0.7968,0.7973,0.7963,0.7972,0.7969,0.7968,0.7966,0.7964,0.7965,0.7968,0.7967,0.7968,0.7969,0.7972,0.7971,0.7965,0.797,0.7969,0.7971,0.7971,0.7966,0.797,0.797,0.7967,0.7971,0.7966,0.7972,0.7964,0.797,0.7962,0.7967,0.7968,0.7969,0.7964,0.7972,0.7967,0.7972,0.7972,0.7973,0.797,0.7969,0.7965,0.7967,0.7967,0.7966,0.7962,0.7967,0.7969,0.7969,0.7967,0.7968,0.7967,0.7964,0.797,0.797,0.7967,0.7966,0.7965,0.7966,0.7968,0.7972,0.7964,0.797,0.7967,0.7969,0.7967,0.7967,0.7964,0.7968,0.7971,0.7967,0.7971,0.7975,0.7973,0.797,0.7974,0.7977,0.7975,0.7969,0.7972,0.7968,0.7963,0.7971,0.7963,0.7969,0.7975,0.7966,0.797,0.7966,0.7974,0.7969,0.7965,0.7969,0.7968,0.7971,0.797,0.7966,0.7968,0.7972,0.7969,0.7972,0.797,0.797,0.7974,0.7963,0.7967,0.7969,0.7967,0.7971,0.7968,0.7969,0.7971,0.7966,0.7965,0.797,0.7974,0.7973,0.797,0.7969,0.7975,0.7968,0.7966,0.7969,0.7972,0.7969,0.7972,0.7974,0.7973,0.797,0.7972,0.7974,0.7974,0.7975,0.797,0.7961,0.7965,0.7971,0.7973,0.7961,0.7967,0.797,0.7966,0.7971,0.7961,0.7966,0.7967,0.7969,0.7966,0.7969,0.7967,0.7974,0.7971,0.797,0.797,0.7962,0.7963,0.797,0.7974,0.7972,0.7968,0.797,0.7968,0.7963,0.7973,0.7971,0.7967,0.7968,0.797,0.797,0.7973,0.7973,0.7972]
bf_pc1=[0.6756,0.7318,0.7478,0.757,0.7655,0.7703,0.7717,0.7744,0.7768,0.7781,0.7799,0.7803,0.7808,0.7824,0.7826,0.7839,0.7838,0.7837,0.7852,0.7847,0.7858,0.7864,0.7865,0.7867,0.7866,0.787,0.7877,0.7879,0.7871,0.7878,0.7877,0.7882,0.7877,0.7886,0.7885,0.7891,0.7879,0.7887,0.7884,0.7887,0.789,0.7893,0.7891,0.7892,0.7897,0.7898,0.7897,0.79,0.7897,0.7906,0.7906,0.7904,0.7907,0.7909,0.7908,0.7905,0.7902,0.7904,0.7905,0.7907,0.791,0.7904,0.7912,0.7913,0.7908,0.7908,0.791,0.7912,0.7918,0.7907,0.7911,0.7914,0.7917,0.7916,0.7914,0.7921,0.7917,0.7919,0.7918,0.7918,0.7918,0.7919,0.7916,0.7916,0.7915,0.7916,0.7922,0.7924,0.7921,0.7923,0.7926,0.7922,0.7928,0.7929,0.7928,0.7923,0.7933,0.7924,0.7929,0.7935,0.7931,0.7929,0.7933,0.7938,0.793,0.7939,0.7936,0.7933,0.7937,0.7932,0.7939,0.7941,0.7932,0.7936,0.7933,0.7935,0.7935,0.7934,0.794,0.7935,0.7936,0.7938,0.7939,0.7938,0.7935,0.7937,0.7939,0.7944,0.7938,0.7938,0.7939,0.7939,0.7943,0.7933,0.7929,0.7939,0.7946,0.7937,0.794,0.7945,0.7933,0.7942,0.794,0.7938,0.7943,0.7942,0.7942,0.7948,0.7938,0.7942,0.7948,0.7942,0.7943,0.7939,0.7933,0.7945,0.7948,0.7939,0.7945,0.7943,0.7946,0.7947,0.7946,0.7947,0.7944,0.7948,0.7946,0.7942,0.7946,0.7952,0.7942,0.7945,0.7946,0.7949,0.7951,0.7951,0.7947,0.7942,0.7953,0.7942,0.7944,0.795,0.7947,0.7945,0.7949,0.7949,0.7949,0.7955,0.795,0.7949,0.7948,0.7945,0.7952,0.7951,0.7952,0.7945,0.7945,0.7944,0.7945,0.7945,0.7954,0.7951,0.7954,0.7952,0.7942,0.7947,0.7949,0.7945,0.7954,0.7955,0.7953,0.7945,0.795,0.7948,0.7952,0.795,0.7944,0.7949,0.7949,0.7953,0.7942,0.7955,0.7958,0.7952,0.7951,0.7949,0.7952,0.7952,0.7949,0.795,0.7954,0.7949,0.7954,0.795,0.7948,0.7952,0.7958,0.7954,0.7958,0.7952,0.7957,0.7955,0.7953,0.7956,0.7953,0.7954,0.7957,0.7949,0.7958,0.7952,0.7955,0.7954,0.7955,0.7957,0.7957,0.7956,0.7954,0.7956,0.7954,0.7953,0.7957,0.7956,0.7953,0.7952,0.7961,0.7961,0.7963,0.7958,0.7961,0.7954,0.7955,0.7951,0.7953,0.7958,0.7958,0.7955,0.7956,0.7956,0.7957,0.7956,0.7961,0.796,0.7958,0.7956,0.7959,0.7958,0.7953,0.7958,0.7956,0.7957,0.7957,0.7957,0.7959,0.7961,0.7955,0.7955,0.7955,0.7952,0.7954,0.7958,0.7959,0.796,0.796,0.7961,0.7957,0.7962,0.7963,0.796,0.796,0.7963,0.7961,0.7961,0.7958,0.7959,0.796,0.7962,0.7959,0.796,0.7962,0.7962,0.7961,0.7958,0.7966,0.7956,0.7959,0.7955,0.7961,0.7962,0.7959,0.7953,0.7955,0.796,0.7964,0.796,0.7962,0.7954,0.7961,0.7958,0.7961,0.7961,0.7961,0.7958,0.796,0.7963,0.7956,0.7955,0.7958,0.7959,0.796,0.7961,0.796,0.7955,0.7957,0.7962,0.7959,0.796,0.796,0.7961,0.7957,0.7964,0.796,0.7963,0.7962,0.7961,0.7962,0.796,0.7963,0.7962,0.7959,0.796,0.7961,0.7965,0.7963,0.7964,0.7961,0.7959,0.7962,0.7962,0.796,0.7963,0.7961,0.7962,0.7964,0.7958,0.7965,0.7966,0.7961,0.7965,0.7964,0.7964,0.7963,0.796,0.7967,0.7965,0.7964,0.7965,0.7963,0.7966,0.7966,0.7963,0.7959,0.7963,0.7964,0.7959,0.7964,0.7961,0.7962,0.7962,0.796,0.7961,0.7964,0.7963,0.7966,0.7965,0.7963,0.7957,0.7966,0.7963,0.7965,0.7962,0.7962,0.7961,0.7958,0.7963,0.7962,0.7965,0.7963,0.7962,0.7962,0.796,0.7964,0.7962,0.7966,0.7967,0.7965,0.7965,0.7963,0.7962,0.7964,0.7961,0.7962,0.7964,0.7964,0.7963,0.7962,0.7964,0.7961,0.7961,0.7957,0.7963,0.796,0.7965,0.7963,0.796,0.7963,0.7964,0.7961,0.7966,0.7965,0.7965,0.7963,0.7961,0.7968,0.7963,0.7964,0.7965,0.7964,0.7961,0.7965,0.7965,0.7966,0.7965,0.7958,0.7969,0.7966,0.7962,0.7965,0.7962,0.7963,0.7963,0.7963,0.7964,0.7963,0.7961,0.7966,0.7963,0.7969,0.7961,0.7966,0.7966,0.7964,0.7961,0.7965,0.7964,0.7964,0.7962,0.7962,0.7962,0.7962,0.7967,0.7963,0.7966,0.7964,0.7962,0.7967,0.7965,0.7964,0.7967,0.7968,0.7965,0.7967,0.7966,0.7964,0.7967,0.7967,0.7965,0.7969,0.7966,0.7963,0.7964,0.7965,0.7964,0.7962,0.7961,0.7964,0.7963,0.7967,0.7969,0.7965,0.7965,0.7966,0.7964,0.7964,0.7967,0.7963,0.7969,0.7967,0.797,0.7966,0.7964,0.7965,0.797,0.7969,0.7973,0.7969,0.7967,0.7966,0.7967,0.7965,0.7965,0.7968,0.7968,0.7966,0.7966,0.7969,0.7972,0.7969,0.797,0.797,0.7969,0.7967,0.7969,0.7967,0.7967,0.7966,0.7966,0.7964,0.7966,0.7967,0.7966,0.7968,0.7966,0.7964,0.7964,0.7968,0.7969,0.7964,0.7965,0.7966,0.7968,0.7965,0.7969,0.7967,0.7967,0.7969,0.7968,0.7969,0.7969,0.7966,0.7966,0.7969,0.7966,0.7963,0.7966,0.7967,0.7964,0.7967,0.7967,0.7967,0.7968,0.7966,0.7967,0.7967,0.7968,0.7965,0.7967,0.7968,0.797,0.7966,0.7968,0.797,0.797,0.797,0.7966,0.7968,0.7966,0.7967,0.7963,0.7964,0.7966,0.7966,0.7968,0.7968,0.7968,0.797,0.7971,0.7968,0.7964,0.7964,0.7967,0.7963,0.7964,0.797,0.7971,0.7966,0.7969,0.7967,0.7969,0.7965,0.7968,0.7971,0.7966,0.7968,0.7967,0.7968,0.7968,0.7966,0.7968,0.7969,0.7968,0.7965,0.7968,0.7963,0.7968,0.7969,0.7965,0.7965,0.7966,0.7967,0.7966,0.7968,0.7967,0.7967,0.7966,0.797,0.7972,0.7966,0.7967,0.7967,0.7959,0.7966,0.7966,0.7968,0.7966,0.7968,0.7966,0.797,0.7968,0.797,0.7973,0.7976,0.7972,0.7973,0.797,0.7967,0.7966,0.7969,0.797,0.7971,0.797,0.7969,0.7972,0.797,0.797,0.7969,0.7969,0.7971,0.7968,0.797,0.7972,0.7966,0.7968,0.7966,0.7969,0.7963,0.7969,0.7972,0.7973,0.7971,0.7967,0.7972,0.7966,0.7968,0.7967,0.7969,0.7968,0.7968,0.7967,0.7968,0.7967,0.7968,0.7968,0.7965,0.7968,0.7968,0.797,0.7969,0.7969,0.7972,0.7968,0.7968,0.7967,0.7968,0.797,0.7969,0.7969,0.7973,0.7975,0.7972,0.7971,0.7967,0.7973,0.7969,0.7973,0.7974,0.7971,0.7972,0.7974,0.7974,0.7971,0.797,0.7969,0.7969,0.7969,0.7964,0.7969,0.7967,0.7969,0.7973,0.7971,0.797,0.7972,0.7973,0.797,0.797,0.7968,0.7974,0.7976,0.7972,0.7972,0.7972,0.7974,0.797,0.7974,0.7974,0.7968,0.797,0.797,0.797,0.797,0.7973,0.797,0.7968,0.797,0.797,0.7976,0.7973,0.7974,0.7978,0.7979,0.7969,0.7972,0.7974,0.7974,0.7974,0.7971,0.7969,0.7974,0.7975,0.797,0.7969,0.7971,0.7973,0.7973,0.7971,0.7975,0.797,0.7973,0.7971,0.797,0.797,0.7969,0.7967,0.7971,0.7967,0.7967,0.7971,0.7968,0.7973,0.7968,0.7967,0.7973,0.7971,0.797,0.797,0.7973,0.7971,0.797,0.797,0.7967,0.7968,0.7975,0.797,0.7972,0.7967,0.7975,0.7973,0.7969,0.7971,0.7971,0.7974,0.7968,0.7971,0.7971,0.7972,0.7968,0.7974,0.7973,0.7974,0.7974,0.7972,0.7974,0.797,0.7972,0.7972,0.797,0.7971,0.7975,0.7975,0.7978,0.7976,0.7975,0.7974,0.7975,0.797,0.7974,0.797,0.7975,0.7974,0.797,0.7965,0.797,0.7972,0.7969,0.7972,0.7972,0.7974,0.7971,0.7971,0.7968,0.7972,0.7971,0.797,0.7969,0.7973,0.7973,0.7972,0.7976,0.7973,0.7973,0.7972,0.797,0.7972,0.7967,0.7969,0.7973,0.7975,0.7974,0.7972,0.7973,0.7969,0.7972,0.7971,0.7967,0.7967,0.7972,0.7971,0.7975,0.7972,0.7971,0.797,0.7969,0.7973,0.7972,0.7971,0.7973,0.7976,0.7971,0.7974,0.7974,0.7974,0.7975,0.7976,0.7972,0.7972,0.7972,0.7968,0.7969,0.7972,0.7969,0.797,0.7969,0.797,0.7966,0.7972,0.7968,0.7972,0.7972,0.7973,0.7976,0.7975,0.7974,0.7975,0.7973,0.7974,0.7972,0.797,0.7971,0.7969,0.7973,0.7971,0.7968,0.7973,0.7976,0.7973,0.7974,0.7971,0.7976,0.7974,0.7973,0.7976,0.7974,0.7973,0.7973,0.7976,0.7975,0.7971,0.7973,0.7972,0.7973,0.7972,0.7972,0.797,0.7973,0.7975,0.7972,0.7972,0.7976,0.7973,0.7973,0.7973,0.7971,0.7969,0.7973,0.7973,0.7973,0.7972,0.7969,0.7969,0.7969,0.7967,0.7972,0.7975,0.7971,0.7973,0.7972,0.7974,0.7976,0.7971,0.7973]
sfl_pc1=[0.7627,0.7745,0.7792,0.7813,0.7833,0.7852,0.786,0.7876,0.7875,0.7899,0.79,0.79,0.7908,0.7898,0.7917,0.7913,0.7921,0.7921,0.7921,0.7918,0.7929,0.7923,0.7932,0.7932,0.7937,0.7936,0.7933,0.793,0.7939,0.7934,0.7929,0.7934,0.7931,0.7942,0.7943,0.7948,0.7945,0.7946,0.7951,0.7953,0.795,0.795,0.7941,0.7956,0.7954,0.7956,0.7945,0.7953,0.7953,0.7951,0.7944,0.7951,0.796,0.7957,0.7957,0.7956,0.7951,0.7956,0.7956,0.7959,0.7967,0.7955,0.7955,0.7953,0.7957,0.795,0.7956,0.7952,0.7962,0.7947,0.7961,0.7956,0.7957,0.7954,0.7959,0.7962,0.7956,0.7959,0.7963,0.796,0.7953,0.7952,0.7954,0.7954,0.796,0.7953,0.796,0.7962,0.7961,0.7959,0.7961,0.7961,0.796,0.7959,0.7961,0.7958,0.7959,0.7964,0.7964,0.7959,0.7957,0.7963,0.7962,0.7963,0.796,0.7965,0.7962,0.7955,0.7961,0.7966,0.796,0.7963,0.7967,0.796,0.7959,0.7964,0.7961,0.7963,0.7961,0.7962,0.7961,0.7959,0.7955,0.7954,0.796,0.7961,0.7952,0.7961,0.7952,0.7963,0.7955,0.7952,0.7958,0.796,0.7958,0.7956,0.7959,0.7961,0.7961,0.7955,0.7959,0.7961,0.7959,0.796,0.7963,0.7963,0.7959,0.7961,0.7965,0.7958,0.796,0.796,0.7965,0.7957,0.7961,0.7959,0.7964,0.7965,0.7964,0.7969,0.7965,0.7962,0.7957,0.7967,0.7961,0.7963,0.7969,0.7961,0.7966,0.7965,0.7968,0.7964,0.797,0.7964,0.7969,0.7968,0.7958,0.7957,0.796,0.7961,0.7961,0.7965,0.7965,0.7966,0.7957,0.7963,0.7965,0.7958,0.796,0.796,0.796,0.7961,0.7954,0.7969,0.7966,0.7969,0.7969,0.7972,0.7964,0.7967,0.7964,0.7969,0.7964,0.796,0.7967,0.7966,0.7968,0.7969,0.7958,0.7964,0.7967,0.7969,0.7971,0.7963,0.7958,0.7965,0.796,0.7966,0.7965,0.7965,0.7958,0.7967,0.7963,0.7964,0.7964,0.7965,0.797,0.7968,0.7971,0.7966,0.7967,0.797,0.797,0.7973,0.7972,0.797,0.7965,0.7967,0.7969,0.7968,0.797,0.7969,0.7971,0.7961,0.7969,0.7966,0.7962,0.7964,0.7969,0.7968,0.7964,0.7964,0.7969,0.7968,0.7966,0.7959,0.7968,0.7971,0.7966,0.7967,0.7973,0.7965,0.796,0.796,0.7965,0.797,0.7967,0.797,0.7968,0.7966,0.7962,0.7966,0.7964,0.7964,0.7968,0.7965,0.7969,0.7967,0.7959,0.7965,0.7967,0.7968,0.796,0.7965,0.7964,0.7961,0.7968,0.7964,0.7971,0.7967,0.7966,0.7969,0.7971,0.797,0.7964,0.7973,0.7968,0.7971,0.7972,0.7972,0.7966,0.7969,0.7963,0.7964,0.7963,0.7965,0.7973,0.796,0.7963,0.7965,0.7969,0.7968,0.7971,0.7967,0.797,0.7962,0.7971,0.7973,0.7968,0.7966,0.7972,0.7972,0.797,0.797,0.7973,0.7973,0.7969,0.797,0.7971,0.7968,0.7963,0.7965,0.7966,0.7969,0.7968,0.7973,0.7965,0.7966,0.7966,0.7967,0.7968,0.7974,0.7972,0.7966,0.7965,0.7961,0.7972,0.7967,0.7966,0.7972,0.7971,0.7967,0.7965,0.7973,0.7971,0.7974,0.7963,0.7966,0.7966,0.7965,0.7959,0.7968,0.7962,0.7967,0.7972,0.7972,0.7963,0.797,0.7967,0.7962,0.7972,0.7968,0.797,0.7965,0.7965,0.797,0.797,0.7973,0.7969,0.7966,0.7968,0.7977,0.7976,0.7971,0.797,0.797,0.7966,0.7968,0.7971,0.797,0.7969,0.7961,0.7966,0.7971,0.7965,0.7966,0.7965,0.7968,0.7962,0.7969,0.7959,0.7963,0.797,0.797,0.7978,0.797,0.7972,0.7977,0.7966,0.7969,0.797,0.7969,0.7968,0.797,0.7974,0.7971,0.7968,0.7974,0.7971,0.7969,0.7968,0.7965,0.7963,0.7969,0.7972,0.7971,0.7969,0.7968,0.7957,0.7971,0.7967,0.7965,0.7965,0.7964,0.7964,0.7963,0.7969,0.7971,0.7965,0.7971,0.7971,0.7962,0.7962,0.7956,0.7969,0.7962,0.7968,0.7972,0.7973,0.7973,0.7971,0.7971,0.7968,0.7968,0.7965,0.7974,0.7973,0.7971,0.7968,0.7971,0.7967,0.7959,0.7969,0.7968,0.7964,0.7974,0.7966,0.7964,0.7968,0.7972,0.7971,0.7971,0.796,0.7972,0.7973,0.797,0.7971,0.7969,0.7966,0.7971,0.7972,0.7974,0.7975,0.797,0.797,0.7966,0.7972,0.7965,0.7971,0.7969,0.7971,0.7966,0.7973,0.7972,0.7976,0.7968,0.7974,0.7965,0.7972,0.7973,0.7969,0.7965,0.7974,0.7977,0.7977,0.7974,0.7972,0.7974,0.7976,0.7977,0.7975,0.7974,0.7971,0.7973,0.7972,0.7972,0.797,0.7969,0.7975,0.7973,0.7975,0.7974,0.797,0.7973,0.7971,0.7972,0.7969,0.7973,0.7968,0.7969,0.7971,0.7974,0.7968,0.7972,0.7971,0.797,0.7978,0.7976,0.7973,0.7972,0.7976,0.797,0.7975,0.7975,0.7969,0.7976,0.7975,0.797,0.797,0.7973,0.797,0.7964,0.7975,0.7972,0.7973,0.7974,0.7973,0.7974,0.7975,0.7979,0.7975,0.7974,0.7967,0.7967,0.796,0.7972,0.7976,0.7977,0.7969,0.7972,0.797,0.7977,0.7969,0.7974,0.7972,0.7969,0.7975,0.7967,0.7965,0.7968,0.7972,0.7972,0.7972,0.7972,0.7973,0.7972,0.7974,0.7971,0.797,0.7975,0.7973,0.7972,0.7973,0.7969,0.7975,0.7976,0.7969,0.797,0.797,0.7968,0.7978,0.7969,0.7977,0.7975,0.7973,0.7975,0.7974,0.7975,0.7975,0.7971,0.7972,0.7969,0.7967,0.7973,0.797,0.7975,0.7972,0.797,0.7968,0.7972,0.797,0.7967,0.7968,0.797,0.7966,0.7971,0.7965,0.7966,0.7977,0.7975,0.7969,0.7971,0.7972,0.7975,0.7973,0.7973,0.7972,0.7973,0.7971,0.7971,0.7968,0.797,0.797,0.7972,0.7975,0.7973,0.7974,0.7974,0.7975,0.7972,0.7977,0.7972,0.7971,0.7969,0.7972,0.7967,0.7967,0.7973,0.7973,0.7971,0.7966,0.7968,0.7967,0.7965,0.797,0.7969,0.7973,0.7975,0.797,0.798,0.797,0.7974,0.7974,0.7973,0.7969,0.7973,0.7974,0.7973,0.7977,0.7971,0.7967,0.7974,0.7971,0.797,0.7973,0.7968,0.7974,0.7973,0.7966,0.7964,0.7971,0.7975,0.7975,0.7974,0.7975,0.7977,0.7972,0.7975,0.7972,0.7966,0.7972,0.7965,0.797,0.7972,0.7966,0.7975,0.7972,0.7973,0.7973,0.7972,0.7972,0.7976,0.7975,0.7977,0.7969,0.797,0.7975,0.7973,0.7976,0.7974,0.797,0.7969,0.797,0.7976,0.7972,0.7973,0.797,0.7974,0.797,0.7973,0.7976,0.7975,0.7974,0.7979,0.7971,0.7971,0.7974,0.7972,0.7973,0.7978,0.7976,0.7974,0.7976,0.7971,0.7969,0.7971,0.7964,0.7973,0.7973,0.7969,0.797,0.7975,0.7975,0.7975,0.7975,0.7979,0.7973,0.7971,0.7973,0.7974,0.7973,0.797,0.7972,0.7963,0.7973,0.7975,0.7971,0.7974,0.7974,0.7979,0.7969,0.7974,0.797,0.7972,0.7967,0.7969,0.7966,0.7972,0.7971,0.797,0.7968,0.7972,0.797,0.7972,0.7969,0.7977,0.7973,0.7975,0.7973,0.7972,0.7976,0.7975,0.7974,0.7972,0.797,0.7974,0.7968,0.7961,0.7976,0.7976,0.7968,0.7971,0.7965,0.7979,0.7978,0.7972,0.7974,0.7971,0.797,0.7972,0.7969,0.7972,0.7972,0.7972,0.7976,0.7972,0.7965,0.797,0.7968,0.797,0.7974,0.7973,0.797,0.7974,0.7971,0.7974,0.7975,0.7974,0.7972,0.7971,0.7978,0.7972,0.7967,0.7972,0.7973,0.7969,0.797,0.7975,0.7975,0.7975,0.7968,0.7971,0.7974,0.7966,0.7974,0.7966,0.7974,0.7971,0.7976,0.7974,0.7969,0.7973,0.7973,0.7966,0.7974,0.7975,0.7976,0.7977,0.7978,0.7973,0.7976,0.797,0.7975,0.7978,0.7967,0.7974,0.7978,0.7976,0.7975,0.7972,0.7969,0.7975,0.7973,0.7974,0.7969,0.7975,0.7971,0.7969,0.7971,0.7977,0.7973,0.7975,0.7974,0.7979,0.7975,0.7975,0.7973,0.7973,0.7973,0.7976,0.7973,0.7977,0.7974,0.7973,0.7975,0.7976,0.7972,0.7974,0.7972,0.7972,0.797,0.797,0.7972,0.7972,0.7973,0.7973,0.7977,0.7972,0.7975,0.7972,0.7975,0.7972,0.7973,0.7976,0.7974,0.7978,0.7974,0.7978,0.7972,0.7978,0.7974,0.7974,0.7977,0.7975,0.7978,0.7975,0.7977,0.7977,0.7966,0.7978,0.7972,0.7975,0.7975,0.7965,0.7973,0.7976,0.7971,0.7974,0.7975,0.7977,0.7976,0.7974,0.7969,0.7971,0.797,0.7974,0.7979,0.7974,0.7975,0.7976,0.7971,0.7969,0.7973,0.7974,0.7974,0.7975,0.7972,0.7978,0.7974,0.7973,0.7973,0.7972,0.7975,0.7967,0.7974,0.7976,0.798,0.7966,0.7969,0.7979,0.7971,0.7977,0.7968,0.7975,0.7975,0.7976,0.7975,0.7968,0.798,0.7978,0.7977,0.7968,0.7974,0.797,0.7975,0.7969,0.7973,0.797,0.7971,0.7972,0.7972,0.7974,0.7973,0.7969,0.7976,0.7971,0.7974,0.7969,0.7972,0.7972]
#sfl_pc1=[0.1989,0.3809,0.4926,0.5303,0.587,0.6134,0.6135,0.6153,0.6351,0.6716,0.6557,0.6476,0.6834,0.7023,0.6693,0.7019,0.678,0.7119,0.6882,0.7126,0.7472,0.7489,0.7739,0.7486,0.7695,0.763,0.7571,0.7391,0.7537,0.7668,0.7808,0.7843,0.7661,0.7719,0.8028,0.8135,0.8146,0.8213,0.8103,0.7996,0.8136,0.8284,0.8076,0.7864,0.8161,0.8024,0.8065,0.8132,0.8144,0.8268,0.8264,0.7995,0.7881,0.8032,0.7985,0.807,0.8272,0.8094,0.8279,0.8279,0.7976,0.8163,0.8289,0.8219,0.83,0.8198,0.8297,0.8286,0.8393,0.8213,0.8262,0.8317,0.8327,0.8283,0.8315,0.8382,0.8299,0.8359,0.8256,0.8337,0.8208,0.8373,0.8162,0.8311,0.8362,0.8282,0.8467,0.8335,0.84,0.8391,0.8295,0.8415,0.8518,0.8495,0.843,0.8482,0.8338,0.8511,0.8429,0.8477,0.8469,0.84,0.8248,0.8456,0.8468,0.8383,0.8487,0.843,0.8384,0.8485,0.8392,0.8473,0.8497,0.8535,0.8546,0.8204,0.8513,0.8381,0.8455,0.8336,0.8435,0.8537,0.8408,0.82,0.8494,0.8549,0.8379,0.8156,0.8458,0.8543,0.8437,0.8452,0.8351,0.8475,0.8323,0.8539,0.8235,0.8497,0.8566,0.8399,0.8476,0.8511,0.841,0.8456,0.8545,0.8419,0.8552,0.855,0.8565,0.8537,0.8554,0.8532,0.847,0.8583,0.8519,0.8397,0.8457,0.8407,0.8514,0.8549,0.8583,0.8595,0.8571,0.8447,0.8544,0.857,0.8515,0.8526,0.838,0.8495,0.8535,0.8446,0.8568,0.8543,0.8555,0.8618,0.8572,0.8608,0.8542,0.8658,0.8583,0.8392,0.8351,0.8558,0.8577,0.855,0.8678,0.8592,0.8574,0.8591,0.8541,0.8478,0.852,0.8551,0.8638,0.8439,0.8572,0.8489,0.8638,0.8559,0.8623,0.8606,0.8408,0.8455,0.8581,0.8629,0.8567,0.8631,0.8669,0.8633,0.852,0.8601,0.8659,0.8637,0.8555,0.861,0.8602,0.8649,0.8638,0.8624,0.8683,0.8625,0.8623,0.8645,0.8591,0.8638,0.8588,0.8544,0.8646,0.867,0.8602,0.8623,0.8668,0.8647,0.8625,0.849,0.8635,0.8662,0.8634,0.8661,0.8653,0.8609,0.8677,0.8664,0.8669,0.8613,0.8618,0.8455,0.868,0.8616,0.8558,0.863,0.8651,0.8636,0.8638,0.8666,0.8581,0.865,0.856,0.8524,0.8553,0.8587,0.8574,0.8678,0.8663,0.8635,0.8656,0.8612,0.8656,0.8628,0.8677,0.8669,0.8678,0.8571,0.8614,0.8682,0.8502,0.8642,0.8556,0.864,0.8675,0.862,0.8685,0.8674,0.8658,0.8672,0.8582,0.8674,0.8617,0.8683,0.865,0.868,0.8691,0.8684,0.8682,0.8682,0.8695,0.8732,0.8674,0.8682,0.8645,0.8666,0.8623,0.8623,0.8663,0.8677,0.8657,0.8552,0.8672,0.8715,0.8681,0.8698,0.8656,0.8685,0.8707,0.8631,0.8685,0.8701,0.8667,0.8652,0.8656,0.8693,0.8704,0.8711,0.8696,0.8664,0.8654,0.8692,0.8689,0.8691,0.8659,0.8708,0.8704,0.8699,0.8668,0.8695,0.8703,0.872,0.8703,0.8674,0.8688,0.8677,0.8702,0.8684,0.8699,0.8712,0.8664,0.8699,0.8646,0.8684,0.8593,0.8644,0.8703,0.8717,0.8748,0.8706,0.8687,0.868,0.8716,0.8712,0.8729,0.8668,0.8605,0.8601,0.8655,0.8712,0.8681,0.8703,0.8675,0.871,0.8699,0.8695,0.8723,0.8712,0.8701,0.871,0.862,0.8687,0.8654,0.8683,0.8655,0.8717,0.8708,0.867,0.8686,0.8704,0.8689,0.8697,0.8699,0.8713,0.8686,0.8699,0.8706,0.869,0.8699,0.8691,0.8694,0.8707,0.8654,0.873,0.8724,0.8695,0.8702,0.8651,0.8677,0.871,0.8712,0.8661,0.8738,0.8702,0.8717,0.8697,0.8701,0.8714,0.8707,0.8687,0.8714,0.8717,0.8722,0.8715,0.869,0.8712,0.8728,0.8728,0.8712,0.8714,0.8689,0.8733,0.8741,0.866,0.8736,0.8715,0.8725,0.8715,0.8716,0.8728,0.8696,0.8668,0.8703,0.8711,0.8716,0.87,0.8681,0.8717,0.8713,0.8713,0.8715,0.8724,0.8712,0.8742,0.873,0.8731,0.8712,0.8742,0.8692,0.8706,0.8717,0.8727,0.8669,0.8718,0.8721,0.8721,0.8696,0.8701,0.8735,0.8699,0.87,0.8726,0.8694,0.8723,0.8717,0.8717,0.8709,0.8691,0.874,0.8695,0.8718,0.8722,0.8748,0.8681,0.8747,0.8735,0.8675,0.8734,0.8695,0.8719,0.8657,0.8733,0.8739,0.8715,0.8746,0.8732,0.8684,0.8728,0.8739,0.8721,0.8737,0.8733,0.8695,0.8733,0.8736,0.872,0.8733,0.8711,0.8738,0.8744,0.8728,0.8725,0.8711,0.8679,0.8735,0.8711,0.8736,0.8726,0.8755,0.8722,0.8735,0.8724,0.8724,0.8728,0.8727,0.8634,0.8724,0.8734,0.8741,0.8707,0.8727,0.8729,0.8726,0.8726,0.8705,0.8729,0.8734,0.872,0.872,0.8721,0.8749,0.8731,0.8729,0.8731,0.8737,0.8712,0.8727,0.8728,0.8727,0.8737,0.8733,0.8736,0.8702,0.8713,0.8692,0.8735,0.8719,0.8723,0.8702,0.8701,0.8632,0.8725,0.8748,0.8665,0.8741,0.8689,0.8735,0.872,0.8737,0.8673,0.8721,0.8708,0.8677,0.8716,0.8733,0.8705,0.8709,0.8739,0.872,0.871,0.8713,0.8721,0.873,0.8738,0.871,0.8749,0.874,0.8716,0.8715,0.8734,0.8728,0.8716,0.8727,0.8751,0.8738,0.8733,0.8728,0.8733,0.872,0.8747,0.8734,0.8718,0.8745,0.8738,0.8749,0.8688,0.8693,0.8703,0.8707,0.8731,0.8753,0.8689,0.8737,0.8736,0.8736,0.8723,0.8742,0.8752,0.8746,0.8757,0.8687,0.8674,0.8663,0.8716,0.8735,0.8739,0.8736,0.8709,0.8719,0.8738,0.8702,0.872,0.8741,0.873,0.8701,0.8714,0.8742,0.8743,0.87,0.8721,0.8728,0.8723,0.8699,0.872,0.8745,0.8719,0.8755,0.8741,0.8714,0.8687,0.8715,0.8753,0.8726,0.8747,0.8749,0.8712,0.8728,0.874,0.8711,0.8733,0.869,0.8747,0.8697,0.8742,0.8726,0.8741,0.875,0.8675,0.8725,0.8736,0.8707,0.8718,0.8733,0.87,0.8718,0.8747,0.8735,0.8743,0.8736,0.8744,0.8704,0.8744,0.8702,0.8742,0.873,0.865,0.871,0.8748,0.8708,0.8734,0.8713,0.8741,0.8739,0.8737,0.8696,0.8739,0.8723,0.8728,0.8711,0.8737,0.8717,0.8754,0.8734,0.8707,0.874,0.8727,0.87,0.8737,0.8732,0.8732,0.8692,0.8734,0.8745,0.8689,0.8749,0.8746,0.874,0.8769,0.8736,0.8748,0.8759,0.875,0.8739,0.8733,0.8733,0.8716,0.8709,0.8734,0.8753,0.8736,0.8734,0.8735,0.8724,0.8753,0.8749,0.874,0.8722,0.8731,0.8745,0.8751,0.8744,0.8719,0.8755,0.8735,0.8728,0.8745,0.872,0.8733,0.8755,0.871,0.8657,0.873,0.8724,0.8734,0.8726,0.872,0.8723,0.8715,0.8736,0.8722,0.8707,0.8729,0.8735,0.8732,0.8749,0.8758,0.8654,0.8752,0.8749,0.8758,0.8753,0.8742,0.8751,0.8745,0.876,0.8747,0.8755,0.8749,0.8729,0.8747,0.8734,0.8736,0.875,0.8752,0.8742,0.8735,0.8776,0.8685,0.8731,0.8759,0.8729,0.8741,0.876,0.8736,0.8744,0.8739,0.8749,0.8692,0.8739,0.875,0.8691,0.8718,0.876,0.8749,0.872,0.8746,0.8741,0.8747,0.8734,0.8715,0.8722,0.8737,0.8748,0.8727,0.8732,0.8744,0.8711,0.8745,0.8719,0.8738,0.8742,0.8747,0.8751,0.8755,0.8698,0.8725,0.8707,0.8732,0.8729,0.8752,0.8733,0.8719,0.8743,0.8731,0.8758,0.8736,0.8728,0.8722,0.8714,0.8718,0.8709,0.8738,0.8704,0.8747,0.8739,0.8697,0.8723,0.8762,0.8751,0.8761,0.8746,0.8739,0.8728,0.8744,0.8712,0.8722,0.874,0.8703,0.8731,0.8755,0.8739,0.872,0.875,0.8762,0.8757,0.8754,0.8679,0.8723,0.875,0.8708,0.8745,0.8735,0.8712,0.875,0.876,0.8738,0.8731,0.8735,0.8733,0.8705,0.873,0.8696,0.871,0.8755,0.8739,0.8738,0.8731,0.8735,0.8745,0.8731,0.8729,0.8724,0.8731,0.8697,0.8736,0.8737,0.8738,0.8737,0.8728,0.8736,0.8732,0.8736,0.8755,0.8721,0.8745,0.8752,0.8761,0.8703,0.8735,0.8723,0.873,0.8748,0.8733,0.8742,0.8743,0.8744,0.8737,0.8725,0.8719,0.8749,0.8752,0.8749,0.8751,0.8744,0.8748,0.8753,0.8744,0.8711,0.875,0.8713,0.8709,0.8739,0.8737,0.873,0.8748,0.8696,0.8707,0.872,0.8719,0.8712,0.874,0.8728,0.8726,0.8745,0.8734,0.8723,0.8752,0.8721,0.8732,0.8728,0.8752,0.8737,0.8763,0.8713,0.8727,0.8751,0.8755,0.8703,0.8744,0.8746,0.8755,0.8719,0.8737,0.872,0.875,0.8744,0.8733,0.8707,0.872,0.876,0.8741,0.8741,0.8742,0.873,0.8739,0.8716,0.876,0.872,0.8758,0.874,0.8736,0.8701,0.8746,0.8712,0.8741,0.874,0.8731,0.8755,0.873,0.8744,0.8718,0.8737,0.8724,0.8741,0.8706,0.8713,0.8736,0.8759,0.8735,0.876,0.873,0.8755,0.8735,0.8726]

draw_icml(e2s_pc1,e2e_pc1,bf_pc1,bfc_pc1,sfl_pc1,'mnist_50_pg10.pdf','lower right')
# Draw small figure on it, may from (50,100) communication rounds, (990,1000) communication rounds



