#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt

SLIDE_WIN=10
ALPHA=.2

def sliding_avg(input_data, slide_win=5):
    input_len = len(input_data)
    output_data = []
    output_data.append(input_data[0])
    for x in range(slide_win, input_len, slide_win):
        avg_value = np.mean(input_data[x:x+slide_win])
        output_data.append(avg_value)
        pass
    output_axis = np.linspace(0, input_len, len(output_data))
    return output_axis, output_data

#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt
def draw_icml(Fed_E2S,Fed_E2E,Base_FedAvg,Base_FedCyCP,sfl,file_name,loc):
    mpl.rcParams['lines.linewidth'] = 2
    x = np.arange(0,1000)

    xys = make_interp_spline(x,Fed_E2S)
    x_z = np.linspace(0, 999, 1000)
    FedE2S_s = xys(x_z)
    
    xys = make_interp_spline(x,Fed_E2E)
    x_e = np.linspace(0, 999, 1000)
    Fed_E2E_s = xys(x_e)

    xys = make_interp_spline(x,Base_FedAvg)
    x_f = np.linspace(0,999, 1000)
    Base_FedAvg_s = xys(x_f)

    xys = make_interp_spline(x,Base_FedCyCP)
    x_c = np.linspace(0, 999, 1000)
    Base_FedCyCP_s = xys(x_c)
    
    xys = make_interp_spline(x,sfl)
    x_sf = np.linspace(0,999,1000)
    sfl_s = xys(x_sf)

    fig0 = plt.figure(figsize=plt.figaspect(1))
    ax0 = fig0.add_subplot(1,1,1)
    ax0.grid(linestyle='-')
    fig0.set_figwidth(4)
    fig0.set_figheight(4)
    
    avg_x_z, avg_FedE2S_s = sliding_avg(FedE2S_s, slide_win=SLIDE_WIN)
    avg_x_e, avg_Fed_E2E_s = sliding_avg(Fed_E2E_s, slide_win=SLIDE_WIN)
    avg_x_f, avg_Base_FedAvg_s = sliding_avg(Base_FedAvg_s, slide_win=SLIDE_WIN)
    avg_x_c, avg_Base_FedCyCP_s = sliding_avg(Base_FedCyCP_s, slide_win=SLIDE_WIN)
    avg_x_sfl, avg_sfl_s = sliding_avg(sfl_s, slide_win=SLIDE_WIN)
    

    ax0.plot(avg_x_z, avg_FedE2S_s, color = 'C2', linestyle = 'solid', label = 'HFL-E2S')
    ax0.plot(avg_x_e, avg_Fed_E2E_s, color = 'C3', linestyle = 'solid', label = 'HFL-E2E')
    ax0.plot(avg_x_f, avg_Base_FedAvg_s, color = "C0", linestyle = 'solid', label = 'Base_FedAvg')
    ax0.plot(avg_x_c, avg_Base_FedCyCP_s, color = "C4", linestyle = 'solid', label = 'Base_FedCyCP')
    ax0.plot(avg_x_sfl, avg_sfl_s, color = "C1", linestyle = 'solid', label = 'SFL')

    #line1=ax0.plot(x_m,m_3_test_s,color="C1",linestyle='solid',label='Mean Imputation',markersize = 15, marker=".",markevery=50)
#     ax0.plot(x_z,FedE2S_s,color='C2',linestyle='solid',label='HFL-E2S')
#     ax0.plot(x_e,Fed_E2E_s,color='C3',linestyle='solid',label='HFL-E2E',)
#     ax0.plot(x_f,Base_FedAvg_s,color="C0",linestyle='solid',label='Base_FedAvg')
#     ax0.plot(x_c,Base_FedCyCP_s,color="#b28c6e",linestyle='solid',label='Base_FedCyCP')

    #legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5,bbox_to_anchor=[1, 0.7])
    legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5)

    ax0.set_xlim(0,999)
    ax0.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
    ax0.set_xticklabels(['0','100','200','300','400','500','600','700','800','900','1000'])
    ax0.set_xlabel('Communication Rounds',fontsize='large',fontweight='bold')
    ax0.set_ylabel('Test Accuracy',fontsize='large',fontweight='bold')
    ax0.set_ylim(0.3,1) #(0.4-1) 
    
    fig0.savefig(file_name,dpi=500,bbox_inches = 'tight')
#icml_24_400=[0.1009,0.0974,0.0974,0.1009,0.0892,0.0892,0.1028,0.0982,0.1028,0.0974,0.1705,0.1347,0.0974,0.1009,0.2356,0.1305,0.1829,0.1214,0.2643,0.1606,0.0892,0.1862,0.1061,0.1975,0.2047,0.3028,0.0974,0.114,0.0998,0.1822,0.1889,0.1942,0.2406,0.3139,0.2951,0.2748,0.2974,0.1062,0.1495,0.4265,0.2547,0.3616,0.1581,0.4512,0.4001,0.3687,0.2403,0.3547,0.3507,0.2297,0.4441,0.1247,0.371,0.3869,0.2443,0.2835,0.4172,0.425,0.414,0.436,0.4962,0.4247,0.4155,0.4877,0.4495,0.378,0.1358,0.4562,0.4212,0.4704,0.4763,0.4717,0.2223,0.4477,0.3686,0.2542,0.531,0.6428,0.5013,0.5487,0.2281,0.6381,0.5242,0.6225,0.6032,0.4201,0.4503,0.4624,0.5585,0.5827,0.4438,0.4273,0.3709,0.4714,0.4034,0.5321,0.5029,0.6018,0.5419,0.2401,0.5949,0.5283,0.591,0.4646,0.5854,0.2891,0.602,0.6018,0.5851,0.6394,0.585,0.605,0.5838,0.6337,0.577,0.35,0.5995,0.6086,0.5729,0.5034,0.6024,0.6658,0.6224,0.6567,0.5986,0.6285,0.6174,0.6129,0.5265,0.516,0.5685,0.3348,0.6012,0.5118,0.4654,0.6287,0.28,0.3282,0.5362,0.5236,0.5932,0.5662,0.664,0.6911,0.6119,0.6261,0.5959,0.5995,0.5891,0.5704,0.6537,0.5178,0.7066,0.6245,0.6757,0.6974,0.6188,0.4154,0.437,0.7135,0.6485,0.5898,0.6376,0.6458,0.6601,0.6883,0.5766,0.6516,0.6434,0.6814,0.6551,0.663,0.6365,0.6279,0.6273,0.4387,0.5035,0.5659,0.613,0.6359,0.6298,0.6383,0.647,0.618,0.5664,0.6156,0.5881,0.6548,0.6464,0.5852,0.6453,0.589,0.5626,0.5693,0.6405,0.669,0.6526,0.4737,0.6663,0.6594,0.4915,0.6486,0.6263,0.5172,0.6579,0.6517,0.5347,0.7071,0.5963,0.6616,0.6064,0.6758,0.5266,0.6265,0.6817,0.6102,0.6507,0.6836,0.6628,0.6633,0.6644,0.7248,0.6932,0.6866,0.7278,0.5817,0.7157,0.6997,0.7007,0.6618,0.6668,0.6613,0.5531,0.6572,0.6488,0.7004,0.6955,0.5297,0.6322,0.5479,0.6376,0.7076,0.6926,0.6479,0.7371,0.7308,0.5863,0.5801,0.7338,0.6493,0.6519,0.6442,0.7304,0.5391,0.6526,0.5618,0.6835,0.6789,0.6918,0.7003,0.682,0.6017,0.6539,0.669,0.6455,0.6784,0.7033,0.6824,0.5701,0.6893,0.6739,0.6318,0.6753,0.6828,0.705,0.6275,0.6216,0.6711,0.705,0.6722,0.6309,0.7006,0.6799,0.7359,0.7121,0.7157,0.7382,0.6584,0.6718,0.7415,0.7166,0.6986,0.6521,0.7082,0.6731,0.6593,0.7322,0.7177,0.7168,0.6819,0.6919,0.7196,0.6709,0.6584,0.6447,0.6774,0.7021,0.668,0.5959,0.6803,0.6602,0.6305,0.5647,0.5697,0.6754,0.7205,0.7174,0.6935,0.6918,0.6824,0.7121,0.6594,0.6741,0.7553,0.6989,0.732,0.7135,0.7352,0.6534,0.6717,0.6547,0.684,0.6616,0.7069,0.7172,0.7534,0.7048,0.734,0.6864,0.6849,0.706,0.7532,0.7208,0.746,0.7105,0.7157,0.7141,0.6764,0.6043,0.6886,0.7132,0.7424,0.6985,0.6352,0.6966,0.7327,0.7241,0.6936,0.7132,0.7084,0.6871,0.6687,0.6586,0.6687,0.7053,0.6307,0.693,0.6724,0.6756,0.6904,0.673,0.6211,0.6983,0.6651,0.7065,0.6697,0.7326,0.7282,0.6997,0.6809,0.7293,0.7219,0.6923,0.6817,0.682,0.6911,0.7237,0.7375,0.7528,0.7406,0.6903,0.7058,0.7538,0.7368,0.7183,0.7478,0.7131,0.6699,0.694,0.6675]
e2e_pc1=[0.2102,0.2624,0.3883,0.4171,0.5447,0.4584,0.561,0.5857,0.6102,0.7075,0.7258,0.6757,0.7344,0.7431,0.6702,0.7195,0.7685,0.8011,0.8024,0.7855,0.8184,0.8086,0.8131,0.8326,0.8344,0.7925,0.8118,0.8381,0.8363,0.8415,0.8315,0.8466,0.8384,0.8158,0.8505,0.8447,0.8466,0.8454,0.8439,0.8421,0.8544,0.8511,0.8359,0.8565,0.8646,0.855,0.8572,0.8558,0.8574,0.8597,0.86,0.8505,0.8596,0.8694,0.8512,0.8545,0.8578,0.8631,0.8635,0.8677,0.8625,0.8659,0.8585,0.8604,0.8573,0.865,0.863,0.8725,0.8664,0.8699,0.869,0.869,0.8676,0.8689,0.8574,0.87,0.8723,0.8692,0.8628,0.8725,0.8714,0.8747,0.8702,0.8681,0.8694,0.8759,0.8749,0.8662,0.8637,0.8661,0.8728,0.8728,0.8743,0.8742,0.8718,0.8703,0.8708,0.8772,0.8749,0.8698,0.8687,0.8733,0.8742,0.8741,0.8732,0.8758,0.8784,0.8759,0.8689,0.8704,0.8758,0.8745,0.8763,0.8764,0.8741,0.8748,0.8788,0.864,0.8703,0.8744,0.8781,0.8747,0.8686,0.8734,0.8712,0.8743,0.8747,0.8783,0.8757,0.8728,0.8758,0.8775,0.878,0.8773,0.8801,0.8764,0.8752,0.8781,0.8576,0.8749,0.8758,0.8794,0.8798,0.8744,0.869,0.8715,0.8708,0.8749,0.8787,0.871,0.8781,0.876,0.8693,0.8776,0.8761,0.8792,0.8792,0.8772,0.8792,0.8797,0.8788,0.8783,0.8816,0.8805,0.8803,0.8778,0.8816,0.8787,0.8802,0.8695,0.8821,0.878,0.8733,0.8803,0.8745,0.8784,0.877,0.88,0.8804,0.8812,0.8829,0.8764,0.8781,0.8726,0.8768,0.8728,0.8799,0.8803,0.8792,0.8788,0.8759,0.8822,0.8819,0.8825,0.8787,0.8792,0.8793,0.8763,0.8803,0.8826,0.8815,0.8777,0.8768,0.8787,0.8744,0.881,0.8835,0.8799,0.8658,0.8783,0.8806,0.8796,0.874,0.883,0.8827,0.8773,0.882,0.8737,0.8816,0.8786,0.8815,0.8773,0.8729,0.8788,0.8757,0.8786,0.8782,0.8817,0.8771,0.8793,0.8774,0.882,0.8826,0.8774,0.8761,0.8784,0.8792,0.8781,0.881,0.8781,0.875,0.8738,0.8801,0.8785,0.8718,0.8787,0.8807,0.8743,0.874,0.877,0.8802,0.8784,0.8775,0.8767,0.8776,0.8768,0.8782,0.8811,0.8803,0.8769,0.8757,0.8817,0.8756,0.8755,0.8739,0.8777,0.878,0.8773,0.8819,0.8729,0.8796,0.8652,0.878,0.8736,0.8741,0.8789,0.878,0.8763,0.8809,0.8752,0.8783,0.8796,0.8788,0.8767,0.8709,0.8774,0.8743,0.8773,0.8754,0.8757,0.8766,0.8755,0.8755,0.877,0.8789,0.8781,0.8791,0.8764,0.8762,0.8799,0.8781,0.8752,0.882,0.8793,0.8805,0.8757,0.876,0.878,0.8777,0.879,0.8803,0.8796,0.8804,0.8811,0.8696,0.8822,0.8831,0.8792,0.8772,0.8844,0.8829,0.8793,0.8837,0.8819,0.8825,0.8803,0.8832,0.8778,0.8849,0.8759,0.878,0.8819,0.879,0.8819,0.8802,0.8812,0.8788,0.8823,0.8818,0.8808,0.8777,0.8805,0.8838,0.8802,0.8812,0.8807,0.8804,0.881,0.8716,0.8791,0.8839,0.8721,0.8815,0.8817,0.8823,0.8742,0.8806,0.8782,0.8819,0.8809,0.8829,0.8827,0.8828,0.8841,0.8822,0.8799,0.8831,0.8819,0.8806,0.8804,0.8798,0.8846,0.8802,0.8797,0.8828,0.8795,0.8843,0.8808,0.8806,0.8841,0.8843,0.8849,0.8831,0.8765,0.8823,0.8781,0.8825,0.8837,0.8841,0.8827,0.8832,0.8826,0.8843,0.8792,0.8831,0.8818,0.8823,0.8831,0.88,0.886,0.8782,0.8784,0.882,0.8787,0.8841,0.8831,0.8838,0.8814,0.8839,0.8808,0.8814,0.8837,0.8818,0.8826,0.8811,0.8834,0.8785,0.8804,0.8832,0.8815,0.8823,0.8821,0.8818,0.8837,0.8831,0.8848,0.8843,0.8814,0.8841,0.8831,0.8822,0.8836,0.8797,0.884,0.8843,0.8826,0.8828,0.8832,0.8771,0.8845,0.8841,0.8834,0.8825,0.8792,0.8837,0.8779,0.8841,0.8832,0.8861,0.8847,0.8853,0.8852,0.8787,0.8851,0.8827,0.8842,0.8814,0.8852,0.8842,0.8816,0.8822,0.887,0.8851,0.8834,0.8818,0.8853,0.8848,0.885,0.8814,0.8843,0.8871,0.8843,0.8808,0.884,0.883,0.8844,0.8836,0.8845,0.8851,0.8828,0.8847,0.8856,0.8851,0.8854,0.8844,0.8848,0.8824,0.8857,0.8828,0.8854,0.8841,0.8843,0.8859,0.884,0.8835,0.8851,0.8847,0.8853,0.8829,0.8833,0.8833,0.8856,0.885,0.8863,0.8831,0.8846,0.8855,0.8859,0.8847,0.8822,0.8819,0.8856,0.8815,0.8825,0.886,0.8845,0.8843,0.8835,0.8846,0.885,0.8835,0.8839,0.8845,0.8854,0.8854,0.883,0.8858,0.8828,0.8822,0.8858,0.8832,0.8821,0.8855,0.8858,0.8855,0.8844,0.8848,0.885,0.8837,0.885,0.8805,0.8863,0.882,0.8857,0.8867,0.8834,0.8865,0.8835,0.8822,0.886,0.8837,0.8841,0.8863,0.8835,0.8846,0.8851,0.8814,0.8821,0.8847,0.8843,0.8837,0.8837,0.8844,0.8815,0.884,0.8857,0.8851,0.8837,0.8855,0.8867,0.8869,0.8861,0.8869,0.8838,0.885,0.8839,0.885,0.8842,0.8861,0.8844,0.8845,0.8868,0.8871,0.8848,0.8854,0.883,0.8831,0.8838,0.8831,0.8835,0.8836,0.8836,0.8841,0.8858,0.8827,0.8841,0.8857,0.8842,0.8858,0.886,0.8838,0.8843,0.881,0.884,0.8855,0.8851,0.8852,0.8852,0.8842,0.8846,0.8843,0.8835,0.8843,0.8855,0.8856,0.8838,0.8846,0.8805,0.8822,0.8815,0.885,0.8836,0.8834,0.8836,0.883,0.8823,0.8856,0.8843,0.8851,0.8856,0.8859,0.8837,0.8853,0.8823,0.8823,0.8858,0.8864,0.8857,0.8857,0.8868,0.887,0.8865,0.8852,0.8847,0.8854,0.8841,0.8846,0.8847,0.8844,0.8859,0.8829,0.8844,0.8827,0.8847,0.8864,0.8846,0.8833,0.886,0.8844,0.8826,0.8787,0.8854,0.886,0.886,0.8848,0.8872,0.8853,0.8824,0.8855,0.8872,0.884,0.8825,0.8855,0.8849,0.8859,0.8852,0.8866,0.8819,0.8858,0.8857,0.8843,0.8825,0.8842,0.8842,0.885,0.8851,0.8857,0.8856,0.8849,0.8829,0.8844,0.8794,0.8873,0.8839,0.8831,0.8836,0.8867,0.8833,0.886,0.8847,0.8848,0.8866,0.886,0.8839,0.8863,0.8837,0.8848,0.8865,0.8875,0.8844,0.8858,0.8848,0.8828,0.8861,0.8813,0.8839,0.8845,0.8853,0.8847,0.8872,0.8818,0.885,0.8847,0.8872,0.8849,0.8833,0.8836,0.8838,0.886,0.8841,0.8869,0.8852,0.8836,0.8852,0.8851,0.8852,0.8841,0.8862,0.8849,0.8865,0.885,0.8841,0.8848,0.8873,0.8855,0.8866,0.8861,0.8866,0.8855,0.885,0.887,0.8863,0.8866,0.8842,0.8859,0.8852,0.8865,0.8858,0.8849,0.8858,0.8874,0.882,0.8834,0.8846,0.8861,0.886,0.8832,0.8816,0.8876,0.8875,0.8861,0.8857,0.8823,0.8846,0.8853,0.8842,0.8834,0.8849,0.8846,0.884,0.8851,0.8849,0.8847,0.8826,0.8833,0.8835,0.8864,0.8859,0.8851,0.885,0.8867,0.8844,0.8844,0.8821,0.8854,0.8853,0.8856,0.8829,0.8822,0.884,0.8827,0.8831,0.8857,0.8855,0.8847,0.8851,0.885,0.8855,0.8841,0.8829,0.8848,0.8836,0.8871,0.8859,0.8836,0.8821,0.8868,0.8842,0.8858,0.8842,0.8859,0.8852,0.8842,0.8847,0.883,0.8861,0.884,0.8829,0.8834,0.8848,0.8843,0.8799,0.8835,0.8834,0.8847,0.8835,0.884,0.8836,0.886,0.8854,0.883,0.8867,0.885,0.8839,0.8864,0.8856,0.887,0.8851,0.8871,0.8852,0.8864,0.885,0.8844,0.8837,0.885,0.8864,0.8862,0.8826,0.8867,0.8818,0.8858,0.8855,0.885,0.8827,0.8813,0.8866,0.884,0.8846,0.8836,0.8855,0.8877,0.8824,0.8824,0.8843,0.8858,0.8843,0.885,0.8849,0.8857,0.8834,0.8853,0.8829,0.8855,0.8842,0.8845,0.8835,0.8842,0.8872,0.8863,0.8848,0.8831,0.8842,0.8873,0.8863,0.8856,0.8852,0.8854,0.8845,0.8853,0.8844,0.8875,0.8867,0.8835,0.8868,0.8888,0.8867,0.8861,0.8878,0.883,0.8853,0.8823,0.8853,0.8853,0.8858,0.8846,0.8814,0.8862,0.8829,0.8858,0.8817,0.883,0.883,0.885,0.8861,0.8873,0.884,0.8834,0.8849,0.8864,0.8847,0.8853,0.882,0.8852,0.8849,0.8848,0.8844,0.8861,0.8868,0.8867,0.8865,0.8872,0.8838,0.8875,0.8881,0.8849,0.8874,0.8844,0.8865,0.8854,0.8872,0.8865,0.8869,0.8835,0.885,0.8843,0.8866,0.8841,0.8866,0.8869,0.8868,0.885,0.8816,0.8857,0.885,0.8873,0.8844,0.8858,0.8836,0.8838,0.8856,0.888,0.8859,0.8869,0.8868,0.8851,0.8865,0.8865,0.8848,0.8844,0.8836,0.8869,0.8836,0.884,0.8868,0.8872,0.8875,0.8856,0.8837,0.8863,0.8849,0.887,0.8866,0.8864,0.8864,0.8856,0.8869,0.8843,0.8871,0.8836,0.886]
e2s_pc1=[0.2794,0.3127,0.222,0.3741,0.4032,0.3795,0.3933,0.4388,0.4098,0.4444,0.3834,0.4473,0.5209,0.3689,0.3173,0.5052,0.4372,0.393,0.3986,0.3272,0.4196,0.5364,0.469,0.5747,0.4949,0.5722,0.554,0.5856,0.5276,0.4927,0.5381,0.5124,0.5363,0.6119,0.6275,0.6529,0.6661,0.2958,0.5549,0.658,0.5749,0.7116,0.6656,0.6013,0.611,0.5978,0.6483,0.7261,0.6625,0.5918,0.6531,0.692,0.6635,0.556,0.6603,0.7684,0.6219,0.7564,0.6264,0.7593,0.7294,0.7643,0.6391,0.7511,0.7163,0.715,0.693,0.6852,0.6566,0.7712,0.6939,0.756,0.7171,0.6855,0.6922,0.731,0.7605,0.6026,0.6817,0.766,0.728,0.685,0.7693,0.7312,0.5238,0.7823,0.7963,0.7369,0.6534,0.8129,0.7865,0.75,0.822,0.762,0.8137,0.6511,0.7907,0.7209,0.7285,0.6443,0.5006,0.626,0.5998,0.6921,0.8061,0.7635,0.7218,0.708,0.7827,0.7586,0.7383,0.7037,0.6832,0.738,0.7219,0.8313,0.7875,0.7611,0.7954,0.8281,0.7758,0.7268,0.7044,0.6862,0.8024,0.7372,0.767,0.6821,0.7301,0.8008,0.7573,0.8264,0.8169,0.7291,0.5539,0.6988,0.8197,0.8316,0.8149,0.7723,0.8291,0.8225,0.8225,0.7142,0.6963,0.7363,0.7342,0.8084,0.8467,0.8258,0.864,0.8354,0.8105,0.8255,0.8101,0.8001,0.7317,0.7674,0.7807,0.7682,0.8133,0.6997,0.7643,0.7337,0.7012,0.816,0.8212,0.8061,0.7655,0.7673,0.7738,0.7605,0.8333,0.8234,0.786,0.7913,0.7813,0.8149,0.7493,0.7605,0.8422,0.7768,0.7763,0.7608,0.7816,0.7866,0.8293,0.8064,0.8282,0.7799,0.7531,0.7651,0.847,0.8549,0.8601,0.8263,0.8059,0.7863,0.827,0.7742,0.564,0.8252,0.76,0.8377,0.7628,0.8031,0.7639,0.7524,0.8369,0.8108,0.7793,0.7335,0.7131,0.6919,0.6959,0.7424,0.7374,0.6734,0.6962,0.768,0.7858,0.8472,0.7742,0.7797,0.8564,0.8223,0.7958,0.8391,0.7797,0.8032,0.7496,0.7822,0.8348,0.8691,0.8332,0.8068,0.8434,0.8319,0.8375,0.7805,0.8433,0.7817,0.817,0.8332,0.8617,0.7669,0.8467,0.808,0.7959,0.7743,0.8328,0.8638,0.7937,0.8655,0.8573,0.7918,0.8319,0.8489,0.8406,0.7917,0.7899,0.8245,0.8545,0.8288,0.8583,0.8596,0.8499,0.8448,0.8545,0.8495,0.8259,0.7762,0.8187,0.8085,0.8275,0.7606,0.7162,0.8487,0.7734,0.7307,0.8442,0.7194,0.8398,0.8117,0.8063,0.787,0.8373,0.7532,0.8608,0.8583,0.8121,0.8135,0.8169,0.8079,0.8539,0.8618,0.8515,0.738,0.8632,0.8628,0.8591,0.8177,0.801,0.8677,0.8589,0.8392,0.8412,0.8484,0.8602,0.8399,0.8506,0.8611,0.7682,0.7995,0.7726,0.7632,0.8791,0.8518,0.8503,0.871,0.848,0.8636,0.8593,0.8305,0.8627,0.699,0.7656,0.7704,0.8293,0.8547,0.8037,0.8215,0.859,0.8689,0.8406,0.78,0.7851,0.8077,0.8573,0.7992,0.7896,0.861,0.8411,0.806,0.8451,0.7126,0.7623,0.8104,0.7858,0.7733,0.7789,0.7957,0.8601,0.8236,0.8206,0.7197,0.8254,0.8337,0.8539,0.7495,0.8206,0.8306,0.8547,0.7701,0.7743,0.8304,0.8165,0.8395,0.7741,0.7618,0.7537,0.7362,0.7778,0.8552,0.844,0.8632,0.7519,0.812,0.7973,0.839,0.8414,0.8393,0.8729,0.8271,0.827,0.8515,0.8407,0.7711,0.8473,0.8263,0.8762,0.8641,0.8426,0.8389,0.8174,0.8014,0.8002,0.8188,0.8029,0.8656,0.8436,0.7735,0.8028,0.8775,0.8566,0.8448,0.8288,0.8363,0.8723,0.868,0.8749,0.8568,0.852,0.8166,0.815,0.8732,0.858,0.8689,0.8618,0.8273,0.8435,0.8656,0.8768,0.8489,0.8239,0.8665,0.8635,0.8618,0.8407,0.8555,0.8758,0.8705,0.8566,0.8465,0.8181,0.8482,0.8675,0.7789,0.8504,0.8746,0.8633,0.8607,0.8382,0.8712,0.8756,0.8161,0.8163,0.7808,0.8513,0.8556,0.8707,0.7967,0.7561,0.8047,0.8173,0.8143,0.7973,0.8388,0.819,0.829,0.7771,0.7825,0.7791,0.763,0.7924,0.7724,0.8685,0.8595,0.8229,0.8198,0.8626,0.8419,0.829,0.8754,0.8396,0.8428,0.8623,0.8331,0.8549,0.8393,0.7727,0.8486,0.8522,0.8719,0.7894,0.8473,0.837,0.8236,0.8376,0.8042,0.8686,0.8509,0.8644,0.8601,0.8536,0.8758,0.859,0.876,0.8426,0.8166,0.8725,0.8534,0.8678,0.8648,0.866,0.8487,0.7864,0.7932,0.7992,0.8542,0.8358,0.8157,0.789,0.794,0.7758,0.7869,0.8579,0.8258,0.8278,0.8328,0.8297,0.8431,0.8473,0.8075,0.8721,0.8634,0.8638,0.8502,0.8469,0.8768,0.8693,0.8538,0.8516,0.8695,0.8155,0.8825,0.8629,0.8486,0.8714,0.8607,0.8478,0.8705,0.859,0.8207,0.8701,0.8686,0.8434,0.8586,0.8698,0.8646,0.8538,0.8344,0.8683,0.856,0.8786,0.8646,0.8677,0.846,0.8189,0.8652,0.8602,0.8384,0.8538,0.8611,0.8587,0.8531,0.8332,0.8156,0.8732,0.8794,0.8672,0.8712,0.8477,0.8578,0.8734,0.8434,0.8612,0.8665,0.8567,0.8217,0.8379,0.8655,0.8483,0.8557,0.8203,0.8697,0.8697,0.8541,0.8566,0.854,0.8702,0.8366,0.8312,0.8813,0.8691,0.8042,0.8706,0.8782,0.8684,0.8683,0.876,0.8591,0.8507,0.8675,0.873,0.8583,0.8747,0.8576,0.8597,0.8585,0.8711,0.864,0.8609,0.783,0.8664,0.7955,0.7768,0.7923,0.8246,0.8431,0.857,0.8411,0.7997,0.8677,0.8545,0.8743,0.8563,0.871,0.7839,0.8439,0.8316,0.8727,0.8193,0.873,0.8616,0.87,0.8759,0.8654,0.8438,0.7823,0.853,0.8539,0.8792,0.8537,0.8414,0.8421,0.8457,0.877,0.8564,0.872,0.8632,0.8715,0.883,0.8768,0.8819,0.8718,0.8662,0.8073,0.8558,0.8519,0.7972,0.8793,0.8515,0.8769,0.8561,0.8756,0.8808,0.8659,0.8844,0.8777,0.8753,0.8021,0.8154,0.7866,0.8769,0.8576,0.8252,0.7948,0.8508,0.862,0.7952,0.7576,0.8781,0.8719,0.8499,0.8735,0.8806,0.8422,0.8584,0.8698,0.8648,0.8723,0.8554,0.8543,0.8808,0.8703,0.8735,0.8773,0.8811,0.8152,0.8277,0.8698,0.867,0.8689,0.8811,0.8816,0.8692,0.875,0.8585,0.8788,0.8643,0.8438,0.7991,0.86,0.8706,0.8766,0.8701,0.8583,0.8757,0.8739,0.8597,0.8548,0.8813,0.8597,0.8552,0.8503,0.8739,0.8701,0.8515,0.8427,0.8382,0.8106,0.8533,0.8673,0.803,0.8648,0.8661,0.8735,0.8404,0.8815,0.8796,0.8673,0.8728,0.8684,0.8678,0.8493,0.8565,0.8641,0.8482,0.8439,0.8582,0.8839,0.8638,0.8819,0.8641,0.878,0.8653,0.8492,0.8819,0.875,0.8799,0.862,0.8662,0.8589,0.8783,0.8524,0.8024,0.8494,0.8269,0.8069,0.8343,0.8837,0.8821,0.8726,0.878,0.8773,0.8463,0.8251,0.8476,0.8454,0.8372,0.8613,0.8465,0.8738,0.8506,0.8396,0.8127,0.8584,0.8807,0.8796,0.8706,0.8793,0.8719,0.8733,0.8789,0.8578,0.8808,0.8647,0.8032,0.8717,0.8635,0.8071,0.8565,0.8516,0.7865,0.8111,0.8709,0.8804,0.8714,0.8718,0.8747,0.8722,0.8719,0.875,0.8758,0.8738,0.8734,0.8783,0.8509,0.7997,0.8201,0.8589,0.8519,0.8761,0.8801,0.8815,0.8252,0.8795,0.8673,0.863,0.8747,0.871,0.8704,0.8652,0.843,0.8696,0.8704,0.8572,0.8711,0.8474,0.8852,0.8811,0.8778,0.8771,0.8794,0.8388,0.8721,0.8693,0.8664,0.8762,0.8778,0.864,0.8636,0.8644,0.8743,0.8825,0.873,0.8802,0.8696,0.873,0.8774,0.867,0.8211,0.8329,0.8506,0.8626,0.8449,0.8594,0.8658,0.8126,0.818,0.8785,0.8808,0.8712,0.8772,0.8561,0.8585,0.8582,0.8825,0.8671,0.8836,0.8782,0.8737,0.874,0.8656,0.8583,0.8732,0.8789,0.8678,0.8545,0.8693,0.874,0.8647,0.8722,0.8665,0.8539,0.8634,0.8613,0.8239,0.8835,0.8757,0.8798,0.8691,0.8102,0.8193,0.8332,0.8779,0.8793,0.8697,0.8558,0.8081,0.883,0.8777,0.8751,0.8672,0.8617,0.872,0.8805,0.8834,0.861,0.8418,0.8806,0.876,0.8663,0.8767,0.8602,0.8767,0.8869,0.8724,0.8689,0.8839,0.8732,0.8555,0.8043,0.8757,0.8611,0.8766,0.8666,0.8782,0.8327,0.8814,0.8357,0.8775,0.838,0.8694,0.8857,0.8713,0.8821,0.875,0.8667,0.8578,0.8497,0.8471,0.8281,0.8853,0.8307,0.8404,0.8462,0.8857,0.8827,0.8624,0.8667,0.8745,0.8768,0.875,0.861,0.8852,0.8706,0.8579,0.854,0.8721,0.82,0.8143,0.8332,0.8312,0.8723,0.8852,0.8824,0.8805,0.8692,0.8672,0.8594,0.8642,0.8673,0.8221,0.8667,0.876,0.8178,0.8501,0.8721,0.8813,0.8653,0.8803,0.8772,0.8712,0.8753,0.8254,0.8693,0.8807,0.8768]
bfc_pc1=[0.2725,0.4241,0.5002,0.4991,0.5775,0.6431,0.6525,0.665,0.6713,0.6941,0.6771,0.72,0.7332,0.7424,0.7455,0.7515,0.7551,0.762,0.7601,0.7781,0.798,0.7945,0.7702,0.8096,0.7843,0.8003,0.8155,0.8198,0.8154,0.8203,0.8225,0.8204,0.8193,0.8335,0.8178,0.8343,0.8186,0.8398,0.8336,0.8292,0.8443,0.8461,0.844,0.8451,0.8455,0.843,0.8446,0.84,0.8455,0.8551,0.8512,0.8555,0.8556,0.8552,0.8546,0.8542,0.848,0.8509,0.85,0.8595,0.8533,0.8592,0.8561,0.8578,0.8598,0.8616,0.8593,0.8641,0.8596,0.8662,0.8589,0.8597,0.8503,0.8645,0.856,0.8591,0.8691,0.8615,0.8627,0.8605,0.8623,0.8599,0.8661,0.8598,0.8623,0.8634,0.8695,0.8632,0.8727,0.8657,0.8654,0.8646,0.8681,0.8716,0.8725,0.8742,0.8679,0.8695,0.8688,0.8655,0.8736,0.8677,0.8698,0.8693,0.8709,0.8714,0.8702,0.8712,0.869,0.871,0.8721,0.8736,0.8684,0.8682,0.8731,0.8761,0.8689,0.8737,0.8681,0.8729,0.8727,0.8734,0.8774,0.8739,0.8703,0.8716,0.8776,0.8771,0.8756,0.8766,0.8777,0.8747,0.8744,0.8723,0.871,0.8698,0.8725,0.8749,0.8758,0.8757,0.875,0.8723,0.8769,0.8705,0.8779,0.8764,0.8802,0.8743,0.8731,0.871,0.8744,0.8754,0.8799,0.8752,0.8763,0.8741,0.8776,0.8727,0.8758,0.8749,0.8746,0.8775,0.8805,0.8795,0.8822,0.8776,0.8809,0.8798,0.8742,0.8799,0.8791,0.8737,0.8795,0.879,0.8832,0.8818,0.8813,0.8791,0.8837,0.8818,0.8724,0.8796,0.878,0.8817,0.877,0.8782,0.8831,0.8773,0.8819,0.8815,0.8837,0.8758,0.8815,0.8766,0.8804,0.8814,0.8791,0.8745,0.8796,0.882,0.8794,0.8772,0.8826,0.8797,0.8803,0.8809,0.8842,0.8821,0.8817,0.8794,0.8769,0.8798,0.8806,0.8796,0.8792,0.8829,0.8809,0.8831,0.8831,0.8842,0.881,0.8832,0.8836,0.8796,0.8791,0.8827,0.8793,0.8798,0.8814,0.882,0.8848,0.8834,0.8818,0.8798,0.877,0.8815,0.8823,0.8815,0.8747,0.8794,0.8812,0.8828,0.8839,0.8837,0.8823,0.8829,0.8797,0.8826,0.8793,0.8826,0.8825,0.8847,0.8799,0.8838,0.8833,0.8852,0.8815,0.8813,0.8811,0.8798,0.8804,0.8829,0.8816,0.8823,0.8821,0.8808,0.8827,0.8797,0.8836,0.8835,0.8829,0.8817,0.8816,0.8806,0.8803,0.8813,0.8809,0.8835,0.8825,0.8827,0.8788,0.8796,0.8811,0.8831,0.8832,0.8831,0.8834,0.8846,0.8827,0.8831,0.8811,0.8834,0.8839,0.8801,0.8809,0.8827,0.8825,0.883,0.8841,0.8818,0.8846,0.8827,0.882,0.8841,0.8831,0.8836,0.8852,0.8847,0.8789,0.8832,0.8837,0.8831,0.8824,0.8832,0.8826,0.8842,0.8829,0.8846,0.8848,0.8836,0.8854,0.8767,0.8802,0.8858,0.8851,0.8845,0.8831,0.884,0.8852,0.8852,0.8809,0.8829,0.8849,0.8834,0.8805,0.8836,0.8862,0.8847,0.8838,0.883,0.8839,0.8848,0.8818,0.8828,0.8848,0.8822,0.8834,0.8809,0.8833,0.8834,0.8825,0.8825,0.8854,0.885,0.8849,0.8842,0.8837,0.8863,0.8835,0.8846,0.8855,0.8847,0.8837,0.8842,0.8851,0.8857,0.8835,0.883,0.8848,0.8869,0.886,0.8832,0.8856,0.8847,0.8799,0.8855,0.8844,0.8862,0.8832,0.8827,0.8857,0.8853,0.8836,0.8825,0.884,0.8858,0.8842,0.8863,0.8847,0.8858,0.8842,0.8847,0.884,0.8828,0.8856,0.8868,0.8846,0.8853,0.8839,0.8866,0.8846,0.8861,0.8843,0.883,0.8851,0.8857,0.886,0.886,0.8866,0.8853,0.885,0.8852,0.8814,0.8834,0.8844,0.8809,0.8844,0.8856,0.8862,0.8844,0.8834,0.8826,0.8845,0.8864,0.8846,0.8858,0.8836,0.8861,0.8859,0.8855,0.887,0.8859,0.8849,0.8816,0.8864,0.8851,0.8854,0.8858,0.8868,0.8839,0.8834,0.8859,0.887,0.8857,0.8843,0.8827,0.8836,0.8843,0.8847,0.8842,0.8817,0.8876,0.8844,0.8862,0.8845,0.8859,0.8867,0.8871,0.8856,0.884,0.8837,0.8859,0.8866,0.8858,0.8834,0.8867,0.8871,0.8861,0.8856,0.8846,0.8857,0.8835,0.8852,0.887,0.8849,0.8832,0.8863,0.8848,0.8849,0.8869,0.8845,0.8841,0.8846,0.8856,0.8848,0.8873,0.8839,0.8865,0.8828,0.8875,0.8842,0.8851,0.8877,0.8856,0.8855,0.8859,0.8861,0.8831,0.8858,0.8835,0.8853,0.8852,0.886,0.8849,0.8856,0.8868,0.8849,0.8857,0.8866,0.8854,0.8859,0.8858,0.8848,0.8886,0.8876,0.8859,0.8859,0.8858,0.8866,0.8867,0.886,0.8887,0.8848,0.8882,0.8855,0.8861,0.8876,0.8867,0.8848,0.8861,0.886,0.8841,0.8862,0.8853,0.8851,0.8847,0.8863,0.8871,0.8845,0.887,0.8879,0.8865,0.8841,0.8851,0.8877,0.8861,0.8871,0.8871,0.8861,0.8863,0.8853,0.885,0.8859,0.8849,0.8876,0.8869,0.885,0.8842,0.8871,0.8863,0.8873,0.8843,0.8865,0.8855,0.8864,0.8873,0.8857,0.8877,0.887,0.8847,0.8874,0.8851,0.8852,0.8871,0.8863,0.8874,0.8866,0.886,0.888,0.8879,0.8859,0.8862,0.887,0.8862,0.8837,0.8868,0.8868,0.8869,0.8867,0.8866,0.8864,0.8843,0.8854,0.8883,0.8859,0.8871,0.8872,0.8869,0.886,0.8859,0.8874,0.8856,0.8873,0.8879,0.8879,0.8868,0.8878,0.8883,0.8877,0.8856,0.8869,0.8862,0.8861,0.8858,0.8873,0.8861,0.8867,0.8853,0.887,0.8868,0.8862,0.8869,0.8866,0.8859,0.8865,0.8861,0.8847,0.8872,0.8867,0.8868,0.8864,0.8851,0.8871,0.8851,0.8873,0.887,0.8872,0.8848,0.886,0.887,0.8872,0.887,0.8887,0.887,0.8873,0.8867,0.8861,0.8863,0.8852,0.8876,0.8874,0.8868,0.8851,0.8869,0.8864,0.8848,0.8873,0.8875,0.8864,0.8872,0.888,0.8866,0.8874,0.886,0.8858,0.8866,0.886,0.8862,0.8874,0.8872,0.8855,0.8854,0.8861,0.8873,0.8864,0.8839,0.8875,0.8858,0.8848,0.8864,0.8845,0.8876,0.8864,0.8869,0.8877,0.8867,0.8864,0.8867,0.8881,0.8877,0.8874,0.8866,0.8857,0.8886,0.8867,0.886,0.8859,0.8865,0.888,0.8851,0.8875,0.8862,0.8874,0.8858,0.8845,0.8875,0.8874,0.8868,0.888,0.8871,0.8864,0.8851,0.8884,0.8881,0.886,0.8871,0.8866,0.8879,0.8877,0.8858,0.8876,0.887,0.8862,0.887,0.8883,0.8875,0.8859,0.8848,0.8866,0.8857,0.8876,0.8852,0.8858,0.8865,0.8875,0.8845,0.8868,0.8857,0.8872,0.8884,0.8876,0.8858,0.8862,0.8881,0.8886,0.8871,0.8859,0.8877,0.8874,0.8851,0.8877,0.8872,0.8882,0.8883,0.8851,0.8871,0.8869,0.8875,0.8878,0.8876,0.8862,0.8852,0.8888,0.8838,0.8866,0.8875,0.8884,0.8862,0.8874,0.8869,0.8881,0.8874,0.8857,0.8885,0.885,0.8874,0.8867,0.8863,0.8869,0.8888,0.887,0.8867,0.8863,0.8867,0.886,0.8867,0.8864,0.8856,0.8872,0.8869,0.8858,0.8868,0.8862,0.8869,0.8874,0.8861,0.8858,0.8859,0.8862,0.8855,0.8858,0.8864,0.8863,0.8864,0.8862,0.8863,0.8861,0.887,0.8855,0.8861,0.8851,0.8858,0.8872,0.8877,0.8855,0.8861,0.887,0.8876,0.8851,0.8887,0.8863,0.8863,0.8873,0.8878,0.8867,0.8859,0.8867,0.8858,0.8863,0.8877,0.8857,0.8863,0.8859,0.8878,0.8889,0.8879,0.8882,0.8854,0.8873,0.8875,0.8875,0.888,0.8864,0.8865,0.8885,0.8862,0.8869,0.8887,0.8872,0.8869,0.8893,0.8837,0.8868,0.8874,0.8871,0.8871,0.8888,0.8872,0.888,0.8874,0.8861,0.8865,0.8875,0.8877,0.8881,0.8881,0.8872,0.8881,0.8881,0.8864,0.887,0.886,0.8861,0.8854,0.886,0.8873,0.8866,0.8877,0.8882,0.8873,0.8889,0.8889,0.8889,0.8876,0.8875,0.8894,0.8866,0.8885,0.8877,0.8884,0.8867,0.8881,0.8876,0.8875,0.8888,0.8879,0.8873,0.8881,0.8876,0.8875,0.8873,0.8865,0.8878,0.886,0.8862,0.8867,0.8858,0.8858,0.888,0.8883,0.8874,0.8888,0.887,0.8871,0.8882,0.8854,0.8867,0.8877,0.8873,0.884,0.8862,0.8857,0.8873,0.886,0.8868,0.8886,0.8874,0.8876,0.8868,0.8867,0.8878,0.8871,0.8883,0.8883,0.8887,0.8861,0.8885,0.8873,0.8889,0.8884,0.8865,0.8875,0.888,0.8871,0.8875,0.8855,0.8866,0.8861,0.8861,0.8853,0.8875,0.888,0.8867,0.8879,0.8885,0.8886,0.8875,0.888,0.8875,0.8872,0.8883,0.8876,0.8884,0.8888,0.8889,0.8853,0.8868,0.8854,0.8879,0.8887,0.8887,0.887,0.8889,0.8871,0.8873,0.8866,0.8869,0.8869,0.8867,0.8872,0.8874,0.8874,0.887,0.8889,0.8873,0.8863,0.8865,0.8875,0.8875,0.8883,0.888,0.8881,0.888,0.8892,0.8865,0.8882,0.8886,0.888,0.8889,0.8873]
bf_pc1=[0.3199,0.2613,0.1597,0.3929,0.3878,0.2072,0.4962,0.2769,0.5274,0.5616,0.4893,0.524,0.4591,0.5003,0.3662,0.4773,0.5679,0.4037,0.5125,0.3799,0.6284,0.5911,0.5157,0.6304,0.4619,0.6094,0.4479,0.6352,0.7213,0.6506,0.5083,0.44,0.4102,0.6969,0.7318,0.7311,0.6705,0.563,0.6303,0.7352,0.6852,0.4773,0.7032,0.7702,0.7706,0.7409,0.7144,0.7223,0.753,0.7497,0.7566,0.7802,0.7769,0.8262,0.6321,0.7281,0.7353,0.8083,0.7917,0.6808,0.6135,0.7437,0.6533,0.6477,0.6421,0.6191,0.751,0.6737,0.7036,0.784,0.7819,0.6967,0.7932,0.8037,0.8778,0.7711,0.8068,0.8571,0.7941,0.7326,0.8207,0.7513,0.746,0.6835,0.7355,0.8397,0.7491,0.7603,0.7537,0.7968,0.7487,0.6659,0.7509,0.715,0.8021,0.7304,0.7743,0.7973,0.8235,0.7347,0.7228,0.7553,0.6963,0.8185,0.7563,0.7378,0.7354,0.7685,0.755,0.8181,0.7206,0.72,0.6852,0.8164,0.6939,0.7109,0.8359,0.8691,0.7619,0.8514,0.8631,0.8917,0.7458,0.8636,0.8161,0.8458,0.8276,0.8137,0.7707,0.7757,0.812,0.8113,0.8306,0.7514,0.7238,0.7974,0.7713,0.8068,0.8155,0.8507,0.8522,0.9169,0.9018,0.8895,0.9161,0.8625,0.8267,0.833,0.8286,0.8722,0.796,0.8041,0.9018,0.9282,0.9284,0.9397,0.8157,0.8162,0.7869,0.8112,0.8388,0.8647,0.9079,0.8605,0.8957,0.8662,0.9177,0.8554,0.8316,0.8366,0.7919,0.7354,0.9047,0.8447,0.7831,0.7705,0.762,0.8125,0.8933,0.7735,0.8375,0.9157,0.8883,0.846,0.8614,0.8602,0.901,0.8661,0.8129,0.8988,0.9111,0.909,0.8968,0.8858,0.925,0.8874,0.9029,0.8696,0.8992,0.9199,0.8482,0.8409,0.8721,0.8542,0.827,0.8017,0.833,0.8721,0.8565,0.931,0.9206,0.926,0.9351,0.8954,0.8639,0.8418,0.9113,0.8592,0.9315,0.9292,0.9461,0.8575,0.935,0.9226,0.8757,0.8222,0.7822,0.942,0.9168,0.8556,0.8542,0.8758,0.9532,0.9176,0.9162,0.9078,0.9126,0.944,0.8888,0.8424,0.8378,0.811,0.8145,0.8867,0.8569,0.8716,0.8513,0.8484,0.8465,0.8279,0.8075,0.8233,0.8244,0.7917,0.7888,0.7856,0.8062,0.8561,0.9043,0.8794,0.8417,0.8988,0.8523,0.8489,0.8864,0.8865,0.8843,0.8583,0.8887,0.8431,0.8153,0.8123,0.808,0.8578,0.8391,0.8643,0.8619,0.8564,0.9057,0.8964,0.8686,0.9294,0.9427,0.9157,0.8818,0.9457,0.948,0.8947,0.8278,0.8213,0.9083,0.9104,0.8638,0.8231,0.9067,0.8477,0.8422,0.8459,0.7877,0.8367,0.866,0.854,0.8504,0.8589,0.9236,0.8591,0.9241,0.8947,0.9451,0.9145,0.8818,0.8759,0.908,0.8812,0.859,0.9003,0.8762,0.8848,0.8983,0.8508,0.8963,0.8783,0.908,0.9168,0.9154,0.9231,0.9101,0.9369,0.9419,0.9542,0.9394,0.9319,0.946,0.9092,0.9531,0.91,0.9325,0.8932,0.9248,0.8948,0.9203,0.9493,0.9411,0.9076,0.9127,0.8594,0.8786,0.8676,0.9297,0.9555,0.9432,0.8995,0.9374,0.9156,0.888,0.8624,0.8466,0.8465,0.849,0.9017,0.8692,0.9351,0.9304,0.8778,0.8758,0.9128,0.8791,0.8481,0.932,0.9198,0.9003,0.8798,0.8861,0.9126,0.9131,0.9137,0.9494,0.942,0.9174,0.9241,0.9138,0.9189,0.904,0.8974,0.8857,0.9136,0.8896,0.8967,0.9209,0.8972,0.8971,0.9092,0.8913,0.9345,0.9671,0.9245,0.9299,0.9369,0.9165,0.8818,0.874,0.8795,0.8958,0.8685,0.8767,0.9183,0.9007,0.9137,0.9317,0.8873,0.8772,0.9191,0.9215,0.8723,0.9142,0.906,0.9263,0.8949,0.8695,0.8942,0.9407,0.8962,0.9003,0.939,0.941,0.911,0.9018,0.9055,0.8616,0.8388,0.8544,0.8394,0.8331,0.8854,0.9093,0.8626,0.8763,0.8633,0.8545,0.8758,0.8668,0.8887,0.8808,0.8889,0.8949,0.9387,0.9127,0.8811,0.8851,0.9006,0.8542,0.8548,0.9339,0.8864,0.9037,0.9573,0.9258,0.9154,0.9326,0.9297,0.9005,0.8926,0.8931,0.9546,0.9486,0.9245,0.9263,0.9059,0.8889,0.9306,0.9245,0.8848,0.8797,0.8685,0.8682,0.8663,0.9441,0.9237,0.9047,0.8647,0.8307,0.8475,0.9299,0.9371,0.9541,0.9264,0.9607,0.9444,0.9504,0.9185,0.8957,0.9396,0.9202,0.9429,0.9468,0.8893,0.9294,0.9469,0.9396,0.965,0.9525,0.944,0.9192,0.9101,0.9091,0.9329,0.942,0.9385,0.9219,0.8937,0.9507,0.9473,0.9209,0.9129,0.8983,0.8893,0.9228,0.9403,0.9515,0.901,0.8929,0.9196,0.9196,0.8664,0.9329,0.906,0.9245,0.9613,0.9362,0.9378,0.9416,0.9492,0.9697,0.9227,0.9115,0.9298,0.9049,0.8846,0.8641,0.8749,0.8673,0.8802,0.8939,0.9415,0.9288,0.9218,0.9442,0.9151,0.9098,0.9061,0.9038,0.883,0.8919,0.9147,0.9578,0.936,0.9168,0.9017,0.8903,0.9411,0.9202,0.936,0.9552,0.9216,0.9332,0.9363,0.9208,0.953,0.9352,0.9208,0.9039,0.921,0.8962,0.8964,0.9126,0.8972,0.8626,0.9049,0.9361,0.893,0.8955,0.9584,0.9536,0.9526,0.9272,0.9504,0.9267,0.9559,0.9183,0.9103,0.8788,0.8661,0.8988,0.8822,0.8764,0.8634,0.942,0.9382,0.923,0.9252,0.9434,0.9526,0.9156,0.9294,0.9377,0.9356,0.9245,0.9081,0.8795,0.8886,0.9567,0.9414,0.9371,0.9309,0.9056,0.902,0.8821,0.9065,0.8983,0.9056,0.8809,0.8969,0.8923,0.9156,0.9242,0.8786,0.8941,0.8734,0.9145,0.8907,0.8792,0.8724,0.8729,0.9433,0.9293,0.962,0.9453,0.9257,0.9598,0.9241,0.9266,0.9023,0.9383,0.8973,0.9594,0.9505,0.9302,0.9359,0.9018,0.87,0.9052,0.8822,0.9638,0.9606,0.9635,0.9398,0.9554,0.9234,0.9262,0.938,0.9637,0.9394,0.9384,0.9243,0.9601,0.9465,0.9608,0.9524,0.9178,0.9434,0.9615,0.9289,0.9332,0.953,0.9389,0.9475,0.9459,0.9421,0.9084,0.9203,0.9174,0.8802,0.9109,0.9572,0.9376,0.9207,0.9299,0.9429,0.9248,0.9561,0.9533,0.973,0.9669,0.9351,0.9362,0.8764,0.9434,0.948,0.9492,0.9405,0.9576,0.9397,0.957,0.9379,0.9018,0.9424,0.9455,0.9434,0.9333,0.9401,0.9236,0.9365,0.9356,0.9433,0.9367,0.9554,0.9541,0.9334,0.9236,0.8966,0.9237,0.9118,0.8779,0.8926,0.8953,0.8592,0.8749,0.8799,0.8838,0.8972,0.9655,0.964,0.9538,0.9396,0.9383,0.9327,0.9505,0.9225,0.8915,0.8633,0.9144,0.9731,0.9479,0.9547,0.9605,0.9619,0.9537,0.9555,0.9199,0.9458,0.9422,0.9397,0.9314,0.9314,0.9489,0.9189,0.9491,0.945,0.9516,0.9489,0.9454,0.9369,0.9318,0.9326,0.96,0.9608,0.9284,0.918,0.9187,0.9037,0.9444,0.9209,0.9622,0.9486,0.9197,0.9228,0.9143,0.9175,0.954,0.9047,0.9769,0.9656,0.9548,0.9612,0.9511,0.9505,0.945,0.9344,0.951,0.9511,0.9405,0.9547,0.9365,0.9297,0.9155,0.9237,0.9349,0.9494,0.9442,0.9567,0.9453,0.9363,0.9411,0.8982,0.9107,0.9654,0.9573,0.9345,0.9177,0.9298,0.9312,0.9532,0.9535,0.9371,0.9512,0.9591,0.9474,0.9635,0.9563,0.9628,0.9644,0.9501,0.9463,0.9404,0.935,0.9219,0.907,0.9049,0.9415,0.9246,0.9164,0.9351,0.9537,0.949,0.951,0.9325,0.8961,0.9109,0.9141,0.9087,0.8761,0.9515,0.9163,0.9071,0.9361,0.9352,0.944,0.9388,0.9397,0.917,0.9277,0.9507,0.9509,0.9537,0.9401,0.9471,0.9222,0.9517,0.9328,0.9436,0.9057,0.9087,0.908,0.9482,0.9514,0.9485,0.9532,0.9444,0.9615,0.9228,0.9415,0.9277,0.9427,0.9394,0.9119,0.9256,0.9359,0.9607,0.9521,0.9388,0.9244,0.8989,0.945,0.9641,0.9521,0.9407,0.9459,0.9746,0.9672,0.9463,0.9351,0.9392,0.9157,0.9264,0.9612,0.9661,0.9297,0.9389,0.9578,0.9596,0.9214,0.9226,0.9441,0.9345,0.9547,0.948,0.9371,0.9317,0.9334,0.93,0.8942,0.9005,0.9234,0.9512,0.96,0.9651,0.9793,0.9734,0.954,0.9656,0.9677,0.95,0.9518,0.9404,0.927,0.9587,0.9526,0.9161,0.8854,0.899,0.9395,0.9289,0.8926,0.961,0.9564,0.9416,0.9578,0.9468,0.952,0.9446,0.9594,0.9313,0.9449,0.9022,0.9658,0.9675,0.9478,0.9525,0.9607,0.9541,0.9404,0.9488,0.9397,0.9396,0.9552,0.945,0.906,0.9031,0.905,0.9647,0.9237,0.885,0.9328,0.9476,0.9204,0.9385,0.9479,0.9369,0.9591,0.9635,0.9562,0.9307,0.9587,0.9192,0.9333,0.9366,0.9472,0.9664,0.9398,0.9245,0.9567,0.9641,0.9332,0.9085,0.9413,0.922,0.9531,0.9605,0.9567,0.9575,0.9512,0.9488,0.9468,0.938,0.9369,0.9271,0.9461,0.95,0.9312,0.9217]
sfl_pc1=[0.1989,0.3809,0.4926,0.5303,0.587,0.6134,0.6135,0.6153,0.6351,0.6716,0.6557,0.6476,0.6834,0.7023,0.6693,0.7019,0.678,0.7119,0.6882,0.7126,0.7472,0.7489,0.7739,0.7486,0.7695,0.763,0.7571,0.7391,0.7537,0.7668,0.7808,0.7843,0.7661,0.7719,0.8028,0.8135,0.8146,0.8213,0.8103,0.7996,0.8136,0.8284,0.8076,0.7864,0.8161,0.8024,0.8065,0.8132,0.8144,0.8268,0.8264,0.7995,0.7881,0.8032,0.7985,0.807,0.8272,0.8094,0.8279,0.8279,0.7976,0.8163,0.8289,0.8219,0.83,0.8198,0.8297,0.8286,0.8393,0.8213,0.8262,0.8317,0.8327,0.8283,0.8315,0.8382,0.8299,0.8359,0.8256,0.8337,0.8208,0.8373,0.8162,0.8311,0.8362,0.8282,0.8467,0.8335,0.84,0.8391,0.8295,0.8415,0.8518,0.8495,0.843,0.8482,0.8338,0.8511,0.8429,0.8477,0.8469,0.84,0.8248,0.8456,0.8468,0.8383,0.8487,0.843,0.8384,0.8485,0.8392,0.8473,0.8497,0.8535,0.8546,0.8204,0.8513,0.8381,0.8455,0.8336,0.8435,0.8537,0.8408,0.82,0.8494,0.8549,0.8379,0.8156,0.8458,0.8543,0.8437,0.8452,0.8351,0.8475,0.8323,0.8539,0.8235,0.8497,0.8566,0.8399,0.8476,0.8511,0.841,0.8456,0.8545,0.8419,0.8552,0.855,0.8565,0.8537,0.8554,0.8532,0.847,0.8583,0.8519,0.8397,0.8457,0.8407,0.8514,0.8549,0.8583,0.8595,0.8571,0.8447,0.8544,0.857,0.8515,0.8526,0.838,0.8495,0.8535,0.8446,0.8568,0.8543,0.8555,0.8618,0.8572,0.8608,0.8542,0.8658,0.8583,0.8392,0.8351,0.8558,0.8577,0.855,0.8678,0.8592,0.8574,0.8591,0.8541,0.8478,0.852,0.8551,0.8638,0.8439,0.8572,0.8489,0.8638,0.8559,0.8623,0.8606,0.8408,0.8455,0.8581,0.8629,0.8567,0.8631,0.8669,0.8633,0.852,0.8601,0.8659,0.8637,0.8555,0.861,0.8602,0.8649,0.8638,0.8624,0.8683,0.8625,0.8623,0.8645,0.8591,0.8638,0.8588,0.8544,0.8646,0.867,0.8602,0.8623,0.8668,0.8647,0.8625,0.849,0.8635,0.8662,0.8634,0.8661,0.8653,0.8609,0.8677,0.8664,0.8669,0.8613,0.8618,0.8455,0.868,0.8616,0.8558,0.863,0.8651,0.8636,0.8638,0.8666,0.8581,0.865,0.856,0.8524,0.8553,0.8587,0.8574,0.8678,0.8663,0.8635,0.8656,0.8612,0.8656,0.8628,0.8677,0.8669,0.8678,0.8571,0.8614,0.8682,0.8502,0.8642,0.8556,0.864,0.8675,0.862,0.8685,0.8674,0.8658,0.8672,0.8582,0.8674,0.8617,0.8683,0.865,0.868,0.8691,0.8684,0.8682,0.8682,0.8695,0.8732,0.8674,0.8682,0.8645,0.8666,0.8623,0.8623,0.8663,0.8677,0.8657,0.8552,0.8672,0.8715,0.8681,0.8698,0.8656,0.8685,0.8707,0.8631,0.8685,0.8701,0.8667,0.8652,0.8656,0.8693,0.8704,0.8711,0.8696,0.8664,0.8654,0.8692,0.8689,0.8691,0.8659,0.8708,0.8704,0.8699,0.8668,0.8695,0.8703,0.872,0.8703,0.8674,0.8688,0.8677,0.8702,0.8684,0.8699,0.8712,0.8664,0.8699,0.8646,0.8684,0.8593,0.8644,0.8703,0.8717,0.8748,0.8706,0.8687,0.868,0.8716,0.8712,0.8729,0.8668,0.8605,0.8601,0.8655,0.8712,0.8681,0.8703,0.8675,0.871,0.8699,0.8695,0.8723,0.8712,0.8701,0.871,0.862,0.8687,0.8654,0.8683,0.8655,0.8717,0.8708,0.867,0.8686,0.8704,0.8689,0.8697,0.8699,0.8713,0.8686,0.8699,0.8706,0.869,0.8699,0.8691,0.8694,0.8707,0.8654,0.873,0.8724,0.8695,0.8702,0.8651,0.8677,0.871,0.8712,0.8661,0.8738,0.8702,0.8717,0.8697,0.8701,0.8714,0.8707,0.8687,0.8714,0.8717,0.8722,0.8715,0.869,0.8712,0.8728,0.8728,0.8712,0.8714,0.8689,0.8733,0.8741,0.866,0.8736,0.8715,0.8725,0.8715,0.8716,0.8728,0.8696,0.8668,0.8703,0.8711,0.8716,0.87,0.8681,0.8717,0.8713,0.8713,0.8715,0.8724,0.8712,0.8742,0.873,0.8731,0.8712,0.8742,0.8692,0.8706,0.8717,0.8727,0.8669,0.8718,0.8721,0.8721,0.8696,0.8701,0.8735,0.8699,0.87,0.8726,0.8694,0.8723,0.8717,0.8717,0.8709,0.8691,0.874,0.8695,0.8718,0.8722,0.8748,0.8681,0.8747,0.8735,0.8675,0.8734,0.8695,0.8719,0.8657,0.8733,0.8739,0.8715,0.8746,0.8732,0.8684,0.8728,0.8739,0.8721,0.8737,0.8733,0.8695,0.8733,0.8736,0.872,0.8733,0.8711,0.8738,0.8744,0.8728,0.8725,0.8711,0.8679,0.8735,0.8711,0.8736,0.8726,0.8755,0.8722,0.8735,0.8724,0.8724,0.8728,0.8727,0.8634,0.8724,0.8734,0.8741,0.8707,0.8727,0.8729,0.8726,0.8726,0.8705,0.8729,0.8734,0.872,0.872,0.8721,0.8749,0.8731,0.8729,0.8731,0.8737,0.8712,0.8727,0.8728,0.8727,0.8737,0.8733,0.8736,0.8702,0.8713,0.8692,0.8735,0.8719,0.8723,0.8702,0.8701,0.8632,0.8725,0.8748,0.8665,0.8741,0.8689,0.8735,0.872,0.8737,0.8673,0.8721,0.8708,0.8677,0.8716,0.8733,0.8705,0.8709,0.8739,0.872,0.871,0.8713,0.8721,0.873,0.8738,0.871,0.8749,0.874,0.8716,0.8715,0.8734,0.8728,0.8716,0.8727,0.8751,0.8738,0.8733,0.8728,0.8733,0.872,0.8747,0.8734,0.8718,0.8745,0.8738,0.8749,0.8688,0.8693,0.8703,0.8707,0.8731,0.8753,0.8689,0.8737,0.8736,0.8736,0.8723,0.8742,0.8752,0.8746,0.8757,0.8687,0.8674,0.8663,0.8716,0.8735,0.8739,0.8736,0.8709,0.8719,0.8738,0.8702,0.872,0.8741,0.873,0.8701,0.8714,0.8742,0.8743,0.87,0.8721,0.8728,0.8723,0.8699,0.872,0.8745,0.8719,0.8755,0.8741,0.8714,0.8687,0.8715,0.8753,0.8726,0.8747,0.8749,0.8712,0.8728,0.874,0.8711,0.8733,0.869,0.8747,0.8697,0.8742,0.8726,0.8741,0.875,0.8675,0.8725,0.8736,0.8707,0.8718,0.8733,0.87,0.8718,0.8747,0.8735,0.8743,0.8736,0.8744,0.8704,0.8744,0.8702,0.8742,0.873,0.865,0.871,0.8748,0.8708,0.8734,0.8713,0.8741,0.8739,0.8737,0.8696,0.8739,0.8723,0.8728,0.8711,0.8737,0.8717,0.8754,0.8734,0.8707,0.874,0.8727,0.87,0.8737,0.8732,0.8732,0.8692,0.8734,0.8745,0.8689,0.8749,0.8746,0.874,0.8769,0.8736,0.8748,0.8759,0.875,0.8739,0.8733,0.8733,0.8716,0.8709,0.8734,0.8753,0.8736,0.8734,0.8735,0.8724,0.8753,0.8749,0.874,0.8722,0.8731,0.8745,0.8751,0.8744,0.8719,0.8755,0.8735,0.8728,0.8745,0.872,0.8733,0.8755,0.871,0.8657,0.873,0.8724,0.8734,0.8726,0.872,0.8723,0.8715,0.8736,0.8722,0.8707,0.8729,0.8735,0.8732,0.8749,0.8758,0.8654,0.8752,0.8749,0.8758,0.8753,0.8742,0.8751,0.8745,0.876,0.8747,0.8755,0.8749,0.8729,0.8747,0.8734,0.8736,0.875,0.8752,0.8742,0.8735,0.8776,0.8685,0.8731,0.8759,0.8729,0.8741,0.876,0.8736,0.8744,0.8739,0.8749,0.8692,0.8739,0.875,0.8691,0.8718,0.876,0.8749,0.872,0.8746,0.8741,0.8747,0.8734,0.8715,0.8722,0.8737,0.8748,0.8727,0.8732,0.8744,0.8711,0.8745,0.8719,0.8738,0.8742,0.8747,0.8751,0.8755,0.8698,0.8725,0.8707,0.8732,0.8729,0.8752,0.8733,0.8719,0.8743,0.8731,0.8758,0.8736,0.8728,0.8722,0.8714,0.8718,0.8709,0.8738,0.8704,0.8747,0.8739,0.8697,0.8723,0.8762,0.8751,0.8761,0.8746,0.8739,0.8728,0.8744,0.8712,0.8722,0.874,0.8703,0.8731,0.8755,0.8739,0.872,0.875,0.8762,0.8757,0.8754,0.8679,0.8723,0.875,0.8708,0.8745,0.8735,0.8712,0.875,0.876,0.8738,0.8731,0.8735,0.8733,0.8705,0.873,0.8696,0.871,0.8755,0.8739,0.8738,0.8731,0.8735,0.8745,0.8731,0.8729,0.8724,0.8731,0.8697,0.8736,0.8737,0.8738,0.8737,0.8728,0.8736,0.8732,0.8736,0.8755,0.8721,0.8745,0.8752,0.8761,0.8703,0.8735,0.8723,0.873,0.8748,0.8733,0.8742,0.8743,0.8744,0.8737,0.8725,0.8719,0.8749,0.8752,0.8749,0.8751,0.8744,0.8748,0.8753,0.8744,0.8711,0.875,0.8713,0.8709,0.8739,0.8737,0.873,0.8748,0.8696,0.8707,0.872,0.8719,0.8712,0.874,0.8728,0.8726,0.8745,0.8734,0.8723,0.8752,0.8721,0.8732,0.8728,0.8752,0.8737,0.8763,0.8713,0.8727,0.8751,0.8755,0.8703,0.8744,0.8746,0.8755,0.8719,0.8737,0.872,0.875,0.8744,0.8733,0.8707,0.872,0.876,0.8741,0.8741,0.8742,0.873,0.8739,0.8716,0.876,0.872,0.8758,0.874,0.8736,0.8701,0.8746,0.8712,0.8741,0.874,0.8731,0.8755,0.873,0.8744,0.8718,0.8737,0.8724,0.8741,0.8706,0.8713,0.8736,0.8759,0.8735,0.876,0.873,0.8755,0.8735,0.8726]

draw_icml(e2s_pc1,e2e_pc1,bf_pc1,bfc_pc1,sfl_pc1,'mnist_50_pg2.pdf','lower right')
# Draw small figure on it, may from (50,100) communication rounds, (990,1000) communication rounds



