#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt

SLIDE_WIN=10
ALPHA=.2

def sliding_avg(input_data, slide_win=5):
    input_len = len(input_data)
    output_data = []
    output_data.append(input_data[0])
    for x in range(slide_win, input_len, slide_win):
        avg_value = np.mean(input_data[x:x+slide_win])
        output_data.append(avg_value)
        pass
    output_axis = np.linspace(0, input_len, len(output_data))
    return output_axis, output_data

#pg=2
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt
def draw_icml(Fed_E2S,Fed_E2E,Base_FedAvg,Base_FedCyCP,sfl,file_name,loc):
    mpl.rcParams['lines.linewidth'] = 2
    x = np.arange(0,1000)

    xys = make_interp_spline(x,Fed_E2S)
    x_z = np.linspace(0, 999, 1000)
    FedE2S_s = xys(x_z)
    
    xys = make_interp_spline(x,Fed_E2E)
    x_e = np.linspace(0, 999, 1000)
    Fed_E2E_s = xys(x_e)

    xys = make_interp_spline(x,Base_FedAvg)
    x_f = np.linspace(0,999, 1000)
    Base_FedAvg_s = xys(x_f)

    xys = make_interp_spline(x,Base_FedCyCP)
    x_c = np.linspace(0, 999, 1000)
    Base_FedCyCP_s = xys(x_c)
    
    xys = make_interp_spline(x,sfl)
    x_sf = np.linspace(0,999,1000)
    sfl_s = xys(x_sf)

    fig0 = plt.figure(figsize=plt.figaspect(1))
    ax0 = fig0.add_subplot(1,1,1)
    ax0.grid(linestyle='-')
    fig0.set_figwidth(4)
    fig0.set_figheight(4)
    
    avg_x_z, avg_FedE2S_s = sliding_avg(FedE2S_s, slide_win=SLIDE_WIN)
    avg_x_e, avg_Fed_E2E_s = sliding_avg(Fed_E2E_s, slide_win=SLIDE_WIN)
    avg_x_f, avg_Base_FedAvg_s = sliding_avg(Base_FedAvg_s, slide_win=SLIDE_WIN)
    avg_x_c, avg_Base_FedCyCP_s = sliding_avg(Base_FedCyCP_s, slide_win=SLIDE_WIN)
    avg_x_sfl, avg_sfl_s = sliding_avg(sfl_s, slide_win=SLIDE_WIN)
    

    ax0.plot(avg_x_z, avg_FedE2S_s, color = 'C2', linestyle = 'solid', label = 'HFL-E2S')
    ax0.plot(avg_x_e, avg_Fed_E2E_s, color = 'C3', linestyle = 'solid', label = 'HFL-E2E')
    ax0.plot(avg_x_f, avg_Base_FedAvg_s, color = "C0", linestyle = 'solid', label = 'Base_FedAvg')
    ax0.plot(avg_x_c, avg_Base_FedCyCP_s, color = "C4", linestyle = 'solid', label = 'Base_FedCyCP')
    ax0.plot(avg_x_sfl, avg_sfl_s, color = "C1", linestyle = 'solid', label = 'SFL')

    #line1=ax0.plot(x_m,m_3_test_s,color="C1",linestyle='solid',label='Mean Imputation',markersize = 15, marker=".",markevery=50)
#     ax0.plot(x_z,FedE2S_s,color='C2',linestyle='solid',label='HFL-E2S')
#     ax0.plot(x_e,Fed_E2E_s,color='C3',linestyle='solid',label='HFL-E2E',)
#     ax0.plot(x_f,Base_FedAvg_s,color="C0",linestyle='solid',label='Base_FedAvg')
#     ax0.plot(x_c,Base_FedCyCP_s,color="#b28c6e",linestyle='solid',label='Base_FedCyCP')

    #legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5,bbox_to_anchor=[1, 0.7])
    legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5)

    ax0.set_xlim(0,999)
    ax0.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
    ax0.set_xticklabels(['0','100','200','300','400','500','600','700','800','900','1000'])
    ax0.set_xlabel('Communication Rounds',fontsize='large',fontweight='bold')
    ax0.set_ylabel('Test Accuracy',fontsize='large',fontweight='bold')
    ax0.set_ylim(0.3,1) #(0.4-1) 
    
    fig0.savefig(file_name,dpi=500,bbox_inches = 'tight')
#icml_24_400=[0.1009,0.0974,0.0974,0.1009,0.0892,0.0892,0.1028,0.0982,0.1028,0.0974,0.1705,0.1347,0.0974,0.1009,0.2356,0.1305,0.1829,0.1214,0.2643,0.1606,0.0892,0.1862,0.1061,0.1975,0.2047,0.3028,0.0974,0.114,0.0998,0.1822,0.1889,0.1942,0.2406,0.3139,0.2951,0.2748,0.2974,0.1062,0.1495,0.4265,0.2547,0.3616,0.1581,0.4512,0.4001,0.3687,0.2403,0.3547,0.3507,0.2297,0.4441,0.1247,0.371,0.3869,0.2443,0.2835,0.4172,0.425,0.414,0.436,0.4962,0.4247,0.4155,0.4877,0.4495,0.378,0.1358,0.4562,0.4212,0.4704,0.4763,0.4717,0.2223,0.4477,0.3686,0.2542,0.531,0.6428,0.5013,0.5487,0.2281,0.6381,0.5242,0.6225,0.6032,0.4201,0.4503,0.4624,0.5585,0.5827,0.4438,0.4273,0.3709,0.4714,0.4034,0.5321,0.5029,0.6018,0.5419,0.2401,0.5949,0.5283,0.591,0.4646,0.5854,0.2891,0.602,0.6018,0.5851,0.6394,0.585,0.605,0.5838,0.6337,0.577,0.35,0.5995,0.6086,0.5729,0.5034,0.6024,0.6658,0.6224,0.6567,0.5986,0.6285,0.6174,0.6129,0.5265,0.516,0.5685,0.3348,0.6012,0.5118,0.4654,0.6287,0.28,0.3282,0.5362,0.5236,0.5932,0.5662,0.664,0.6911,0.6119,0.6261,0.5959,0.5995,0.5891,0.5704,0.6537,0.5178,0.7066,0.6245,0.6757,0.6974,0.6188,0.4154,0.437,0.7135,0.6485,0.5898,0.6376,0.6458,0.6601,0.6883,0.5766,0.6516,0.6434,0.6814,0.6551,0.663,0.6365,0.6279,0.6273,0.4387,0.5035,0.5659,0.613,0.6359,0.6298,0.6383,0.647,0.618,0.5664,0.6156,0.5881,0.6548,0.6464,0.5852,0.6453,0.589,0.5626,0.5693,0.6405,0.669,0.6526,0.4737,0.6663,0.6594,0.4915,0.6486,0.6263,0.5172,0.6579,0.6517,0.5347,0.7071,0.5963,0.6616,0.6064,0.6758,0.5266,0.6265,0.6817,0.6102,0.6507,0.6836,0.6628,0.6633,0.6644,0.7248,0.6932,0.6866,0.7278,0.5817,0.7157,0.6997,0.7007,0.6618,0.6668,0.6613,0.5531,0.6572,0.6488,0.7004,0.6955,0.5297,0.6322,0.5479,0.6376,0.7076,0.6926,0.6479,0.7371,0.7308,0.5863,0.5801,0.7338,0.6493,0.6519,0.6442,0.7304,0.5391,0.6526,0.5618,0.6835,0.6789,0.6918,0.7003,0.682,0.6017,0.6539,0.669,0.6455,0.6784,0.7033,0.6824,0.5701,0.6893,0.6739,0.6318,0.6753,0.6828,0.705,0.6275,0.6216,0.6711,0.705,0.6722,0.6309,0.7006,0.6799,0.7359,0.7121,0.7157,0.7382,0.6584,0.6718,0.7415,0.7166,0.6986,0.6521,0.7082,0.6731,0.6593,0.7322,0.7177,0.7168,0.6819,0.6919,0.7196,0.6709,0.6584,0.6447,0.6774,0.7021,0.668,0.5959,0.6803,0.6602,0.6305,0.5647,0.5697,0.6754,0.7205,0.7174,0.6935,0.6918,0.6824,0.7121,0.6594,0.6741,0.7553,0.6989,0.732,0.7135,0.7352,0.6534,0.6717,0.6547,0.684,0.6616,0.7069,0.7172,0.7534,0.7048,0.734,0.6864,0.6849,0.706,0.7532,0.7208,0.746,0.7105,0.7157,0.7141,0.6764,0.6043,0.6886,0.7132,0.7424,0.6985,0.6352,0.6966,0.7327,0.7241,0.6936,0.7132,0.7084,0.6871,0.6687,0.6586,0.6687,0.7053,0.6307,0.693,0.6724,0.6756,0.6904,0.673,0.6211,0.6983,0.6651,0.7065,0.6697,0.7326,0.7282,0.6997,0.6809,0.7293,0.7219,0.6923,0.6817,0.682,0.6911,0.7237,0.7375,0.7528,0.7406,0.6903,0.7058,0.7538,0.7368,0.7183,0.7478,0.7131,0.6699,0.694,0.6675]
e2e_pc1=[0.6162,0.6999,0.7368,0.7885,0.7769,0.8038,0.8092,0.8373,0.8409,0.8531,0.847,0.8639,0.8637,0.8591,0.8652,0.8627,0.8592,0.8662,0.871,0.8694,0.8726,0.8743,0.8755,0.8758,0.8738,0.8735,0.8792,0.8776,0.8777,0.8786,0.8806,0.8815,0.8781,0.8815,0.8824,0.8792,0.8805,0.882,0.8822,0.8808,0.8843,0.8844,0.8826,0.8842,0.8827,0.8815,0.884,0.885,0.8829,0.883,0.8864,0.8826,0.8851,0.8843,0.8865,0.8865,0.8853,0.8844,0.8854,0.8852,0.8861,0.8824,0.8873,0.8856,0.8857,0.8863,0.8873,0.8828,0.8865,0.8864,0.8868,0.8868,0.8873,0.8875,0.887,0.8854,0.8852,0.8864,0.8869,0.8872,0.8853,0.8866,0.8868,0.8866,0.8866,0.8845,0.8855,0.8845,0.8863,0.8861,0.8856,0.8857,0.8881,0.8873,0.8879,0.887,0.8875,0.8886,0.8858,0.8883,0.8883,0.8882,0.8869,0.8854,0.8878,0.8886,0.8869,0.8874,0.8856,0.8881,0.888,0.8869,0.885,0.8878,0.888,0.8852,0.8879,0.889,0.8894,0.8881,0.885,0.8855,0.888,0.8886,0.8876,0.8878,0.8893,0.8881,0.8887,0.8866,0.8872,0.8875,0.8882,0.8875,0.8901,0.8896,0.8878,0.8879,0.8888,0.8888,0.8884,0.8875,0.8875,0.8883,0.8881,0.8892,0.889,0.889,0.889,0.8884,0.8896,0.8857,0.8897,0.8881,0.8898,0.8898,0.889,0.8891,0.8874,0.8882,0.8884,0.8892,0.8888,0.8891,0.8891,0.8901,0.8885,0.888,0.8891,0.8885,0.8877,0.8905,0.8892,0.8888,0.89,0.8899,0.8904,0.8891,0.8889,0.8876,0.8899,0.8887,0.889,0.8881,0.8894,0.8883,0.8903,0.89,0.8899,0.8905,0.8889,0.8894,0.8897,0.8899,0.8892,0.8903,0.8896,0.889,0.8905,0.8903,0.8893,0.8903,0.8893,0.8891,0.8899,0.8904,0.8904,0.8888,0.8879,0.8872,0.8891,0.8897,0.8871,0.8892,0.8902,0.8905,0.8897,0.8905,0.8893,0.8898,0.8897,0.8902,0.8882,0.8904,0.8903,0.8888,0.8887,0.8893,0.887,0.8877,0.8898,0.8881,0.8902,0.8893,0.8899,0.8889,0.8904,0.8898,0.8892,0.8897,0.8878,0.8895,0.8895,0.8894,0.8891,0.8905,0.8898,0.8887,0.889,0.8902,0.8897,0.8892,0.8884,0.8896,0.8891,0.8901,0.8895,0.8906,0.8869,0.8899,0.8905,0.8904,0.8903,0.8907,0.8909,0.8919,0.8892,0.8898,0.8873,0.8898,0.8904,0.8917,0.8901,0.8895,0.8899,0.8906,0.8914,0.8892,0.8909,0.8889,0.8894,0.8899,0.8888,0.8915,0.889,0.8899,0.8896,0.8902,0.8905,0.8898,0.8895,0.8897,0.8899,0.8892,0.8886,0.89,0.8893,0.8898,0.8881,0.8891,0.8899,0.8904,0.891,0.8898,0.8888,0.8903,0.89,0.8886,0.8894,0.891,0.8901,0.8894,0.8901,0.8904,0.8894,0.8895,0.8896,0.8906,0.8894,0.8903,0.8898,0.8903,0.889,0.8904,0.8907,0.8901,0.8909,0.8896,0.891,0.887,0.8901,0.8901,0.8899,0.8902,0.8903,0.89,0.8904,0.8895,0.89,0.8898,0.8893,0.8886,0.8886,0.8889,0.8889,0.8901,0.8901,0.8887,0.889,0.8896,0.8897,0.8901,0.8892,0.8911,0.89,0.889,0.8895,0.8892,0.8889,0.8895,0.8889,0.8902,0.8891,0.8896,0.8894,0.8897,0.8901,0.889,0.8889,0.8899,0.8883,0.8906,0.8892,0.8887,0.8889,0.8897,0.89,0.8904,0.8896,0.8897,0.8903,0.8906,0.8897,0.8894,0.8894,0.8901,0.8893,0.889,0.8901,0.8896,0.8895,0.8901,0.8911,0.8899,0.8893,0.8906,0.8902,0.8884,0.8896,0.8895,0.8888,0.8904,0.89,0.8901,0.8905,0.8901,0.8898,0.8901,0.8905,0.889,0.8899,0.8902,0.8898,0.8898,0.8891,0.8896,0.8898,0.8891,0.8902,0.8898,0.8898,0.8898,0.8896,0.8901,0.8902,0.8896,0.8889,0.8898,0.8896,0.8895,0.8898,0.8898,0.8898,0.8912,0.8902,0.8888,0.8899,0.8906,0.8908,0.8906,0.8902,0.891,0.8906,0.8906,0.8899,0.8902,0.8907,0.8905,0.89,0.8891,0.8896,0.8908,0.8904,0.8913,0.8891,0.8885,0.8903,0.8907,0.8907,0.8902,0.8912,0.8901,0.8896,0.8892,0.8908,0.8903,0.8897,0.8904,0.8898,0.8903,0.8892,0.8875,0.8898,0.89,0.8903,0.8902,0.8903,0.8903,0.8897,0.8908,0.8894,0.8918,0.8898,0.8899,0.8895,0.8899,0.8909,0.8907,0.8901,0.8898,0.8908,0.8911,0.8902,0.8902,0.8899,0.8899,0.8902,0.8905,0.8902,0.89,0.8896,0.8905,0.8901,0.8906,0.891,0.8909,0.8911,0.8906,0.8888,0.8911,0.8891,0.8902,0.8908,0.89,0.8892,0.8899,0.8906,0.8898,0.8898,0.8893,0.8887,0.8901,0.8899,0.8896,0.8909,0.8901,0.891,0.8903,0.8905,0.8903,0.8897,0.8899,0.8889,0.8897,0.8905,0.8897,0.8901,0.8881,0.8895,0.8901,0.8893,0.8891,0.8898,0.8893,0.8901,0.8892,0.8908,0.8895,0.8902,0.8894,0.8902,0.8908,0.89,0.8905,0.8908,0.8893,0.8898,0.8906,0.8902,0.8905,0.8896,0.8903,0.8895,0.8895,0.8904,0.8899,0.8896,0.8903,0.8899,0.8901,0.8879,0.8907,0.8895,0.8897,0.8894,0.8903,0.8903,0.89,0.8897,0.8893,0.8899,0.8882,0.8901,0.8906,0.89,0.8902,0.8891,0.8908,0.891,0.8894,0.8904,0.891,0.8902,0.8899,0.8902,0.891,0.8898,0.8902,0.8907,0.8909,0.8894,0.8902,0.8899,0.8902,0.8897,0.8889,0.8904,0.8902,0.89,0.8899,0.89,0.8913,0.8899,0.8902,0.891,0.8879,0.889,0.8902,0.8904,0.8908,0.8912,0.8898,0.8908,0.8896,0.8895,0.8901,0.8897,0.8901,0.8903,0.8899,0.8903,0.8899,0.8891,0.8904,0.8897,0.8895,0.8897,0.8903,0.889,0.8898,0.8908,0.8896,0.8908,0.8904,0.8893,0.8895,0.8909,0.8905,0.8898,0.8902,0.8905,0.8906,0.8903,0.89,0.8899,0.8894,0.8892,0.8887,0.8909,0.8901,0.8892,0.8891,0.8889,0.8896,0.8886,0.8885,0.8899,0.8905,0.8904,0.8896,0.8898,0.8909,0.8891,0.8913,0.8906,0.891,0.8901,0.8896,0.8902,0.8901,0.889,0.8904,0.8903,0.8914,0.8905,0.8892,0.8908,0.8895,0.8888,0.8913,0.89,0.8911,0.8905,0.8903,0.8902,0.8901,0.8891,0.8902,0.8899,0.8898,0.8903,0.8905,0.8873,0.8891,0.8898,0.8902,0.8894,0.8888,0.8884,0.889,0.8904,0.8893,0.8882,0.8908,0.8905,0.8884,0.8896,0.8901,0.8908,0.891,0.8898,0.8914,0.8901,0.8906,0.8912,0.8915,0.8902,0.8893,0.8907,0.8905,0.8904,0.8898,0.8898,0.8906,0.89,0.8905,0.8902,0.8908,0.8908,0.8913,0.8904,0.8911,0.8904,0.8904,0.8902,0.8894,0.891,0.8901,0.8908,0.8896,0.891,0.8897,0.89,0.8903,0.891,0.8921,0.8902,0.8909,0.8906,0.8898,0.8901,0.8908,0.8903,0.8909,0.8892,0.8906,0.8878,0.8902,0.89,0.8896,0.8901,0.8901,0.8906,0.8902,0.8904,0.8898,0.8898,0.8903,0.8912,0.8899,0.8892,0.8894,0.8905,0.8908,0.8898,0.89,0.8884,0.8905,0.8904,0.8893,0.8897,0.8899,0.8903,0.8906,0.8899,0.8902,0.8901,0.8902,0.8905,0.8909,0.8905,0.8886,0.8905,0.8906,0.889,0.8903,0.8897,0.8903,0.8901,0.8897,0.8903,0.8885,0.8901,0.8903,0.8898,0.8893,0.8911,0.89,0.8897,0.8908,0.891,0.8904,0.8913,0.8896,0.8896,0.8905,0.8905,0.8915,0.8909,0.89,0.8902,0.8887,0.8912,0.8892,0.8903,0.8883,0.8904,0.8904,0.8913,0.8907,0.8911,0.8908,0.8904,0.8899,0.8901,0.8902,0.8897,0.8909,0.8902,0.8908,0.8903,0.8906,0.8905,0.8892,0.8902,0.89,0.8905,0.891,0.8914,0.8908,0.8906,0.8904,0.8909,0.8907,0.8895,0.8902,0.891,0.8907,0.8907,0.8909,0.89,0.8911,0.8902,0.8898,0.8891,0.8899,0.8899,0.8907,0.8887,0.891,0.8898,0.8903,0.891,0.8907,0.8896,0.8888,0.889,0.8911,0.8901,0.8908,0.8903,0.8908,0.8907,0.8908,0.8912,0.8903,0.8884,0.8895,0.8898,0.8903,0.8895,0.8896,0.8907,0.8891,0.8905,0.8891,0.8909,0.8908,0.8893,0.8899,0.8902,0.8895,0.8898,0.8911,0.8895,0.8881,0.8907,0.8914,0.891,0.8899,0.8905,0.8892,0.8891,0.8898,0.8917,0.8893,0.8902,0.8893,0.8892,0.8904,0.8893,0.8897,0.8917,0.8912,0.8904,0.8911,0.8898,0.89,0.8904,0.8895,0.8908,0.891,0.89,0.8904,0.8902,0.8905,0.89,0.8897,0.89,0.89,0.8911,0.891,0.8908,0.8907,0.8914,0.8884,0.8911,0.8903,0.8903,0.8905,0.8906,0.8888,0.8901,0.8908,0.8901,0.8901,0.89,0.8898,0.8895,0.8908,0.8898,0.891,0.8905,0.8891,0.8903,0.89,0.8908,0.8907,0.8903,0.89,0.8905,0.8906,0.8902,0.8881,0.8901,0.8911,0.8901,0.8904,0.8904,0.8908,0.8899,0.8893,0.8898,0.8904,0.8901,0.8902,0.8885,0.8898,0.8901,0.8899]
e2s_pc1=[0.2158,0.3918,0.4625,0.5771,0.5827,0.6177,0.6889,0.6967,0.628,0.6699,0.6717,0.7361,0.7659,0.7373,0.7485,0.7363,0.7533,0.6499,0.7416,0.6627,0.6011,0.7254,0.7861,0.7696,0.8001,0.7234,0.7688,0.8378,0.7767,0.7745,0.8102,0.7835,0.7822,0.7864,0.8528,0.8089,0.7291,0.7876,0.8491,0.791,0.7871,0.7923,0.7807,0.779,0.7031,0.7842,0.8405,0.8702,0.8755,0.7413,0.8125,0.87,0.8141,0.8631,0.8777,0.8397,0.8066,0.8657,0.8326,0.8515,0.8355,0.7977,0.8005,0.7859,0.7909,0.7964,0.8473,0.8088,0.8661,0.8764,0.8178,0.8598,0.7341,0.7324,0.8365,0.8155,0.8778,0.8557,0.7927,0.7487,0.7964,0.7341,0.8472,0.8527,0.8793,0.8389,0.7656,0.8642,0.8683,0.8373,0.8277,0.8644,0.7421,0.8381,0.8175,0.8676,0.8045,0.8559,0.8254,0.8166,0.7526,0.7823,0.8793,0.8433,0.8288,0.8418,0.8307,0.8301,0.8329,0.8242,0.8771,0.8668,0.8544,0.8816,0.8805,0.8636,0.8817,0.8309,0.8147,0.8633,0.8524,0.8651,0.7875,0.8819,0.832,0.8399,0.8376,0.8783,0.863,0.8224,0.8302,0.7874,0.8145,0.7964,0.8767,0.8572,0.8672,0.8764,0.8418,0.7939,0.8591,0.8649,0.8789,0.7758,0.8668,0.8497,0.8279,0.8134,0.8264,0.8314,0.8165,0.8791,0.8749,0.8867,0.877,0.8677,0.7945,0.8838,0.8684,0.8435,0.836,0.8829,0.8709,0.8838,0.8764,0.8874,0.873,0.8643,0.8623,0.8746,0.8673,0.873,0.854,0.885,0.8409,0.8548,0.8582,0.8848,0.8664,0.874,0.8562,0.861,0.8556,0.8366,0.8437,0.837,0.7889,0.767,0.7668,0.7676,0.8132,0.87,0.8471,0.8354,0.7934,0.8084,0.8784,0.8704,0.8719,0.8397,0.8463,0.8785,0.8836,0.8648,0.8844,0.8778,0.833,0.8735,0.8753,0.8631,0.8847,0.8816,0.8726,0.8802,0.8713,0.8571,0.8388,0.8805,0.8835,0.8832,0.8873,0.8877,0.8793,0.8711,0.8845,0.8774,0.8774,0.8166,0.8566,0.8864,0.8781,0.8735,0.8809,0.8776,0.8625,0.8643,0.8538,0.8125,0.8847,0.8852,0.8853,0.8686,0.8852,0.8609,0.8841,0.8809,0.8342,0.873,0.8838,0.8796,0.8733,0.8746,0.841,0.8846,0.8367,0.8628,0.8825,0.8364,0.8742,0.8416,0.8656,0.84,0.8194,0.8072,0.8215,0.8798,0.8828,0.8769,0.8708,0.872,0.8353,0.8227,0.8527,0.8765,0.8773,0.844,0.8412,0.8866,0.8495,0.8841,0.8797,0.8889,0.8819,0.8838,0.8875,0.8803,0.8699,0.8858,0.8676,0.8585,0.8678,0.847,0.8669,0.8575,0.8397,0.8509,0.8482,0.8866,0.8783,0.854,0.8854,0.873,0.8587,0.8593,0.8595,0.8414,0.8591,0.8392,0.8343,0.8484,0.8463,0.8405,0.875,0.841,0.8679,0.8328,0.8552,0.8163,0.8543,0.8372,0.8845,0.8571,0.8778,0.8776,0.88,0.8831,0.8828,0.8733,0.8814,0.8734,0.8886,0.8865,0.8721,0.885,0.8823,0.8691,0.8862,0.8799,0.8886,0.8813,0.8861,0.8808,0.8816,0.8736,0.8727,0.8844,0.8887,0.8874,0.8789,0.8807,0.8776,0.8553,0.8889,0.8717,0.8889,0.8786,0.886,0.8757,0.8771,0.8678,0.8852,0.881,0.8466,0.8712,0.8458,0.8595,0.8889,0.8883,0.8876,0.8852,0.8768,0.8619,0.8891,0.8729,0.8868,0.8823,0.8783,0.886,0.8576,0.8841,0.8794,0.858,0.8871,0.88,0.8598,0.8569,0.8676,0.8889,0.8838,0.8753,0.8522,0.8794,0.8631,0.886,0.8794,0.8775,0.8886,0.8717,0.872,0.8887,0.8657,0.8577,0.8688,0.8718,0.866,0.8332,0.8307,0.8427,0.8547,0.8829,0.8734,0.874,0.8617,0.8879,0.8841,0.8736,0.8743,0.8823,0.8771,0.8899,0.8783,0.8791,0.888,0.8852,0.8896,0.8902,0.8854,0.87,0.8661,0.8726,0.888,0.8799,0.874,0.8531,0.855,0.8678,0.8336,0.8233,0.8413,0.8863,0.8824,0.8699,0.8857,0.8813,0.8776,0.878,0.8827,0.8816,0.8844,0.8757,0.8896,0.8831,0.863,0.8759,0.8486,0.8882,0.8867,0.8795,0.887,0.882,0.8818,0.8573,0.8391,0.8671,0.8884,0.8875,0.8818,0.8759,0.8717,0.8728,0.8849,0.885,0.8665,0.8798,0.8721,0.8679,0.8456,0.8583,0.8831,0.8555,0.8899,0.886,0.8784,0.8821,0.8782,0.8747,0.8561,0.8661,0.8864,0.8844,0.8912,0.8857,0.8872,0.8857,0.8734,0.8726,0.866,0.8738,0.8739,0.8727,0.8413,0.8524,0.8875,0.8875,0.8844,0.8909,0.8899,0.8873,0.8886,0.8871,0.8814,0.8866,0.8778,0.8784,0.8717,0.8674,0.8624,0.8735,0.8735,0.8568,0.8633,0.8872,0.89,0.8904,0.8891,0.878,0.8721,0.8878,0.8834,0.8782,0.8754,0.854,0.8861,0.8758,0.8892,0.8881,0.891,0.8871,0.8851,0.8688,0.8857,0.8858,0.8802,0.8823,0.8905,0.8791,0.8899,0.8862,0.8865,0.8873,0.8905,0.8703,0.8867,0.8745,0.8912,0.8827,0.8642,0.8733,0.8671,0.8884,0.8864,0.879,0.881,0.8679,0.889,0.8702,0.8763,0.8856,0.8749,0.8797,0.8734,0.8775,0.8878,0.8892,0.8686,0.8897,0.8795,0.8695,0.8708,0.8858,0.8908,0.881,0.8701,0.8905,0.8885,0.8907,0.8814,0.8788,0.8887,0.8842,0.8901,0.8867,0.865,0.8771,0.8683,0.8679,0.8506,0.8867,0.8757,0.8673,0.8582,0.8788,0.872,0.8721,0.8903,0.8897,0.8739,0.8816,0.8901,0.8904,0.8888,0.8848,0.8795,0.8811,0.8789,0.8519,0.8891,0.8864,0.8899,0.8816,0.8657,0.8792,0.8809,0.8903,0.8838,0.881,0.864,0.8886,0.8812,0.8796,0.8725,0.8904,0.8866,0.8778,0.8782,0.873,0.8883,0.8774,0.882,0.8907,0.8843,0.872,0.8783,0.8564,0.8734,0.8559,0.8617,0.8634,0.8669,0.8887,0.8819,0.8792,0.8739,0.871,0.8679,0.8509,0.8593,0.8564,0.8633,0.8866,0.8845,0.8746,0.887,0.8909,0.8895,0.8766,0.8816,0.8805,0.8861,0.8768,0.8912,0.8874,0.8889,0.8866,0.8823,0.8904,0.8752,0.8831,0.867,0.8906,0.8866,0.8882,0.8734,0.8657,0.8666,0.881,0.8797,0.8844,0.8811,0.8888,0.8811,0.8752,0.8903,0.8862,0.8862,0.8902,0.878,0.8791,0.8908,0.8908,0.8891,0.8866,0.8847,0.8846,0.8893,0.888,0.8913,0.8819,0.8917,0.8754,0.8711,0.881,0.8682,0.8903,0.8895,0.8876,0.8746,0.8912,0.887,0.8746,0.8815,0.8907,0.8838,0.8897,0.8896,0.885,0.8892,0.8908,0.8889,0.8912,0.8853,0.8918,0.8775,0.8848,0.8826,0.8826,0.8909,0.8903,0.8859,0.8835,0.8883,0.8848,0.8884,0.8761,0.8911,0.8896,0.8853,0.879,0.8798,0.8891,0.8897,0.8775,0.889,0.8909,0.8836,0.8722,0.8803,0.8901,0.8907,0.887,0.8813,0.8821,0.8782,0.869,0.8849,0.8895,0.8906,0.8915,0.887,0.8909,0.886,0.8826,0.8809,0.88,0.8776,0.8774,0.8734,0.8568,0.8859,0.8881,0.8917,0.8861,0.8898,0.8894,0.8884,0.8896,0.8839,0.8826,0.8773,0.8904,0.8848,0.8858,0.8728,0.8705,0.8652,0.8752,0.8603,0.8846,0.8869,0.8833,0.885,0.8867,0.8833,0.89,0.8887,0.8896,0.8836,0.8865,0.8843,0.8893,0.8848,0.8914,0.8887,0.8865,0.8897,0.8893,0.8743,0.8708,0.8814,0.879,0.8792,0.8845,0.8841,0.8817,0.8792,0.8768,0.867,0.8906,0.8806,0.8716,0.8886,0.8728,0.8821,0.8801,0.8786,0.8876,0.8865,0.8907,0.8916,0.8855,0.8893,0.8818,0.8854,0.8835,0.8842,0.8806,0.8903,0.8885,0.8834,0.8714,0.8882,0.8884,0.8851,0.8843,0.8794,0.8894,0.8898,0.8778,0.8787,0.8809,0.8671,0.8906,0.8832,0.8885,0.8855,0.8839,0.8834,0.8905,0.879,0.8914,0.8894,0.8876,0.8859,0.8859,0.8856,0.8909,0.8862,0.8852,0.8904,0.8796,0.882,0.8826,0.8819,0.876,0.8806,0.8901,0.8818,0.8739,0.8875,0.8841,0.8818,0.8813,0.8818,0.891,0.8905,0.8883,0.8901,0.8881,0.8856,0.8815,0.8842,0.887,0.8783,0.8752,0.891,0.8911,0.8851,0.8833,0.8817,0.879,0.8884,0.8882,0.8908,0.8862,0.8875,0.8897,0.8862,0.8767,0.8818,0.8785,0.8691,0.8852,0.8854,0.8746,0.8825,0.8905,0.8882,0.8803,0.883,0.8805,0.8798,0.8807,0.8898,0.8815,0.8858,0.8811,0.8826,0.8807,0.8787,0.876,0.8765,0.8872,0.8881,0.8897,0.8799,0.89,0.8912,0.8864,0.8893,0.8884,0.8793,0.8904,0.8882,0.8861,0.8918,0.8902,0.8914,0.8857,0.8911,0.8836,0.8785,0.8864,0.8879,0.8761,0.8799,0.8782,0.8748,0.8803,0.8803,0.8681,0.8775,0.8866,0.8875,0.8817,0.879,0.8769,0.8679,0.8909,0.8904,0.8889,0.8841,0.8884,0.8871,0.8891,0.8902,0.8897,0.8816,0.8903,0.8875,0.8913,0.8865,0.8877,0.8869,0.8883,0.892,0.8886,0.8835,0.8821,0.8847,0.8826]
bfc_pc1=[0.5492,0.6518,0.7425,0.7655,0.8098,0.8134,0.8263,0.8331,0.8324,0.8393,0.842,0.8317,0.8535,0.8509,0.845,0.8598,0.8637,0.8545,0.8643,0.8643,0.8652,0.862,0.8687,0.8647,0.8674,0.8672,0.8628,0.8673,0.865,0.8734,0.8696,0.8701,0.8707,0.872,0.8644,0.8688,0.8654,0.8666,0.8726,0.8742,0.8705,0.8773,0.874,0.8677,0.8764,0.8738,0.8749,0.8736,0.8752,0.8771,0.8807,0.8739,0.8768,0.8809,0.8795,0.8797,0.8804,0.8777,0.8801,0.8782,0.8788,0.8801,0.8813,0.881,0.8794,0.8791,0.8812,0.8792,0.8745,0.8722,0.8838,0.8767,0.8805,0.8802,0.8796,0.8827,0.8802,0.8827,0.8779,0.8787,0.883,0.8802,0.8788,0.8836,0.8857,0.883,0.8804,0.8848,0.8849,0.8817,0.879,0.8816,0.8827,0.8819,0.8772,0.8819,0.8793,0.8847,0.8821,0.8849,0.8786,0.884,0.8842,0.8809,0.8855,0.879,0.8819,0.8816,0.8831,0.8826,0.8852,0.8843,0.8807,0.8819,0.8843,0.8857,0.8846,0.882,0.8844,0.8812,0.8831,0.8873,0.8847,0.8866,0.8836,0.885,0.8848,0.8842,0.8868,0.883,0.8859,0.8872,0.8838,0.8835,0.8817,0.8868,0.8858,0.8844,0.884,0.8856,0.885,0.8844,0.8835,0.8866,0.8844,0.8778,0.8841,0.8841,0.8862,0.8854,0.8848,0.8876,0.8843,0.8873,0.8822,0.8836,0.8866,0.8864,0.8852,0.8846,0.8857,0.8854,0.8851,0.8865,0.8868,0.8857,0.8837,0.8824,0.8846,0.8871,0.8817,0.8863,0.8863,0.8856,0.8851,0.8868,0.8878,0.8856,0.8852,0.8856,0.8834,0.8855,0.8866,0.8858,0.884,0.8871,0.8857,0.8863,0.8842,0.887,0.8866,0.8878,0.8874,0.8854,0.8855,0.8849,0.883,0.8837,0.8858,0.8869,0.8851,0.8834,0.8863,0.885,0.8827,0.8873,0.8842,0.8842,0.8855,0.8827,0.8859,0.8854,0.8871,0.886,0.8856,0.8865,0.8866,0.8847,0.8862,0.887,0.885,0.8877,0.8871,0.8861,0.8869,0.8871,0.8868,0.8866,0.8878,0.8874,0.8849,0.8861,0.8871,0.8888,0.8886,0.8872,0.8865,0.8859,0.8879,0.8874,0.888,0.8871,0.8886,0.8882,0.8878,0.8867,0.8868,0.8849,0.8874,0.885,0.888,0.8873,0.8874,0.8851,0.8854,0.8873,0.8866,0.8862,0.8881,0.8879,0.8872,0.8858,0.8886,0.8877,0.8851,0.8874,0.8876,0.8883,0.8877,0.8872,0.8878,0.889,0.887,0.8864,0.8873,0.8892,0.8883,0.8888,0.8882,0.8874,0.8882,0.8879,0.8867,0.8848,0.8874,0.8866,0.8875,0.8893,0.8864,0.8849,0.8886,0.8881,0.8862,0.8872,0.8873,0.8884,0.8873,0.8867,0.8887,0.8872,0.8873,0.8872,0.8893,0.8876,0.8886,0.888,0.8881,0.8874,0.8857,0.8872,0.8893,0.8871,0.8872,0.8887,0.8884,0.8868,0.8882,0.8884,0.887,0.8879,0.8873,0.8874,0.8879,0.888,0.8882,0.8844,0.8878,0.8867,0.8876,0.8881,0.8879,0.8869,0.8887,0.8882,0.8885,0.8872,0.888,0.8892,0.8884,0.8884,0.8877,0.8884,0.8892,0.8871,0.887,0.8874,0.8886,0.8882,0.8876,0.8867,0.8869,0.8875,0.8875,0.8892,0.8879,0.8888,0.8871,0.8885,0.8881,0.8884,0.8879,0.8876,0.8876,0.8882,0.8875,0.8875,0.8875,0.8867,0.8847,0.8888,0.8891,0.8869,0.8861,0.8891,0.8865,0.8875,0.8876,0.8883,0.8897,0.8868,0.8882,0.8876,0.8881,0.888,0.889,0.8889,0.8896,0.8871,0.8882,0.8893,0.8883,0.8886,0.8882,0.8892,0.8886,0.8872,0.8895,0.8873,0.8899,0.8873,0.8881,0.888,0.8879,0.8884,0.8888,0.8887,0.8873,0.8876,0.8843,0.886,0.8865,0.8895,0.8883,0.8884,0.888,0.8882,0.8877,0.8888,0.8886,0.8881,0.8878,0.8872,0.8883,0.887,0.8893,0.889,0.8889,0.8887,0.8876,0.8878,0.8881,0.8864,0.8886,0.8881,0.8863,0.8891,0.8875,0.8891,0.8888,0.8893,0.8887,0.8876,0.8875,0.8894,0.8899,0.8888,0.8874,0.8888,0.8876,0.8873,0.8889,0.8881,0.8897,0.8885,0.8885,0.8884,0.8877,0.8886,0.8873,0.8881,0.8868,0.8879,0.8888,0.8878,0.8881,0.8874,0.887,0.8865,0.8878,0.8877,0.8865,0.8886,0.8863,0.8882,0.8873,0.8879,0.8877,0.8872,0.889,0.8883,0.8886,0.8885,0.887,0.888,0.8878,0.8883,0.8871,0.8878,0.8876,0.8894,0.886,0.8878,0.8868,0.8876,0.8885,0.8889,0.8877,0.8881,0.8866,0.8872,0.8889,0.8884,0.89,0.8874,0.8876,0.8894,0.8887,0.8883,0.8893,0.8891,0.8892,0.89,0.8889,0.8893,0.8891,0.8875,0.8887,0.89,0.8879,0.8886,0.889,0.8885,0.8885,0.8882,0.8879,0.8884,0.8882,0.8901,0.8882,0.8887,0.8859,0.8889,0.8894,0.8898,0.8883,0.8882,0.8869,0.8874,0.8874,0.8879,0.888,0.8894,0.8884,0.8888,0.8877,0.89,0.8878,0.8891,0.8887,0.8901,0.8883,0.886,0.8894,0.8879,0.8884,0.8891,0.8883,0.889,0.8873,0.8902,0.8895,0.889,0.8891,0.8875,0.8896,0.8879,0.8871,0.8891,0.8882,0.8891,0.8875,0.887,0.8866,0.8886,0.8882,0.8883,0.8882,0.8887,0.8896,0.8887,0.8878,0.8867,0.887,0.8896,0.8883,0.8889,0.8881,0.8882,0.8894,0.8857,0.888,0.8869,0.8896,0.8877,0.8884,0.8893,0.8885,0.8885,0.8898,0.8894,0.8896,0.8895,0.8892,0.8874,0.8894,0.887,0.8885,0.888,0.8891,0.8881,0.8875,0.8883,0.8882,0.8877,0.8898,0.8875,0.8891,0.8902,0.8882,0.8875,0.8882,0.8887,0.8878,0.8876,0.8882,0.888,0.89,0.8872,0.8879,0.8891,0.888,0.8886,0.89,0.89,0.8888,0.8893,0.889,0.8891,0.889,0.8888,0.8894,0.889,0.8882,0.8872,0.8899,0.8883,0.8897,0.888,0.8888,0.8883,0.8885,0.8892,0.8864,0.8883,0.8889,0.889,0.89,0.8887,0.8893,0.8889,0.8891,0.8884,0.8884,0.8893,0.8892,0.8895,0.8901,0.8875,0.8892,0.8882,0.8892,0.8891,0.8894,0.8882,0.8889,0.8872,0.8897,0.8893,0.8882,0.8886,0.89,0.8888,0.889,0.8881,0.8902,0.8899,0.8874,0.8893,0.8897,0.8875,0.8895,0.8907,0.889,0.8902,0.889,0.8897,0.8895,0.8888,0.8889,0.8888,0.8887,0.8884,0.8891,0.8885,0.8901,0.8902,0.8902,0.8888,0.8899,0.8897,0.8895,0.8889,0.8892,0.8891,0.8884,0.8889,0.8896,0.889,0.8899,0.8899,0.8889,0.89,0.8896,0.8889,0.889,0.8883,0.8881,0.8875,0.8896,0.8867,0.888,0.8866,0.8883,0.8894,0.8897,0.8896,0.8899,0.8896,0.8893,0.8883,0.8871,0.8874,0.8882,0.8888,0.8887,0.8885,0.8899,0.8882,0.8898,0.8896,0.8897,0.8898,0.8897,0.8899,0.8901,0.8885,0.888,0.8868,0.8894,0.8873,0.8893,0.8879,0.8884,0.8891,0.8886,0.8888,0.8884,0.8887,0.8884,0.8895,0.8895,0.8898,0.8887,0.8894,0.8891,0.889,0.8891,0.8886,0.8887,0.8897,0.8879,0.8883,0.8892,0.889,0.8874,0.8886,0.8894,0.8888,0.889,0.8899,0.8898,0.8889,0.8894,0.8891,0.8896,0.889,0.8881,0.8889,0.8881,0.8885,0.8892,0.889,0.8881,0.8898,0.8887,0.889,0.8894,0.8889,0.8894,0.8892,0.8892,0.8898,0.8885,0.8886,0.8898,0.8857,0.888,0.8896,0.8897,0.8896,0.8898,0.8892,0.8875,0.8892,0.8883,0.8897,0.89,0.8885,0.8886,0.8885,0.8889,0.8889,0.8888,0.888,0.8883,0.8887,0.8875,0.8889,0.8902,0.89,0.8893,0.8887,0.8888,0.8897,0.8901,0.8884,0.8889,0.8895,0.8891,0.8897,0.8882,0.8899,0.8873,0.8866,0.8889,0.8878,0.8898,0.8889,0.8892,0.8883,0.8876,0.8882,0.8883,0.8878,0.8887,0.8879,0.8866,0.8864,0.8885,0.8873,0.8893,0.8891,0.8869,0.888,0.8885,0.8888,0.8871,0.8892,0.8881,0.8889,0.8899,0.8881,0.8886,0.8884,0.8881,0.8909,0.8891,0.8889,0.8886,0.8892,0.8886,0.8887,0.8883,0.8889,0.8899,0.8859,0.8887,0.889,0.8884,0.8883,0.8885,0.8885,0.8892,0.8888,0.888,0.8891,0.8891,0.8891,0.8889,0.8895,0.8875,0.8886,0.8886,0.8886,0.8879,0.8892,0.8895,0.8894,0.8886,0.8884,0.8888,0.8901,0.889,0.8901,0.8889,0.8882,0.8891,0.8889,0.8892,0.8882,0.8893,0.8879,0.8892,0.8898,0.8891,0.8876,0.8892,0.8885,0.8883,0.8902,0.8879,0.8894,0.8873,0.8885,0.8888,0.8888,0.8884,0.8894,0.8891,0.8877,0.8871,0.8888,0.8882,0.8881,0.8884,0.8885,0.8896,0.8891,0.8889,0.8889,0.887,0.8875,0.8883,0.8882,0.8888,0.8883,0.8875,0.887,0.8891,0.8896,0.8879,0.8886,0.8901,0.8894,0.8888,0.8888,0.8891,0.8876,0.8883,0.8883,0.8893,0.8902,0.8865,0.8893,0.8884,0.8897,0.8891,0.8897,0.8847,0.8879,0.8885,0.8895,0.8889,0.8885,0.8872,0.8885,0.8882,0.8893,0.8881,0.8893]
bf_pc1=[0.2034,0.4502,0.4286,0.6162,0.7048,0.5309,0.5834,0.5856,0.6319,0.659,0.7318,0.6882,0.7437,0.7796,0.7581,0.6817,0.7518,0.7818,0.7346,0.7404,0.8148,0.7993,0.7511,0.7125,0.7994,0.7961,0.8409,0.8286,0.8112,0.744,0.8222,0.8057,0.8219,0.7656,0.797,0.7599,0.7793,0.7603,0.7946,0.8051,0.8182,0.7607,0.7464,0.8052,0.763,0.7412,0.7287,0.7681,0.7801,0.7779,0.7623,0.8194,0.8156,0.8061,0.8506,0.7962,0.7667,0.8251,0.7912,0.8371,0.8291,0.8489,0.8513,0.8487,0.8057,0.8264,0.7882,0.7675,0.7872,0.8235,0.8197,0.8219,0.7926,0.8507,0.8634,0.8434,0.8512,0.8466,0.8607,0.8556,0.8406,0.8558,0.8514,0.804,0.799,0.8163,0.8344,0.8302,0.8503,0.8104,0.8506,0.8184,0.8545,0.8489,0.8647,0.8228,0.804,0.8016,0.8131,0.8244,0.8223,0.8251,0.8182,0.8244,0.7989,0.784,0.8418,0.8236,0.827,0.7912,0.8185,0.8545,0.8171,0.8144,0.8464,0.8266,0.825,0.8178,0.8649,0.8683,0.8444,0.8387,0.8248,0.8124,0.8031,0.8385,0.8333,0.8366,0.8364,0.8541,0.85,0.8209,0.8065,0.8487,0.8349,0.8316,0.8031,0.8315,0.7935,0.7947,0.8332,0.8224,0.8092,0.855,0.8522,0.853,0.8374,0.863,0.8741,0.8669,0.857,0.8576,0.8525,0.8516,0.8769,0.8733,0.869,0.8417,0.8656,0.8566,0.8694,0.8566,0.8302,0.8586,0.8548,0.8535,0.85,0.8355,0.8439,0.8492,0.8469,0.8202,0.8056,0.8402,0.8362,0.8059,0.837,0.8044,0.8649,0.833,0.8474,0.8806,0.8722,0.8498,0.8443,0.854,0.8553,0.8308,0.8472,0.8296,0.8504,0.8477,0.8391,0.8468,0.8387,0.8286,0.8325,0.8179,0.8084,0.836,0.8107,0.868,0.8693,0.8586,0.8665,0.8455,0.8484,0.8706,0.843,0.8641,0.8613,0.8595,0.8572,0.841,0.8551,0.8282,0.8403,0.846,0.8476,0.8458,0.8268,0.8609,0.8701,0.8752,0.8684,0.8673,0.8662,0.8433,0.8499,0.8721,0.8734,0.8588,0.8638,0.8645,0.8607,0.8443,0.83,0.853,0.8478,0.8529,0.8458,0.8497,0.8486,0.8436,0.8424,0.8439,0.8173,0.8385,0.8191,0.8601,0.8728,0.8787,0.8771,0.8575,0.8414,0.8465,0.8604,0.836,0.8258,0.8501,0.849,0.8382,0.8464,0.8497,0.8445,0.8308,0.8225,0.808,0.8402,0.8766,0.8735,0.881,0.8749,0.8602,0.8663,0.8637,0.8632,0.8607,0.8529,0.8814,0.8756,0.8782,0.8743,0.8706,0.8657,0.8491,0.8649,0.8479,0.836,0.8308,0.8568,0.8546,0.8484,0.851,0.8808,0.8552,0.8493,0.8342,0.8595,0.8498,0.8519,0.8812,0.8637,0.8612,0.8692,0.8637,0.8545,0.8552,0.8593,0.845,0.8578,0.8793,0.8675,0.8669,0.8626,0.8589,0.8569,0.8514,0.857,0.837,0.836,0.8416,0.8539,0.8524,0.8517,0.8743,0.8598,0.8507,0.8675,0.8741,0.8818,0.8777,0.8585,0.8731,0.8809,0.8737,0.8718,0.8617,0.8705,0.8819,0.8766,0.8726,0.8847,0.8819,0.8775,0.8579,0.8638,0.8645,0.8547,0.8578,0.8552,0.8423,0.8727,0.8567,0.8505,0.8655,0.8659,0.8501,0.8655,0.8508,0.8806,0.8759,0.8543,0.8448,0.8661,0.8646,0.8728,0.8709,0.8637,0.8665,0.8582,0.8786,0.8803,0.8832,0.8648,0.8702,0.8737,0.8581,0.8636,0.8681,0.8494,0.8775,0.8731,0.873,0.8602,0.8575,0.8504,0.8392,0.8839,0.8843,0.8763,0.8846,0.8818,0.8775,0.8753,0.8723,0.8668,0.8634,0.8757,0.87,0.8551,0.8747,0.8744,0.8707,0.8612,0.8816,0.882,0.8768,0.8726,0.8837,0.8692,0.88,0.8589,0.8535,0.8459,0.871,0.8671,0.8727,0.8694,0.8567,0.8769,0.8866,0.8682,0.8611,0.8637,0.8509,0.8747,0.8855,0.883,0.8863,0.8754,0.861,0.8553,0.8514,0.873,0.8727,0.8711,0.8838,0.8796,0.865,0.8716,0.8706,0.8701,0.8621,0.8686,0.8652,0.8826,0.8753,0.8852,0.8829,0.8846,0.8804,0.8778,0.877,0.8754,0.8754,0.8664,0.8624,0.8836,0.8832,0.8785,0.8738,0.8779,0.8798,0.8817,0.8758,0.8713,0.8815,0.8871,0.8806,0.884,0.8801,0.8835,0.8845,0.8804,0.8866,0.8837,0.8817,0.8759,0.8856,0.8838,0.8869,0.879,0.8828,0.8799,0.8789,0.885,0.8693,0.869,0.8768,0.871,0.8661,0.8659,0.8729,0.855,0.8706,0.8639,0.8618,0.8675,0.8677,0.8657,0.8851,0.8706,0.8852,0.8791,0.8636,0.8561,0.8741,0.8869,0.8823,0.8853,0.8857,0.8866,0.8851,0.8811,0.8821,0.8631,0.8574,0.8624,0.8794,0.8737,0.8843,0.8669,0.8828,0.8786,0.8748,0.8763,0.8741,0.87,0.8617,0.8627,0.8584,0.8421,0.8451,0.8401,0.8713,0.8606,0.8595,0.8647,0.8597,0.8548,0.8479,0.8486,0.8726,0.8681,0.8554,0.8487,0.8736,0.8519,0.8623,0.8623,0.8632,0.854,0.8535,0.8756,0.871,0.8795,0.8753,0.8662,0.8672,0.8605,0.8608,0.8734,0.8751,0.8831,0.8836,0.8833,0.8793,0.8645,0.8672,0.8566,0.85,0.8587,0.8475,0.8731,0.8731,0.8745,0.8726,0.8856,0.8715,0.872,0.8816,0.8595,0.8667,0.8566,0.8507,0.8531,0.8762,0.8866,0.8745,0.8751,0.8804,0.8707,0.8819,0.8836,0.8866,0.8841,0.8808,0.8776,0.8662,0.8589,0.8776,0.8734,0.8656,0.8787,0.8785,0.8765,0.8681,0.881,0.8809,0.8747,0.8611,0.8648,0.86,0.8669,0.8719,0.8656,0.8539,0.8824,0.8736,0.8803,0.8777,0.8795,0.8873,0.8758,0.8683,0.8655,0.8794,0.8852,0.8863,0.8845,0.8818,0.876,0.8817,0.877,0.8867,0.8844,0.8796,0.8859,0.8736,0.879,0.8857,0.8761,0.8822,0.8811,0.8825,0.8729,0.8768,0.8782,0.8866,0.8848,0.8755,0.8843,0.8782,0.8739,0.8844,0.882,0.8705,0.8621,0.8785,0.8882,0.8772,0.8707,0.8813,0.8735,0.8773,0.8769,0.8681,0.8778,0.8764,0.8857,0.8818,0.8834,0.8746,0.868,0.8662,0.8735,0.887,0.8781,0.8792,0.8777,0.8744,0.8773,0.8691,0.8772,0.8769,0.8754,0.8755,0.8725,0.8867,0.8843,0.8813,0.8869,0.875,0.8823,0.8836,0.8821,0.8806,0.8732,0.8707,0.879,0.8781,0.8764,0.8757,0.8851,0.8812,0.8847,0.8802,0.8852,0.885,0.8779,0.8816,0.8781,0.8719,0.8794,0.8892,0.8849,0.8879,0.8845,0.8767,0.8823,0.8901,0.8871,0.8822,0.8826,0.8752,0.8857,0.8816,0.8762,0.8768,0.875,0.8779,0.8721,0.8829,0.8822,0.8793,0.8797,0.8739,0.869,0.8583,0.8631,0.8697,0.8697,0.8831,0.882,0.8801,0.8738,0.8758,0.8798,0.8767,0.8854,0.8806,0.8814,0.8856,0.8809,0.8798,0.8801,0.8893,0.8798,0.8827,0.8756,0.8749,0.8811,0.8808,0.8691,0.8801,0.8713,0.8659,0.8828,0.8874,0.8892,0.883,0.8802,0.8811,0.8826,0.88,0.8776,0.8743,0.8812,0.8842,0.8874,0.8865,0.8718,0.8846,0.8862,0.8781,0.88,0.8829,0.8829,0.8867,0.8851,0.8877,0.885,0.8768,0.8733,0.8835,0.8856,0.8845,0.8838,0.8766,0.8795,0.8889,0.8875,0.8839,0.8789,0.8838,0.879,0.8812,0.8764,0.8842,0.8851,0.884,0.8761,0.8689,0.8813,0.8794,0.8796,0.8738,0.8713,0.8594,0.8772,0.866,0.8646,0.8696,0.8649,0.8629,0.8657,0.8827,0.8782,0.8673,0.8634,0.8775,0.8733,0.8789,0.8781,0.8732,0.8758,0.8874,0.8858,0.881,0.8718,0.8685,0.8709,0.8603,0.8736,0.877,0.8823,0.8792,0.8728,0.8863,0.8851,0.8835,0.8778,0.8791,0.8786,0.8754,0.8698,0.8663,0.8645,0.8582,0.8639,0.8751,0.8876,0.8883,0.887,0.8813,0.8783,0.8737,0.8888,0.8861,0.8845,0.8799,0.8729,0.8725,0.8748,0.8686,0.8829,0.8801,0.8798,0.8855,0.8751,0.8689,0.8818,0.8853,0.8845,0.8771,0.8773,0.8769,0.8733,0.8792,0.8872,0.8844,0.875,0.8672,0.8669,0.8887,0.8817,0.8895,0.8813,0.8844,0.8802,0.8716,0.8685,0.8711,0.8682,0.8789,0.8883,0.8876,0.8822,0.888,0.8864,0.884,0.877,0.8712,0.8755,0.8714,0.8727,0.8749,0.8773,0.8882,0.8775,0.8781,0.8822,0.8804,0.8852,0.8873,0.8814,0.8878,0.887,0.8848,0.8843,0.8815,0.8804,0.8771,0.8688,0.8727,0.8744,0.8778,0.8685,0.8819,0.8815,0.8815,0.8809,0.8806,0.8813,0.8776,0.875,0.876,0.875,0.8821,0.8867,0.8836,0.8801,0.8838,0.8839,0.8837,0.8827,0.8756,0.8799,0.8887,0.8865,0.8832,0.8811,0.8781,0.8805,0.8759,0.8807,0.8708,0.8784,0.8879,0.8732,0.8836,0.8788,0.8881,0.8865,0.8795,0.8869,0.8862,0.8871,0.884,0.8853,0.8888,0.8871,0.8796,0.8759,0.89,0.8871,0.8835,0.8884,0.8828,0.8845,0.8847,0.8839,0.8813,0.8826,0.8899,0.8883,0.8827,0.886,0.8895]
#sfl_pc1=[0.1989,0.3809,0.4926,0.5303,0.587,0.6134,0.6135,0.6153,0.6351,0.6716,0.6557,0.6476,0.6834,0.7023,0.6693,0.7019,0.678,0.7119,0.6882,0.7126,0.7472,0.7489,0.7739,0.7486,0.7695,0.763,0.7571,0.7391,0.7537,0.7668,0.7808,0.7843,0.7661,0.7719,0.8028,0.8135,0.8146,0.8213,0.8103,0.7996,0.8136,0.8284,0.8076,0.7864,0.8161,0.8024,0.8065,0.8132,0.8144,0.8268,0.8264,0.7995,0.7881,0.8032,0.7985,0.807,0.8272,0.8094,0.8279,0.8279,0.7976,0.8163,0.8289,0.8219,0.83,0.8198,0.8297,0.8286,0.8393,0.8213,0.8262,0.8317,0.8327,0.8283,0.8315,0.8382,0.8299,0.8359,0.8256,0.8337,0.8208,0.8373,0.8162,0.8311,0.8362,0.8282,0.8467,0.8335,0.84,0.8391,0.8295,0.8415,0.8518,0.8495,0.843,0.8482,0.8338,0.8511,0.8429,0.8477,0.8469,0.84,0.8248,0.8456,0.8468,0.8383,0.8487,0.843,0.8384,0.8485,0.8392,0.8473,0.8497,0.8535,0.8546,0.8204,0.8513,0.8381,0.8455,0.8336,0.8435,0.8537,0.8408,0.82,0.8494,0.8549,0.8379,0.8156,0.8458,0.8543,0.8437,0.8452,0.8351,0.8475,0.8323,0.8539,0.8235,0.8497,0.8566,0.8399,0.8476,0.8511,0.841,0.8456,0.8545,0.8419,0.8552,0.855,0.8565,0.8537,0.8554,0.8532,0.847,0.8583,0.8519,0.8397,0.8457,0.8407,0.8514,0.8549,0.8583,0.8595,0.8571,0.8447,0.8544,0.857,0.8515,0.8526,0.838,0.8495,0.8535,0.8446,0.8568,0.8543,0.8555,0.8618,0.8572,0.8608,0.8542,0.8658,0.8583,0.8392,0.8351,0.8558,0.8577,0.855,0.8678,0.8592,0.8574,0.8591,0.8541,0.8478,0.852,0.8551,0.8638,0.8439,0.8572,0.8489,0.8638,0.8559,0.8623,0.8606,0.8408,0.8455,0.8581,0.8629,0.8567,0.8631,0.8669,0.8633,0.852,0.8601,0.8659,0.8637,0.8555,0.861,0.8602,0.8649,0.8638,0.8624,0.8683,0.8625,0.8623,0.8645,0.8591,0.8638,0.8588,0.8544,0.8646,0.867,0.8602,0.8623,0.8668,0.8647,0.8625,0.849,0.8635,0.8662,0.8634,0.8661,0.8653,0.8609,0.8677,0.8664,0.8669,0.8613,0.8618,0.8455,0.868,0.8616,0.8558,0.863,0.8651,0.8636,0.8638,0.8666,0.8581,0.865,0.856,0.8524,0.8553,0.8587,0.8574,0.8678,0.8663,0.8635,0.8656,0.8612,0.8656,0.8628,0.8677,0.8669,0.8678,0.8571,0.8614,0.8682,0.8502,0.8642,0.8556,0.864,0.8675,0.862,0.8685,0.8674,0.8658,0.8672,0.8582,0.8674,0.8617,0.8683,0.865,0.868,0.8691,0.8684,0.8682,0.8682,0.8695,0.8732,0.8674,0.8682,0.8645,0.8666,0.8623,0.8623,0.8663,0.8677,0.8657,0.8552,0.8672,0.8715,0.8681,0.8698,0.8656,0.8685,0.8707,0.8631,0.8685,0.8701,0.8667,0.8652,0.8656,0.8693,0.8704,0.8711,0.8696,0.8664,0.8654,0.8692,0.8689,0.8691,0.8659,0.8708,0.8704,0.8699,0.8668,0.8695,0.8703,0.872,0.8703,0.8674,0.8688,0.8677,0.8702,0.8684,0.8699,0.8712,0.8664,0.8699,0.8646,0.8684,0.8593,0.8644,0.8703,0.8717,0.8748,0.8706,0.8687,0.868,0.8716,0.8712,0.8729,0.8668,0.8605,0.8601,0.8655,0.8712,0.8681,0.8703,0.8675,0.871,0.8699,0.8695,0.8723,0.8712,0.8701,0.871,0.862,0.8687,0.8654,0.8683,0.8655,0.8717,0.8708,0.867,0.8686,0.8704,0.8689,0.8697,0.8699,0.8713,0.8686,0.8699,0.8706,0.869,0.8699,0.8691,0.8694,0.8707,0.8654,0.873,0.8724,0.8695,0.8702,0.8651,0.8677,0.871,0.8712,0.8661,0.8738,0.8702,0.8717,0.8697,0.8701,0.8714,0.8707,0.8687,0.8714,0.8717,0.8722,0.8715,0.869,0.8712,0.8728,0.8728,0.8712,0.8714,0.8689,0.8733,0.8741,0.866,0.8736,0.8715,0.8725,0.8715,0.8716,0.8728,0.8696,0.8668,0.8703,0.8711,0.8716,0.87,0.8681,0.8717,0.8713,0.8713,0.8715,0.8724,0.8712,0.8742,0.873,0.8731,0.8712,0.8742,0.8692,0.8706,0.8717,0.8727,0.8669,0.8718,0.8721,0.8721,0.8696,0.8701,0.8735,0.8699,0.87,0.8726,0.8694,0.8723,0.8717,0.8717,0.8709,0.8691,0.874,0.8695,0.8718,0.8722,0.8748,0.8681,0.8747,0.8735,0.8675,0.8734,0.8695,0.8719,0.8657,0.8733,0.8739,0.8715,0.8746,0.8732,0.8684,0.8728,0.8739,0.8721,0.8737,0.8733,0.8695,0.8733,0.8736,0.872,0.8733,0.8711,0.8738,0.8744,0.8728,0.8725,0.8711,0.8679,0.8735,0.8711,0.8736,0.8726,0.8755,0.8722,0.8735,0.8724,0.8724,0.8728,0.8727,0.8634,0.8724,0.8734,0.8741,0.8707,0.8727,0.8729,0.8726,0.8726,0.8705,0.8729,0.8734,0.872,0.872,0.8721,0.8749,0.8731,0.8729,0.8731,0.8737,0.8712,0.8727,0.8728,0.8727,0.8737,0.8733,0.8736,0.8702,0.8713,0.8692,0.8735,0.8719,0.8723,0.8702,0.8701,0.8632,0.8725,0.8748,0.8665,0.8741,0.8689,0.8735,0.872,0.8737,0.8673,0.8721,0.8708,0.8677,0.8716,0.8733,0.8705,0.8709,0.8739,0.872,0.871,0.8713,0.8721,0.873,0.8738,0.871,0.8749,0.874,0.8716,0.8715,0.8734,0.8728,0.8716,0.8727,0.8751,0.8738,0.8733,0.8728,0.8733,0.872,0.8747,0.8734,0.8718,0.8745,0.8738,0.8749,0.8688,0.8693,0.8703,0.8707,0.8731,0.8753,0.8689,0.8737,0.8736,0.8736,0.8723,0.8742,0.8752,0.8746,0.8757,0.8687,0.8674,0.8663,0.8716,0.8735,0.8739,0.8736,0.8709,0.8719,0.8738,0.8702,0.872,0.8741,0.873,0.8701,0.8714,0.8742,0.8743,0.87,0.8721,0.8728,0.8723,0.8699,0.872,0.8745,0.8719,0.8755,0.8741,0.8714,0.8687,0.8715,0.8753,0.8726,0.8747,0.8749,0.8712,0.8728,0.874,0.8711,0.8733,0.869,0.8747,0.8697,0.8742,0.8726,0.8741,0.875,0.8675,0.8725,0.8736,0.8707,0.8718,0.8733,0.87,0.8718,0.8747,0.8735,0.8743,0.8736,0.8744,0.8704,0.8744,0.8702,0.8742,0.873,0.865,0.871,0.8748,0.8708,0.8734,0.8713,0.8741,0.8739,0.8737,0.8696,0.8739,0.8723,0.8728,0.8711,0.8737,0.8717,0.8754,0.8734,0.8707,0.874,0.8727,0.87,0.8737,0.8732,0.8732,0.8692,0.8734,0.8745,0.8689,0.8749,0.8746,0.874,0.8769,0.8736,0.8748,0.8759,0.875,0.8739,0.8733,0.8733,0.8716,0.8709,0.8734,0.8753,0.8736,0.8734,0.8735,0.8724,0.8753,0.8749,0.874,0.8722,0.8731,0.8745,0.8751,0.8744,0.8719,0.8755,0.8735,0.8728,0.8745,0.872,0.8733,0.8755,0.871,0.8657,0.873,0.8724,0.8734,0.8726,0.872,0.8723,0.8715,0.8736,0.8722,0.8707,0.8729,0.8735,0.8732,0.8749,0.8758,0.8654,0.8752,0.8749,0.8758,0.8753,0.8742,0.8751,0.8745,0.876,0.8747,0.8755,0.8749,0.8729,0.8747,0.8734,0.8736,0.875,0.8752,0.8742,0.8735,0.8776,0.8685,0.8731,0.8759,0.8729,0.8741,0.876,0.8736,0.8744,0.8739,0.8749,0.8692,0.8739,0.875,0.8691,0.8718,0.876,0.8749,0.872,0.8746,0.8741,0.8747,0.8734,0.8715,0.8722,0.8737,0.8748,0.8727,0.8732,0.8744,0.8711,0.8745,0.8719,0.8738,0.8742,0.8747,0.8751,0.8755,0.8698,0.8725,0.8707,0.8732,0.8729,0.8752,0.8733,0.8719,0.8743,0.8731,0.8758,0.8736,0.8728,0.8722,0.8714,0.8718,0.8709,0.8738,0.8704,0.8747,0.8739,0.8697,0.8723,0.8762,0.8751,0.8761,0.8746,0.8739,0.8728,0.8744,0.8712,0.8722,0.874,0.8703,0.8731,0.8755,0.8739,0.872,0.875,0.8762,0.8757,0.8754,0.8679,0.8723,0.875,0.8708,0.8745,0.8735,0.8712,0.875,0.876,0.8738,0.8731,0.8735,0.8733,0.8705,0.873,0.8696,0.871,0.8755,0.8739,0.8738,0.8731,0.8735,0.8745,0.8731,0.8729,0.8724,0.8731,0.8697,0.8736,0.8737,0.8738,0.8737,0.8728,0.8736,0.8732,0.8736,0.8755,0.8721,0.8745,0.8752,0.8761,0.8703,0.8735,0.8723,0.873,0.8748,0.8733,0.8742,0.8743,0.8744,0.8737,0.8725,0.8719,0.8749,0.8752,0.8749,0.8751,0.8744,0.8748,0.8753,0.8744,0.8711,0.875,0.8713,0.8709,0.8739,0.8737,0.873,0.8748,0.8696,0.8707,0.872,0.8719,0.8712,0.874,0.8728,0.8726,0.8745,0.8734,0.8723,0.8752,0.8721,0.8732,0.8728,0.8752,0.8737,0.8763,0.8713,0.8727,0.8751,0.8755,0.8703,0.8744,0.8746,0.8755,0.8719,0.8737,0.872,0.875,0.8744,0.8733,0.8707,0.872,0.876,0.8741,0.8741,0.8742,0.873,0.8739,0.8716,0.876,0.872,0.8758,0.874,0.8736,0.8701,0.8746,0.8712,0.8741,0.874,0.8731,0.8755,0.873,0.8744,0.8718,0.8737,0.8724,0.8741,0.8706,0.8713,0.8736,0.8759,0.8735,0.876,0.873,0.8755,0.8735,0.8726]
sfl_pc1=[0.462,0.7126,0.7654,0.8026,0.8056,0.8206,0.8407,0.8385,0.8439,0.8527,0.8532,0.858,0.8564,0.8551,0.8554,0.8514,0.8686,0.8685,0.87,0.8693,0.8579,0.8698,0.8689,0.8652,0.8678,0.8701,0.8724,0.876,0.8736,0.8658,0.8747,0.8788,0.8764,0.8807,0.8805,0.8747,0.8752,0.8713,0.8793,0.8761,0.872,0.881,0.8801,0.8787,0.8772,0.8797,0.8802,0.8819,0.8806,0.8835,0.8818,0.8806,0.8833,0.8736,0.8799,0.8824,0.881,0.8806,0.8795,0.8801,0.8821,0.8802,0.8809,0.8831,0.8763,0.8824,0.8827,0.8841,0.8831,0.882,0.8855,0.8829,0.8855,0.8823,0.8808,0.8837,0.8823,0.8859,0.8861,0.8835,0.8815,0.8819,0.8838,0.8859,0.8855,0.8825,0.8845,0.8822,0.8846,0.8852,0.8816,0.8858,0.885,0.8863,0.8862,0.8847,0.885,0.886,0.8854,0.8843,0.8847,0.8826,0.8857,0.8851,0.8836,0.8848,0.8857,0.8871,0.8859,0.887,0.886,0.8861,0.8836,0.8845,0.8865,0.8857,0.8868,0.8857,0.8868,0.8857,0.8867,0.885,0.8861,0.8876,0.8859,0.8856,0.8881,0.8872,0.8847,0.8849,0.8853,0.8852,0.8848,0.8854,0.8876,0.885,0.888,0.8871,0.8871,0.8843,0.8864,0.8888,0.8875,0.8877,0.8882,0.8871,0.8873,0.8879,0.885,0.8874,0.8876,0.8859,0.8865,0.8883,0.8866,0.8866,0.8884,0.8874,0.8892,0.8869,0.8866,0.8865,0.8869,0.8895,0.8881,0.8872,0.8878,0.8877,0.8886,0.8886,0.8886,0.8864,0.8886,0.8881,0.8882,0.8891,0.8872,0.8881,0.8886,0.886,0.8885,0.8871,0.886,0.8879,0.887,0.889,0.8883,0.8875,0.8898,0.889,0.8866,0.8885,0.888,0.8883,0.8892,0.8878,0.8883,0.887,0.8862,0.8898,0.8885,0.8873,0.8887,0.8899,0.8898,0.8885,0.8874,0.8884,0.8884,0.888,0.8879,0.8885,0.8893,0.8898,0.8895,0.8844,0.8879,0.89,0.888,0.8883,0.8899,0.8857,0.8878,0.8882,0.8881,0.888,0.8877,0.8883,0.8889,0.8891,0.8863,0.8859,0.889,0.8894,0.8899,0.8878,0.8894,0.8889,0.8891,0.8882,0.8867,0.8899,0.8875,0.8879,0.888,0.8875,0.8888,0.8895,0.8876,0.8893,0.8873,0.888,0.8901,0.8889,0.8898,0.8886,0.8876,0.887,0.8871,0.8893,0.8898,0.8898,0.8893,0.89,0.8892,0.8903,0.8876,0.8907,0.8883,0.8897,0.8879,0.8902,0.8896,0.8895,0.89,0.8891,0.8894,0.8882,0.8884,0.8905,0.8891,0.8903,0.8874,0.8892,0.888,0.8886,0.8876,0.8907,0.8883,0.8883,0.8888,0.8887,0.8903,0.8909,0.8912,0.8896,0.8904,0.8886,0.8906,0.886,0.8883,0.8879,0.8885,0.8893,0.8889,0.8887,0.8891,0.8878,0.8903,0.89,0.8904,0.8907,0.8897,0.8908,0.8885,0.8882,0.8886,0.8891,0.8885,0.8887,0.8893,0.8875,0.8898,0.8901,0.8906,0.8871,0.8901,0.8904,0.8892,0.8891,0.8866,0.8894,0.8906,0.8893,0.8881,0.8899,0.8904,0.8882,0.8893,0.8882,0.8911,0.8905,0.8898,0.8891,0.8893,0.8891,0.8896,0.8907,0.8898,0.8888,0.8887,0.8904,0.8893,0.8891,0.8889,0.8881,0.8895,0.89,0.8889,0.8903,0.89,0.8894,0.8892,0.8906,0.8877,0.8901,0.8901,0.89,0.8898,0.8895,0.8904,0.888,0.8909,0.8901,0.8905,0.8901,0.8884,0.8893,0.8888,0.8898,0.8903,0.8873,0.8907,0.89,0.89,0.888,0.8885,0.8898,0.891,0.8888,0.8904,0.8915,0.8884,0.887,0.8893,0.8895,0.8896,0.8889,0.8901,0.889,0.8911,0.8883,0.888,0.8896,0.8902,0.8912,0.8907,0.8903,0.8898,0.8896,0.891,0.8898,0.891,0.8911,0.8903,0.8887,0.8896,0.8896,0.8885,0.8887,0.8898,0.8883,0.8895,0.8894,0.8886,0.889,0.8906,0.8891,0.8908,0.8907,0.8904,0.8911,0.8908,0.891,0.8898,0.8906,0.8896,0.8907,0.8913,0.8892,0.8913,0.8897,0.8896,0.8892,0.8912,0.8907,0.8904,0.8895,0.8899,0.8888,0.8915,0.8905,0.8893,0.8897,0.8906,0.8902,0.8912,0.8895,0.8914,0.891,0.8906,0.8887,0.8884,0.8903,0.8906,0.8891,0.8915,0.8902,0.889,0.888,0.8892,0.8897,0.8904,0.8896,0.8914,0.8907,0.8907,0.8899,0.8889,0.89,0.8897,0.8908,0.8892,0.8898,0.8894,0.89,0.8903,0.8909,0.8864,0.8907,0.8909,0.8899,0.8912,0.89,0.8915,0.8898,0.891,0.8898,0.8894,0.8907,0.8897,0.8894,0.8901,0.8908,0.8902,0.8911,0.8909,0.8898,0.8896,0.8891,0.8908,0.8896,0.8898,0.89,0.8893,0.89,0.8891,0.8904,0.8903,0.8906,0.891,0.8907,0.8898,0.89,0.8912,0.8906,0.8907,0.8907,0.8907,0.8902,0.8909,0.8887,0.8882,0.89,0.8891,0.8897,0.8907,0.8893,0.8899,0.8895,0.8899,0.8886,0.8896,0.8906,0.8887,0.8894,0.8907,0.8898,0.8891,0.8894,0.89,0.8901,0.8891,0.8908,0.8908,0.8906,0.8901,0.8896,0.8904,0.8912,0.8896,0.8906,0.8893,0.8893,0.8903,0.891,0.8895,0.8902,0.8903,0.8902,0.8904,0.8914,0.8911,0.8909,0.8913,0.8891,0.891,0.8897,0.8902,0.8901,0.891,0.8908,0.8911,0.8908,0.8907,0.891,0.8886,0.8901,0.8888,0.8904,0.891,0.8899,0.8908,0.8898,0.8914,0.89,0.8879,0.89,0.8906,0.8907,0.8906,0.8911,0.8916,0.8896,0.8894,0.8907,0.8887,0.8902,0.8892,0.8908,0.8904,0.8904,0.891,0.8916,0.8911,0.8906,0.8903,0.8912,0.8911,0.8907,0.8902,0.8901,0.8906,0.89,0.8909,0.8904,0.89,0.8897,0.8906,0.8893,0.891,0.8895,0.8901,0.8907,0.8909,0.8904,0.8902,0.89,0.8913,0.8911,0.8914,0.8907,0.8915,0.8892,0.8901,0.8915,0.8904,0.8911,0.889,0.8901,0.8908,0.8905,0.8909,0.8908,0.8915,0.8899,0.8906,0.8913,0.8907,0.8883,0.8912,0.8882,0.8893,0.889,0.8894,0.8904,0.889,0.8902,0.8903,0.8908,0.891,0.8908,0.8899,0.8896,0.8921,0.891,0.8897,0.8917,0.8903,0.8908,0.8901,0.8897,0.8902,0.8917,0.8902,0.8905,0.8903,0.8918,0.8918,0.8908,0.8904,0.8912,0.891,0.8907,0.8909,0.8896,0.8914,0.8908,0.8903,0.8901,0.8896,0.8892,0.8872,0.8906,0.8903,0.8901,0.8903,0.8907,0.8911,0.8905,0.8902,0.8903,0.8914,0.8901,0.8901,0.8896,0.8909,0.8908,0.8912,0.8907,0.8896,0.8905,0.8891,0.8898,0.8908,0.8894,0.8906,0.8895,0.8899,0.8909,0.89,0.8913,0.89,0.8905,0.8898,0.8906,0.8899,0.8902,0.8891,0.8905,0.8913,0.8901,0.8901,0.8913,0.891,0.8893,0.8909,0.8891,0.8887,0.8911,0.8916,0.8909,0.8906,0.8909,0.892,0.891,0.8911,0.8901,0.8911,0.8906,0.8901,0.8909,0.8909,0.8911,0.8906,0.8881,0.8906,0.8906,0.8905,0.8917,0.8909,0.89,0.8902,0.8886,0.8897,0.8914,0.8899,0.89,0.8907,0.8902,0.8895,0.8911,0.889,0.8911,0.8912,0.89,0.8912,0.8916,0.891,0.8906,0.8883,0.8905,0.8908,0.8892,0.8905,0.8895,0.8902,0.8901,0.8906,0.8898,0.8906,0.89,0.8905,0.8891,0.8904,0.8906,0.8907,0.891,0.8896,0.8905,0.8895,0.8906,0.8887,0.891,0.8915,0.8904,0.8901,0.8916,0.8915,0.8907,0.8912,0.8902,0.8911,0.8918,0.8894,0.8915,0.891,0.8912,0.8891,0.8905,0.8901,0.8916,0.891,0.8902,0.8893,0.8905,0.8879,0.8914,0.8895,0.89,0.8906,0.8905,0.8907,0.8903,0.8897,0.8893,0.8896,0.8904,0.8914,0.8896,0.8911,0.8895,0.8911,0.8918,0.8908,0.8913,0.8891,0.8912,0.8906,0.891,0.8909,0.8905,0.8911,0.8909,0.8915,0.8916,0.8904,0.891,0.8908,0.8897,0.8916,0.8893,0.8905,0.8901,0.8915,0.8902,0.8879,0.8903,0.8902,0.8909,0.8908,0.8903,0.8909,0.8913,0.889,0.8907,0.889,0.8908,0.8907,0.8908,0.8901,0.8898,0.8916,0.8916,0.8908,0.8921,0.8911,0.8903,0.8917,0.89,0.8899,0.8905,0.8906,0.8907,0.8908,0.8875,0.8898,0.8913,0.8917,0.8895,0.8909,0.8915,0.8889,0.8922,0.8913,0.8916,0.8903,0.8904,0.8909,0.8899,0.8902,0.8895,0.8898,0.8899,0.8906,0.8905,0.891,0.8899,0.8905,0.8899,0.8906,0.8907,0.891,0.8909,0.8898,0.8913,0.8913,0.8906,0.89,0.8913,0.8914,0.8908,0.8914,0.8905,0.8911,0.8922,0.8905,0.8912,0.8903,0.8922,0.8904,0.8917,0.8914,0.8908,0.8909,0.8905,0.8916,0.8912,0.8904,0.8911,0.8905,0.8908,0.8901,0.8889,0.8902,0.891,0.8889,0.8905,0.8912,0.8907,0.8906,0.8904,0.8901,0.8906,0.8905,0.8904,0.8901,0.8896,0.8897,0.8905,0.8898,0.8901,0.8898,0.8914,0.8913,0.8898,0.891,0.8899,0.8908,0.8915,0.8914,0.8903,0.8901,0.8915,0.8911,0.8902,0.8911,0.8906,0.8901,0.8902]
draw_icml(e2s_pc1,e2e_pc1,bf_pc1,bfc_pc1,sfl_pc1,'mnist_50_pg5.pdf','lower right')
# Draw small figure on it, may from (50,100) communication rounds, (990,1000) communication rounds



