#pg=1
import matplotlib as mpl
import numpy as np
from scipy.interpolate import make_interp_spline
from matplotlib import pyplot as plt

SLIDE_WIN=10
ALPHA=.2

def sliding_avg(input_data, slide_win=5):
    input_len = len(input_data)
    output_data = []
    output_data.append(input_data[0])
    for x in range(slide_win, input_len, slide_win):
        avg_value = np.mean(input_data[x:x+slide_win])
        output_data.append(avg_value)
        pass
    output_axis = np.linspace(0, input_len, len(output_data))
    return output_axis, output_data
dn = 500 # 1000
def draw_icml(Fed_E2S,Fed_E2E,Base_FedAvg,Base_FedCyCP,sfl,file_name,loc):
    mpl.rcParams['lines.linewidth'] = 2
    x = np.arange(0,dn)

    xys = make_interp_spline(x,Fed_E2S)
    x_z = np.linspace(0, dn-1, dn)
    FedE2S_s = xys(x_z)
    
    xys = make_interp_spline(x,Fed_E2E)
    x_e = np.linspace(0, dn-1, dn)
    Fed_E2E_s = xys(x_e)

    xys = make_interp_spline(x,Base_FedAvg)
    x_f = np.linspace(0,dn-1, dn)
    Base_FedAvg_s = xys(x_f)

    xys = make_interp_spline(x,Base_FedCyCP)
    x_c = np.linspace(0, dn-1, dn)
    Base_FedCyCP_s = xys(x_c)
    
    xys = make_interp_spline(x,sfl)
    x_sf = np.linspace(0,dn-1,dn)
    sfl_s = xys(x_sf)


    fig0 = plt.figure(figsize=plt.figaspect(1))
    ax0 = fig0.add_subplot(1,1,1)
    ax0.grid(linestyle='-')
    fig0.set_figwidth(4)
    fig0.set_figheight(4)
    
    avg_x_z, avg_FedE2S_s = sliding_avg(FedE2S_s, slide_win=SLIDE_WIN)
    avg_x_e, avg_Fed_E2E_s = sliding_avg(Fed_E2E_s, slide_win=SLIDE_WIN)
    avg_x_f, avg_Base_FedAvg_s = sliding_avg(Base_FedAvg_s, slide_win=SLIDE_WIN)
    avg_x_c, avg_Base_FedCyCP_s = sliding_avg(Base_FedCyCP_s, slide_win=SLIDE_WIN)
    avg_x_sfl, avg_sfl_s = sliding_avg(sfl_s, slide_win=SLIDE_WIN)

    ax0.plot(avg_x_z, avg_FedE2S_s, color = 'C2', linestyle = 'solid', label = 'HFL-E2S')
    ax0.plot(avg_x_e, avg_Fed_E2E_s, color = 'C3', linestyle = 'solid', label = 'HFL-E2E')
    ax0.plot(avg_x_f, avg_Base_FedAvg_s, color = "C0", linestyle = 'solid', label = 'Base_FedAvg')
    ax0.plot(avg_x_c, avg_Base_FedCyCP_s, color = "C4", linestyle = 'solid', label = 'Base_FedCyCP')
    ax0.plot(avg_x_sfl, avg_sfl_s, color = "C1", linestyle = 'solid', label = 'SFL')
    #line1=ax0.plot(x_m,m_3_test_s,color="C1",linestyle='solid',label='Mean Imputation',markersize = 15, marker=".",markevery=50)
#     ax0.plot(x_z,FedE2S_s,color='C2',linestyle='solid',label='HFL-E2S')
#     ax0.plot(x_e,Fed_E2E_s,color='C3',linestyle='solid',label='HFL-E2E',)
#     ax0.plot(x_f,Base_FedAvg_s,color="C0",linestyle='solid',label='Base_FedAvg')
#     ax0.plot(x_c,Base_FedCyCP_s,color="#b28c6e",linestyle='solid',label='Base_FedCyCP')

    #legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5,bbox_to_anchor=[1, 0.7])
    legend = ax0.legend(ncol=1,loc=loc, fontsize='small',markerfirst = False,framealpha=0.5)

    ax0.set_xlim(0,dn-1)
    #ax0.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
    ax0.set_xticks([0,50,100,150,200,250,300,350,400,450,500])
    #ax0.set_xticklabels(['0','100','200','300','400','500','600','700','800','900','1000'])
    ax0.set_xticklabels(['0','50','100','150','200','250','300','350','400','450','500'])
    ax0.set_xlabel('Communication Rounds',fontsize='large',fontweight='bold')
    ax0.set_ylabel('Test Accuracy',fontsize='large',fontweight='bold')
    ax0.set_ylim(0.1,0.8) #(0.4-1) 
    
    fig0.savefig(file_name,dpi=500,bbox_inches = 'tight')
#icml_24_400=[0.1009,0.0974,0.0974,0.1009,0.0892,0.0892,0.1028,0.0982,0.1028,0.0974,0.1705,0.1347,0.0974,0.1009,0.2356,0.1305,0.1829,0.1214,0.2643,0.1606,0.0892,0.1862,0.1061,0.1975,0.2047,0.3028,0.0974,0.114,0.0998,0.1822,0.1889,0.1942,0.2406,0.3139,0.2951,0.2748,0.2974,0.1062,0.1495,0.4265,0.2547,0.3616,0.1581,0.4512,0.4001,0.3687,0.2403,0.3547,0.3507,0.2297,0.4441,0.1247,0.371,0.3869,0.2443,0.2835,0.4172,0.425,0.414,0.436,0.4962,0.4247,0.4155,0.4877,0.4495,0.378,0.1358,0.4562,0.4212,0.4704,0.4763,0.4717,0.2223,0.4477,0.3686,0.2542,0.531,0.6428,0.5013,0.5487,0.2281,0.6381,0.5242,0.6225,0.6032,0.4201,0.4503,0.4624,0.5585,0.5827,0.4438,0.4273,0.3709,0.4714,0.4034,0.5321,0.5029,0.6018,0.5419,0.2401,0.5949,0.5283,0.591,0.4646,0.5854,0.2891,0.602,0.6018,0.5851,0.6394,0.585,0.605,0.5838,0.6337,0.577,0.35,0.5995,0.6086,0.5729,0.5034,0.6024,0.6658,0.6224,0.6567,0.5986,0.6285,0.6174,0.6129,0.5265,0.516,0.5685,0.3348,0.6012,0.5118,0.4654,0.6287,0.28,0.3282,0.5362,0.5236,0.5932,0.5662,0.664,0.6911,0.6119,0.6261,0.5959,0.5995,0.5891,0.5704,0.6537,0.5178,0.7066,0.6245,0.6757,0.6974,0.6188,0.4154,0.437,0.7135,0.6485,0.5898,0.6376,0.6458,0.6601,0.6883,0.5766,0.6516,0.6434,0.6814,0.6551,0.663,0.6365,0.6279,0.6273,0.4387,0.5035,0.5659,0.613,0.6359,0.6298,0.6383,0.647,0.618,0.5664,0.6156,0.5881,0.6548,0.6464,0.5852,0.6453,0.589,0.5626,0.5693,0.6405,0.669,0.6526,0.4737,0.6663,0.6594,0.4915,0.6486,0.6263,0.5172,0.6579,0.6517,0.5347,0.7071,0.5963,0.6616,0.6064,0.6758,0.5266,0.6265,0.6817,0.6102,0.6507,0.6836,0.6628,0.6633,0.6644,0.7248,0.6932,0.6866,0.7278,0.5817,0.7157,0.6997,0.7007,0.6618,0.6668,0.6613,0.5531,0.6572,0.6488,0.7004,0.6955,0.5297,0.6322,0.5479,0.6376,0.7076,0.6926,0.6479,0.7371,0.7308,0.5863,0.5801,0.7338,0.6493,0.6519,0.6442,0.7304,0.5391,0.6526,0.5618,0.6835,0.6789,0.6918,0.7003,0.682,0.6017,0.6539,0.669,0.6455,0.6784,0.7033,0.6824,0.5701,0.6893,0.6739,0.6318,0.6753,0.6828,0.705,0.6275,0.6216,0.6711,0.705,0.6722,0.6309,0.7006,0.6799,0.7359,0.7121,0.7157,0.7382,0.6584,0.6718,0.7415,0.7166,0.6986,0.6521,0.7082,0.6731,0.6593,0.7322,0.7177,0.7168,0.6819,0.6919,0.7196,0.6709,0.6584,0.6447,0.6774,0.7021,0.668,0.5959,0.6803,0.6602,0.6305,0.5647,0.5697,0.6754,0.7205,0.7174,0.6935,0.6918,0.6824,0.7121,0.6594,0.6741,0.7553,0.6989,0.732,0.7135,0.7352,0.6534,0.6717,0.6547,0.684,0.6616,0.7069,0.7172,0.7534,0.7048,0.734,0.6864,0.6849,0.706,0.7532,0.7208,0.746,0.7105,0.7157,0.7141,0.6764,0.6043,0.6886,0.7132,0.7424,0.6985,0.6352,0.6966,0.7327,0.7241,0.6936,0.7132,0.7084,0.6871,0.6687,0.6586,0.6687,0.7053,0.6307,0.693,0.6724,0.6756,0.6904,0.673,0.6211,0.6983,0.6651,0.7065,0.6697,0.7326,0.7282,0.6997,0.6809,0.7293,0.7219,0.6923,0.6817,0.682,0.6911,0.7237,0.7375,0.7528,0.7406,0.6903,0.7058,0.7538,0.7368,0.7183,0.7478,0.7131,0.6699,0.694,0.6675]
e2e_pc1=[0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.098,0.1126,0.1014,0.1629,0.1465,0.1812,0.2004,0.1874,0.21,0.1853,0.1928,0.2147,0.2143,0.2112,0.2152,0.2224,0.2895,0.2357,0.2203,0.2315,0.251,0.2348,0.2487,0.2912,0.3112,0.3432,0.3698,0.4104,0.3812,0.2529,0.248,0.2857,0.3342,0.3966,0.3265,0.2999,0.3144,0.3341,0.4213,0.4541,0.4248,0.4405,0.4657,0.4468,0.4917,0.4708,0.4611,0.4463,0.4704,0.491,0.49,0.4886,0.5413,0.5492,0.5354,0.498,0.5266,0.4778,0.445,0.4806,0.4814,0.5506,0.5256,0.4947,0.5188,0.5086,0.5309,0.5604,0.5821,0.5707,0.5592,0.5265,0.4928,0.5009,0.5236,0.5091,0.5531,0.5284,0.5269,0.4595,0.4578,0.4472,0.4267,0.543,0.5477,0.5495,0.5315,0.5117,0.484,0.5016,0.4684,0.4731,0.4917,0.4708,0.52,0.5173,0.4942,0.5099,0.5302,0.5427,0.567,0.5707,0.5877,0.5955,0.5779,0.5751,0.539,0.4983,0.4509,0.4429,0.433,0.5393,0.5343,0.552,0.536,0.5407,0.5453,0.5474,0.547,0.5441,0.5428,0.5653,0.5753,0.5486,0.5919,0.5831,0.5828,0.5849,0.6037,0.5993,0.5924,0.5971,0.5989,0.5932,0.5929,0.5524,0.5126,0.5132,0.5263,0.5508,0.5439,0.5819,0.5666,0.5265,0.5102,0.5172,0.4949,0.5304,0.5251,0.5654,0.5949,0.6011,0.5995,0.5903,0.5849,0.5891,0.5913,0.597,0.617,0.6028,0.6026,0.6014,0.5877,0.5975,0.5941,0.5987,0.5813,0.5894,0.5963,0.5815,0.5966,0.6006,0.6004,0.5837,0.5786,0.5574,0.5707,0.5744,0.5927,0.5942,0.5998,0.6014,0.5694,0.6103,0.609,0.6119,0.6026,0.6069,0.6297,0.6186,0.6415,0.6413,0.6255,0.6444,0.6403,0.6395,0.6354,0.6376,0.6283,0.6188,0.6255,0.6366,0.6428,0.652,0.6452,0.6445,0.6459,0.629,0.6373,0.637,0.6392,0.6431,0.6446,0.6384,0.6515,0.6551,0.6577,0.6572,0.6523,0.6424,0.6331,0.6484,0.6238,0.6321,0.6377,0.6387,0.6447,0.6418,0.6151,0.6503,0.6404,0.6457,0.6307,0.6387,0.6267,0.624,0.642,0.64,0.6553,0.6443,0.6485,0.6492,0.6566,0.6577,0.6483,0.6521,0.6435,0.6468,0.6518,0.6422,0.6496,0.6431,0.651,0.6441,0.6361,0.6446,0.64,0.6319,0.6386,0.6319,0.6231,0.645,0.637,0.6534,0.6529,0.6586,0.6528,0.6552,0.6592,0.663,0.6557,0.6476,0.6466,0.6546,0.6504,0.6347,0.65,0.6475,0.6391,0.6522,0.6529,0.6481,0.6422,0.6561,0.632,0.6374,0.6447,0.6353,0.6436,0.6548,0.6488,0.6503,0.654,0.657,0.6612,0.6538,0.6513,0.6581,0.6601,0.6601,0.6573,0.6567,0.6621,0.6553,0.661,0.6561,0.6631,0.6642,0.6621,0.6644,0.6655,0.6495,0.6557,0.6602,0.6568,0.6495,0.6551,0.6535,0.6495,0.6533,0.651,0.6408,0.6486,0.6537,0.6508,0.6503,0.6584,0.6607,0.6644,0.66,0.6639,0.6627,0.6604,0.6631,0.6541,0.6541,0.6587,0.6576,0.6611,0.6604,0.648,0.6533,0.6597,0.6632,0.6598,0.6607,0.6607,0.6608,0.666,0.6674,0.6674,0.6647,0.6637,0.6576,0.6627,0.6633,0.6556,0.6579,0.6602,0.6618,0.6559,0.6527,0.6613,0.6667,0.6528,0.6585,0.6683,0.6678,0.6607,0.6625,0.6711,0.669,0.6639,0.6678,0.6628,0.6625,0.6656,0.6637,0.6601,0.6585,0.66,0.6596,0.6575,0.653,0.6597,0.6564,0.6616,0.6603,0.6611,0.653,0.6624,0.6535,0.6598,0.6602,0.6639,0.6568,0.664,0.6643,0.6623,0.6659,0.6658,0.6675,0.6592,0.6611,0.6616,0.662,0.6562,0.6593,0.6596,0.6564,0.6519,0.6601,0.6568,0.665,0.6649,0.669,0.6646,0.668,0.668,0.6713,0.668,0.6653,0.6662,0.6653,0.6634,0.6638,0.6573,0.6657,0.6658,0.6688,0.6652,0.6655,0.666,0.6699,0.6611,0.6657,0.6643,0.665,0.6678,0.6721,0.6624,0.6695,0.6686,0.6659,0.667,0.6673,0.6705,0.6687,0.6652,0.6652,0.6691,0.6659,0.6702,0.6693,0.6675,0.6693,0.6714,0.6699,0.6724,0.6671,0.6711,0.6723,0.6723,0.6725,0.6738,0.6744,0.675,0.6756,0.6702,0.6733,0.6741,0.6725,0.6697,0.6741,0.6714,0.6703,0.6682,0.6697,0.6724,0.6752,0.6709,0.6736,0.6731,0.6739,0.6739,0.6725,0.6703,0.6719,0.6705,0.6692,0.6741,0.6722,0.6747,0.6713,0.6738,0.6736,0.6749,0.6715,0.6726,0.6741,0.6749,0.6733,0.672,0.673,0.6724,0.671,0.6695,0.6706,0.6719,0.6754,0.6746,0.6732,0.6698,0.675,0.6714,0.6739,0.67,0.673,0.6739,0.6704,0.6719,0.6718,0.6671,0.6726,0.6701,0.6729,0.6717,0.6726,0.6671,0.666,0.6729,0.6731,0.6734,0.6733,0.6694,0.6702,0.671,0.6722,0.6716,0.6715,0.6735,0.6739,0.6726,0.6725,0.6732,0.6742,0.6745,0.6751,0.6734,0.6747,0.6748,0.674,0.6748,0.672,0.6751,0.6747,0.6714,0.6732,0.6728,0.6737,0.6746,0.6756,0.6711,0.6744,0.6765,0.6725,0.672,0.674,0.6729,0.6696,0.6734,0.6726,0.6726,0.6723,0.6724,0.6751,0.6706,0.6709,0.6708,0.6709,0.6664,0.6722,0.6726,0.6736,0.6738,0.6746,0.6743,0.6728,0.6709,0.6706,0.6695,0.6736,0.6744,0.6736,0.6738,0.6719,0.6698,0.6713,0.6688,0.6745,0.6699,0.6742,0.6747,0.6726,0.6743,0.6757,0.6771,0.6765,0.6744,0.6726,0.6736,0.6734,0.6752,0.6735,0.675,0.6731,0.6748,0.6733,0.674,0.6731,0.6709,0.6744,0.6699,0.6737,0.6745,0.6728,0.6724,0.6751,0.6753,0.6757,0.6735,0.6745,0.6709,0.6744,0.6727,0.6737,0.6732,0.6755,0.6739,0.6751,0.6751,0.6743,0.6757,0.6769,0.6758,0.6761,0.6748,0.6754,0.6773,0.6764,0.6742,0.6759,0.6747,0.6758,0.6687,0.6769,0.6725,0.6709,0.6721,0.674,0.6756,0.6721,0.6716,0.6757,0.6737,0.6713,0.6706,0.674,0.6753,0.674,0.673,0.6764,0.6753,0.6758,0.6739,0.6769,0.6765,0.6757,0.6757,0.6745,0.6746,0.6726,0.6729,0.674,0.6754,0.6744,0.675,0.673,0.6745,0.6747,0.6734,0.6736,0.6721,0.6751,0.6746,0.6737,0.6698,0.676,0.6725,0.6752,0.6733,0.6726,0.6764,0.6752,0.6757,0.6762,0.6747,0.6752,0.6747,0.6747,0.6751,0.6764,0.6769,0.6755,0.6774,0.6759,0.6739,0.6772,0.6753,0.6757,0.6755,0.6732,0.6754,0.6768,0.6755,0.6746,0.6713,0.677,0.6738,0.6739,0.6762,0.6755,0.6705,0.6756,0.6757,0.6758,0.6754,0.6761,0.6773,0.6744,0.6758,0.6732,0.6745,0.6766,0.671,0.6745,0.6748,0.6757,0.6737,0.6755,0.6731,0.6742,0.6769,0.6768,0.6756,0.6759,0.6763,0.6763,0.6748,0.6757,0.674,0.6756,0.6761,0.6755,0.6767,0.6733,0.6746,0.6756,0.6771,0.6748,0.6771,0.6761,0.6756,0.6756,0.6747,0.672,0.6762,0.6733,0.6778,0.6769,0.6773,0.6753,0.6777,0.6768,0.6774,0.6755,0.6745,0.6763,0.678,0.6777,0.6779,0.6786,0.6784,0.677,0.6757,0.6783,0.6781,0.6756,0.6766,0.678,0.6785,0.6778,0.675,0.6785,0.6772,0.6754,0.6778,0.6768,0.6762,0.6767,0.6747,0.6778,0.674,0.676,0.677,0.677,0.6766,0.6773,0.6739,0.6764,0.6755,0.6778,0.6762,0.6776,0.6777,0.6745,0.6744,0.6774,0.6773,0.6748,0.6752,0.6772,0.6765,0.6765,0.676,0.6765,0.6779,0.6766,0.6762,0.6755,0.6762,0.6759,0.6763,0.6756,0.6756,0.6733,0.6769,0.6771,0.678,0.6779,0.6763,0.6781,0.6738,0.6769,0.6779,0.6744,0.6786,0.6757,0.677,0.6756,0.6773,0.6749,0.6781,0.6751,0.6758,0.6785,0.676,0.6795,0.6772,0.6763,0.6789,0.6782,0.678,0.6791,0.678,0.6752,0.6784,0.6774,0.6787,0.6767,0.6782,0.6766,0.6787,0.6794,0.6765,0.6788,0.6776,0.6787,0.6777,0.6779,0.6783,0.6775,0.6769,0.6781,0.6758,0.677,0.6749,0.6761,0.678,0.6777,0.6776,0.6787,0.6771,0.6788,0.6767,0.6774,0.6791,0.6777,0.678,0.6744,0.6763,0.6778,0.6756,0.6767,0.6773,0.6778,0.6751,0.6769,0.6777,0.6767,0.6783,0.6772,0.6758,0.6772,0.6773,0.6782,0.6776,0.6769,0.6771,0.6778,0.677,0.6763,0.6776,0.6762,0.6785,0.678,0.6761,0.6771,0.677,0.6764,0.677,0.678,0.679,0.6783,0.6772,0.6792,0.6768,0.6777,0.6782,0.6769,0.6768,0.676,0.6767,0.6773,0.6775,0.6773,0.6763,0.6769]
e2s_pc1=[0.1372,0.1375,0.101,0.1032,0.1397,0.1217,0.1135,0.1449,0.143,0.1831,0.1975,0.0957,0.1956,0.1025,0.0958,0.1617,0.1052,0.1169,0.2064,0.205,0.1142,0.2093,0.1132,0.178,0.101,0.1009,0.101,0.2036,0.1825,0.1987,0.1542,0.101,0.1766,0.1682,0.1979,0.2009,0.2097,0.2095,0.1415,0.2055,0.21,0.198,0.2322,0.1848,0.2087,0.2106,0.2498,0.1917,0.2108,0.1996,0.101,0.2083,0.2657,0.2588,0.2616,0.2328,0.288,0.2865,0.2611,0.2532,0.27,0.101,0.2564,0.1009,0.3322,0.2848,0.3121,0.2797,0.3124,0.4,0.3414,0.3715,0.3222,0.2059,0.3596,0.3673,0.3188,0.3097,0.3836,0.3193,0.1696,0.3555,0.3237,0.3855,0.3553,0.3178,0.2688,0.4046,0.3658,0.309,0.3909,0.3192,0.3809,0.3543,0.204,0.3317,0.1662,0.3819,0.4082,0.4471,0.1667,0.3971,0.3385,0.3557,0.4655,0.375,0.3824,0.5044,0.4699,0.4617,0.3731,0.4743,0.2041,0.4282,0.4926,0.3048,0.4358,0.4849,0.5158,0.2405,0.3869,0.4502,0.4658,0.4361,0.4273,0.5052,0.473,0.4693,0.4764,0.4618,0.4854,0.4856,0.5188,0.5188,0.4867,0.5258,0.5069,0.3347,0.4825,0.4426,0.2427,0.2138,0.4743,0.4171,0.478,0.437,0.4465,0.4792,0.5403,0.5551,0.4992,0.5255,0.4977,0.491,0.4379,0.4236,0.4977,0.5147,0.5091,0.4582,0.4822,0.4773,0.5019,0.4846,0.4421,0.4332,0.4842,0.4737,0.4412,0.4727,0.523,0.5324,0.4853,0.4997,0.4765,0.4903,0.456,0.4999,0.4662,0.421,0.535,0.537,0.4653,0.4883,0.5114,0.4678,0.4471,0.5273,0.5323,0.49,0.507,0.5619,0.4428,0.4694,0.4956,0.485,0.4943,0.5239,0.4981,0.496,0.4567,0.5111,0.4958,0.4811,0.5047,0.4909,0.4374,0.4141,0.2887,0.5201,0.4879,0.5256,0.5033,0.5496,0.53,0.5202,0.4773,0.5463,0.5696,0.5394,0.5152,0.5317,0.5018,0.4878,0.5634,0.5317,0.5733,0.5389,0.5155,0.5278,0.4991,0.337,0.4634,0.5121,0.5047,0.5522,0.5584,0.5402,0.4864,0.5477,0.5405,0.3836,0.4581,0.4382,0.5268,0.4992,0.5671,0.5378,0.5444,0.5245,0.4573,0.539,0.5365,0.5506,0.5511,0.5486,0.5612,0.543,0.3803,0.5486,0.5597,0.5479,0.5207,0.5444,0.5222,0.5374,0.544,0.5313,0.5772,0.5694,0.5541,0.5307,0.5225,0.5183,0.5563,0.5024,0.5258,0.5162,0.5782,0.5586,0.5483,0.5439,0.5725,0.5649,0.5575,0.5645,0.5529,0.5766,0.5527,0.5178,0.5381,0.5725,0.577,0.5601,0.576,0.5787,0.563,0.5614,0.5465,0.511,0.5014,0.5076,0.4898,0.4689,0.5552,0.5639,0.5443,0.561,0.5212,0.5523,0.54,0.5417,0.5346,0.5496,0.5718,0.5659,0.5231,0.5437,0.5518,0.5846,0.5596,0.5649,0.5688,0.5663,0.5507,0.5622,0.5411,0.5638,0.5465,0.5105,0.532,0.5791,0.5801,0.5684,0.5181,0.4966,0.5295,0.5538,0.574,0.5799,0.5579,0.5741,0.557,0.5455,0.5516,0.567,0.5833,0.5616,0.5596,0.5771,0.5728,0.5519,0.5502,0.577,0.573,0.5722,0.5573,0.566,0.5422,0.5586,0.5457,0.57,0.5491,0.3837,0.5643,0.572,0.5771,0.5662,0.5537,0.507,0.4345,0.5076,0.5712,0.5631,0.5484,0.5274,0.5251,0.4909,0.4181,0.5257,0.5691,0.5447,0.5183,0.5024,0.5444,0.5837,0.5718,0.5755,0.561,0.583,0.5828,0.5596,0.5243,0.5632,0.5646,0.5786,0.5665,0.5648,0.5455,0.5319,0.5812,0.5853,0.5781,0.5845,0.5593,0.556,0.4689,0.499,0.5108,0.4832,0.5516,0.5544,0.472,0.495,0.5728,0.5807,0.5588,0.5848,0.5907,0.581,0.5789,0.5664,0.564,0.4794,0.5741,0.5321,0.5648,0.5379,0.5198,0.5775,0.5838,0.5668,0.567,0.5553,0.5784,0.5695,0.5706,0.5741,0.5739,0.5814,0.5831,0.5843,0.5676,0.5526,0.5375,0.5772,0.5554,0.5539,0.5733,0.5564,0.5643,0.5672,0.5855,0.5697,0.5712,0.5806,0.5723,0.548,0.5752,0.5717,0.5699,0.5253,0.5454,0.5881,0.545,0.5754,0.584,0.5698,0.582,0.4951,0.5313,0.5783,0.4837,0.5575,0.5623,0.5478,0.5661,0.5727,0.5561,0.5334,0.5774,0.5719,0.5774,0.5673,0.4846,0.5604,0.5657,0.5892,0.5627,0.5703,0.5646,0.5606,0.5464,0.5884,0.562,0.5766,0.5781,0.5091,0.5455,0.5577,0.5824,0.5682,0.5849,0.5202,0.5861,0.574,0.5738,0.5766,0.57,0.528,0.54,0.5167,0.57,0.5548,0.5578,0.4885,0.5639,0.5692,0.5732,0.4951,0.5302,0.5575,0.5391,0.5228,0.5445,0.5351,0.5519,0.4965,0.4626,0.5212,0.4765,0.5223,0.5847,0.5696,0.5789,0.5601,0.5352,0.5631,0.5634,0.5534,0.5444,0.5275,0.5277,0.5409,0.5207,0.5109,0.5409,0.5079,0.5232,0.4909,0.5126,0.526,0.5154,0.5097,0.4992,0.5763,0.5795,0.5741,0.5771,0.5835,0.5713,0.5637,0.5461,0.5429,0.5469,0.5249,0.4671,0.5568,0.5716,0.5738,0.5728,0.5506,0.5724,0.5791,0.5655,0.5171,0.5718,0.5798,0.5896,0.5839,0.5272,0.5638,0.5809,0.582,0.5858,0.5738,0.5818,0.5796,0.5666,0.5677,0.5619,0.5602,0.5883,0.5717,0.5897,0.5814,0.5898,0.5918,0.587,0.5792,0.5816,0.5149,0.528,0.5568,0.5415,0.5202,0.5731,0.591,0.5869,0.5812,0.5533,0.5772,0.5831,0.5845,0.592,0.5878,0.5851,0.5868,0.5238,0.4945,0.5328,0.5198,0.466,0.5255,0.5734,0.5913,0.5734,0.5856,0.5847,0.5759,0.5508,0.5537,0.5505,0.5596,0.5714,0.5716,0.5681,0.5465,0.5535,0.5508,0.5202,0.585,0.586,0.5631,0.5511,0.5876,0.5673,0.562,0.5671,0.562,0.4988,0.5483,0.5297,0.5769,0.592,0.5833,0.5909,0.5823,0.5779,0.5908,0.5844,0.5774,0.5753,0.5887,0.5889,0.5728,0.5895,0.5675,0.5194,0.5871,0.5307,0.5433,0.5768,0.5748,0.5797,0.5861,0.5769,0.5741,0.5861,0.586,0.5778,0.5715,0.5561,0.5761,0.5801,0.578,0.5843,0.5866,0.5745,0.5837,0.5837,0.5766,0.5539,0.5542,0.5366,0.5778,0.5609,0.5932,0.5895,0.5932,0.5874,0.5875,0.5395,0.5699,0.5348,0.5721,0.5733,0.5559,0.577,0.5795,0.5634,0.5689,0.5721,0.5665,0.561,0.5341,0.5527,0.5448,0.5047,0.5741,0.5865,0.5875,0.5808,0.5731,0.5752,0.5681,0.5653,0.556,0.5574,0.5812,0.572,0.5787,0.543,0.5897,0.587,0.5811,0.5708,0.5699,0.5626,0.5217,0.582,0.5734,0.5737,0.5814,0.5715,0.5303,0.5638,0.5653,0.561,0.5261,0.55,0.5521,0.5614,0.5944,0.5921,0.5917,0.592,0.5895,0.5829,0.5772,0.5885,0.5857,0.589,0.5759,0.5596,0.5586,0.5758,0.5333,0.5883,0.5888,0.5848,0.5422,0.5812,0.5526,0.5882,0.5823,0.584,0.5935,0.5867,0.5771,0.5871,0.5798,0.5858,0.5911,0.5906,0.5876,0.5938,0.5876,0.5781,0.5922,0.58,0.5923,0.5914,0.5864,0.5832,0.5893,0.5793,0.5847,0.5779,0.5715,0.5832,0.5763,0.556,0.577,0.5786,0.5743,0.5693,0.5807,0.5876,0.5932,0.5896,0.5911,0.5913,0.5857,0.5859,0.5803,0.591,0.5854,0.5743,0.5709,0.519,0.5307,0.5476,0.5313,0.583,0.5417,0.557,0.5511,0.5395,0.5827,0.562,0.5692,0.5898,0.5455,0.5889,0.5899,0.5826,0.5828,0.5574,0.5834,0.5791,0.5818,0.5883,0.5934,0.5926,0.5782,0.5729,0.5864,0.5792,0.5438,0.5576,0.5548,0.5608,0.5409,0.591,0.5897,0.5904,0.5777,0.5825,0.5729,0.5629,0.5725,0.5805,0.5794,0.5818,0.5778,0.5749,0.5801,0.5462,0.5705,0.56,0.5749,0.5703,0.571,0.5339,0.5867,0.5905,0.5842,0.5898,0.5905,0.5861,0.5841,0.581,0.5882,0.5936,0.5847,0.5858,0.5895,0.5901,0.5758,0.5676,0.567,0.5775,0.5696,0.555,0.5914,0.5813,0.5845,0.5542,0.5787,0.5897,0.5887,0.5864,0.5831,0.5803,0.5787,0.585,0.5855,0.5792,0.5476,0.5713,0.5591,0.5692,0.5343,0.5834,0.5927,0.58,0.5838,0.5733,0.5769,0.5505,0.5785,0.5723,0.5818,0.585,0.5883,0.5592,0.5732,0.5783,0.5768,0.583,0.5432,0.5771,0.5906,0.5905,0.5877,0.5828,0.5813,0.5836,0.5471,0.5739,0.5822,0.5842,0.5504,0.5852,0.5762,0.5821,0.5932,0.5883,0.5827,0.5903,0.5871,0.5921,0.5794,0.5869,0.5735,0.5537,0.5687,0.5752,0.5768,0.5653,0.588,0.5958,0.5938,0.5891,0.5887,0.5823,0.5806,0.5754,0.543,0.5568,0.5595,0.5464,0.5602,0.5816,0.5819,0.5894,0.5786,0.5871,0.5809,0.59,0.5895,0.5888,0.5793,0.5629,0.5792,0.5656,0.5771,0.5806,0.5839,0.5786,0.5769,0.5905,0.594,0.5917,0.5824,0.5805,0.5703,0.5769,0.5434]
bfc_pc1=[0.098,0.098,0.098,0.1326,0.1574,0.2112,0.3071,0.2171,0.2641,0.2577,0.3217,0.4101,0.4543,0.4591,0.4671,0.4737,0.4867,0.5091,0.5249,0.5093,0.5462,0.5433,0.5453,0.5481,0.5546,0.5644,0.5667,0.5754,0.5737,0.5476,0.558,0.5851,0.5837,0.5759,0.5817,0.5791,0.581,0.5861,0.585,0.5903,0.589,0.5915,0.5891,0.5907,0.5956,0.5926,0.5845,0.5894,0.5917,0.5925,0.5882,0.5899,0.5863,0.5955,0.5935,0.588,0.5884,0.586,0.5911,0.593,0.5901,0.596,0.5946,0.5934,0.599,0.5951,0.598,0.5957,0.5937,0.5977,0.5935,0.5938,0.5985,0.5944,0.5961,0.5994,0.594,0.5978,0.5984,0.5985,0.5962,0.5987,0.5912,0.5973,0.5957,0.598,0.5955,0.5967,0.5991,0.5992,0.5985,0.5991,0.6005,0.5971,0.5978,0.598,0.5993,0.6,0.597,0.6002,0.5993,0.5971,0.5987,0.5988,0.601,0.6005,0.5998,0.5997,0.6005,0.6001,0.599,0.5983,0.6018,0.599,0.6013,0.5978,0.6004,0.6017,0.602,0.6008,0.5997,0.6016,0.6017,0.6019,0.6007,0.6018,0.6008,0.6,0.6023,0.6016,0.602,0.6022,0.6006,0.601,0.6012,0.6009,0.6015,0.6016,0.6022,0.6025,0.6026,0.6015,0.6026,0.6022,0.6028,0.6025,0.6018,0.6009,0.6013,0.6018,0.6001,0.6026,0.6027,0.6023,0.6018,0.6028,0.6028,0.6032,0.6032,0.6028,0.6027,0.601,0.6025,0.6023,0.6025,0.6032,0.6006,0.6025,0.6017,0.6012,0.6023,0.6015,0.6024,0.6029,0.603,0.6023,0.602,0.6026,0.6024,0.6028,0.6029,0.6026,0.6032,0.6023,0.6032,0.6036,0.6032,0.6036,0.6015,0.6029,0.6034,0.6035,0.6031,0.6032,0.6036,0.6033,0.6034,0.6028,0.603,0.6027,0.6031,0.6028,0.6031,0.6027,0.6029,0.6028,0.6034,0.6019,0.6028,0.6033,0.6024,0.603,0.6031,0.6031,0.6033,0.6031,0.6029,0.6004,0.6029,0.6023,0.6017,0.6029,0.6031,0.6018,0.6028,0.6028,0.6021,0.6036,0.601,0.6032,0.6035,0.6029,0.6035,0.6036,0.6034,0.6033,0.6036,0.6031,0.6023,0.6032,0.6022,0.6034,0.6034,0.6033,0.6032,0.6032,0.6033,0.602,0.6033,0.6032,0.6024,0.6024,0.6035,0.6014,0.6032,0.6032,0.6035,0.6034,0.6025,0.6022,0.6035,0.6033,0.6035,0.6035,0.6022,0.603,0.6031,0.6038,0.6028,0.6029,0.6029,0.6037,0.603,0.604,0.6039,0.6033,0.6033,0.604,0.6035,0.6034,0.6035,0.6036,0.6037,0.6032,0.6031,0.6039,0.6026,0.6035,0.6036,0.6035,0.6034,0.6033,0.6031,0.603,0.6035,0.6037,0.6035,0.6035,0.6019,0.6038,0.6037,0.6035,0.6036,0.6031,0.6044,0.604,0.604,0.6038,0.6037,0.6024,0.6026,0.6035,0.6037,0.6036,0.6041,0.604,0.6036,0.6032,0.6034,0.6033,0.6024,0.6036,0.6043,0.6038,0.6032,0.604,0.6041,0.6037,0.6041,0.6031,0.6034,0.6029,0.6036,0.6036,0.6037,0.6032,0.6037,0.604,0.6034,0.6017,0.604,0.6043,0.6039,0.6036,0.6035,0.6035,0.6046,0.6041,0.6038,0.6041,0.6026,0.6041,0.6041,0.604,0.6033,0.6017,0.6042,0.6034,0.604,0.6037,0.6036,0.6041,0.6042,0.6042,0.6039,0.6037,0.604,0.6041,0.6039,0.6028,0.6032,0.6036,0.6039,0.6039,0.6042,0.6027,0.604,0.604,0.6037,0.604,0.6038,0.6044,0.6042,0.603,0.6041,0.6039,0.6043,0.604,0.6043,0.6042,0.6044,0.604,0.6041,0.6036,0.6042,0.6038,0.6044,0.6042,0.6015,0.6038,0.604,0.6036,0.603,0.6043,0.6043,0.604,0.6045,0.6036,0.6022,0.6026,0.6043,0.6038,0.604,0.6044,0.6042,0.604,0.6042,0.6047,0.604,0.6039,0.6039,0.6042,0.6041,0.6018,0.6037,0.6039,0.6037,0.6041,0.603,0.6028,0.6038,0.6038,0.6038,0.6044,0.6036,0.6041,0.6037,0.6044,0.6042,0.6042,0.6036,0.6041,0.6039,0.604,0.6031,0.6044,0.6041,0.6033,0.6038,0.6038,0.6039,0.6038,0.6025,0.6034,0.6033,0.6041,0.6038,0.603,0.604,0.6037,0.6038,0.6035,0.6035,0.604,0.6039,0.6037,0.6033,0.6035,0.6038,0.603,0.6037,0.6035,0.6039,0.604,0.6035,0.6036,0.6041,0.6041,0.6044,0.6044,0.6039,0.6039,0.6041,0.6042,0.6044,0.6043,0.6035,0.6038,0.6039,0.6034,0.6032,0.6041,0.6038,0.6045,0.6042,0.6043,0.6041,0.6041,0.6041,0.6041,0.6038,0.6041,0.604,0.6044,0.6041,0.6045,0.6042,0.6042,0.6037,0.6041,0.6038,0.6034,0.6038,0.6036,0.603,0.6042,0.6041,0.6045,0.6045,0.6042,0.604,0.6035,0.6039,0.6043,0.6042,0.6043,0.6041,0.6045,0.6044,0.6041,0.6045,0.604,0.6041,0.6044,0.6046,0.6045,0.6046,0.604,0.6039,0.6044,0.6039,0.6045,0.6042,0.6042,0.6043,0.6041,0.6043,0.6043,0.6044,0.6041,0.6035,0.6039,0.6048,0.6043,0.6034,0.6045,0.6047,0.6046,0.6043,0.6042,0.6043,0.6045,0.6041,0.6041,0.6043,0.6045,0.6044,0.604,0.6039,0.6042,0.6041,0.6035,0.6039,0.6041,0.6042,0.6038,0.6039,0.604,0.6041,0.6046,0.6044,0.6042,0.6042,0.6039,0.6042,0.6041,0.6044,0.6042,0.6042,0.6046,0.6041,0.6043,0.6042,0.604,0.6042,0.6039,0.6041,0.6042,0.6046,0.6038,0.6032,0.6034,0.6039,0.6041,0.604,0.6039,0.6043,0.6042,0.6042,0.6038,0.6047,0.6041,0.6046,0.6044,0.604,0.6041,0.6045,0.6044,0.6043,0.6044,0.6045,0.6045,0.6043,0.6042,0.6042,0.6045,0.604,0.6043,0.6043,0.6041,0.6043,0.6039,0.6037,0.6042,0.6046,0.6039,0.6043,0.6049,0.6045,0.6044,0.6047,0.6045,0.6043,0.6036,0.6045,0.6042,0.6042,0.6037,0.604,0.6044,0.6039,0.6039,0.604,0.6041,0.6041,0.604,0.6038,0.6042,0.6033,0.6041,0.6044,0.6042,0.6034,0.604,0.6039,0.6041,0.6036,0.6041,0.604,0.604,0.6046,0.6042,0.604,0.6044,0.6037,0.604,0.6046,0.6042,0.6043,0.6042,0.6043,0.6043,0.6043,0.6046,0.6046,0.604,0.6038,0.604,0.6041,0.6045,0.604,0.6042,0.6039,0.604,0.6043,0.6042,0.6042,0.6033,0.604,0.6041,0.6039,0.604,0.6042,0.6035,0.6038,0.6039,0.6039,0.6045,0.604,0.6043,0.6044,0.6037,0.6042,0.6041,0.6042,0.6043,0.6042,0.6037,0.6042,0.6045,0.6041,0.6044,0.604,0.6045,0.6045,0.6046,0.6044,0.6046,0.6047,0.6043,0.6045,0.6035,0.6038,0.6045,0.6041,0.6043,0.6037,0.6043,0.6036,0.6042,0.6044,0.6044,0.6042,0.6043,0.6043,0.6043,0.6047,0.604,0.6043,0.6042,0.6041,0.6039,0.6033,0.6038,0.6044,0.6041,0.6041,0.6037,0.6042,0.6036,0.6048,0.6042,0.6047,0.6035,0.6049,0.6046,0.6047,0.6043,0.6044,0.6045,0.6042,0.6048,0.6043,0.6049,0.6046,0.6046,0.6045,0.6041,0.6044,0.6042,0.6043,0.6042,0.6044,0.6046,0.6044,0.6044,0.6043,0.6042,0.6044,0.6043,0.6044,0.6043,0.6043,0.6039,0.6045,0.604,0.6041,0.6041,0.6043,0.6044,0.6042,0.6039,0.6043,0.604,0.6042,0.6027,0.604,0.6044,0.604,0.6043,0.6041,0.6041,0.6036,0.6043,0.6043,0.6037,0.6042,0.6041,0.6038,0.6039,0.6044,0.6042,0.6038,0.6037,0.6041,0.6045,0.6044,0.6043,0.6039,0.6041,0.6042,0.6044,0.6045,0.6039,0.6046,0.6041,0.6043,0.6044,0.6047,0.6041,0.6044,0.6047,0.6044,0.6047,0.6042,0.6042,0.6046,0.6048,0.6036,0.6048,0.6041,0.6044,0.6044,0.6043,0.6043,0.6044,0.6046,0.6044,0.6041,0.6044,0.6042,0.6045,0.6041,0.6038,0.6041,0.6043,0.6034,0.6046,0.6039,0.604,0.6044,0.6045,0.6043,0.6043,0.6043,0.6044,0.6046,0.6042,0.6046,0.6045,0.6044,0.6041,0.6044,0.6042,0.6044,0.6046,0.604,0.6042,0.6042,0.6046,0.6042,0.6043,0.604,0.6044,0.6044,0.6044,0.6046,0.6045,0.6043,0.6042,0.6043,0.6044,0.604,0.6043,0.6045,0.604,0.6043,0.6038,0.6044,0.6043,0.6043,0.6049,0.6048,0.6045,0.6043,0.6044,0.6048,0.6038,0.6037,0.6044,0.6045,0.6041,0.6041,0.6042,0.6038,0.604,0.6041,0.6044,0.6046,0.6046,0.604,0.6041,0.6039,0.6041,0.6041,0.6038,0.6035,0.6041,0.6043,0.6047,0.6044,0.6042,0.6042,0.6041,0.6044,0.6043,0.6044,0.6042,0.6041,0.6043,0.6041,0.6042,0.6039,0.604,0.6044,0.6046,0.604,0.6039,0.604,0.6043,0.6044,0.6042,0.6044,0.6046,0.6042,0.6042,0.6038,0.6044,0.6041,0.6041,0.6044,0.6043,0.6045,0.6045,0.604,0.6043,0.6041,0.6042,0.6043,0.6045,0.6029,0.6045,0.6047,0.6038,0.6035,0.6042,0.6042,0.6043,0.6047,0.6044,0.6047,0.6045,0.6048,0.6043,0.6044,0.6043,0.6045,0.6046,0.6046,0.6046]
bf_pc1=[0.1573,0.0974,0.1763,0.1615,0.1737,0.1258,0.0982,0.0958,0.1046,0.0958,0.1032,0.0974,0.0982,0.0982,0.1836,0.1102,0.1181,0.1052,0.0974,0.1032,0.0974,0.1032,0.1032,0.1505,0.1881,0.1804,0.0974,0.1879,0.1556,0.1032,0.0974,0.1636,0.1469,0.1917,0.1944,0.1032,0.0982,0.1105,0.1887,0.1032,0.1887,0.1631,0.1771,0.1954,0.1881,0.1743,0.173,0.101,0.1916,0.1909,0.1959,0.1978,0.1894,0.1032,0.1847,0.1978,0.19,0.1863,0.2292,0.213,0.2367,0.1032,0.1032,0.163,0.209,0.2016,0.1077,0.1968,0.2593,0.23,0.1125,0.2021,0.3081,0.2464,0.2652,0.2695,0.2832,0.2579,0.1072,0.1037,0.2617,0.2669,0.2815,0.1566,0.1631,0.28,0.269,0.2889,0.2645,0.2255,0.3169,0.2532,0.3238,0.2064,0.1636,0.1499,0.3202,0.27,0.2275,0.2997,0.2854,0.37,0.318,0.3014,0.3033,0.3077,0.2888,0.3035,0.2816,0.3049,0.2556,0.2277,0.3135,0.3481,0.292,0.2382,0.2163,0.3292,0.3405,0.3135,0.2533,0.2335,0.2714,0.3237,0.4182,0.3861,0.3532,0.319,0.2926,0.3244,0.3927,0.3313,0.2118,0.3924,0.21,0.3611,0.2658,0.336,0.2697,0.3168,0.3386,0.3969,0.4604,0.449,0.4076,0.3571,0.2492,0.358,0.4204,0.4047,0.4318,0.3462,0.3975,0.4318,0.2949,0.4187,0.3853,0.3071,0.3614,0.4022,0.3102,0.4267,0.3497,0.4419,0.385,0.4275,0.421,0.3144,0.2836,0.354,0.4807,0.4421,0.423,0.4092,0.4244,0.4579,0.3161,0.4585,0.4231,0.4497,0.3673,0.3978,0.4198,0.4615,0.4414,0.441,0.4909,0.4371,0.4249,0.4628,0.4066,0.4358,0.4858,0.4391,0.4815,0.4166,0.4388,0.3858,0.4384,0.4831,0.4518,0.4424,0.4379,0.395,0.4821,0.4931,0.4379,0.4865,0.4814,0.3862,0.5059,0.3966,0.3519,0.3249,0.4819,0.424,0.452,0.4271,0.4908,0.3997,0.4791,0.4982,0.5058,0.5022,0.4726,0.497,0.4419,0.4088,0.4871,0.4677,0.4366,0.4036,0.523,0.501,0.4717,0.4913,0.499,0.4309,0.4959,0.4317,0.5072,0.412,0.3696,0.337,0.4571,0.4354,0.4633,0.4795,0.4736,0.4824,0.471,0.5069,0.4301,0.5267,0.4949,0.4139,0.4729,0.4805,0.4612,0.5059,0.4525,0.4818,0.4802,0.5057,0.4473,0.5082,0.4823,0.5191,0.5035,0.5249,0.5107,0.5019,0.5317,0.4238,0.5254,0.4464,0.5234,0.5174,0.4903,0.5009,0.4883,0.4747,0.5243,0.5228,0.5219,0.4942,0.507,0.5267,0.4859,0.4458,0.471,0.4613,0.4263,0.5128,0.4934,0.4732,0.4583,0.5102,0.5366,0.4847,0.5038,0.5121,0.4896,0.4841,0.4702,0.5066,0.506,0.491,0.5145,0.5233,0.5047,0.4808,0.5398,0.4991,0.537,0.5228,0.4662,0.4091,0.5002,0.5399,0.5125,0.4854,0.4738,0.4572,0.4927,0.5141,0.5232,0.4898,0.5347,0.5275,0.4899,0.4951,0.4689,0.4774,0.5021,0.5225,0.5036,0.4575,0.5097,0.4686,0.5297,0.4508,0.5155,0.4685,0.4812,0.4721,0.4367,0.4415,0.5028,0.524,0.5072,0.4659,0.4517,0.5135,0.4372,0.5087,0.4962,0.4795,0.5225,0.4895,0.5232,0.4983,0.5109,0.4876,0.5264,0.4575,0.5044,0.523,0.5441,0.5337,0.4976,0.4757,0.4652,0.5253,0.5259,0.523,0.515,0.5123,0.499,0.4693,0.4765,0.4703,0.4932,0.4742,0.4651,0.5002,0.4938,0.4988,0.4858,0.4801,0.4861,0.5481,0.5466,0.5099,0.5234,0.4673,0.5193,0.4904,0.4941,0.4672,0.4561,0.4683,0.4914,0.547,0.546,0.5211,0.5144,0.4764,0.4937,0.4602,0.5196,0.5075,0.4619,0.5293,0.4948,0.5139,0.492,0.5116,0.5156,0.5374,0.5145,0.5188,0.4804,0.4882,0.5164,0.4932,0.5113,0.5052,0.481,0.5028,0.5086,0.5501,0.5525,0.5512,0.5235,0.531,0.5285,0.5145,0.5416,0.5566,0.5508,0.5346,0.539,0.5175,0.5003,0.4869,0.5159,0.5225,0.5437,0.5193,0.5209,0.544,0.5181,0.5284,0.5606,0.5546,0.5513,0.5487,0.544,0.5482,0.5539,0.5398,0.5524,0.537,0.5315,0.5117,0.5396,0.5572,0.5296,0.5044,0.528,0.5206,0.5111,0.5151,0.5031,0.4914,0.4665,0.459,0.521,0.5552,0.5411,0.5455,0.5358,0.5383,0.5395,0.5271,0.5089,0.5299,0.5278,0.5295,0.5232,0.5431,0.5402,0.5241,0.4813,0.5081,0.4757,0.4727,0.4629,0.4862,0.5142,0.5037,0.4672,0.4749,0.5136,0.5002,0.5038,0.4974,0.4838,0.4743,0.4971,0.5563,0.5432,0.5498,0.5392,0.5559,0.5346,0.5312,0.5522,0.5377,0.5411,0.5387,0.5244,0.5378,0.5471,0.524,0.5346,0.5525,0.517,0.5091,0.5543,0.559,0.5502,0.5291,0.531,0.528,0.5519,0.5378,0.5465,0.5453,0.5412,0.5177,0.5181,0.5638,0.5499,0.5445,0.5325,0.537,0.5574,0.5524,0.5436,0.5464,0.5499,0.5477,0.5475,0.5533,0.5426,0.5318,0.5497,0.5302,0.5447,0.5226,0.5601,0.5579,0.5466,0.5326,0.5348,0.5394,0.5228,0.5422,0.5238,0.523,0.5339,0.5203,0.5593,0.5599,0.5441,0.5386,0.5585,0.5423,0.5291,0.5325,0.5472,0.5437,0.537,0.5344,0.5337,0.5333,0.5282,0.5171,0.5265,0.5282,0.5655,0.5536,0.5462,0.5521,0.5531,0.5594,0.5574,0.5351,0.5476,0.5426,0.5297,0.5376,0.5366,0.5591,0.5548,0.5604,0.54,0.5283,0.5465,0.5606,0.5561,0.5415,0.5353,0.5556,0.56,0.5673,0.5439,0.5518,0.5262,0.5663,0.5536,0.5433,0.541,0.5209,0.5557,0.5513,0.5465,0.5374,0.5393,0.5614,0.5482,0.5607,0.557,0.5487,0.5394,0.5427,0.542,0.5476,0.526,0.545,0.5599,0.5647,0.5456,0.5369,0.5286,0.5406,0.5383,0.5408,0.5535,0.5266,0.5686,0.5606,0.5595,0.5438,0.5328,0.5411,0.5514,0.5223,0.5576,0.5516,0.5396,0.5586,0.5197,0.5361,0.4852,0.5395,0.548,0.5138,0.5122,0.503,0.5435,0.5455,0.5581,0.5373,0.544,0.5581,0.5524,0.5382,0.5357,0.5352,0.5255,0.5227,0.5099,0.4999,0.5212,0.5085,0.5498,0.5357,0.52,0.5238,0.5294,0.5643,0.555,0.5599,0.5654,0.5564,0.5411,0.5593,0.5367,0.5236,0.5642,0.5474,0.5493,0.5609,0.5384,0.5214,0.5472,0.5649,0.5561,0.5601,0.5497,0.5432,0.5368,0.5115,0.5509,0.5612,0.563,0.5661,0.5678,0.561,0.5597,0.5601,0.5557,0.562,0.5524,0.5486,0.5384,0.5521,0.5582,0.5692,0.5513,0.5584,0.5459,0.546,0.5497,0.5394,0.5343,0.5153,0.5569,0.5614,0.5541,0.5569,0.5593,0.555,0.5279,0.5638,0.5652,0.5545,0.5434,0.5396,0.5429,0.5248,0.5503,0.5634,0.5501,0.5448,0.5518,0.5291,0.5651,0.5596,0.5477,0.5668,0.5535,0.5471,0.5603,0.5636,0.556,0.5495,0.5316,0.5587,0.5499,0.5426,0.5439,0.5368,0.533,0.5365,0.5699,0.5687,0.5499,0.5547,0.5608,0.5461,0.5451,0.551,0.5579,0.5553,0.537,0.5442,0.5249,0.5512,0.5233,0.5029,0.5636,0.5648,0.5386,0.532,0.5499,0.5622,0.5478,0.5527,0.5394,0.5298,0.5481,0.5393,0.5608,0.5656,0.5587,0.5667,0.5623,0.5688,0.5637,0.5585,0.5433,0.5587,0.5499,0.5387,0.5104,0.5456,0.5363,0.5374,0.5554,0.5673,0.5557,0.5575,0.5636,0.5628,0.5572,0.547,0.5425,0.551,0.548,0.5589,0.5456,0.5643,0.5504,0.558,0.5602,0.5478,0.5499,0.5543,0.5503,0.5491,0.5394,0.532,0.5283,0.5421,0.546,0.5418,0.5641,0.5646,0.567,0.5545,0.5498,0.5455,0.5358,0.5406,0.5547,0.5455,0.5393,0.5521,0.529,0.5369,0.543,0.5708,0.5671,0.5529,0.5644,0.5416,0.5486,0.5418,0.5328,0.5345,0.5438,0.5696,0.5611,0.5654,0.553,0.5469,0.5446,0.5663,0.5454,0.5468,0.5625,0.5649,0.5635,0.5675,0.5668,0.5507,0.5516,0.55,0.5277,0.5427,0.5183,0.516,0.5349,0.5545,0.5361,0.5264,0.5439,0.5469,0.5376,0.5336,0.5637,0.5582,0.5497,0.5375,0.5527,0.5679,0.5603,0.5526,0.5489,0.5556,0.5714,0.5687,0.5633,0.5588,0.561,0.5629,0.5627,0.5626,0.5688,0.5684,0.5569,0.566,0.5544,0.5661,0.565,0.5644,0.5486,0.5631,0.5461,0.5505,0.5404,0.5526,0.5473,0.5687,0.5628,0.5647,0.5655,0.5585,0.5558,0.5493,0.5453,0.5676,0.5699,0.5623,0.5665,0.5647,0.5662,0.5596,0.5637,0.5445,0.5385,0.5641,0.546,0.5268,0.5624,0.5632,0.5654,0.5591,0.5625,0.5632,0.5636,0.5465,0.5684,0.567,0.5593,0.5575,0.5601,0.5693,0.5634,0.5641,0.567,0.5635,0.5523,0.5647,0.5564,0.5579,0.5503,0.5297,0.5394,0.5518,0.5367,0.5486,0.5323,0.5189,0.5332,0.5731,0.5654,0.5514,0.567,0.5406,0.5541,0.5587,0.5443,0.5733,0.5675,0.5555]
sfl_pc1=[0.0974,0.0974,0.0974,0.0977,0.1426,0.178,0.2486,0.2841,0.3525,0.3405,0.4173,0.4292,0.4424,0.449,0.4414,0.4704,0.502,0.5049,0.5202,0.5034,0.5227,0.5227,0.5487,0.554,0.5562,0.5502,0.5648,0.5713,0.5715,0.5693,0.5731,0.5771,0.579,0.5761,0.5753,0.5803,0.5746,0.5865,0.5825,0.589,0.5908,0.5867,0.5895,0.5888,0.5898,0.5892,0.5932,0.5942,0.5907,0.5937,0.5942,0.5968,0.5948,0.594,0.5965,0.595,0.5945,0.5984,0.5971,0.5968,0.5984,0.5996,0.5956,0.6002,0.5983,0.597,0.5999,0.5996,0.5976,0.6009,0.5995,0.5971,0.6007,0.5982,0.5963,0.5979,0.6006,0.6013,0.5991,0.6001,0.5995,0.6005,0.6012,0.6002,0.6015,0.6016,0.6008,0.6019,0.602,0.6035,0.6051,0.6045,0.604,0.6041,0.5999,0.6005,0.6023,0.6026,0.6046,0.6017,0.605,0.6028,0.6034,0.605,0.6029,0.6029,0.6027,0.6042,0.6059,0.6033,0.6025,0.6022,0.6026,0.6036,0.6064,0.6052,0.6051,0.6047,0.6038,0.6046,0.6053,0.6054,0.6041,0.6057,0.6036,0.6056,0.6055,0.6035,0.604,0.6065,0.6064,0.6066,0.6068,0.6057,0.6051,0.606,0.6064,0.6051,0.6066,0.6071,0.6052,0.607,0.6056,0.6061,0.6068,0.6064,0.6076,0.6063,0.6061,0.6068,0.6069,0.6071,0.607,0.6041,0.6065,0.6066,0.6065,0.6064,0.6076,0.6078,0.608,0.6073,0.6064,0.6062,0.6068,0.6067,0.6059,0.6058,0.6077,0.6075,0.6064,0.6069,0.6076,0.6076,0.6079,0.6069,0.6074,0.6079,0.6079,0.6063,0.6066,0.6076,0.6072,0.6073,0.6074,0.6067,0.6076,0.6081,0.6078,0.6071,0.6079,0.6078,0.608,0.6064,0.6071,0.6068,0.6072,0.6081,0.6074,0.6084,0.6077,0.6079,0.6081,0.6064,0.6053,0.6081,0.6085,0.6077,0.6081,0.6085,0.6084,0.6073,0.609,0.6068,0.6082,0.6075,0.6068,0.6063,0.6088,0.6086,0.608,0.6073,0.6071,0.6085,0.6075,0.6074,0.6085,0.609,0.6077,0.6084,0.6079,0.6084,0.6088,0.6085,0.6086,0.6075,0.608,0.6083,0.6086,0.6083,0.608,0.6085,0.6082,0.6088,0.6083,0.6086,0.6078,0.6067,0.608,0.6077,0.6082,0.6092,0.608,0.6077,0.6081,0.6083,0.6086,0.6085,0.6084,0.6076,0.6076,0.6084,0.6081,0.6079,0.6083,0.6079,0.6082,0.6083,0.6074,0.6086,0.6091,0.6082,0.6089,0.608,0.6075,0.6086,0.6075,0.6072,0.608,0.6084,0.6093,0.6061,0.6079,0.6068,0.6075,0.608,0.6088,0.6079,0.6083,0.6087,0.6077,0.6088,0.6086,0.607,0.6089,0.609,0.6085,0.6082,0.6086,0.6076,0.609,0.6079,0.6078,0.6066,0.6067,0.6074,0.6081,0.6085,0.6082,0.6079,0.6078,0.608,0.6082,0.6081,0.6087,0.6091,0.6078,0.6086,0.6081,0.608,0.6085,0.6076,0.6087,0.6083,0.608,0.609,0.6082,0.6091,0.6084,0.6087,0.6085,0.6085,0.6088,0.6084,0.6085,0.6088,0.6067,0.6083,0.6079,0.6078,0.6082,0.6084,0.6076,0.6077,0.6088,0.6075,0.6088,0.6079,0.6088,0.6082,0.6085,0.6091,0.6088,0.6068,0.6083,0.6083,0.6085,0.6079,0.6089,0.6083,0.6084,0.6089,0.6087,0.6083,0.6087,0.6084,0.6087,0.6069,0.6073,0.6082,0.6073,0.6076,0.6085,0.6088,0.6084,0.6078,0.6086,0.6084,0.6077,0.6087,0.6077,0.6083,0.6086,0.6068,0.6076,0.6084,0.6088,0.608,0.6087,0.6092,0.609,0.6084,0.6082,0.6088,0.6087,0.6086,0.6085,0.6084,0.6084,0.6082,0.6086,0.6085,0.6094,0.6084,0.6083,0.6095,0.608,0.6075,0.6083,0.6091,0.6083,0.6083,0.6085,0.6082,0.6087,0.6081,0.6087,0.6082,0.6082,0.608,0.6086,0.6085,0.608,0.6083,0.6082,0.6087,0.6089,0.6083,0.6084,0.6083,0.6082,0.609,0.6083,0.608,0.6077,0.6083,0.6093,0.6084,0.6089,0.6086,0.6086,0.6089,0.6083,0.6089,0.6093,0.6078,0.6089,0.6086,0.6085,0.6091,0.6089,0.609,0.6092,0.6085,0.6086,0.6086,0.6087,0.6088,0.6088,0.6085,0.6083,0.6077,0.6091,0.609,0.6092,0.6089,0.6093,0.6092,0.609,0.6094,0.6086,0.6085,0.609,0.6094,0.6065,0.6085,0.6084,0.6092,0.6086,0.6088,0.6089,0.6085,0.6086,0.6094,0.6095,0.6086,0.6092,0.6076,0.6086,0.6088,0.6081,0.6086,0.6082,0.6083,0.6082,0.6082,0.609,0.6083,0.6086,0.6084,0.6081,0.6089,0.6086,0.6084,0.6084,0.6081,0.6087,0.6084,0.6075,0.6085,0.6079,0.6091,0.6089,0.6086,0.6089,0.6087,0.6085,0.6083,0.6085,0.6083,0.6084,0.6092,0.6086,0.6083,0.6092,0.6084,0.6091,0.609,0.6089,0.6082,0.6093,0.6088,0.6098,0.609,0.6088,0.6086,0.6094,0.6083,0.6091,0.6094,0.6091,0.6086,0.6093,0.6087,0.6092,0.6091,0.6076,0.6082,0.6086,0.609,0.609,0.6092,0.6089,0.6087,0.6091,0.6086,0.6092,0.6086,0.6092,0.6087,0.6094,0.6096,0.609,0.6087,0.6091,0.6095,0.6085,0.6094,0.6087,0.6091,0.6083,0.6087,0.6089,0.6094,0.6081,0.6089,0.6085,0.609,0.6094,0.6088,0.6091,0.6091,0.6092,0.6083,0.6085,0.6085,0.6092,0.6085,0.608,0.608,0.6085,0.6081,0.6087,0.609,0.6086,0.6088,0.6084,0.6094,0.6089,0.6085,0.6089,0.6091,0.6088,0.6084,0.6077,0.6093,0.6095,0.6098,0.6091,0.6094,0.6087,0.6089,0.6091,0.6091,0.6089,0.6089,0.6084,0.6083,0.6089,0.6082,0.6088,0.608,0.6088,0.609,0.6083,0.6085,0.6079,0.6078,0.609,0.609,0.6093,0.6094,0.6094,0.6093,0.6082,0.6086,0.6083,0.609,0.6086,0.6092,0.6085,0.609,0.6091,0.6087,0.6083,0.6099,0.6089,0.6086,0.6096,0.6075,0.6089,0.6084,0.6085,0.6093,0.6088,0.6094,0.6084,0.6086,0.6093,0.6097,0.6085,0.6092,0.6089,0.6094,0.608,0.6093,0.6086,0.6092,0.6083,0.6082,0.6087,0.6089,0.609,0.6085,0.6092,0.6088,0.6089,0.6094,0.6097,0.6092,0.6093,0.6093,0.609,0.6083,0.6084,0.6094,0.6086,0.6082,0.6098,0.6094,0.6096,0.6091,0.6088,0.609,0.6096,0.6094,0.6096,0.6088,0.6087,0.6088,0.6091,0.609,0.6089,0.6083,0.6083,0.6092,0.6098,0.6094,0.6094,0.6086,0.6091,0.6092,0.6093,0.609,0.609,0.6094,0.6095,0.6093,0.6087,0.6093,0.6088,0.6079,0.6085,0.6093,0.6091,0.6095,0.6095,0.6092,0.6091,0.609,0.6092,0.609,0.6082,0.6087,0.6091,0.6095,0.6088,0.6094,0.6095,0.6079,0.609,0.6093,0.6089,0.6093,0.6091,0.6087,0.6092,0.6085,0.6099,0.6091,0.6091,0.6088,0.6096,0.6093,0.6093,0.6088,0.6088,0.6086,0.6072,0.6089,0.6093,0.6092,0.6095,0.6091,0.6087,0.6091,0.6085,0.609,0.6093,0.6079,0.6094,0.6089,0.6092,0.6082,0.6088,0.6084,0.6095,0.6089,0.6078,0.6093,0.6094,0.6095,0.6092,0.6096,0.6075,0.6095,0.6079,0.6091,0.6095,0.6088,0.609,0.6087,0.6085,0.6094,0.6094,0.6093,0.6085,0.6087,0.6083,0.609,0.6095,0.609,0.6086,0.6101,0.6094,0.6087,0.6095,0.6097,0.6095,0.6093,0.6092,0.6089,0.6089,0.6093,0.6083,0.6089,0.6092,0.6092,0.6091,0.609,0.6092,0.6096,0.6095,0.6096,0.6096,0.6091,0.6095,0.6096,0.6085,0.6093,0.6085,0.6085,0.6087,0.6088,0.6086,0.6091,0.6091,0.6093,0.6087,0.6091,0.6092,0.6086,0.609,0.6088,0.6084,0.6084,0.6087,0.609,0.6086,0.6093,0.6086,0.6086,0.6084,0.6088,0.6091,0.6088,0.6087,0.6091,0.6088,0.6092,0.6094,0.6089,0.6088,0.6096,0.6093,0.6091,0.6088,0.6085,0.6092,0.6089,0.6093,0.6089,0.6088,0.609,0.6095,0.6079,0.6097,0.6093,0.6088,0.609,0.6091,0.6091,0.6089,0.6087,0.6088,0.609,0.6081,0.6084,0.6079,0.6081,0.6088,0.6092,0.6091,0.6086,0.6085,0.6085,0.6094,0.6087,0.6086,0.6093,0.609,0.6086,0.6092,0.6087,0.6094,0.6084,0.6085,0.6089,0.6091,0.6086,0.6087,0.6088,0.6085,0.6087,0.6087,0.6086,0.6084,0.6088,0.6087,0.6089,0.6081,0.6089,0.6088,0.6088,0.6084,0.6088,0.609,0.6095,0.6093,0.6093,0.6095,0.6087,0.6091,0.6087,0.6091,0.6086,0.6082,0.6085,0.6082,0.609,0.6085,0.6086,0.6092,0.6089,0.6093,0.6087,0.6092,0.609,0.6086,0.6084,0.6094,0.6093,0.6096,0.6091,0.6094,0.6089,0.6096,0.6087,0.6091,0.6093,0.6087,0.6088,0.6091,0.6093,0.6089,0.6086,0.6083,0.6091,0.6093,0.6087,0.6093,0.6092,0.6084,0.6093,0.6089,0.6093,0.6087,0.6091,0.6088,0.6087,0.6094,0.609,0.6096,0.6095,0.6092,0.6091,0.6093,0.6096,0.6088,0.6092,0.609,0.6095,0.6092,0.6091,0.608,0.6083,0.6088,0.6089,0.6096,0.6097]

draw_icml(e2s_pc1[:dn],e2e_pc1[:dn],bf_pc1[:dn],bfc_pc1[:dn],sfl_pc1[::2],'mnist_50_pg1_500.pdf','lower right')
#No need small figures


