# Reproduction Instructions for `EXCOST: Semi-Supervised Classification with Exemplar-Contrastive Self-Training`

This README provides instructions for reviewers to reproduce the experimental results presented in the paper using the provided source code and Anaconda environment.

## Prerequisites

Before proceeding, ensure that you have Anaconda installed on your system. If Anaconda is not already installed, you can download it from [Anaconda's official website](https://www.anaconda.com/download).

**Note**: The experiments were conducted using an NVIDIA GeForce RTX 3090 graphics card with 24GB of VRAM. Please ensure that your hardware configuration is compatible with the memory requirements of the experiments, as this might affect the ability to reproduce the results.

## Setup

1. Open a terminal and navigate to the directory where you have the source code and the `environment.yaml` file.

2. Run the following command to create a Conda environment named `EXCOST` with the specified dependencies:
   
   ```bash
   conda env create --name EXCOST --file environment.yaml
   ```

3. Activate the newly created environment:

   ```bash
   conda activate EXCOST
   ```

## Running Experiments

In this paper, experiments were conducted on four datasets: MNIST, CIFAR-10, CIFAR-100, and SVHN. Each dataset has its corresponding experiment file:

- `experiment_MNIST.py`: Experiment code for MNIST.
- `experiment_SVHN.py`: Experiment code for SVHN.
- `experiment_CIFAR.py`: Experiment code for CIFAR-10/100.

You can customize the experiments by adjusting the parameters in these files.

### Configuring Parameters

You can modify the parameters in the code to customize the experiments:

- `shot`: Specify the number of labeled samples per class.
- For the `experiment_CIFAR.py` script, you can also adjust `num_classes` to switch between CIFAR-10 (10 classes) and CIFAR-100 (100 classes).

### Running an Experiment

To run an experiment, execute the corresponding Python script:

   - For MNIST:
   
     ```bash
     python experiment_MNIST.py
     ```

   - For CIFAR-10/100:
   
     ```bash
     python experiment_CIFAR.py
     ```

   - For SVHN:
   
     ```bash
     python experiment_SVHN.py

### Reviewing Results

Upon completing each experiment, the code will generate results and logs, which can be used for analysis and validation.


---

Thank you for reviewing our paper and for your efforts in replicating the experiments. If you require any further assistance or clarifications, please do not hesitate to contact us.
