import time
from functools import wraps


class AverageMeter(object):

    def __init__(self):
        self.sum = 0.0
        self.num = 0.0

    def update(self, values):
        self.sum += values.sum().item()
        self.num += len(values)

    def result(self):
        return 0 if self.num == 0 else self.sum / self.num


def time_consuming(function):

    @wraps(function)
    def wrapper(*args, **kwds):
        start = time.time()
        result = function(*args, **kwds)
        end = time.time()
        print(f"{function.__name__}: {end - start:>.2f} seconds.")
        return result

    return wrapper
