import json
import os

import matplotlib.pyplot as plt
import numpy as np


class Recorder():

    def __init__(self, path, id, fields):
        assert len(fields) > 0

        if (not os.path.exists(f"{path}/{id}")):
            os.makedirs(f"{path}/{id}")

        self.path = path
        self.id = id
        self.fields = {field: [] for field in fields}
        self.count = 0
        self.logger = open(f"{self.path}/{self.id}/log.txt", mode="wb+", buffering=0)

    def __del__(self):
        self.logger.close()

    def append(self, *record):
        assert len(record) == len(self.fields)
        for i, key in enumerate(self.fields.keys()):
            self.fields[key].append(record[i])
        self.count += 1

    def log(self, message):
        self.logger.write(str(message).encode("utf-8") + b"\n")
        print(message)

    def export_JSON(self):
        with open(f"{self.path}/{self.id}/record.json", "w", encoding="utf-8") as f:
            f.write(json.dumps(self.fields, indent=4))

    def plot(self, filename, label_X, label_Y, fields, show=False):
        plt.cla()
        for label, field in fields.items():
            plt.plot(np.arange(0, len(self.fields[field])), self.fields[field], label=label)
        plt.legend(fields.keys())
        plt.xlabel(label_X)
        plt.ylabel(label_Y)
        plt.grid(True)
        plt.savefig(f"{self.path}/{self.id}/{filename}.pdf")
        if (show):
            plt.show()
