import math


class SigmoidScheduler:

    def __init__(self, scale_x: float, scale_y: float, start: float, end: float, offset: float = 0.0) -> None:
        self.scale_x = scale_x
        self.scale_y = scale_y
        self.start = start
        self.end = end
        self.offset = offset

    def __repr__(self) -> str:
        return f"{self.__class__.__name__}(scale_x={self.scale_x}, scale_y={self.scale_y}, start={self.start}, end={self.end}, offset={self.offset})"

    def __call__(self, progress: float) -> float:
        return min(max(self.scale_y / (1 + math.pow(math.e, -((progress * (self.end - self.start) + self.start) / self.scale_x))) + self.offset, 0.0), 1.0)


class ConstantScheduler:

    def __init__(self, value: float) -> None:
        self.value = value

    def __repr__(self) -> str:
        return f"{self.__class__.__name__}(value={self.value})"

    def __call__(self, progress: float) -> float:
        return self.value
