import os
import random

import numpy
import torch

SEED = 0


def random_seed(seed):
    global SEED
    SEED = seed
    random.seed(seed)
    os.environ["PYTHONHASHSEED"] = str(seed)
    numpy.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.benchmark = False
    torch.backends.cudnn.deterministic = True


def seed_worker(worker_id):
    global SEED
    numpy.random.seed(SEED + worker_id)
    random.seed(SEED + worker_id)


def seed_generator():
    global SEED
    return torch.Generator().manual_seed(SEED)
