import pandas as pd


def table(df: pd.DataFrame, header_to_title: dict = {}, caption="Caption"):
    # \usepackage{booktabs}
    # \usepackage{float}

    caption_text = caption

    latex_table = [
        r"\begin{table}[H]",
        r"\caption{" + caption_text + "}",
        r"\label{tab:exampleTODOLABEL}",
        r"\small",
        r"\centering",
        r"\begin{tabular}{" + "l" * len(df.columns) + "}",
        r"\toprule",
    ]

    cols = header_to_title.keys()

    headers = [r"\textbf{" + header_to_title[col] + "}" for col in cols]
    latex_table.append(" & ".join(headers) + r" \\")

    latex_table.append(r"\midrule")

    for _, row in df[cols].iterrows():
        latex_table.append(" & ".join(str(item) for item in row) + r" \\")

    latex_table.extend([r"\bottomrule", r"\end{tabular}", r"\end{table}"])

    return "\n".join(latex_table)
