// https://stackoverflow.com/questions/57683303/how-can-i-see-the-full-expanded-contract-of-a-typescript-type
export type Expand<T> = T extends (...args: infer A) => infer R
  ? (...args: Expand<A>) => Expand<R>
  : T extends infer O
    ? { [K in keyof O]: O[K] }
    : never;

export type ExpandRecursively<T> = T extends (...args: infer A) => infer R
  ? (...args: ExpandRecursively<A>) => ExpandRecursively<R>
  : T extends object
    ? T extends infer O
      ? { [K in keyof O]: ExpandRecursively<O[K]> }
      : never
    : T;

type Maybe<T> = T | null;

type Step = { step: number; lo: number; hi: number; mid: number };
type SearchMetrics = { steps: Array<Step> };
type Trial = { trial_number: number; target: number; metrics: SearchMetrics };

type ExperimentMetrics = { epsilon: Maybe<number>; trials: Array<Trial> };
type NormalExperimentMetrics = ExperimentMetrics & {
  parameters: { loc: number; scale: number };
};

type ExponentialExperimentMetrics = ExperimentMetrics & {
  parameters: { loc: number; scale: number };
};

type NormalBatch = {
  basic: Array<NormalExperimentMetrics>;
  enhanced: Array<NormalExperimentMetrics>;
};

type ExponentialBatch = {
  basic: Array<ExponentialExperimentMetrics>;
  enhanced: Array<ExponentialExperimentMetrics>;
};

type GenericBatch<T extends { parameters: Record<string, unknown> }> = {
  basic: Array<ExperimentMetrics & T>;
  enhanced: Array<ExperimentMetrics & T>;
};

type GenericNormalBatch = GenericBatch<{
  parameters: { loc: number; scale: number };
}>;

type GenericExponentialBatch = GenericBatch<{
  parameters: { scale: number };
}>;

export type AnnotatedNormalBatch = ExpandRecursively<NormalBatch>;
export type AnnotatedGenericNormalBatch = ExpandRecursively<GenericNormalBatch>;

export type AnnotatedExponentialBatch = ExpandRecursively<ExponentialBatch>;
export type AnnotatedGenericExponentialBatch =
  ExpandRecursively<GenericExponentialBatch>;
