{
  description = "A Nix-flake-based Python development environment";

  inputs = {
    nixpkgs.url = "nixpkgs";
  };

  outputs = { self, nixpkgs }:
    let
      supportedSystems = [ "x86_64-linux" "aarch64-linux" "x86_64-darwin" "aarch64-darwin" ];
      forEachSupportedSystem = f: nixpkgs.lib.genAttrs supportedSystems (system: f {
        pkgs = import nixpkgs { inherit system; };
      });
    in
    {
      devShells = forEachSupportedSystem ({ pkgs }: {
        default = pkgs.mkShell {
          packages = with pkgs; [ python3 cairo poetry graphviz ffmpeg python311Packages.pycairo pango pkg-config python311Packages.scipy darwin.apple_sdk.frameworks.OpenGL darwin.apple_sdk.frameworks.ApplicationServices darwin.apple_sdk.frameworks.Carbon ];

          shellHook = ''
            python3 --version
            poetry --version
          '';
        };
      });
    };
}

