import pandas as pd
from bbs.latex import table


def test_table():
    df = pd.DataFrame(
        {
            "Name": ["John", "Alice", "Bob"],
            "Age": [25, 30, 35],
            "City": ["New York", "London", "Paris"],
            "Score": [85, 92, 78],
        }
    )

    header_mapping = {
        "Name": "Full Name",
        "Age": "Age (years)",
        "City": "City of Residence",
        "Score": "Test Score",
    }

    latex_table = table(df, header_mapping)
    assert (
        latex_table
        == "\\begin{table}[H]\n\\caption{Caption}\n\\label{tab:exampleTODOLABEL}\n\\small\n\\centering\n\\begin{tabular}{llll}\n\\toprule\n\\textbf{Full Name} & \\textbf{Age (years)} & \\textbf{City of Residence} & \\textbf{Test Score} \\\\\n\\midrule\nJohn & 25 & New York & 85 \\\\\nAlice & 30 & London & 92 \\\\\nBob & 35 & Paris & 78 \\\\\n\\bottomrule\n\\end{tabular}\n\\end{table}"
    )
