from dataclasses import asdict
from bbs.uniform.search import binary_search_uniform, enhanced_binary_search_uniform
from scipy.stats import uniform


def test_binary_search_uniform():
    rv = uniform(loc=0, scale=10)
    metrics = binary_search_uniform(rv, 2)
    metricse = enhanced_binary_search_uniform(rv, 2)

    assert asdict(metrics) == asdict(metricse)
    assert asdict(metrics) == dict(
        steps=[
            dict(step=0, lo=0, hi=10, mid=5),
            dict(step=1, lo=0, hi=5, mid=3),
            dict(step=2, lo=0, hi=3, mid=2),
            dict(step=3, lo=2, hi=3, mid=2),
        ]
    )


def test_binary_search_uniform_quickcheck():
    rv = uniform(loc=0, scale=9000)
    for target in range(0, 9000, 51):
        metrics = binary_search_uniform(rv, target)
        metricse = enhanced_binary_search_uniform(rv, target)

        assert asdict(metrics) == asdict(metricse)
