from dataclasses import dataclass
from typing import Optional

from bbs.search import SearchMetrics


@dataclass(frozen=True, kw_only=True)
class Trial:
    trial_number: int
    target: int
    metrics: SearchMetrics


@dataclass(frozen=True, kw_only=True)
class ExperimentMetrics:
    trials: list[Trial]
    epsilon: Optional[int]

    @property
    def steps(self):
        return [trial.metrics.total_steps for trial in self.trials]

    @property
    def targets(self):
        return [trial.target for trial in self.trials]

    @property
    def num_trials(self):
        return self.trials[-1].trial_number
