from math import ceil

from scipy.stats import distributions

from bbs.search import binary_search
from bbs.stats import truncated_median


def binary_search_expon(rv: distributions.rv_frozen, target: int, epsilon: int = 1):
    lo = 0
    hi = ceil(rv.ppf(0.99999))
    return binary_search(lo, hi, target, epsilon=epsilon)


def enhanced_binary_search_expon(
    rv: distributions.rv_frozen, target: int, epsilon: int = 1
):
    lo = 0
    hi = ceil(rv.ppf(0.99999))
    return binary_search(
        lo,
        hi,
        target,
        epsilon=epsilon,
        mid_func=truncated_median(rv),
    )
