from math import ceil, floor
from typing import Optional

from scipy.stats import distributions

from bbs.search import SignFunc, binary_search
from bbs.stats import truncnorm_median


def binary_search_normal(
    rv: distributions.rv_frozen,
    target: Optional[int] = None,
    epsilon: int = 1,
    lo: Optional[int] = None,
    hi: Optional[int] = None,
    sign: Optional[SignFunc] = None,
):
    lo = lo if isinstance(lo, int) else floor(rv.std() * -4.2 + rv.mean())
    hi = hi if isinstance(hi, int) else ceil(rv.std() * 4.2 + rv.mean())
    return binary_search(lo, hi, target, epsilon=epsilon, sign=sign)


def enhanced_binary_search_normal(
    rv: distributions.rv_frozen,
    target: Optional[int] = None,
    epsilon: int = 1,
    lo: Optional[int] = None,
    hi: Optional[int] = None,
    sign: Optional[SignFunc] = None,
):
    lo = lo if isinstance(lo, int) else floor(rv.std() * -4.2 + rv.mean())
    hi = hi if isinstance(hi, int) else ceil(rv.std() * 4.2 + rv.mean())
    return binary_search(
        lo, hi, target, epsilon=epsilon, mid_func=truncnorm_median(rv), sign=sign
    )
