from typing import Optional

from scipy.stats import distributions

from bbs.search import binary_search
from bbs.stats import truncuniform_median


def binary_search_uniform(
    rv: distributions.rv_frozen,
    target: int,
    epsilon: int = 1,
    lo: Optional[int] = None,
    hi: Optional[int] = None,
):
    lo = lo if isinstance(lo, int) else rv.kwds["loc"]
    hi = hi if isinstance(hi, int) else lo + rv.kwds["scale"]

    return binary_search(lo, hi, target, epsilon=epsilon)


def enhanced_binary_search_uniform(
    rv: distributions.rv_frozen,
    target: int,
    epsilon: int = 1,
    lo: Optional[int] = None,
    hi: Optional[int] = None,
):
    lo = lo if isinstance(lo, int) else rv.kwds["loc"]
    hi = hi if isinstance(hi, int) else lo + rv.kwds["scale"]

    return binary_search(lo, hi, target, epsilon=epsilon, mid_func=truncuniform_median)
