# Code for ICLR submission "Slicing Mutual Information Generalization Bounds for Neural Networks"

### Requirements

Python 3, PyTorch, numpy, matplotlib

### Files

* `gaussian_mean_estim.py` computes the analytical generalization error and bounds for the Gaussian mean estimation problem with projected parameters (Figure 1)

* `logistic_regression.py` evaluates our bounds on logistic regression for Gaussian data classification with projected parameters (Section 4.1)

* `bounds_nn_projections.py` evaluates our bounds on neural networks for image classification with projected weights (Section 4.1)

* `bounds_nn_projections_quantization.py` evaluates our bounds on neural networks for image classification with projected and quantized weights (Section 4.1)

* `rate_distortion_nn.py` evaluates our rate-distortion bounds with the regularization technique (Section 4.2)

* `mine.py` implements MINE to estimate mutual information

* `knnie.py` implements the mutual information k-NN-based estimator 

* Folder ''pactl'' contains useful functions for quantization and fast random projections from Lotfi et al. (2022)
