# Disentangling Knowledge Representations for Large Language Model Editing

## Dataset
- `data_files/`: This directory contains all the necessary dataset files, including:
  - `relation.json`: Stores the similarity and corresponding descriptions between different relations.
  - `KRD_train.json`: The dataset used for training the KRD module.
  - `FINE-KED_main.json`: The FINE-KED dataset used for the main experiment.
  - `FINE-KED_batch.json`: The FINE-KED dataset used for batch editing experiments.
  - `FINE-KED_batch_subject.json`: The FINE-KED dataset used for batch editing experiments specifically targeting the subject.
  - `cf_test.json`: A sampled CF dataset.

## Running
First, train a disentangler using `disentangle/train.py`, with the corresponding configuration file `config_{}.yaml`. Then, refer to the following script for editing:
```bash
python3 -m experiments.evaluate \
    --alg_name=DIS_MEMIT \
    --model_name={model_path} \
    --hparams_fname=gpt2-xl.json \
	--ds_name=re \
    --num_edits=1 \
    --dataset_size_limit=2000 \
    --skip_generation_tests \
    --disentangle_model={KRD_name}
```
