import numpy as np

from domain.MinecraftWrapper import create_minecraft_env, create_basic_minecraft_env


def generate_object_drawing(objects):
    if not objects:
        return ''

    objects = ['<DrawingDecorator>'] + objects + ['</DrawingDecorator>']

    return '\n'.join(str(x) for x in objects)


"""
<Inventory>
<InventoryItem slot="0" type="diamond_pickaxe"/>
</Inventory>
"""


def generate_world(seed=42, palette="random", objects=list(), wrap=True, record=False, **kwargs):
    np.random.seed(seed)
    # n_rooms = np.random.randint(2, 6)
    n_rooms = 5
    # temp = np.random.multinomial(n_rooms, np.ones(4) / 4, size=1)[0]
    temp = np.random.multinomial(n_rooms, np.ones(2) / 2, size=1)[0]
    # n_gaps, n_bridges, n_doors, n_puzzles = temp[0], temp[1], temp[2], temp[3]
    n_gaps, n_bridges, n_doors, n_puzzles = 0, 0, temp[0], temp[1]

    if n_puzzles > 2:
        n_doors += n_puzzles - 2
        n_puzzles = 2

    inventory = """
    <Inventory>
    """
    if 'axe' in kwargs:
        inventory += """
        <InventoryItem slot="0" type="diamond_pickaxe"/>
        """
    if 'red' in kwargs:
        inventory += '\n<InventoryItem slot="1" quantity="{}" type="redstone"/>'.format(kwargs['red'])

    if 'gold_block' in kwargs:
        inventory += '\n<InventoryItem slot="2"  type="gold_block"/>'

    if 'gold_ingot' in kwargs:
        inventory += '\n<InventoryItem slot="2" quantity="{}" type="gold_ingot"/>'.format(kwargs['gold_ingot'])

    if 'clock' in kwargs:
        inventory += '\n<InventoryItem slot="3"  type="clock"/>'


    inventory += '</Inventory>'

    # posx = kwargs['posx'] if 'posx' in kwargs else "-150" y="81.0" z="217.5"/>

    xml = """<?xml version="1.0" encoding="UTF-8" ?>
<Mission xmlns="http://ProjectMalmo.microsoft.com" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <About>
        <Summary>Open the chest!</Summary>
    </About>

    <ModSettings>
        <MsPerTick>10</MsPerTick>
        <!--<PrioritiseOffscreenRendering>true</PrioritiseOffscreenRendering>-->
    </ModSettings>

    <ServerSection>
        <ServerInitialConditions>
            <Time>
                <StartTime>6000</StartTime>
                <AllowPassageOfTime>false</AllowPassageOfTime>
            </Time>
            <Weather>clear</Weather>
            <AllowSpawning>false</AllowSpawning>
        </ServerInitialConditions>
        <ServerHandlers>
            <FlatWorldGenerator generatorString="3;7,220*1,5*3,2;3;,biome_1"/>
            <ClassroomDecorator seed="{}" palette="{}">
                <specification>
                    <width>10</width>
                    <height>7</height>
                    <length>40</length>
                    <pathLength>{}</pathLength>
                    <divisions>
                        <southNorth>{}</southNorth>
                        <eastWest>0</eastWest>
                        <aboveBelow>0</aboveBelow>
                    </divisions>
                    <horizontalObstacles>
                        <gap>{}</gap>
                        <bridge>{}</bridge>
                        <door>{}</door>
                        <puzzle>{}</puzzle>
                        <jump>0</jump>
                    </horizontalObstacles>
                    <verticalObstacles>
                        <stairs>0</stairs>
                        <ladder>0</ladder>
                        <jump>0</jump>
                    </verticalObstacles>
                    <hintLikelihood>1</hintLikelihood>
                </specification>
            </ClassroomDecorator>

                {}

            <ServerQuitWhenAnyAgentFinishes/>
        </ServerHandlers>
    </ServerSection>

    <AgentSection mode="Survival">
        <Name>Bob</Name>
        <AgentStart>
            <Placement x="-150" y="81.0" z="217.5"/>
            
            {}
            
        </AgentStart>
        <AgentHandlers>
            <VideoProducer want_depth="false">
                <Width>320</Width>
                <Height>240</Height>
            </VideoProducer>
            <ObservationFromFullStats/>

            <ObservationFromHotBar/>

            <ObservationFromRay/>

            <ContinuousMovementCommands turnSpeedDegs="180">
            </ContinuousMovementCommands>

            <AbsoluteMovementCommands/>
            <SimpleCraftCommands/>

            <MissionQuitCommands/>

            <!--<AgentQuitFromTouchingBlockType>-->
                <!--<Block type="gold_block diamond_block redstone_block" description="found_goal"/>-->
            <!--</AgentQuitFromTouchingBlockType>-->
        </AgentHandlers>
    </AgentSection>
</Mission>
""".format(seed, palette, n_rooms, n_rooms, n_gaps, n_bridges, n_doors, n_puzzles, generate_object_drawing(objects),
           inventory)

    if record:
        return create_basic_minecraft_env(xml)

    return create_minecraft_env(xml, wrap)

    # < RewardForMissionEnd
    # rewardForDeath = "-10000" >
    # < Reward
    # description = "found_goal"
    # reward = "2000" / >
    # < Reward
    # description = "out_of_time"
    # reward = "-1000" / >
    # < / RewardForMissionEnd >
    # < RewardForTouchingBlockType >
    # < Block
    # type = "gold_ore diamond_ore redstone_ore"
    # reward = "20" / >
    # < / RewardForTouchingBlockType >
