from gym.spaces import Discrete




class OptionSpace(Discrete):
    """"
    The OptionSpace is just a super-simple class that ensure our action space is always the discrete one. We also
    provide the length and iterator functionality here
    """

    def __init__(self, n, descriptor=None):
        super().__init__(n)
        if descriptor is None:
            self._descriptor = OptionSpace.__default_descriptor
        else:
            self._descriptor = descriptor

    def __len__(self):
        return self.n

    def __iter__(self):
        for x in range(0, self.n):
            yield x

    def describe(self, option):
        """
        Describe the given option
        :param option: the option
        :return: a human-readable description of the option
        """
        return self._descriptor(option)

    @staticmethod
    def __default_descriptor(option):
        return 'Option_' + str(option)

