# Neural Bandit Implementation
This repository provides an implementation of **combinatorial bandits**, where the agent can offer multiple arms at once.  
Setting `neural_or_lin = neural` and `n_assortment = 1` corresponds exactly to our setting.

## Directory tree

```bash
├── results/
├── bandit.py
├── options.py
├── experiment.py
└── run_experiments.sh

```
- `bandit.py` — core implementation of (combinatorial) bandits  
- `options.py` — definitions of the algorithms  
- `experiment.py` — runs and evaluates the algorithms in the paper  
- `run_experiments.sh` — script to reproduce results  

## Requirements
- python 3
- numpy
- torch
- tqdm

