#!/bin/bash

# choose gpu id
GPU_ID=0

# base python file
PY_SCRIPT=experiment.py   

# ----------------------------------------
# neural / lin + UCB / TS
# ----------------------------------------
for model in neural # lin
do
  for algo in UCB TS
  do
    for score in h1 # h1 h2 h3 h4
    do
      echo "Running $model with $algo and $score on GPU $GPU_ID"
      CUDA_VISIBLE_DEVICES=$GPU_ID python $PY_SCRIPT \
        --neural_or_lin $model \
        --algo $algo \
        --score_ftn $score \
        --noise_coef 0.01 \
        --unif False \
        --n_arms 20 \
        --n_features 80 \
        --n_assortment 1 \
        --n_samples 10 \
        --total_rounds 5000 \
        --n_sim 10 \
        --reg_factor 1.0 \
        --delta 0.1 \
        --nu 1.0 \
        --gamma 1.0 \
        --hidden_layer_width 200 \
        --epochs 100 \
        --dropout 0.0 \
        --learning_rate 0.005 \
        --training_period 50 \
        --training_window 5000 \
        --save results_${model}_${algo}_${score}.pkl
    done
  done
done


# ----------------------------------------
# KL-EXP
# ----------------------------------------
for ref in uniform
do
  for eta in  500 # 10 100 500
  do
     for score in h1 # h1 h2 h3 h4
    do
      echo "Running KL-EXP with $score (eta=$eta, ref=$ref) on GPU $GPU_ID"
      CUDA_VISIBLE_DEVICES=$GPU_ID python $PY_SCRIPT \
        --neural_or_lin neural \
        --algo kl-exp \
        --score_ftn $score \
        --noise_coef 0.01 \
        --unif False \
        --n_arms 20 \
        --n_features 80 \
        --n_assortment 1 \
        --n_samples 10 \
        --total_rounds 5000 \
        --n_sim 10 \
        --delta 0.1 \
        --nu 1.0 \
        --gamma 1.0 \
        --hidden_layer_width 200 \
        --epochs 100 \
        --dropout 0.0 \
        --learning_rate 0.005 \
        --training_period 50 \
        --training_window 5000 \
        --eta $eta \
        --ref_policy $ref \
        --save results_kl-exp_${score}_eta${eta}_${ref}.pkl
    done
  done
done
