import librosa  
import librosa.display  
import matplotlib.pyplot as plt  
  
# 1. 加载音频文件  
audio_file1 = '/home/v-zhijunjia/data/plots_pictures/clip_2_47_p248_003_20230916_091910_p248_003_ar_best-valid-losspt_nar_epoch-40pt_2023_09_16_09_17_37_3_0.wav'  
audio_file2 = '/home/v-zhijunjia/data/plots_pictures/p248_003_clip_2_47.wav'  
y1, sr1 = librosa.load(audio_file1)  
y2, sr2 = librosa.load(audio_file2)  
  
# 2. 创建两个子图  
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(14, 6))  
  
# 3. 绘制第一个波形图  
librosa.display.waveshow(y1, sr1, ax=ax1)  
  
# 4. 移除第一张图的"Time"属性  
ax1.set_xlabel("")  
ax1.set_ylabel("Amplitude", fontsize=18) 

# 5. 在第一个波形图框的上方添加transcript文本  
transcript1 = [  
    {'start_time': 0, 'end_time': 0.49, 'text': 'six'},  
    {'start_time': 0.49, 'end_time': 1.1, 'text': 'spoons of'},  
    {'start_time': 1.1, 'end_time': 1.38, 'text': 'fresh'},  
    {'start_time': 1.4, 'end_time': 1.7, 'text': 'snow'},  
    {'start_time': 1.85, 'end_time': 2.22, 'text': 'beas', 'bold': True, 'color': 'red'},  
]  
  
for item in transcript1:  
    start = item['start_time']  
    end = item['end_time']  
    middle = (start + end) / 2  
    text = item['text']  
    ax1.axvline(x=start, ymin=0, ymax=1, color='r', linestyle='--', linewidth=1)  
    ax1.text(middle, 1.0, text, fontsize=18, fontweight=('bold' if item.get('bold') else 'normal'), color=item.get('color', 'black'), transform=ax1.get_xaxis_transform(), ha='center')  
  
# 6. 绘制第二个波形图  
librosa.display.waveshow(y2, sr2, ax=ax2)  
  
# 7. 在第二个波形图框的上方添加transcript文本  
transcript2 = [  
    {'start_time': 0, 'end_time': 0.40, 'text': 'six'},  
    {'start_time': 0.40, 'end_time': 1.05, 'text': 'spoons of'},  
    {'start_time': 1.05, 'end_time': 1.48, 'text': 'fresh'},  
    {'start_time': 1.48, 'end_time': 1.75, 'text': 'snow'},  
    {'start_time': 1.9, 'end_time': 2.22, 'text': 'peas', 'bold': True, 'color': 'red'},  
]  
  
for item in transcript2:  
    start = item['start_time']  
    end = item['end_time']  
    middle = (start + end) / 2  
    text = item['text']  
    ax2.axvline(x=start, ymin=0, ymax=1, color='r', linestyle='--', linewidth=1)  
    ax2.text(middle, 1.0, text, fontsize=18, fontweight=('bold' if item.get('bold') else 'normal'), color=item.get('color', 'black'), transform=ax2.get_xaxis_transform(), ha='center')  
ax2.set_xlabel("Time(s)", fontsize=18)  
ax2.set_ylabel("Amplitude", fontsize=18)
# 8. 显示图形  
plt.show()  
  
# 9. 保存到指定文件夹  
output_image_file = 'your_output_image_file.png'  # 替换为您的输出图像文件路径  
plt.savefig(output_image_file, dpi=300)
# 5. 保存到当前文件夹  
plt.savefig('/home/v-zhijunjia/data/plots_pictures/audio_waveform_with_transcript_v2.png', dpi=300)  
