import random  
from scipy.stats import poisson  
import numpy as np
class MaskTransformer:  
    def apply_masking_strategy(self, item, mask_token=500, random_token=500, force_mask=False):      
        if force_mask:  
            return mask_token, True  
        else:  
            prob = random.random()      
            if prob < 0.8:      
                return mask_token, True    
            else:      
                prob2 = random.random()      
                if prob2 < 0.5:      
                    return item, False  
                else:      
                    return random.randint(0, random_token), True  
    def poisson_sampling(self, lam=3, size=1):  
        return np.random.poisson(lam, size)
    def mask_transform_v2(self, input_list, masking_ratio=0.3, mask_token=500, random_token=500):      
        num_masked = int(len(input_list) * masking_ratio)      
        masked_indices = sorted(random.sample(range(len(input_list)), num_masked))
        masked_list = []      
        masked_final_indices = []    
        i = 0  
        idx = 0  
        while i < len(input_list):  
            if i not in masked_indices or idx >= len(masked_indices):

                masked_final_indices.append(0)
                masked_list.append(input_list[i])  
                i += 1  
            else:    
                num_replacements = self.poisson_sampling(3,1)[0]
                force_mask = True if random.random() < 0.8 else False  
                  
                if force_mask:  
                    for _ in range(num_replacements):  
                        if i < len(input_list) and idx < len(masked_indices) :
                            if idx ==len(masked_indices)-1 or i< masked_indices[idx+1]:
                                masked_item, _ = self.apply_masking_strategy(input_list[i], mask_token, random_token=random_token, force_mask=force_mask) 
                                
                                masked_list.append(masked_item)  
                                masked_final_indices.append(1)  
                                i += 1  
                        else:  
                            break  
                else:  
                    masked_final_indices.append(0)  
                    masked_list.append(input_list[i])  
                    i += 1  
                  
                idx += 1  
          
        masked_final_indices = masked_final_indices[1:]+[0]  
        return masked_list, masked_final_indices  
  
mask_transformer = MaskTransformer()  
input_list = list(range(20))  
results = []  
for _ in range(1000):  
    masked_list, masked_final_indices = mask_transformer.mask_transform_v2(input_list)  
    results.append((masked_list, masked_final_indices))  
  
for i, result in enumerate(results):  
    print(f"Iteration {i + 1}:")  
    print("Masked list:", result[0])  
    print("Masked final indices:", result[1])  
    print()  
 
