# LFG

The code for semantic guesswork is split across three files that supplement and replace parts of the existing object navigation framework in the home-robot repository. The FBE baseline used is the same one provided by the home-robot repository. The base home-robot repository is >1GB and could not be included in the supplementary material; we intend to release all code publicly upon acceptance.

## language_planner_utils.py

This file contains helper functions for parsing the semantic maps generated by existing code in the home-robot repository. It includes functions for filtering semantic maps, detecting objects, defining object clusters, and converting these clusters into a list of text descriptions that can be fed into the language model.

Location in home-robot: `home-robot/src/home_robot/home_robot/navigation_planner`

## language_tools.py

This file contains the code for directly calling the language models and includes the prompts. Different functions are provided, although our complete implementation uses `ask_gpts_v2` on both positive and negative prompts. The other functions are provided to make it easier to run ablations and study the properties of different prompting strategies.

Location in home-robot: `home-robot/src/home_robot/home_robot/navigation_planner`

## language_planner.py

This file combines the methods and functions defined in language_tools.py and language_planner_utils.py to execute the LFG method. Modifications that distinguish the planner from the home-robot repository are located on lines 505 - 674.

Location in home-robot: `home-robot/src/home_robot/home_robot/navigation_planner`

## launch_full_eval.sh

This runs a distributed evaluation of the LFG method on the test set that splits the scenes across 5 GPUs and queries multiple openai API keys.

Location in home-robot: `root`

## eval_dataset_distributed.py

Executed by `launch_full_eval.sh` to run evaluation of the language method with given hyperparamteres, GPU ids, and API keys.

Locaiton in home-robot: `projects/habitat_objectnav`