# Analyzing and Improving Generative Adversarial Training for Generative Modeling and Out-of-Distribution Detection - Code

## Dependencies

See `requirements.txt`

## Download support files:
In the project directory:
```
$ wget https://maximin.s3.amazonaws.com/support_files.tar
$ tar xf support_files.tar
```

## Preparing datasets

By default, datasets are organized in the `datasets` dir:
```
$ ls datasets
Bedroom128  Bedroom256  CelebAHQ128  CelebAHQ256  imagenet128  imagenet256 ...
```

**ImageNet (the out-of-distribution dataset, or p_{-k}​)**

Download the ImageNet and resize images to 256x256. Files should be structured like

```
$ ls datasets/imagenet256
train val
$ ls datasets/imagenet256/train
n01440764  n01739381  n01978287  n02092002 ...
$ ls datasets/imagenet256/test
n01440764  n01739381  n01978287  n02092002 .. 
```
By default the CIFAR-10 task requires a 128x128 version of the ImageNet, because 128x128 images are much faster to load. The 128x128 version should be structured similarly to the 256x256 version.

**CelebA-HQ dataset**

Download the 512x512 version of CELEBA-HQ dataset from https://github.com/suvojit-0x55aa/celebA-HQ-dataset-download 
(use the Google Drive link provided in their README file).  Unzip the downloaded file to `./datasets/downloads/celebahq_files/`. Inside the `datasets` directory, run `bash create_celebahq.sh 256` to create the 256x256 version of the dataset,  and `bash create_celebahq.sh 128` to create the 128x128 version.

**Bedroom dataset**

Download the dataset from https://www.kaggle.com/jhoward/lsun_bedroom/data. Unzip the downloaded file to `./datasets/downloads/bedroom_files/`. Inside the `datasets` directory, run `bash create_bedroom.sh 256` to create the 256x256 version of the dataset,  and `bash create_bedroom.sh 128` to create the 128x128 version.

**CIFAR-10 and CIFAR-10-class0 datasets**

Downloading of CIFAR-10 and CIFAR-10-class0 datasets is automatically handled by the training script.

** iSUN, LSUN (resize), and TinyImageNet (resize) (for OOD detection evaluation)
Download tar files from https://github.com/facebookresearch/odin and decompress to the `./datasets` dir.

## Reproduce experimental results
- Experimental results can be reproduced using the notebooks.
  - Table 2(a) - `eval_cifar10-resnet3bn-OOD-ImageNet.ipynb`
  - Table 2(b) - `eval_celeba128.ipynb`
  - Table 2(c) - `eval_bedroom128.ipynb`
  - Table 3 - `eval_cifar10-resnet18-OOD-TinyImageNet.ipynb`
  - Table 4 - `eval_cifar10-resnet18-OOD-TinyImageNet.ipynb`
  - Table 9 - `eval_cifar10-class0-OOD-ImageNet.ipynb`
  - Table 10 - `eval_cifar10-class0-OOD-cifar10subset.ipynb`
  - Table 11,12 - `eval_cifar10-class0-OOD-uniform.ipynb`
  - Table 13,14 - `eval_cifar10-resnet3bn-OOD-ImageNet.ipynb`, `eval_cifar10-resnet3bn-OOD-TinyImageNet.ipynb`, `eval_cifar10-resnet18-OOD-TinyImageNet.ipynb`
  - Table 15-18 - `eval_cifar10-resnet3bn-OOD-ImageNet.ipynb`
  - Table 19,20,21 - `eval_cifar10-class0-OOD-ImageNet.ipynb`
  - Table 22-25 - `eval_celeba128.ipynb`
  - Table 26-29 - `eval_bedroom128.ipynb`
  - Table 30 - `eval_cifar10-resnet18-OOD-TinyImageNet-randomrestart.ipynb`
  - Table 31,32 - `eval_svhn-resnet18-OOD-TinyImageNet-randomrestart.ipynb`
  - Figure 3(a),13,16 - `eval_cifar10-resnet3bn-OOD-ImageNet.ipynb`
  - Figure 3(b),14,17 - `eval_celeba128.ipynb`
  - Figure 3(c),15,18 - `eval_bedroom128.ipynb`
  - Figure 19 - `generation_celebahq256.ipynb`
  - Figure 20 - `generation_bedroom256.ipynb`
  - Figure 21 - `generation_dog256.ipynb`
- 2D simulation results can be reproduced using `2Dtasks/2DTasks.ipynb`.
