#!/bin/bash
# https://stackoverflow.com/questions/5914513/shuffling-lines-of-a-file-with-a-fixed-seed
get_seeded_random()
{
  seed="$1"
  openssl enc -aes-256-ctr -pass pass:"$seed" -nosalt \
    </dev/zero 2>/dev/null
}


mkdir -p Bedroom"$1"/train/data

python resize_crop.py --size "$1" --datadir downloads/bedroom_files --savedir Bedroom"$1"/train/data


mkdir -p Bedroom"$1"/test/data

find Bedroom"$1"/train/data/ -type f | sort -R --random-source=<(get_seeded_random 42)  | head -n 3000 | xargs mv -t Bedroom"$1"/test/data

mkdir lsun_bedroom
find sample -type f | xargs mv -t lsun_bedroom


