function [z,s,A_u,A_v] = TwoDCANN(N,a,tau,tau_v,dt,T,ini_time,sample_time,J0,k,sigma_U,sigma_V,m)
    J = zeros(N, N);
    x = linspace(-pi, pi, N+1);
    pos = x(1: N);
    for i = 1: N
        for j = 1: N
            dx = min(pos(i)-pos(1), pi-pos(i));
            dy = min(pos(j)-pos(1), pi-pos(j));
            J(i, j) = J0/(2*pi*a^2) * exp(-(dx^2+dy^2)/(2*a^2));
        end
    end
    Jfft = fft2(J);
  
    Iext = zeros(N, N);
    U = zeros(N, N);
    V = zeros(N, N);
    r = zeros(N, N);

    z = zeros(2, (T-sample_time)/dt);
    s = zeros(2, (T-sample_time)/dt);
    A_u = zeros(1, (T-sample_time)/dt);
    A_v = zeros(1, (T-sample_time)/dt);
    
    i = 0;
    alpha = 1;
    for t = dt:dt:T-dt   
        if t < ini_time
            for x = 1:N
                for y = 1:N
                    Iext(x,y)=alpha.*exp(-(pos(x)^2+pos(y)^2)/2/a^2); %initialization bump at (0,0)
                end
            end
        else
            Iext = 0;
        end
        
        dU = dt * (-U + ifft2(Jfft.*fft2(r)) - V + Iext + (sigma_U*sqrt(tau/dt)).*normrnd(0,1,[N,N]))/tau;
        
            
        U = U + dU;
%         dV = dt * (-V + m.*U + (sigma_V*sqrt(tau_v/dt)).*normrnd(0,1,[N,N])) / tau_v;
        dV = dt * (-V + m.*U + (sigma_V*sqrt(tau_v/dt)).*normrnd(0,1,[N,N]).*U) / tau_v;
        V = V + dV;
        U = max(U, 0);
        r = U.^2./(1+k*sum(U(:).^2));
        
%         subplot(1,2,1);
%         imagesc(V);
%         axis equal
%         drawnow  
%     	subplot(1,2,2);
%         imagesc(U);
%         axis equal
     
        if t >= sample_time
            i = i + 1;
            z(:,i) = expectation(U);
            s(:,i) = z(:,i) - expectation(V);
            s(:,i) = min(abs(s(:,i)),2*pi-abs(s(:,i)));
            A_u(i) = max(max(U));
            A_v(i) = max(max(V));
        end
        
    end
end




% plot(1:i,Ss);
% disp(max(Ss));
% disp(min(Ss));


