%2D CANN perform Levy flight
N = 128;
a = pi/10;
tau = 1;
tau_v = 100;
dt = tau/10;
T=80000;
ini_time = 30;
sample_time = 50;
J0 = 1;
k = 0.05;
lenth = (T-sample_time)/dt;
sigma_U = 0.03;
sigma_V = 0.15;
m = (tau/tau_v)*1;
density = N*N/(4*pi^2);
tic
[z,s,A_u,A_v] = TwoDCANN(N,a,tau,tau_v,dt,T,ini_time,sample_time,J0,k,sigma_U,sigma_V,m);
toc
figure
stepsize = 50;
zz = z(:,1:stepsize*(floor(end/stepsize)-1)+1);
plot_z = zz(:,1:stepsize:end);
c = linspace(1,2,length(plot_z(1,:)));
scatter(plot_z(1,:),plot_z(2,:),2,c);
set(gca,'Box','on');
axis([-pi,pi,-pi,pi]);
t = title('z trace in 2D attractor space');
t.FontSize =24;

%%2D CANN perform Brownian motion
N = 128;
a = pi/10;
tau = 1;
tau_v = 100;
dt = tau/10;
T=80000;
ini_time = 30;
sample_time = 50;
J0 = 1;
k = 0.05;
lenth = (T-sample_time)/dt;
sigma_U = 0.03;
sigma_V = 0.0;
m = (tau/tau_v)*1;
density = N*N/(4*pi^2);
tic
[z,s,A_u,A_v] = TwoDCANN(N,a,tau,tau_v,dt,T,ini_time,sample_time,J0,k,sigma_U,sigma_V,m);
toc
figure
stepsize = 50;
zz = z(:,1:stepsize*(floor(end/stepsize)-1)+1);
plot_z = zz(:,1:stepsize:end);
c = linspace(1,2,length(plot_z(1,:)));
scatter(plot_z(1,:),plot_z(2,:),2,c);
set(gca,'Box','on');
axis([-pi,pi,-pi,pi]);
t = title('z trace in 2D attractor space');
t.FontSize =24;