# class Action

 **Member values** 

|Member name|Data type|Description|
|-----------|---------|-----------|
|handle| [ActionHandle](ActionHandle.md#)|Reference to the action \(useful when updating an existing action\)|
|name|string|Action friendly name|
|application\_data|string|Application data \(reserved for use by Web App\)|
|send\_twist\_command|oneof:action\_parameters [TwistCommand](TwistCommand.md#)|Control the tool in velocity|
|send\_wrench\_command|oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)|Control the tool in force \(EXPERIMENTAL\)|
|send\_joint\_speeds|oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)|Action to control each joint speed|
|reach\_pose|oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)|Reach a pose given Cartesian constraints. This action will be deprecated in a future version and will be replaced by execute\_waypoint\_list.|
|reach\_joint\_angles|oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)|Reach a series of joint angles given angular constraints. This action will be deprecated in a future version and will be replaced by execute\_waypoint\_list.|
|toggle\_admittance\_mode|oneof:action\_parameters uint32|Enable or disable the admittance mode|
|snapshot|oneof:action\_parameters [Snapshot](Snapshot.md#)|Take a snapshot of current robot position|
|switch\_control\_mapping|oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)|Switch the active controller map|
|navigate\_joints|oneof:action\_parameters uint32|Select the next actuator to control in a map|
|navigate\_mappings|oneof:action\_parameters uint32|Select a different map|
|change\_twist|oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)|Change tool twist|
|change\_joint\_speeds|oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)|Change the joint speeds individually|
|change\_wrench|oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)|Change the Cartesian force|
|apply\_emergency\_stop|oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)|Apply robot emergency stop|
|clear\_faults|oneof:action\_parameters [Faults](Faults.md#)|Clear faults. Robot will be able to move if there is no more fault \(see BaseCyclic.BaseFeedback.\[fault\_bank\_a | fault\_bank\_b\]\)|
|delay|oneof:action\_parameters [Delay](Delay.md#)|Apply a delay|
|execute\_action|oneof:action\_parameters [ActionHandle](ActionHandle.md#)|Execute an existing action|
|send\_gripper\_command|oneof:action\_parameters [GripperCommand](GripperCommand.md#)|Send a gripper command|
|send\_gpio\_command|oneof:action\_parameters [GpioCommand](GpioCommand.md#)|Send a gpio command \(not implemented yet\)|
|stop\_action|oneof:action\_parameters [Stop](Stop.md#)|Stop movement|
|play\_pre\_computed\_trajectory|oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)|Play a pre-computed joint trajectory|
|execute\_sequence|oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)|Execute an existing sequence|
|execute\_waypoint\_list|oneof:action\_parameters [WaypointList](WaypointList.md#)|Execute a trajectory defined by a series of waypoints|

 **Member functions** 

|Function name|Return type|Input type|Description|
|-------------|-----------|----------|-----------|
|has\_handle\(\) const|bool|void|Returns true if handle is set.|
|handle\(\)|const [ActionHandle](ActionHandle.md#)&|void|Returns the current value of handle. If handle is not set, returns a [ActionHandle](ActionHandle.md#) with none of its fields set \(possibly handle::default\_instance\(\)\).|
|mutable\_handle\(\)| [ActionHandle](ActionHandle.md#) \*|void|Returns a pointer to the mutable [ActionHandle](ActionHandle.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [ActionHandle](ActionHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [ActionHandle](ActionHandle.md#)\). After calling this, has\_handle\(\) will return true and handle\(\) will return a reference to the same instance of [ActionHandle](ActionHandle.md#).|
|clear\_handle\(\)|void|void|Clears the value of the field. After calling this, has\_handle\(\) will return false and handle\(\) will return the default value.|
|set\_allocated\_handle\(\)|void| [ActionHandle](ActionHandle.md#) \*|Sets the [ActionHandle](ActionHandle.md#) object to the field and frees the previous field value if it exists. If the [ActionHandle](ActionHandle.md#) pointer is not NULL, the message takes ownership of the allocated [ActionHandle](ActionHandle.md#) object and has\_ [ActionHandle](ActionHandle.md#)\(\) will return true. Otherwise, if the handle is NULL, the behavior is the same as calling clear\_handle\(\).|
|release\_handle\(\)| [ActionHandle](ActionHandle.md#) \*|void|Releases the ownership of the field and returns the pointer of the [ActionHandle](ActionHandle.md#) object. After calling this, caller takes the ownership of the allocated [ActionHandle](ActionHandle.md#) object, has\_handle\(\) will return false, and handle\(\) will return the default value.|
|name\(\)|const string&|void|Returns the current value of name. If name is not set, returns the empty string/empty bytes.|
|set\_name\(\)|void|const string&|Sets the value of name. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|string&&|\(C++11 and beyond\): Sets the value of name, moving from the passed string. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|const char\*|Sets the value of name using a C-style null-terminated string. After calling this, name\(\) will return a copy of value.|
|mutable\_name\(\)|string \*|void|Returns a pointer to the mutable string object that stores name's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, name\(\) will return whatever value is written into the given string.|
|clear\_name\(\)|void|void|Clears the value of name. After calling this, name\(\) will return the empty string/empty bytes.|
|set\_allocated\_name\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_name\(\).|
|release\_name\(\)|string \*|void|Releases the ownership of name and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and name\(\) will return the empty string/empty bytes.|
|application\_data\(\)|const string&|void|Returns the current value of application\_data. If application\_data is not set, returns the empty string/empty bytes.|
|set\_application\_data\(\)|void|const string&|Sets the value of application\_data. After calling this, application\_data\(\) will return a copy of value.|
|set\_application\_data\(\)|void|string&&|\(C++11 and beyond\): Sets the value of application\_data, moving from the passed string. After calling this, application\_data\(\) will return a copy of value.|
|set\_application\_data\(\)|void|const char\*|Sets the value of application\_data using a C-style null-terminated string. After calling this, application\_data\(\) will return a copy of value.|
|mutable\_application\_data\(\)|string \*|void|Returns a pointer to the mutable string object that stores application\_data's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, application\_data\(\) will return whatever value is written into the given string.|
|clear\_application\_data\(\)|void|void|Clears the value of application\_data. After calling this, application\_data\(\) will return the empty string/empty bytes.|
|set\_allocated\_application\_data\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_application\_data\(\).|
|release\_application\_data\(\)|string \*|void|Releases the ownership of application\_data and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and application\_data\(\) will return the empty string/empty bytes.|
|has\_send\_twist\_command\(\) const|void|void|Returns the current value of the field if oneof case is kSend\_twist\_command. Otherwise, returns oneof:action\_parameters [TwistCommand](TwistCommand.md#)::default\_instance\(\)|
|send\_twist\_command\(\) const|const oneof:action\_parameters [TwistCommand](TwistCommand.md#)&|void|Returns the current value of the field if oneof case is kSend\_twist\_command|
|mutable\_send\_twist\_command\(\)|oneof:action\_parameters [TwistCommand](TwistCommand.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSend\_twist\_command and returns a pointer to the mutable oneof:action\_parameters [TwistCommand](TwistCommand.md#) object that stores the field's value. If the oneof case was not kSend\_twist\_command prior to the call, then the returned oneof:action\_parameters [TwistCommand](TwistCommand.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [TwistCommand](TwistCommand.md#)\). After calling this, has\_send\_twist\_command\(\) will return true, send\_twist\_command\(\) will return a reference to the same instance of oneof:action\_parameters [TwistCommand](TwistCommand.md#) and action\_parameters\_case\(\) will return kSend\_twist\_command|
|clear\_send\_twist\_command\(\)|void|void|Nothing will be changed if the oneof case is not kSend\_twist\_command. If the oneof case equals kSend\_twist\_command, frees the field and clears the oneof case. has\_send\_twist\_command\(\) will return false, send\_twist\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_send\_twist\_command\(\)|void|oneof:action\_parameters [TwistCommand](TwistCommand.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [TwistCommand](TwistCommand.md#) pointer is not NULL: Sets the oneof:action\_parameters [TwistCommand](TwistCommand.md#) object to the field and sets the oneof case to kSend\_twist\_command. The message takes ownership of the allocated oneof:action\_parameters [TwistCommand](TwistCommand.md#) object, has\_send\_twist\_command\(\) will return true and action\_parameters\_case\(\) will return kSend\_twist\_command. If the pointer is NULL, has\_send\_twist\_command\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_send\_twist\_command\(\)|oneof:action\_parameters [TwistCommand](TwistCommand.md#)\*|void|Returns NULL if oneof case is not kSend\_twist\_command. If the oneof case is kSend\_twist\_command, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_send\_twist\_command\(\) will return false, send\_twist\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_send\_wrench\_command\(\) const|void|void|Returns the current value of the field if oneof case is kSend\_wrench\_command. Otherwise, returns oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)::default\_instance\(\)|
|send\_wrench\_command\(\) const|const oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)&|void|Returns the current value of the field if oneof case is kSend\_wrench\_command|
|mutable\_send\_wrench\_command\(\)|oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSend\_wrench\_command and returns a pointer to the mutable oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) object that stores the field's value. If the oneof case was not kSend\_wrench\_command prior to the call, then the returned oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)\). After calling this, has\_send\_wrench\_command\(\) will return true, send\_wrench\_command\(\) will return a reference to the same instance of oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) and action\_parameters\_case\(\) will return kSend\_wrench\_command|
|clear\_send\_wrench\_command\(\)|void|void|Nothing will be changed if the oneof case is not kSend\_wrench\_command. If the oneof case equals kSend\_wrench\_command, frees the field and clears the oneof case. has\_send\_wrench\_command\(\) will return false, send\_wrench\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_send\_wrench\_command\(\)|void|oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) pointer is not NULL: Sets the oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) object to the field and sets the oneof case to kSend\_wrench\_command. The message takes ownership of the allocated oneof:action\_parameters [WrenchCommand](WrenchCommand.md#) object, has\_send\_wrench\_command\(\) will return true and action\_parameters\_case\(\) will return kSend\_wrench\_command. If the pointer is NULL, has\_send\_wrench\_command\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_send\_wrench\_command\(\)|oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)\*|void|Returns NULL if oneof case is not kSend\_wrench\_command. If the oneof case is kSend\_wrench\_command, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_send\_wrench\_command\(\) will return false, send\_wrench\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_send\_joint\_speeds\(\) const|void|void|Returns the current value of the field if oneof case is kSend\_joint\_speeds. Otherwise, returns oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)::default\_instance\(\)|
|send\_joint\_speeds\(\) const|const oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)&|void|Returns the current value of the field if oneof case is kSend\_joint\_speeds|
|mutable\_send\_joint\_speeds\(\)|oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSend\_joint\_speeds and returns a pointer to the mutable oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) object that stores the field's value. If the oneof case was not kSend\_joint\_speeds prior to the call, then the returned oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)\). After calling this, has\_send\_joint\_speeds\(\) will return true, send\_joint\_speeds\(\) will return a reference to the same instance of oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) and action\_parameters\_case\(\) will return kSend\_joint\_speeds|
|clear\_send\_joint\_speeds\(\)|void|void|Nothing will be changed if the oneof case is not kSend\_joint\_speeds. If the oneof case equals kSend\_joint\_speeds, frees the field and clears the oneof case. has\_send\_joint\_speeds\(\) will return false, send\_joint\_speeds\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_send\_joint\_speeds\(\)|void|oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) pointer is not NULL: Sets the oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) object to the field and sets the oneof case to kSend\_joint\_speeds. The message takes ownership of the allocated oneof:action\_parameters [JointSpeeds](JointSpeeds.md#) object, has\_send\_joint\_speeds\(\) will return true and action\_parameters\_case\(\) will return kSend\_joint\_speeds. If the pointer is NULL, has\_send\_joint\_speeds\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_send\_joint\_speeds\(\)|oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)\*|void|Returns NULL if oneof case is not kSend\_joint\_speeds. If the oneof case is kSend\_joint\_speeds, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_send\_joint\_speeds\(\) will return false, send\_joint\_speeds\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_reach\_pose\(\) const|void|void|Returns the current value of the field if oneof case is kReach\_pose. Otherwise, returns oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)::default\_instance\(\)|
|reach\_pose\(\) const|const oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)&|void|Returns the current value of the field if oneof case is kReach\_pose|
|mutable\_reach\_pose\(\)|oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kReach\_pose and returns a pointer to the mutable oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) object that stores the field's value. If the oneof case was not kReach\_pose prior to the call, then the returned oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)\). After calling this, has\_reach\_pose\(\) will return true, reach\_pose\(\) will return a reference to the same instance of oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) and action\_parameters\_case\(\) will return kReach\_pose|
|clear\_reach\_pose\(\)|void|void|Nothing will be changed if the oneof case is not kReach\_pose. If the oneof case equals kReach\_pose, frees the field and clears the oneof case. has\_reach\_pose\(\) will return false, reach\_pose\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_reach\_pose\(\)|void|oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) pointer is not NULL: Sets the oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) object to the field and sets the oneof case to kReach\_pose. The message takes ownership of the allocated oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#) object, has\_reach\_pose\(\) will return true and action\_parameters\_case\(\) will return kReach\_pose. If the pointer is NULL, has\_reach\_pose\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_reach\_pose\(\)|oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)\*|void|Returns NULL if oneof case is not kReach\_pose. If the oneof case is kReach\_pose, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_reach\_pose\(\) will return false, reach\_pose\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_reach\_joint\_angles\(\) const|void|void|Returns the current value of the field if oneof case is kReach\_joint\_angles. Otherwise, returns oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)::default\_instance\(\)|
|reach\_joint\_angles\(\) const|const oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)&|void|Returns the current value of the field if oneof case is kReach\_joint\_angles|
|mutable\_reach\_joint\_angles\(\)|oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kReach\_joint\_angles and returns a pointer to the mutable oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) object that stores the field's value. If the oneof case was not kReach\_joint\_angles prior to the call, then the returned oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)\). After calling this, has\_reach\_joint\_angles\(\) will return true, reach\_joint\_angles\(\) will return a reference to the same instance of oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) and action\_parameters\_case\(\) will return kReach\_joint\_angles|
|clear\_reach\_joint\_angles\(\)|void|void|Nothing will be changed if the oneof case is not kReach\_joint\_angles. If the oneof case equals kReach\_joint\_angles, frees the field and clears the oneof case. has\_reach\_joint\_angles\(\) will return false, reach\_joint\_angles\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_reach\_joint\_angles\(\)|void|oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) pointer is not NULL: Sets the oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) object to the field and sets the oneof case to kReach\_joint\_angles. The message takes ownership of the allocated oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#) object, has\_reach\_joint\_angles\(\) will return true and action\_parameters\_case\(\) will return kReach\_joint\_angles. If the pointer is NULL, has\_reach\_joint\_angles\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_reach\_joint\_angles\(\)|oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)\*|void|Returns NULL if oneof case is not kReach\_joint\_angles. If the oneof case is kReach\_joint\_angles, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_reach\_joint\_angles\(\) will return false, reach\_joint\_angles\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_toggle\_admittance\_mode\(\)|void|oneof:action\_parameters uint32|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the value of this field and sets the oneof case to kToggle\_admittance\_mode.|
|toggle\_admittance\_mode\(\) const|oneof:action\_parameters uint32|void|Returns the current value of the field if oneof case is kToggle\_admittance\_mode. Otherwise, returns the default value.|
|clear\_toggle\_admittance\_mode\(\)|void|void|Nothing will be changed if the oneof case is not kToggle\_admittance\_mode. If the oneof case is kToggle\_admittance\_mode, clears the value of the field and the oneof case|
|has\_snapshot\(\) const|void|void|Returns the current value of the field if oneof case is kSnapshot. Otherwise, returns oneof:action\_parameters [Snapshot](Snapshot.md#)::default\_instance\(\)|
|snapshot\(\) const|const oneof:action\_parameters [Snapshot](Snapshot.md#)&|void|Returns the current value of the field if oneof case is kSnapshot|
|mutable\_snapshot\(\)|oneof:action\_parameters [Snapshot](Snapshot.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSnapshot and returns a pointer to the mutable oneof:action\_parameters [Snapshot](Snapshot.md#) object that stores the field's value. If the oneof case was not kSnapshot prior to the call, then the returned oneof:action\_parameters [Snapshot](Snapshot.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [Snapshot](Snapshot.md#)\). After calling this, has\_snapshot\(\) will return true, snapshot\(\) will return a reference to the same instance of oneof:action\_parameters [Snapshot](Snapshot.md#) and action\_parameters\_case\(\) will return kSnapshot|
|clear\_snapshot\(\)|void|void|Nothing will be changed if the oneof case is not kSnapshot. If the oneof case equals kSnapshot, frees the field and clears the oneof case. has\_snapshot\(\) will return false, snapshot\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_snapshot\(\)|void|oneof:action\_parameters [Snapshot](Snapshot.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [Snapshot](Snapshot.md#) pointer is not NULL: Sets the oneof:action\_parameters [Snapshot](Snapshot.md#) object to the field and sets the oneof case to kSnapshot. The message takes ownership of the allocated oneof:action\_parameters [Snapshot](Snapshot.md#) object, has\_snapshot\(\) will return true and action\_parameters\_case\(\) will return kSnapshot. If the pointer is NULL, has\_snapshot\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_snapshot\(\)|oneof:action\_parameters [Snapshot](Snapshot.md#)\*|void|Returns NULL if oneof case is not kSnapshot. If the oneof case is kSnapshot, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_snapshot\(\) will return false, snapshot\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_switch\_control\_mapping\(\) const|void|void|Returns the current value of the field if oneof case is kSwitch\_control\_mapping. Otherwise, returns oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)::default\_instance\(\)|
|switch\_control\_mapping\(\) const|const oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)&|void|Returns the current value of the field if oneof case is kSwitch\_control\_mapping|
|mutable\_switch\_control\_mapping\(\)|oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSwitch\_control\_mapping and returns a pointer to the mutable oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) object that stores the field's value. If the oneof case was not kSwitch\_control\_mapping prior to the call, then the returned oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)\). After calling this, has\_switch\_control\_mapping\(\) will return true, switch\_control\_mapping\(\) will return a reference to the same instance of oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) and action\_parameters\_case\(\) will return kSwitch\_control\_mapping|
|clear\_switch\_control\_mapping\(\)|void|void|Nothing will be changed if the oneof case is not kSwitch\_control\_mapping. If the oneof case equals kSwitch\_control\_mapping, frees the field and clears the oneof case. has\_switch\_control\_mapping\(\) will return false, switch\_control\_mapping\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_switch\_control\_mapping\(\)|void|oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) pointer is not NULL: Sets the oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) object to the field and sets the oneof case to kSwitch\_control\_mapping. The message takes ownership of the allocated oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#) object, has\_switch\_control\_mapping\(\) will return true and action\_parameters\_case\(\) will return kSwitch\_control\_mapping. If the pointer is NULL, has\_switch\_control\_mapping\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_switch\_control\_mapping\(\)|oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)\*|void|Returns NULL if oneof case is not kSwitch\_control\_mapping. If the oneof case is kSwitch\_control\_mapping, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_switch\_control\_mapping\(\) will return false, switch\_control\_mapping\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_navigate\_joints\(\)|void|oneof:action\_parameters uint32|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the value of this field and sets the oneof case to kNavigate\_joints.|
|navigate\_joints\(\) const|oneof:action\_parameters uint32|void|Returns the current value of the field if oneof case is kNavigate\_joints. Otherwise, returns the default value.|
|clear\_navigate\_joints\(\)|void|void|Nothing will be changed if the oneof case is not kNavigate\_joints. If the oneof case is kNavigate\_joints, clears the value of the field and the oneof case|
|set\_navigate\_mappings\(\)|void|oneof:action\_parameters uint32|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the value of this field and sets the oneof case to kNavigate\_mappings.|
|navigate\_mappings\(\) const|oneof:action\_parameters uint32|void|Returns the current value of the field if oneof case is kNavigate\_mappings. Otherwise, returns the default value.|
|clear\_navigate\_mappings\(\)|void|void|Nothing will be changed if the oneof case is not kNavigate\_mappings. If the oneof case is kNavigate\_mappings, clears the value of the field and the oneof case|
|has\_change\_twist\(\) const|void|void|Returns the current value of the field if oneof case is kChange\_twist. Otherwise, returns oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)::default\_instance\(\)|
|change\_twist\(\) const|const oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)&|void|Returns the current value of the field if oneof case is kChange\_twist|
|mutable\_change\_twist\(\)|oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kChange\_twist and returns a pointer to the mutable oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) object that stores the field's value. If the oneof case was not kChange\_twist prior to the call, then the returned oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)\). After calling this, has\_change\_twist\(\) will return true, change\_twist\(\) will return a reference to the same instance of oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) and action\_parameters\_case\(\) will return kChange\_twist|
|clear\_change\_twist\(\)|void|void|Nothing will be changed if the oneof case is not kChange\_twist. If the oneof case equals kChange\_twist, frees the field and clears the oneof case. has\_change\_twist\(\) will return false, change\_twist\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_change\_twist\(\)|void|oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) pointer is not NULL: Sets the oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) object to the field and sets the oneof case to kChange\_twist. The message takes ownership of the allocated oneof:action\_parameters [ChangeTwist](ChangeTwist.md#) object, has\_change\_twist\(\) will return true and action\_parameters\_case\(\) will return kChange\_twist. If the pointer is NULL, has\_change\_twist\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_change\_twist\(\)|oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)\*|void|Returns NULL if oneof case is not kChange\_twist. If the oneof case is kChange\_twist, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_change\_twist\(\) will return false, change\_twist\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_change\_joint\_speeds\(\) const|void|void|Returns the current value of the field if oneof case is kChange\_joint\_speeds. Otherwise, returns oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)::default\_instance\(\)|
|change\_joint\_speeds\(\) const|const oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)&|void|Returns the current value of the field if oneof case is kChange\_joint\_speeds|
|mutable\_change\_joint\_speeds\(\)|oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kChange\_joint\_speeds and returns a pointer to the mutable oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) object that stores the field's value. If the oneof case was not kChange\_joint\_speeds prior to the call, then the returned oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)\). After calling this, has\_change\_joint\_speeds\(\) will return true, change\_joint\_speeds\(\) will return a reference to the same instance of oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) and action\_parameters\_case\(\) will return kChange\_joint\_speeds|
|clear\_change\_joint\_speeds\(\)|void|void|Nothing will be changed if the oneof case is not kChange\_joint\_speeds. If the oneof case equals kChange\_joint\_speeds, frees the field and clears the oneof case. has\_change\_joint\_speeds\(\) will return false, change\_joint\_speeds\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_change\_joint\_speeds\(\)|void|oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) pointer is not NULL: Sets the oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) object to the field and sets the oneof case to kChange\_joint\_speeds. The message takes ownership of the allocated oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#) object, has\_change\_joint\_speeds\(\) will return true and action\_parameters\_case\(\) will return kChange\_joint\_speeds. If the pointer is NULL, has\_change\_joint\_speeds\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_change\_joint\_speeds\(\)|oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)\*|void|Returns NULL if oneof case is not kChange\_joint\_speeds. If the oneof case is kChange\_joint\_speeds, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_change\_joint\_speeds\(\) will return false, change\_joint\_speeds\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_change\_wrench\(\) const|void|void|Returns the current value of the field if oneof case is kChange\_wrench. Otherwise, returns oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)::default\_instance\(\)|
|change\_wrench\(\) const|const oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)&|void|Returns the current value of the field if oneof case is kChange\_wrench|
|mutable\_change\_wrench\(\)|oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kChange\_wrench and returns a pointer to the mutable oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) object that stores the field's value. If the oneof case was not kChange\_wrench prior to the call, then the returned oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)\). After calling this, has\_change\_wrench\(\) will return true, change\_wrench\(\) will return a reference to the same instance of oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) and action\_parameters\_case\(\) will return kChange\_wrench|
|clear\_change\_wrench\(\)|void|void|Nothing will be changed if the oneof case is not kChange\_wrench. If the oneof case equals kChange\_wrench, frees the field and clears the oneof case. has\_change\_wrench\(\) will return false, change\_wrench\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_change\_wrench\(\)|void|oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) pointer is not NULL: Sets the oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) object to the field and sets the oneof case to kChange\_wrench. The message takes ownership of the allocated oneof:action\_parameters [ChangeWrench](ChangeWrench.md#) object, has\_change\_wrench\(\) will return true and action\_parameters\_case\(\) will return kChange\_wrench. If the pointer is NULL, has\_change\_wrench\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_change\_wrench\(\)|oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)\*|void|Returns NULL if oneof case is not kChange\_wrench. If the oneof case is kChange\_wrench, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_change\_wrench\(\) will return false, change\_wrench\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_apply\_emergency\_stop\(\) const|void|void|Returns the current value of the field if oneof case is kApply\_emergency\_stop. Otherwise, returns oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)::default\_instance\(\)|
|apply\_emergency\_stop\(\) const|const oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)&|void|Returns the current value of the field if oneof case is kApply\_emergency\_stop|
|mutable\_apply\_emergency\_stop\(\)|oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kApply\_emergency\_stop and returns a pointer to the mutable oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) object that stores the field's value. If the oneof case was not kApply\_emergency\_stop prior to the call, then the returned oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)\). After calling this, has\_apply\_emergency\_stop\(\) will return true, apply\_emergency\_stop\(\) will return a reference to the same instance of oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) and action\_parameters\_case\(\) will return kApply\_emergency\_stop|
|clear\_apply\_emergency\_stop\(\)|void|void|Nothing will be changed if the oneof case is not kApply\_emergency\_stop. If the oneof case equals kApply\_emergency\_stop, frees the field and clears the oneof case. has\_apply\_emergency\_stop\(\) will return false, apply\_emergency\_stop\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_apply\_emergency\_stop\(\)|void|oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) pointer is not NULL: Sets the oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) object to the field and sets the oneof case to kApply\_emergency\_stop. The message takes ownership of the allocated oneof:action\_parameters [EmergencyStop](EmergencyStop.md#) object, has\_apply\_emergency\_stop\(\) will return true and action\_parameters\_case\(\) will return kApply\_emergency\_stop. If the pointer is NULL, has\_apply\_emergency\_stop\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_apply\_emergency\_stop\(\)|oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)\*|void|Returns NULL if oneof case is not kApply\_emergency\_stop. If the oneof case is kApply\_emergency\_stop, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_apply\_emergency\_stop\(\) will return false, apply\_emergency\_stop\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_clear\_faults\(\) const|void|void|Returns the current value of the field if oneof case is kClear\_faults. Otherwise, returns oneof:action\_parameters [Faults](Faults.md#)::default\_instance\(\)|
|clear\_faults\(\) const|const oneof:action\_parameters [Faults](Faults.md#)&|void|Returns the current value of the field if oneof case is kClear\_faults|
|mutable\_clear\_faults\(\)|oneof:action\_parameters [Faults](Faults.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kClear\_faults and returns a pointer to the mutable oneof:action\_parameters [Faults](Faults.md#) object that stores the field's value. If the oneof case was not kClear\_faults prior to the call, then the returned oneof:action\_parameters [Faults](Faults.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [Faults](Faults.md#)\). After calling this, has\_clear\_faults\(\) will return true, clear\_faults\(\) will return a reference to the same instance of oneof:action\_parameters [Faults](Faults.md#) and action\_parameters\_case\(\) will return kClear\_faults|
|clear\_clear\_faults\(\)|void|void|Nothing will be changed if the oneof case is not kClear\_faults. If the oneof case equals kClear\_faults, frees the field and clears the oneof case. has\_clear\_faults\(\) will return false, clear\_faults\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_clear\_faults\(\)|void|oneof:action\_parameters [Faults](Faults.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [Faults](Faults.md#) pointer is not NULL: Sets the oneof:action\_parameters [Faults](Faults.md#) object to the field and sets the oneof case to kClear\_faults. The message takes ownership of the allocated oneof:action\_parameters [Faults](Faults.md#) object, has\_clear\_faults\(\) will return true and action\_parameters\_case\(\) will return kClear\_faults. If the pointer is NULL, has\_clear\_faults\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_clear\_faults\(\)|oneof:action\_parameters [Faults](Faults.md#)\*|void|Returns NULL if oneof case is not kClear\_faults. If the oneof case is kClear\_faults, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_clear\_faults\(\) will return false, clear\_faults\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_delay\(\) const|void|void|Returns the current value of the field if oneof case is kDelay. Otherwise, returns oneof:action\_parameters [Delay](Delay.md#)::default\_instance\(\)|
|delay\(\) const|const oneof:action\_parameters [Delay](Delay.md#)&|void|Returns the current value of the field if oneof case is kDelay|
|mutable\_delay\(\)|oneof:action\_parameters [Delay](Delay.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kDelay and returns a pointer to the mutable oneof:action\_parameters [Delay](Delay.md#) object that stores the field's value. If the oneof case was not kDelay prior to the call, then the returned oneof:action\_parameters [Delay](Delay.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [Delay](Delay.md#)\). After calling this, has\_delay\(\) will return true, delay\(\) will return a reference to the same instance of oneof:action\_parameters [Delay](Delay.md#) and action\_parameters\_case\(\) will return kDelay|
|clear\_delay\(\)|void|void|Nothing will be changed if the oneof case is not kDelay. If the oneof case equals kDelay, frees the field and clears the oneof case. has\_delay\(\) will return false, delay\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_delay\(\)|void|oneof:action\_parameters [Delay](Delay.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [Delay](Delay.md#) pointer is not NULL: Sets the oneof:action\_parameters [Delay](Delay.md#) object to the field and sets the oneof case to kDelay. The message takes ownership of the allocated oneof:action\_parameters [Delay](Delay.md#) object, has\_delay\(\) will return true and action\_parameters\_case\(\) will return kDelay. If the pointer is NULL, has\_delay\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_delay\(\)|oneof:action\_parameters [Delay](Delay.md#)\*|void|Returns NULL if oneof case is not kDelay. If the oneof case is kDelay, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_delay\(\) will return false, delay\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_execute\_action\(\) const|void|void|Returns the current value of the field if oneof case is kExecute\_action. Otherwise, returns oneof:action\_parameters [ActionHandle](ActionHandle.md#)::default\_instance\(\)|
|execute\_action\(\) const|const oneof:action\_parameters [ActionHandle](ActionHandle.md#)&|void|Returns the current value of the field if oneof case is kExecute\_action|
|mutable\_execute\_action\(\)|oneof:action\_parameters [ActionHandle](ActionHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kExecute\_action and returns a pointer to the mutable oneof:action\_parameters [ActionHandle](ActionHandle.md#) object that stores the field's value. If the oneof case was not kExecute\_action prior to the call, then the returned oneof:action\_parameters [ActionHandle](ActionHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [ActionHandle](ActionHandle.md#)\). After calling this, has\_execute\_action\(\) will return true, execute\_action\(\) will return a reference to the same instance of oneof:action\_parameters [ActionHandle](ActionHandle.md#) and action\_parameters\_case\(\) will return kExecute\_action|
|clear\_execute\_action\(\)|void|void|Nothing will be changed if the oneof case is not kExecute\_action. If the oneof case equals kExecute\_action, frees the field and clears the oneof case. has\_execute\_action\(\) will return false, execute\_action\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_execute\_action\(\)|void|oneof:action\_parameters [ActionHandle](ActionHandle.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [ActionHandle](ActionHandle.md#) pointer is not NULL: Sets the oneof:action\_parameters [ActionHandle](ActionHandle.md#) object to the field and sets the oneof case to kExecute\_action. The message takes ownership of the allocated oneof:action\_parameters [ActionHandle](ActionHandle.md#) object, has\_execute\_action\(\) will return true and action\_parameters\_case\(\) will return kExecute\_action. If the pointer is NULL, has\_execute\_action\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_execute\_action\(\)|oneof:action\_parameters [ActionHandle](ActionHandle.md#)\*|void|Returns NULL if oneof case is not kExecute\_action. If the oneof case is kExecute\_action, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_execute\_action\(\) will return false, execute\_action\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_send\_gripper\_command\(\) const|void|void|Returns the current value of the field if oneof case is kSend\_gripper\_command. Otherwise, returns oneof:action\_parameters [GripperCommand](GripperCommand.md#)::default\_instance\(\)|
|send\_gripper\_command\(\) const|const oneof:action\_parameters [GripperCommand](GripperCommand.md#)&|void|Returns the current value of the field if oneof case is kSend\_gripper\_command|
|mutable\_send\_gripper\_command\(\)|oneof:action\_parameters [GripperCommand](GripperCommand.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSend\_gripper\_command and returns a pointer to the mutable oneof:action\_parameters [GripperCommand](GripperCommand.md#) object that stores the field's value. If the oneof case was not kSend\_gripper\_command prior to the call, then the returned oneof:action\_parameters [GripperCommand](GripperCommand.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [GripperCommand](GripperCommand.md#)\). After calling this, has\_send\_gripper\_command\(\) will return true, send\_gripper\_command\(\) will return a reference to the same instance of oneof:action\_parameters [GripperCommand](GripperCommand.md#) and action\_parameters\_case\(\) will return kSend\_gripper\_command|
|clear\_send\_gripper\_command\(\)|void|void|Nothing will be changed if the oneof case is not kSend\_gripper\_command. If the oneof case equals kSend\_gripper\_command, frees the field and clears the oneof case. has\_send\_gripper\_command\(\) will return false, send\_gripper\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_send\_gripper\_command\(\)|void|oneof:action\_parameters [GripperCommand](GripperCommand.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [GripperCommand](GripperCommand.md#) pointer is not NULL: Sets the oneof:action\_parameters [GripperCommand](GripperCommand.md#) object to the field and sets the oneof case to kSend\_gripper\_command. The message takes ownership of the allocated oneof:action\_parameters [GripperCommand](GripperCommand.md#) object, has\_send\_gripper\_command\(\) will return true and action\_parameters\_case\(\) will return kSend\_gripper\_command. If the pointer is NULL, has\_send\_gripper\_command\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_send\_gripper\_command\(\)|oneof:action\_parameters [GripperCommand](GripperCommand.md#)\*|void|Returns NULL if oneof case is not kSend\_gripper\_command. If the oneof case is kSend\_gripper\_command, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_send\_gripper\_command\(\) will return false, send\_gripper\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_send\_gpio\_command\(\) const|void|void|Returns the current value of the field if oneof case is kSend\_gpio\_command. Otherwise, returns oneof:action\_parameters [GpioCommand](GpioCommand.md#)::default\_instance\(\)|
|send\_gpio\_command\(\) const|const oneof:action\_parameters [GpioCommand](GpioCommand.md#)&|void|Returns the current value of the field if oneof case is kSend\_gpio\_command|
|mutable\_send\_gpio\_command\(\)|oneof:action\_parameters [GpioCommand](GpioCommand.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kSend\_gpio\_command and returns a pointer to the mutable oneof:action\_parameters [GpioCommand](GpioCommand.md#) object that stores the field's value. If the oneof case was not kSend\_gpio\_command prior to the call, then the returned oneof:action\_parameters [GpioCommand](GpioCommand.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [GpioCommand](GpioCommand.md#)\). After calling this, has\_send\_gpio\_command\(\) will return true, send\_gpio\_command\(\) will return a reference to the same instance of oneof:action\_parameters [GpioCommand](GpioCommand.md#) and action\_parameters\_case\(\) will return kSend\_gpio\_command|
|clear\_send\_gpio\_command\(\)|void|void|Nothing will be changed if the oneof case is not kSend\_gpio\_command. If the oneof case equals kSend\_gpio\_command, frees the field and clears the oneof case. has\_send\_gpio\_command\(\) will return false, send\_gpio\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_send\_gpio\_command\(\)|void|oneof:action\_parameters [GpioCommand](GpioCommand.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [GpioCommand](GpioCommand.md#) pointer is not NULL: Sets the oneof:action\_parameters [GpioCommand](GpioCommand.md#) object to the field and sets the oneof case to kSend\_gpio\_command. The message takes ownership of the allocated oneof:action\_parameters [GpioCommand](GpioCommand.md#) object, has\_send\_gpio\_command\(\) will return true and action\_parameters\_case\(\) will return kSend\_gpio\_command. If the pointer is NULL, has\_send\_gpio\_command\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_send\_gpio\_command\(\)|oneof:action\_parameters [GpioCommand](GpioCommand.md#)\*|void|Returns NULL if oneof case is not kSend\_gpio\_command. If the oneof case is kSend\_gpio\_command, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_send\_gpio\_command\(\) will return false, send\_gpio\_command\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_stop\_action\(\) const|void|void|Returns the current value of the field if oneof case is kStop\_action. Otherwise, returns oneof:action\_parameters [Stop](Stop.md#)::default\_instance\(\)|
|stop\_action\(\) const|const oneof:action\_parameters [Stop](Stop.md#)&|void|Returns the current value of the field if oneof case is kStop\_action|
|mutable\_stop\_action\(\)|oneof:action\_parameters [Stop](Stop.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kStop\_action and returns a pointer to the mutable oneof:action\_parameters [Stop](Stop.md#) object that stores the field's value. If the oneof case was not kStop\_action prior to the call, then the returned oneof:action\_parameters [Stop](Stop.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [Stop](Stop.md#)\). After calling this, has\_stop\_action\(\) will return true, stop\_action\(\) will return a reference to the same instance of oneof:action\_parameters [Stop](Stop.md#) and action\_parameters\_case\(\) will return kStop\_action|
|clear\_stop\_action\(\)|void|void|Nothing will be changed if the oneof case is not kStop\_action. If the oneof case equals kStop\_action, frees the field and clears the oneof case. has\_stop\_action\(\) will return false, stop\_action\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_stop\_action\(\)|void|oneof:action\_parameters [Stop](Stop.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [Stop](Stop.md#) pointer is not NULL: Sets the oneof:action\_parameters [Stop](Stop.md#) object to the field and sets the oneof case to kStop\_action. The message takes ownership of the allocated oneof:action\_parameters [Stop](Stop.md#) object, has\_stop\_action\(\) will return true and action\_parameters\_case\(\) will return kStop\_action. If the pointer is NULL, has\_stop\_action\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_stop\_action\(\)|oneof:action\_parameters [Stop](Stop.md#)\*|void|Returns NULL if oneof case is not kStop\_action. If the oneof case is kStop\_action, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_stop\_action\(\) will return false, stop\_action\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_play\_pre\_computed\_trajectory\(\) const|void|void|Returns the current value of the field if oneof case is kPlay\_pre\_computed\_trajectory. Otherwise, returns oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)::default\_instance\(\)|
|play\_pre\_computed\_trajectory\(\) const|const oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)&|void|Returns the current value of the field if oneof case is kPlay\_pre\_computed\_trajectory|
|mutable\_play\_pre\_computed\_trajectory\(\)|oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kPlay\_pre\_computed\_trajectory and returns a pointer to the mutable oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) object that stores the field's value. If the oneof case was not kPlay\_pre\_computed\_trajectory prior to the call, then the returned oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)\). After calling this, has\_play\_pre\_computed\_trajectory\(\) will return true, play\_pre\_computed\_trajectory\(\) will return a reference to the same instance of oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) and action\_parameters\_case\(\) will return kPlay\_pre\_computed\_trajectory|
|clear\_play\_pre\_computed\_trajectory\(\)|void|void|Nothing will be changed if the oneof case is not kPlay\_pre\_computed\_trajectory. If the oneof case equals kPlay\_pre\_computed\_trajectory, frees the field and clears the oneof case. has\_play\_pre\_computed\_trajectory\(\) will return false, play\_pre\_computed\_trajectory\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_play\_pre\_computed\_trajectory\(\)|void|oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) pointer is not NULL: Sets the oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) object to the field and sets the oneof case to kPlay\_pre\_computed\_trajectory. The message takes ownership of the allocated oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#) object, has\_play\_pre\_computed\_trajectory\(\) will return true and action\_parameters\_case\(\) will return kPlay\_pre\_computed\_trajectory. If the pointer is NULL, has\_play\_pre\_computed\_trajectory\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_play\_pre\_computed\_trajectory\(\)|oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)\*|void|Returns NULL if oneof case is not kPlay\_pre\_computed\_trajectory. If the oneof case is kPlay\_pre\_computed\_trajectory, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_play\_pre\_computed\_trajectory\(\) will return false, play\_pre\_computed\_trajectory\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_execute\_sequence\(\) const|void|void|Returns the current value of the field if oneof case is kExecute\_sequence. Otherwise, returns oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)::default\_instance\(\)|
|execute\_sequence\(\) const|const oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)&|void|Returns the current value of the field if oneof case is kExecute\_sequence|
|mutable\_execute\_sequence\(\)|oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kExecute\_sequence and returns a pointer to the mutable oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) object that stores the field's value. If the oneof case was not kExecute\_sequence prior to the call, then the returned oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)\). After calling this, has\_execute\_sequence\(\) will return true, execute\_sequence\(\) will return a reference to the same instance of oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) and action\_parameters\_case\(\) will return kExecute\_sequence|
|clear\_execute\_sequence\(\)|void|void|Nothing will be changed if the oneof case is not kExecute\_sequence. If the oneof case equals kExecute\_sequence, frees the field and clears the oneof case. has\_execute\_sequence\(\) will return false, execute\_sequence\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_execute\_sequence\(\)|void|oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) pointer is not NULL: Sets the oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) object to the field and sets the oneof case to kExecute\_sequence. The message takes ownership of the allocated oneof:action\_parameters [SequenceHandle](SequenceHandle.md#) object, has\_execute\_sequence\(\) will return true and action\_parameters\_case\(\) will return kExecute\_sequence. If the pointer is NULL, has\_execute\_sequence\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_execute\_sequence\(\)|oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)\*|void|Returns NULL if oneof case is not kExecute\_sequence. If the oneof case is kExecute\_sequence, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_execute\_sequence\(\) will return false, execute\_sequence\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|has\_execute\_waypoint\_list\(\) const|void|void|Returns the current value of the field if oneof case is kExecute\_waypoint\_list. Otherwise, returns oneof:action\_parameters [WaypointList](WaypointList.md#)::default\_instance\(\)|
|execute\_waypoint\_list\(\) const|const oneof:action\_parameters [WaypointList](WaypointList.md#)&|void|Returns the current value of the field if oneof case is kExecute\_waypoint\_list|
|mutable\_execute\_waypoint\_list\(\)|oneof:action\_parameters [WaypointList](WaypointList.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_action\_parameters\(\). Sets the oneof case to kExecute\_waypoint\_list and returns a pointer to the mutable oneof:action\_parameters [WaypointList](WaypointList.md#) object that stores the field's value. If the oneof case was not kExecute\_waypoint\_list prior to the call, then the returned oneof:action\_parameters [WaypointList](WaypointList.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:action\_parameters [WaypointList](WaypointList.md#)\). After calling this, has\_execute\_waypoint\_list\(\) will return true, execute\_waypoint\_list\(\) will return a reference to the same instance of oneof:action\_parameters [WaypointList](WaypointList.md#) and action\_parameters\_case\(\) will return kExecute\_waypoint\_list|
|clear\_execute\_waypoint\_list\(\)|void|void|Nothing will be changed if the oneof case is not kExecute\_waypoint\_list. If the oneof case equals kExecute\_waypoint\_list, frees the field and clears the oneof case. has\_execute\_waypoint\_list\(\) will return false, execute\_waypoint\_list\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|
|set\_allocated\_execute\_waypoint\_list\(\)|void|oneof:action\_parameters [WaypointList](WaypointList.md#)\*|Calls clear\_action\_parameters\(\). If the oneof:action\_parameters [WaypointList](WaypointList.md#) pointer is not NULL: Sets the oneof:action\_parameters [WaypointList](WaypointList.md#) object to the field and sets the oneof case to kExecute\_waypoint\_list. The message takes ownership of the allocated oneof:action\_parameters [WaypointList](WaypointList.md#) object, has\_execute\_waypoint\_list\(\) will return true and action\_parameters\_case\(\) will return kExecute\_waypoint\_list. If the pointer is NULL, has\_execute\_waypoint\_list\(\) will return false and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET. \(The behavior is like calling clear\_action\_parameters\(\)\)|
|release\_execute\_waypoint\_list\(\)|oneof:action\_parameters [WaypointList](WaypointList.md#)\*|void|Returns NULL if oneof case is not kExecute\_waypoint\_list. If the oneof case is kExecute\_waypoint\_list, clears the oneof case, releases the ownership of the field and returns the pointer of the action\_parameters object. After calling this, caller takes the ownership of the allocated action\_parameters object, has\_execute\_waypoint\_list\(\) will return false, execute\_waypoint\_list\(\) will return the default value and action\_parameters\_case\(\) will return ACTION\_PARAMETERS\_NOT\_SET.|

**Parent topic:** [Base \(C++\)](../../summary_pages/Base.md)

