# class ConfigurationChangeNotification

 **Member values** 

|Member name|Data type|Description|
|-----------|---------|-----------|
|event|uint32|Configuration event|
|timestamp| [Timestamp](../Common/Timestamp.md#)|Event timestamp|
|user\_handle| [UserProfileHandle](../Common/UserProfileHandle.md#)|User that caused the configuration event|
|sequence\_handle|oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)|Sequence for which the configuration changed|
|action\_handle|oneof:configuration\_change [ActionHandle](ActionHandle.md#)|Action for which the configuration changed|
|mapping\_handle|oneof:configuration\_change [MappingHandle](MappingHandle.md#)|Mapping for which the configuration changed|
|map\_group\_handle|oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)|Map group for which the configuration changed|
|map\_handle|oneof:configuration\_change [MapHandle](MapHandle.md#)|Map for which the configuration changed|
|user\_profile\_handle|oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)|User Profile for which the configuration changed|
|protection\_zone\_handle|oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)|Protection zone for which the configuration changed|
|safety\_handle|oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)|Safety for which the configuration changed|
|network\_handle|oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)|Network element for which the configuration changed|
|ssid|oneof:configuration\_change [Ssid](Ssid.md#)|Wi-Fi instance for which the configuration changed|
|controller\_handle|oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)|Controller instance for which the configuration changed|
|connection| [Connection](../Common/Connection.md#)|Connection that caused the configuration event|

 **Member functions** 

|Function name|Return type|Input type|Description|
|-------------|-----------|----------|-----------|
|event\(\) const|uint32|void|Returns the current value of event. If the event is not set, returns 0.|
|set\_event\(\)|void|uint32|Sets the value of event. After calling this, event\(\) will return value.|
|clear\_event\(\)|void|void|Clears the value of event. After calling this, event\(\) will return the empty string/empty bytes.|
|has\_timestamp\(\) const|bool|void|Returns true if timestamp is set.|
|timestamp\(\)|const [Timestamp](../Common/Timestamp.md#)&|void|Returns the current value of timestamp. If timestamp is not set, returns a [Timestamp](../Common/Timestamp.md#) with none of its fields set \(possibly timestamp::default\_instance\(\)\).|
|mutable\_timestamp\(\)| [Timestamp](../Common/Timestamp.md#) \*|void|Returns a pointer to the mutable [Timestamp](../Common/Timestamp.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [Timestamp](../Common/Timestamp.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [Timestamp](../Common/Timestamp.md#)\). After calling this, has\_timestamp\(\) will return true and timestamp\(\) will return a reference to the same instance of [Timestamp](../Common/Timestamp.md#).|
|clear\_timestamp\(\)|void|void|Clears the value of the field. After calling this, has\_timestamp\(\) will return false and timestamp\(\) will return the default value.|
|set\_allocated\_timestamp\(\)|void| [Timestamp](../Common/Timestamp.md#) \*|Sets the [Timestamp](../Common/Timestamp.md#) object to the field and frees the previous field value if it exists. If the [Timestamp](../Common/Timestamp.md#) pointer is not NULL, the message takes ownership of the allocated [Timestamp](../Common/Timestamp.md#) object and has\_ [Timestamp](../Common/Timestamp.md#)\(\) will return true. Otherwise, if the timestamp is NULL, the behavior is the same as calling clear\_timestamp\(\).|
|release\_timestamp\(\)| [Timestamp](../Common/Timestamp.md#) \*|void|Releases the ownership of the field and returns the pointer of the [Timestamp](../Common/Timestamp.md#) object. After calling this, caller takes the ownership of the allocated [Timestamp](../Common/Timestamp.md#) object, has\_timestamp\(\) will return false, and timestamp\(\) will return the default value.|
|has\_user\_handle\(\) const|bool|void|Returns true if user\_handle is set.|
|user\_handle\(\)|const [UserProfileHandle](../Common/UserProfileHandle.md#)&|void|Returns the current value of user\_handle. If user\_handle is not set, returns a [UserProfileHandle](../Common/UserProfileHandle.md#) with none of its fields set \(possibly user\_handle::default\_instance\(\)\).|
|mutable\_user\_handle\(\)| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|void|Returns a pointer to the mutable [UserProfileHandle](../Common/UserProfileHandle.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [UserProfileHandle](../Common/UserProfileHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [UserProfileHandle](../Common/UserProfileHandle.md#)\). After calling this, has\_user\_handle\(\) will return true and user\_handle\(\) will return a reference to the same instance of [UserProfileHandle](../Common/UserProfileHandle.md#).|
|clear\_user\_handle\(\)|void|void|Clears the value of the field. After calling this, has\_user\_handle\(\) will return false and user\_handle\(\) will return the default value.|
|set\_allocated\_user\_handle\(\)|void| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|Sets the [UserProfileHandle](../Common/UserProfileHandle.md#) object to the field and frees the previous field value if it exists. If the [UserProfileHandle](../Common/UserProfileHandle.md#) pointer is not NULL, the message takes ownership of the allocated [UserProfileHandle](../Common/UserProfileHandle.md#) object and has\_ [UserProfileHandle](../Common/UserProfileHandle.md#)\(\) will return true. Otherwise, if the user\_handle is NULL, the behavior is the same as calling clear\_user\_handle\(\).|
|release\_user\_handle\(\)| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|void|Releases the ownership of the field and returns the pointer of the [UserProfileHandle](../Common/UserProfileHandle.md#) object. After calling this, caller takes the ownership of the allocated [UserProfileHandle](../Common/UserProfileHandle.md#) object, has\_user\_handle\(\) will return false, and user\_handle\(\) will return the default value.|
|has\_sequence\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kSequence\_handle. Otherwise, returns oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)::default\_instance\(\)|
|sequence\_handle\(\) const|const oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)&|void|Returns the current value of the field if oneof case is kSequence\_handle|
|mutable\_sequence\_handle\(\)|oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kSequence\_handle and returns a pointer to the mutable oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) object that stores the field's value. If the oneof case was not kSequence\_handle prior to the call, then the returned oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)\). After calling this, has\_sequence\_handle\(\) will return true, sequence\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) and configuration\_change\_case\(\) will return kSequence\_handle|
|clear\_sequence\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kSequence\_handle. If the oneof case equals kSequence\_handle, frees the field and clears the oneof case. has\_sequence\_handle\(\) will return false, sequence\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_sequence\_handle\(\)|void|oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) object to the field and sets the oneof case to kSequence\_handle. The message takes ownership of the allocated oneof:configuration\_change [SequenceHandle](SequenceHandle.md#) object, has\_sequence\_handle\(\) will return true and configuration\_change\_case\(\) will return kSequence\_handle. If the pointer is NULL, has\_sequence\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_sequence\_handle\(\)|oneof:configuration\_change [SequenceHandle](SequenceHandle.md#)\*|void|Returns NULL if oneof case is not kSequence\_handle. If the oneof case is kSequence\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_sequence\_handle\(\) will return false, sequence\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_action\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kAction\_handle. Otherwise, returns oneof:configuration\_change [ActionHandle](ActionHandle.md#)::default\_instance\(\)|
|action\_handle\(\) const|const oneof:configuration\_change [ActionHandle](ActionHandle.md#)&|void|Returns the current value of the field if oneof case is kAction\_handle|
|mutable\_action\_handle\(\)|oneof:configuration\_change [ActionHandle](ActionHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kAction\_handle and returns a pointer to the mutable oneof:configuration\_change [ActionHandle](ActionHandle.md#) object that stores the field's value. If the oneof case was not kAction\_handle prior to the call, then the returned oneof:configuration\_change [ActionHandle](ActionHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [ActionHandle](ActionHandle.md#)\). After calling this, has\_action\_handle\(\) will return true, action\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [ActionHandle](ActionHandle.md#) and configuration\_change\_case\(\) will return kAction\_handle|
|clear\_action\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kAction\_handle. If the oneof case equals kAction\_handle, frees the field and clears the oneof case. has\_action\_handle\(\) will return false, action\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_action\_handle\(\)|void|oneof:configuration\_change [ActionHandle](ActionHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [ActionHandle](ActionHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [ActionHandle](ActionHandle.md#) object to the field and sets the oneof case to kAction\_handle. The message takes ownership of the allocated oneof:configuration\_change [ActionHandle](ActionHandle.md#) object, has\_action\_handle\(\) will return true and configuration\_change\_case\(\) will return kAction\_handle. If the pointer is NULL, has\_action\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_action\_handle\(\)|oneof:configuration\_change [ActionHandle](ActionHandle.md#)\*|void|Returns NULL if oneof case is not kAction\_handle. If the oneof case is kAction\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_action\_handle\(\) will return false, action\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_mapping\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kMapping\_handle. Otherwise, returns oneof:configuration\_change [MappingHandle](MappingHandle.md#)::default\_instance\(\)|
|mapping\_handle\(\) const|const oneof:configuration\_change [MappingHandle](MappingHandle.md#)&|void|Returns the current value of the field if oneof case is kMapping\_handle|
|mutable\_mapping\_handle\(\)|oneof:configuration\_change [MappingHandle](MappingHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kMapping\_handle and returns a pointer to the mutable oneof:configuration\_change [MappingHandle](MappingHandle.md#) object that stores the field's value. If the oneof case was not kMapping\_handle prior to the call, then the returned oneof:configuration\_change [MappingHandle](MappingHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [MappingHandle](MappingHandle.md#)\). After calling this, has\_mapping\_handle\(\) will return true, mapping\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [MappingHandle](MappingHandle.md#) and configuration\_change\_case\(\) will return kMapping\_handle|
|clear\_mapping\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kMapping\_handle. If the oneof case equals kMapping\_handle, frees the field and clears the oneof case. has\_mapping\_handle\(\) will return false, mapping\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_mapping\_handle\(\)|void|oneof:configuration\_change [MappingHandle](MappingHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [MappingHandle](MappingHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [MappingHandle](MappingHandle.md#) object to the field and sets the oneof case to kMapping\_handle. The message takes ownership of the allocated oneof:configuration\_change [MappingHandle](MappingHandle.md#) object, has\_mapping\_handle\(\) will return true and configuration\_change\_case\(\) will return kMapping\_handle. If the pointer is NULL, has\_mapping\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_mapping\_handle\(\)|oneof:configuration\_change [MappingHandle](MappingHandle.md#)\*|void|Returns NULL if oneof case is not kMapping\_handle. If the oneof case is kMapping\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_mapping\_handle\(\) will return false, mapping\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_map\_group\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kMap\_group\_handle. Otherwise, returns oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)::default\_instance\(\)|
|map\_group\_handle\(\) const|const oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)&|void|Returns the current value of the field if oneof case is kMap\_group\_handle|
|mutable\_map\_group\_handle\(\)|oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kMap\_group\_handle and returns a pointer to the mutable oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) object that stores the field's value. If the oneof case was not kMap\_group\_handle prior to the call, then the returned oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)\). After calling this, has\_map\_group\_handle\(\) will return true, map\_group\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) and configuration\_change\_case\(\) will return kMap\_group\_handle|
|clear\_map\_group\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kMap\_group\_handle. If the oneof case equals kMap\_group\_handle, frees the field and clears the oneof case. has\_map\_group\_handle\(\) will return false, map\_group\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_map\_group\_handle\(\)|void|oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) object to the field and sets the oneof case to kMap\_group\_handle. The message takes ownership of the allocated oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#) object, has\_map\_group\_handle\(\) will return true and configuration\_change\_case\(\) will return kMap\_group\_handle. If the pointer is NULL, has\_map\_group\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_map\_group\_handle\(\)|oneof:configuration\_change [MapGroupHandle](MapGroupHandle.md#)\*|void|Returns NULL if oneof case is not kMap\_group\_handle. If the oneof case is kMap\_group\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_map\_group\_handle\(\) will return false, map\_group\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_map\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kMap\_handle. Otherwise, returns oneof:configuration\_change [MapHandle](MapHandle.md#)::default\_instance\(\)|
|map\_handle\(\) const|const oneof:configuration\_change [MapHandle](MapHandle.md#)&|void|Returns the current value of the field if oneof case is kMap\_handle|
|mutable\_map\_handle\(\)|oneof:configuration\_change [MapHandle](MapHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kMap\_handle and returns a pointer to the mutable oneof:configuration\_change [MapHandle](MapHandle.md#) object that stores the field's value. If the oneof case was not kMap\_handle prior to the call, then the returned oneof:configuration\_change [MapHandle](MapHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [MapHandle](MapHandle.md#)\). After calling this, has\_map\_handle\(\) will return true, map\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [MapHandle](MapHandle.md#) and configuration\_change\_case\(\) will return kMap\_handle|
|clear\_map\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kMap\_handle. If the oneof case equals kMap\_handle, frees the field and clears the oneof case. has\_map\_handle\(\) will return false, map\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_map\_handle\(\)|void|oneof:configuration\_change [MapHandle](MapHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [MapHandle](MapHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [MapHandle](MapHandle.md#) object to the field and sets the oneof case to kMap\_handle. The message takes ownership of the allocated oneof:configuration\_change [MapHandle](MapHandle.md#) object, has\_map\_handle\(\) will return true and configuration\_change\_case\(\) will return kMap\_handle. If the pointer is NULL, has\_map\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_map\_handle\(\)|oneof:configuration\_change [MapHandle](MapHandle.md#)\*|void|Returns NULL if oneof case is not kMap\_handle. If the oneof case is kMap\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_map\_handle\(\) will return false, map\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_user\_profile\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kUser\_profile\_handle. Otherwise, returns oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)::default\_instance\(\)|
|user\_profile\_handle\(\) const|const oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)&|void|Returns the current value of the field if oneof case is kUser\_profile\_handle|
|mutable\_user\_profile\_handle\(\)|oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kUser\_profile\_handle and returns a pointer to the mutable oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) object that stores the field's value. If the oneof case was not kUser\_profile\_handle prior to the call, then the returned oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)\). After calling this, has\_user\_profile\_handle\(\) will return true, user\_profile\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) and configuration\_change\_case\(\) will return kUser\_profile\_handle|
|clear\_user\_profile\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kUser\_profile\_handle. If the oneof case equals kUser\_profile\_handle, frees the field and clears the oneof case. has\_user\_profile\_handle\(\) will return false, user\_profile\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_user\_profile\_handle\(\)|void|oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) object to the field and sets the oneof case to kUser\_profile\_handle. The message takes ownership of the allocated oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#) object, has\_user\_profile\_handle\(\) will return true and configuration\_change\_case\(\) will return kUser\_profile\_handle. If the pointer is NULL, has\_user\_profile\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_user\_profile\_handle\(\)|oneof:configuration\_change [UserProfileHandle](../Common/UserProfileHandle.md#)\*|void|Returns NULL if oneof case is not kUser\_profile\_handle. If the oneof case is kUser\_profile\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_user\_profile\_handle\(\) will return false, user\_profile\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_protection\_zone\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kProtection\_zone\_handle. Otherwise, returns oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)::default\_instance\(\)|
|protection\_zone\_handle\(\) const|const oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)&|void|Returns the current value of the field if oneof case is kProtection\_zone\_handle|
|mutable\_protection\_zone\_handle\(\)|oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kProtection\_zone\_handle and returns a pointer to the mutable oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) object that stores the field's value. If the oneof case was not kProtection\_zone\_handle prior to the call, then the returned oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)\). After calling this, has\_protection\_zone\_handle\(\) will return true, protection\_zone\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) and configuration\_change\_case\(\) will return kProtection\_zone\_handle|
|clear\_protection\_zone\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kProtection\_zone\_handle. If the oneof case equals kProtection\_zone\_handle, frees the field and clears the oneof case. has\_protection\_zone\_handle\(\) will return false, protection\_zone\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_protection\_zone\_handle\(\)|void|oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) object to the field and sets the oneof case to kProtection\_zone\_handle. The message takes ownership of the allocated oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#) object, has\_protection\_zone\_handle\(\) will return true and configuration\_change\_case\(\) will return kProtection\_zone\_handle. If the pointer is NULL, has\_protection\_zone\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_protection\_zone\_handle\(\)|oneof:configuration\_change [ProtectionZoneHandle](ProtectionZoneHandle.md#)\*|void|Returns NULL if oneof case is not kProtection\_zone\_handle. If the oneof case is kProtection\_zone\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_protection\_zone\_handle\(\) will return false, protection\_zone\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_safety\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kSafety\_handle. Otherwise, returns oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)::default\_instance\(\)|
|safety\_handle\(\) const|const oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)&|void|Returns the current value of the field if oneof case is kSafety\_handle|
|mutable\_safety\_handle\(\)|oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kSafety\_handle and returns a pointer to the mutable oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) object that stores the field's value. If the oneof case was not kSafety\_handle prior to the call, then the returned oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)\). After calling this, has\_safety\_handle\(\) will return true, safety\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) and configuration\_change\_case\(\) will return kSafety\_handle|
|clear\_safety\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kSafety\_handle. If the oneof case equals kSafety\_handle, frees the field and clears the oneof case. has\_safety\_handle\(\) will return false, safety\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_safety\_handle\(\)|void|oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) object to the field and sets the oneof case to kSafety\_handle. The message takes ownership of the allocated oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#) object, has\_safety\_handle\(\) will return true and configuration\_change\_case\(\) will return kSafety\_handle. If the pointer is NULL, has\_safety\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_safety\_handle\(\)|oneof:configuration\_change [SafetyHandle](../Common/SafetyHandle.md#)\*|void|Returns NULL if oneof case is not kSafety\_handle. If the oneof case is kSafety\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_safety\_handle\(\) will return false, safety\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_network\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kNetwork\_handle. Otherwise, returns oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)::default\_instance\(\)|
|network\_handle\(\) const|const oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)&|void|Returns the current value of the field if oneof case is kNetwork\_handle|
|mutable\_network\_handle\(\)|oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kNetwork\_handle and returns a pointer to the mutable oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) object that stores the field's value. If the oneof case was not kNetwork\_handle prior to the call, then the returned oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)\). After calling this, has\_network\_handle\(\) will return true, network\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) and configuration\_change\_case\(\) will return kNetwork\_handle|
|clear\_network\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kNetwork\_handle. If the oneof case equals kNetwork\_handle, frees the field and clears the oneof case. has\_network\_handle\(\) will return false, network\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_network\_handle\(\)|void|oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) object to the field and sets the oneof case to kNetwork\_handle. The message takes ownership of the allocated oneof:configuration\_change [NetworkHandle](NetworkHandle.md#) object, has\_network\_handle\(\) will return true and configuration\_change\_case\(\) will return kNetwork\_handle. If the pointer is NULL, has\_network\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_network\_handle\(\)|oneof:configuration\_change [NetworkHandle](NetworkHandle.md#)\*|void|Returns NULL if oneof case is not kNetwork\_handle. If the oneof case is kNetwork\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_network\_handle\(\) will return false, network\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_ssid\(\) const|void|void|Returns the current value of the field if oneof case is kSsid. Otherwise, returns oneof:configuration\_change [Ssid](Ssid.md#)::default\_instance\(\)|
|ssid\(\) const|const oneof:configuration\_change [Ssid](Ssid.md#)&|void|Returns the current value of the field if oneof case is kSsid|
|mutable\_ssid\(\)|oneof:configuration\_change [Ssid](Ssid.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kSsid and returns a pointer to the mutable oneof:configuration\_change [Ssid](Ssid.md#) object that stores the field's value. If the oneof case was not kSsid prior to the call, then the returned oneof:configuration\_change [Ssid](Ssid.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [Ssid](Ssid.md#)\). After calling this, has\_ssid\(\) will return true, ssid\(\) will return a reference to the same instance of oneof:configuration\_change [Ssid](Ssid.md#) and configuration\_change\_case\(\) will return kSsid|
|clear\_ssid\(\)|void|void|Nothing will be changed if the oneof case is not kSsid. If the oneof case equals kSsid, frees the field and clears the oneof case. has\_ssid\(\) will return false, ssid\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_ssid\(\)|void|oneof:configuration\_change [Ssid](Ssid.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [Ssid](Ssid.md#) pointer is not NULL: Sets the oneof:configuration\_change [Ssid](Ssid.md#) object to the field and sets the oneof case to kSsid. The message takes ownership of the allocated oneof:configuration\_change [Ssid](Ssid.md#) object, has\_ssid\(\) will return true and configuration\_change\_case\(\) will return kSsid. If the pointer is NULL, has\_ssid\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_ssid\(\)|oneof:configuration\_change [Ssid](Ssid.md#)\*|void|Returns NULL if oneof case is not kSsid. If the oneof case is kSsid, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_ssid\(\) will return false, ssid\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_controller\_handle\(\) const|void|void|Returns the current value of the field if oneof case is kController\_handle. Otherwise, returns oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)::default\_instance\(\)|
|controller\_handle\(\) const|const oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)&|void|Returns the current value of the field if oneof case is kController\_handle|
|mutable\_controller\_handle\(\)|oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_configuration\_change\(\). Sets the oneof case to kController\_handle and returns a pointer to the mutable oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) object that stores the field's value. If the oneof case was not kController\_handle prior to the call, then the returned oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)\). After calling this, has\_controller\_handle\(\) will return true, controller\_handle\(\) will return a reference to the same instance of oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) and configuration\_change\_case\(\) will return kController\_handle|
|clear\_controller\_handle\(\)|void|void|Nothing will be changed if the oneof case is not kController\_handle. If the oneof case equals kController\_handle, frees the field and clears the oneof case. has\_controller\_handle\(\) will return false, controller\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|set\_allocated\_controller\_handle\(\)|void|oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)\*|Calls clear\_configuration\_change\(\). If the oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) pointer is not NULL: Sets the oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) object to the field and sets the oneof case to kController\_handle. The message takes ownership of the allocated oneof:configuration\_change [ControllerHandle](ControllerHandle.md#) object, has\_controller\_handle\(\) will return true and configuration\_change\_case\(\) will return kController\_handle. If the pointer is NULL, has\_controller\_handle\(\) will return false and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET. \(The behavior is like calling clear\_configuration\_change\(\)\)|
|release\_controller\_handle\(\)|oneof:configuration\_change [ControllerHandle](ControllerHandle.md#)\*|void|Returns NULL if oneof case is not kController\_handle. If the oneof case is kController\_handle, clears the oneof case, releases the ownership of the field and returns the pointer of the configuration\_change object. After calling this, caller takes the ownership of the allocated configuration\_change object, has\_controller\_handle\(\) will return false, controller\_handle\(\) will return the default value and configuration\_change\_case\(\) will return CONFIGURATION\_CHANGE\_NOT\_SET.|
|has\_connection\(\) const|bool|void|Returns true if connection is set.|
|connection\(\)|const [Connection](../Common/Connection.md#)&|void|Returns the current value of connection. If connection is not set, returns a [Connection](../Common/Connection.md#) with none of its fields set \(possibly connection::default\_instance\(\)\).|
|mutable\_connection\(\)| [Connection](../Common/Connection.md#) \*|void|Returns a pointer to the mutable [Connection](../Common/Connection.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [Connection](../Common/Connection.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [Connection](../Common/Connection.md#)\). After calling this, has\_connection\(\) will return true and connection\(\) will return a reference to the same instance of [Connection](../Common/Connection.md#).|
|clear\_connection\(\)|void|void|Clears the value of the field. After calling this, has\_connection\(\) will return false and connection\(\) will return the default value.|
|set\_allocated\_connection\(\)|void| [Connection](../Common/Connection.md#) \*|Sets the [Connection](../Common/Connection.md#) object to the field and frees the previous field value if it exists. If the [Connection](../Common/Connection.md#) pointer is not NULL, the message takes ownership of the allocated [Connection](../Common/Connection.md#) object and has\_ [Connection](../Common/Connection.md#)\(\) will return true. Otherwise, if the connection is NULL, the behavior is the same as calling clear\_connection\(\).|
|release\_connection\(\)| [Connection](../Common/Connection.md#) \*|void|Releases the ownership of the field and returns the pointer of the [Connection](../Common/Connection.md#) object. After calling this, caller takes the ownership of the allocated [Connection](../Common/Connection.md#) object, has\_connection\(\) will return false, and connection\(\) will return the default value.|

**Parent topic:** [Base \(C++\)](../../summary_pages/Base.md)

