# class ControllerConfiguration

 **Member values** 

|Member name|Data type|Description|
|-----------|---------|-----------|
|handle| [ControllerHandle](ControllerHandle.md#)|Controller identifier|
|name|string|Controller friendly name|
|active\_mapping\_handle| [MappingHandle](MappingHandle.md#)|Mapping that is active on this controller|
|analog\_input\_identifier\_enum|string|Name that identifies the enum used to interpret the ‘analog\_input\_identifier’ field \(for example in ControllerEvent\). Thus 'analog\_input\_identifier\_enum' shall take the name of an existing enum \(ex. Xbox360AnalogInputIdentifier\)|
|digital\_input\_identifier\_enum|string|Name that identifies the enum used to interpret the ‘digital\_input\_identifier’ field \(for example in ControllerEvent\). Thus 'digital\_input\_identifier\_enum' shall take the name of an existing enum \(ex. Xbox360DigitalInputIdentifier, WristDigitalInputIdentifier\)|

 **Member functions** 

|Function name|Return type|Input type|Description|
|-------------|-----------|----------|-----------|
|has\_handle\(\) const|bool|void|Returns true if handle is set.|
|handle\(\)|const [ControllerHandle](ControllerHandle.md#)&|void|Returns the current value of handle. If handle is not set, returns a [ControllerHandle](ControllerHandle.md#) with none of its fields set \(possibly handle::default\_instance\(\)\).|
|mutable\_handle\(\)| [ControllerHandle](ControllerHandle.md#) \*|void|Returns a pointer to the mutable [ControllerHandle](ControllerHandle.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [ControllerHandle](ControllerHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [ControllerHandle](ControllerHandle.md#)\). After calling this, has\_handle\(\) will return true and handle\(\) will return a reference to the same instance of [ControllerHandle](ControllerHandle.md#).|
|clear\_handle\(\)|void|void|Clears the value of the field. After calling this, has\_handle\(\) will return false and handle\(\) will return the default value.|
|set\_allocated\_handle\(\)|void| [ControllerHandle](ControllerHandle.md#) \*|Sets the [ControllerHandle](ControllerHandle.md#) object to the field and frees the previous field value if it exists. If the [ControllerHandle](ControllerHandle.md#) pointer is not NULL, the message takes ownership of the allocated [ControllerHandle](ControllerHandle.md#) object and has\_ [ControllerHandle](ControllerHandle.md#)\(\) will return true. Otherwise, if the handle is NULL, the behavior is the same as calling clear\_handle\(\).|
|release\_handle\(\)| [ControllerHandle](ControllerHandle.md#) \*|void|Releases the ownership of the field and returns the pointer of the [ControllerHandle](ControllerHandle.md#) object. After calling this, caller takes the ownership of the allocated [ControllerHandle](ControllerHandle.md#) object, has\_handle\(\) will return false, and handle\(\) will return the default value.|
|name\(\)|const string&|void|Returns the current value of name. If name is not set, returns the empty string/empty bytes.|
|set\_name\(\)|void|const string&|Sets the value of name. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|string&&|\(C++11 and beyond\): Sets the value of name, moving from the passed string. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|const char\*|Sets the value of name using a C-style null-terminated string. After calling this, name\(\) will return a copy of value.|
|mutable\_name\(\)|string \*|void|Returns a pointer to the mutable string object that stores name's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, name\(\) will return whatever value is written into the given string.|
|clear\_name\(\)|void|void|Clears the value of name. After calling this, name\(\) will return the empty string/empty bytes.|
|set\_allocated\_name\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_name\(\).|
|release\_name\(\)|string \*|void|Releases the ownership of name and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and name\(\) will return the empty string/empty bytes.|
|has\_active\_mapping\_handle\(\) const|bool|void|Returns true if active\_mapping\_handle is set.|
|active\_mapping\_handle\(\)|const [MappingHandle](MappingHandle.md#)&|void|Returns the current value of active\_mapping\_handle. If active\_mapping\_handle is not set, returns a [MappingHandle](MappingHandle.md#) with none of its fields set \(possibly active\_mapping\_handle::default\_instance\(\)\).|
|mutable\_active\_mapping\_handle\(\)| [MappingHandle](MappingHandle.md#) \*|void|Returns a pointer to the mutable [MappingHandle](MappingHandle.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [MappingHandle](MappingHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [MappingHandle](MappingHandle.md#)\). After calling this, has\_active\_mapping\_handle\(\) will return true and active\_mapping\_handle\(\) will return a reference to the same instance of [MappingHandle](MappingHandle.md#).|
|clear\_active\_mapping\_handle\(\)|void|void|Clears the value of the field. After calling this, has\_active\_mapping\_handle\(\) will return false and active\_mapping\_handle\(\) will return the default value.|
|set\_allocated\_active\_mapping\_handle\(\)|void| [MappingHandle](MappingHandle.md#) \*|Sets the [MappingHandle](MappingHandle.md#) object to the field and frees the previous field value if it exists. If the [MappingHandle](MappingHandle.md#) pointer is not NULL, the message takes ownership of the allocated [MappingHandle](MappingHandle.md#) object and has\_ [MappingHandle](MappingHandle.md#)\(\) will return true. Otherwise, if the active\_mapping\_handle is NULL, the behavior is the same as calling clear\_active\_mapping\_handle\(\).|
|release\_active\_mapping\_handle\(\)| [MappingHandle](MappingHandle.md#) \*|void|Releases the ownership of the field and returns the pointer of the [MappingHandle](MappingHandle.md#) object. After calling this, caller takes the ownership of the allocated [MappingHandle](MappingHandle.md#) object, has\_active\_mapping\_handle\(\) will return false, and active\_mapping\_handle\(\) will return the default value.|
|analog\_input\_identifier\_enum\(\)|const string&|void|Returns the current value of analog\_input\_identifier\_enum. If analog\_input\_identifier\_enum is not set, returns the empty string/empty bytes.|
|set\_analog\_input\_identifier\_enum\(\)|void|const string&|Sets the value of analog\_input\_identifier\_enum. After calling this, analog\_input\_identifier\_enum\(\) will return a copy of value.|
|set\_analog\_input\_identifier\_enum\(\)|void|string&&|\(C++11 and beyond\): Sets the value of analog\_input\_identifier\_enum, moving from the passed string. After calling this, analog\_input\_identifier\_enum\(\) will return a copy of value.|
|set\_analog\_input\_identifier\_enum\(\)|void|const char\*|Sets the value of analog\_input\_identifier\_enum using a C-style null-terminated string. After calling this, analog\_input\_identifier\_enum\(\) will return a copy of value.|
|mutable\_analog\_input\_identifier\_enum\(\)|string \*|void|Returns a pointer to the mutable string object that stores analog\_input\_identifier\_enum's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, analog\_input\_identifier\_enum\(\) will return whatever value is written into the given string.|
|clear\_analog\_input\_identifier\_enum\(\)|void|void|Clears the value of analog\_input\_identifier\_enum. After calling this, analog\_input\_identifier\_enum\(\) will return the empty string/empty bytes.|
|set\_allocated\_analog\_input\_identifier\_enum\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_analog\_input\_identifier\_enum\(\).|
|release\_analog\_input\_identifier\_enum\(\)|string \*|void|Releases the ownership of analog\_input\_identifier\_enum and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and analog\_input\_identifier\_enum\(\) will return the empty string/empty bytes.|
|digital\_input\_identifier\_enum\(\)|const string&|void|Returns the current value of digital\_input\_identifier\_enum. If digital\_input\_identifier\_enum is not set, returns the empty string/empty bytes.|
|set\_digital\_input\_identifier\_enum\(\)|void|const string&|Sets the value of digital\_input\_identifier\_enum. After calling this, digital\_input\_identifier\_enum\(\) will return a copy of value.|
|set\_digital\_input\_identifier\_enum\(\)|void|string&&|\(C++11 and beyond\): Sets the value of digital\_input\_identifier\_enum, moving from the passed string. After calling this, digital\_input\_identifier\_enum\(\) will return a copy of value.|
|set\_digital\_input\_identifier\_enum\(\)|void|const char\*|Sets the value of digital\_input\_identifier\_enum using a C-style null-terminated string. After calling this, digital\_input\_identifier\_enum\(\) will return a copy of value.|
|mutable\_digital\_input\_identifier\_enum\(\)|string \*|void|Returns a pointer to the mutable string object that stores digital\_input\_identifier\_enum's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, digital\_input\_identifier\_enum\(\) will return whatever value is written into the given string.|
|clear\_digital\_input\_identifier\_enum\(\)|void|void|Clears the value of digital\_input\_identifier\_enum. After calling this, digital\_input\_identifier\_enum\(\) will return the empty string/empty bytes.|
|set\_allocated\_digital\_input\_identifier\_enum\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_digital\_input\_identifier\_enum\(\).|
|release\_digital\_input\_identifier\_enum\(\)|string \*|void|Releases the ownership of digital\_input\_identifier\_enum and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and digital\_input\_identifier\_enum\(\) will return the empty string/empty bytes.|

**Parent topic:** [Base \(C++\)](../../summary_pages/Base.md)

