# class ControllerNotification

 **Member values** 

|Member name|Data type|Description|
|-----------|---------|-----------|
|controller\_state|oneof:state [ControllerState](ControllerState.md#)|Used to indicate if a controller connection or disconnection event occured|
|controller\_element|oneof:state [ControllerElementState](ControllerElementState.md#)|Used to indicate if a specific button \(or axis\) was pressed \(or moved\)|
|timestamp| [Timestamp](../Common/Timestamp.md#)|Event timestamp|
|user\_handle| [UserProfileHandle](../Common/UserProfileHandle.md#)|User that caused the controller event|
|connection| [Connection](../Common/Connection.md#)|Connection that caused the controller event|

 **Member functions** 

|Function name|Return type|Input type|Description|
|-------------|-----------|----------|-----------|
|has\_controller\_state\(\) const|void|void|Returns the current value of the field if oneof case is kController\_state. Otherwise, returns oneof:state [ControllerState](ControllerState.md#)::default\_instance\(\)|
|controller\_state\(\) const|const oneof:state [ControllerState](ControllerState.md#)&|void|Returns the current value of the field if oneof case is kController\_state|
|mutable\_controller\_state\(\)|oneof:state [ControllerState](ControllerState.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_state\(\). Sets the oneof case to kController\_state and returns a pointer to the mutable oneof:state [ControllerState](ControllerState.md#) object that stores the field's value. If the oneof case was not kController\_state prior to the call, then the returned oneof:state [ControllerState](ControllerState.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:state [ControllerState](ControllerState.md#)\). After calling this, has\_controller\_state\(\) will return true, controller\_state\(\) will return a reference to the same instance of oneof:state [ControllerState](ControllerState.md#) and state\_case\(\) will return kController\_state|
|clear\_controller\_state\(\)|void|void|Nothing will be changed if the oneof case is not kController\_state. If the oneof case equals kController\_state, frees the field and clears the oneof case. has\_controller\_state\(\) will return false, controller\_state\(\) will return the default value and state\_case\(\) will return STATE\_NOT\_SET.|
|set\_allocated\_controller\_state\(\)|void|oneof:state [ControllerState](ControllerState.md#)\*|Calls clear\_state\(\). If the oneof:state [ControllerState](ControllerState.md#) pointer is not NULL: Sets the oneof:state [ControllerState](ControllerState.md#) object to the field and sets the oneof case to kController\_state. The message takes ownership of the allocated oneof:state [ControllerState](ControllerState.md#) object, has\_controller\_state\(\) will return true and state\_case\(\) will return kController\_state. If the pointer is NULL, has\_controller\_state\(\) will return false and state\_case\(\) will return STATE\_NOT\_SET. \(The behavior is like calling clear\_state\(\)\)|
|release\_controller\_state\(\)|oneof:state [ControllerState](ControllerState.md#)\*|void|Returns NULL if oneof case is not kController\_state. If the oneof case is kController\_state, clears the oneof case, releases the ownership of the field and returns the pointer of the state object. After calling this, caller takes the ownership of the allocated state object, has\_controller\_state\(\) will return false, controller\_state\(\) will return the default value and state\_case\(\) will return STATE\_NOT\_SET.|
|has\_controller\_element\(\) const|void|void|Returns the current value of the field if oneof case is kController\_element. Otherwise, returns oneof:state [ControllerElementState](ControllerElementState.md#)::default\_instance\(\)|
|controller\_element\(\) const|const oneof:state [ControllerElementState](ControllerElementState.md#)&|void|Returns the current value of the field if oneof case is kController\_element|
|mutable\_controller\_element\(\)|oneof:state [ControllerElementState](ControllerElementState.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_state\(\). Sets the oneof case to kController\_element and returns a pointer to the mutable oneof:state [ControllerElementState](ControllerElementState.md#) object that stores the field's value. If the oneof case was not kController\_element prior to the call, then the returned oneof:state [ControllerElementState](ControllerElementState.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:state [ControllerElementState](ControllerElementState.md#)\). After calling this, has\_controller\_element\(\) will return true, controller\_element\(\) will return a reference to the same instance of oneof:state [ControllerElementState](ControllerElementState.md#) and state\_case\(\) will return kController\_element|
|clear\_controller\_element\(\)|void|void|Nothing will be changed if the oneof case is not kController\_element. If the oneof case equals kController\_element, frees the field and clears the oneof case. has\_controller\_element\(\) will return false, controller\_element\(\) will return the default value and state\_case\(\) will return STATE\_NOT\_SET.|
|set\_allocated\_controller\_element\(\)|void|oneof:state [ControllerElementState](ControllerElementState.md#)\*|Calls clear\_state\(\). If the oneof:state [ControllerElementState](ControllerElementState.md#) pointer is not NULL: Sets the oneof:state [ControllerElementState](ControllerElementState.md#) object to the field and sets the oneof case to kController\_element. The message takes ownership of the allocated oneof:state [ControllerElementState](ControllerElementState.md#) object, has\_controller\_element\(\) will return true and state\_case\(\) will return kController\_element. If the pointer is NULL, has\_controller\_element\(\) will return false and state\_case\(\) will return STATE\_NOT\_SET. \(The behavior is like calling clear\_state\(\)\)|
|release\_controller\_element\(\)|oneof:state [ControllerElementState](ControllerElementState.md#)\*|void|Returns NULL if oneof case is not kController\_element. If the oneof case is kController\_element, clears the oneof case, releases the ownership of the field and returns the pointer of the state object. After calling this, caller takes the ownership of the allocated state object, has\_controller\_element\(\) will return false, controller\_element\(\) will return the default value and state\_case\(\) will return STATE\_NOT\_SET.|
|has\_timestamp\(\) const|bool|void|Returns true if timestamp is set.|
|timestamp\(\)|const [Timestamp](../Common/Timestamp.md#)&|void|Returns the current value of timestamp. If timestamp is not set, returns a [Timestamp](../Common/Timestamp.md#) with none of its fields set \(possibly timestamp::default\_instance\(\)\).|
|mutable\_timestamp\(\)| [Timestamp](../Common/Timestamp.md#) \*|void|Returns a pointer to the mutable [Timestamp](../Common/Timestamp.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [Timestamp](../Common/Timestamp.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [Timestamp](../Common/Timestamp.md#)\). After calling this, has\_timestamp\(\) will return true and timestamp\(\) will return a reference to the same instance of [Timestamp](../Common/Timestamp.md#).|
|clear\_timestamp\(\)|void|void|Clears the value of the field. After calling this, has\_timestamp\(\) will return false and timestamp\(\) will return the default value.|
|set\_allocated\_timestamp\(\)|void| [Timestamp](../Common/Timestamp.md#) \*|Sets the [Timestamp](../Common/Timestamp.md#) object to the field and frees the previous field value if it exists. If the [Timestamp](../Common/Timestamp.md#) pointer is not NULL, the message takes ownership of the allocated [Timestamp](../Common/Timestamp.md#) object and has\_ [Timestamp](../Common/Timestamp.md#)\(\) will return true. Otherwise, if the timestamp is NULL, the behavior is the same as calling clear\_timestamp\(\).|
|release\_timestamp\(\)| [Timestamp](../Common/Timestamp.md#) \*|void|Releases the ownership of the field and returns the pointer of the [Timestamp](../Common/Timestamp.md#) object. After calling this, caller takes the ownership of the allocated [Timestamp](../Common/Timestamp.md#) object, has\_timestamp\(\) will return false, and timestamp\(\) will return the default value.|
|has\_user\_handle\(\) const|bool|void|Returns true if user\_handle is set.|
|user\_handle\(\)|const [UserProfileHandle](../Common/UserProfileHandle.md#)&|void|Returns the current value of user\_handle. If user\_handle is not set, returns a [UserProfileHandle](../Common/UserProfileHandle.md#) with none of its fields set \(possibly user\_handle::default\_instance\(\)\).|
|mutable\_user\_handle\(\)| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|void|Returns a pointer to the mutable [UserProfileHandle](../Common/UserProfileHandle.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [UserProfileHandle](../Common/UserProfileHandle.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [UserProfileHandle](../Common/UserProfileHandle.md#)\). After calling this, has\_user\_handle\(\) will return true and user\_handle\(\) will return a reference to the same instance of [UserProfileHandle](../Common/UserProfileHandle.md#).|
|clear\_user\_handle\(\)|void|void|Clears the value of the field. After calling this, has\_user\_handle\(\) will return false and user\_handle\(\) will return the default value.|
|set\_allocated\_user\_handle\(\)|void| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|Sets the [UserProfileHandle](../Common/UserProfileHandle.md#) object to the field and frees the previous field value if it exists. If the [UserProfileHandle](../Common/UserProfileHandle.md#) pointer is not NULL, the message takes ownership of the allocated [UserProfileHandle](../Common/UserProfileHandle.md#) object and has\_ [UserProfileHandle](../Common/UserProfileHandle.md#)\(\) will return true. Otherwise, if the user\_handle is NULL, the behavior is the same as calling clear\_user\_handle\(\).|
|release\_user\_handle\(\)| [UserProfileHandle](../Common/UserProfileHandle.md#) \*|void|Releases the ownership of the field and returns the pointer of the [UserProfileHandle](../Common/UserProfileHandle.md#) object. After calling this, caller takes the ownership of the allocated [UserProfileHandle](../Common/UserProfileHandle.md#) object, has\_user\_handle\(\) will return false, and user\_handle\(\) will return the default value.|
|has\_connection\(\) const|bool|void|Returns true if connection is set.|
|connection\(\)|const [Connection](../Common/Connection.md#)&|void|Returns the current value of connection. If connection is not set, returns a [Connection](../Common/Connection.md#) with none of its fields set \(possibly connection::default\_instance\(\)\).|
|mutable\_connection\(\)| [Connection](../Common/Connection.md#) \*|void|Returns a pointer to the mutable [Connection](../Common/Connection.md#) object that stores the field's value. If the field was not set prior to the call, then the returned [Connection](../Common/Connection.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated [Connection](../Common/Connection.md#)\). After calling this, has\_connection\(\) will return true and connection\(\) will return a reference to the same instance of [Connection](../Common/Connection.md#).|
|clear\_connection\(\)|void|void|Clears the value of the field. After calling this, has\_connection\(\) will return false and connection\(\) will return the default value.|
|set\_allocated\_connection\(\)|void| [Connection](../Common/Connection.md#) \*|Sets the [Connection](../Common/Connection.md#) object to the field and frees the previous field value if it exists. If the [Connection](../Common/Connection.md#) pointer is not NULL, the message takes ownership of the allocated [Connection](../Common/Connection.md#) object and has\_ [Connection](../Common/Connection.md#)\(\) will return true. Otherwise, if the connection is NULL, the behavior is the same as calling clear\_connection\(\).|
|release\_connection\(\)| [Connection](../Common/Connection.md#) \*|void|Releases the ownership of the field and returns the pointer of the [Connection](../Common/Connection.md#) object. After calling this, caller takes the ownership of the allocated [Connection](../Common/Connection.md#) object, has\_connection\(\) will return false, and connection\(\) will return the default value.|

**Parent topic:** [Base \(C++\)](../../summary_pages/Base.md)

