# class Waypoint

 **Member values** 

|Member name|Data type|Description|
|-----------|---------|-----------|
|name|string|Waypoint friendly name|
|angular\_waypoint|oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)| |
|cartesian\_waypoint|oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)| |

 **Member functions** 

|Function name|Return type|Input type|Description|
|-------------|-----------|----------|-----------|
|name\(\)|const string&|void|Returns the current value of name. If name is not set, returns the empty string/empty bytes.|
|set\_name\(\)|void|const string&|Sets the value of name. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|string&&|\(C++11 and beyond\): Sets the value of name, moving from the passed string. After calling this, name\(\) will return a copy of value.|
|set\_name\(\)|void|const char\*|Sets the value of name using a C-style null-terminated string. After calling this, name\(\) will return a copy of value.|
|mutable\_name\(\)|string \*|void|Returns a pointer to the mutable string object that stores name's value. If the field was not set prior to the call, then the returned string will be empty. After calling this, name\(\) will return whatever value is written into the given string.|
|clear\_name\(\)|void|void|Clears the value of name. After calling this, name\(\) will return the empty string/empty bytes.|
|set\_allocated\_name\(\)|void|string\*|Sets the string object to the field and frees the previous field value if it exists. If the string pointer is not NULL, the message takes ownership of the allocated string object. The message is free to delete the allocated string object at any time, so references to the object may be invalidated. Otherwise, if the value is NULL, the behavior is the same as calling clear\_name\(\).|
|release\_name\(\)|string \*|void|Releases the ownership of name and returns the pointer of the string object. After calling this, caller takes the ownership of the allocated string object and name\(\) will return the empty string/empty bytes.|
|has\_angular\_waypoint\(\) const|void|void|Returns the current value of the field if oneof case is kAngular\_waypoint. Otherwise, returns oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)::default\_instance\(\)|
|angular\_waypoint\(\) const|const oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)&|void|Returns the current value of the field if oneof case is kAngular\_waypoint|
|mutable\_angular\_waypoint\(\)|oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_type\_of\_waypoint\(\). Sets the oneof case to kAngular\_waypoint and returns a pointer to the mutable oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) object that stores the field's value. If the oneof case was not kAngular\_waypoint prior to the call, then the returned oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)\). After calling this, has\_angular\_waypoint\(\) will return true, angular\_waypoint\(\) will return a reference to the same instance of oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) and type\_of\_waypoint\_case\(\) will return kAngular\_waypoint|
|clear\_angular\_waypoint\(\)|void|void|Nothing will be changed if the oneof case is not kAngular\_waypoint. If the oneof case equals kAngular\_waypoint, frees the field and clears the oneof case. has\_angular\_waypoint\(\) will return false, angular\_waypoint\(\) will return the default value and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET.|
|set\_allocated\_angular\_waypoint\(\)|void|oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)\*|Calls clear\_type\_of\_waypoint\(\). If the oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) pointer is not NULL: Sets the oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) object to the field and sets the oneof case to kAngular\_waypoint. The message takes ownership of the allocated oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#) object, has\_angular\_waypoint\(\) will return true and type\_of\_waypoint\_case\(\) will return kAngular\_waypoint. If the pointer is NULL, has\_angular\_waypoint\(\) will return false and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET. \(The behavior is like calling clear\_type\_of\_waypoint\(\)\)|
|release\_angular\_waypoint\(\)|oneof:type\_of\_waypoint [AngularWaypoint](AngularWaypoint.md#)\*|void|Returns NULL if oneof case is not kAngular\_waypoint. If the oneof case is kAngular\_waypoint, clears the oneof case, releases the ownership of the field and returns the pointer of the type\_of\_waypoint object. After calling this, caller takes the ownership of the allocated type\_of\_waypoint object, has\_angular\_waypoint\(\) will return false, angular\_waypoint\(\) will return the default value and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET.|
|has\_cartesian\_waypoint\(\) const|void|void|Returns the current value of the field if oneof case is kCartesian\_waypoint. Otherwise, returns oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)::default\_instance\(\)|
|cartesian\_waypoint\(\) const|const oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)&|void|Returns the current value of the field if oneof case is kCartesian\_waypoint|
|mutable\_cartesian\_waypoint\(\)|oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)\*|void|If any other oneof field in the same oneof is set, calls clear\_type\_of\_waypoint\(\). Sets the oneof case to kCartesian\_waypoint and returns a pointer to the mutable oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) object that stores the field's value. If the oneof case was not kCartesian\_waypoint prior to the call, then the returned oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) will have none of its fields set \(i.e. it will be identical to a newly-allocated oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)\). After calling this, has\_cartesian\_waypoint\(\) will return true, cartesian\_waypoint\(\) will return a reference to the same instance of oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) and type\_of\_waypoint\_case\(\) will return kCartesian\_waypoint|
|clear\_cartesian\_waypoint\(\)|void|void|Nothing will be changed if the oneof case is not kCartesian\_waypoint. If the oneof case equals kCartesian\_waypoint, frees the field and clears the oneof case. has\_cartesian\_waypoint\(\) will return false, cartesian\_waypoint\(\) will return the default value and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET.|
|set\_allocated\_cartesian\_waypoint\(\)|void|oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)\*|Calls clear\_type\_of\_waypoint\(\). If the oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) pointer is not NULL: Sets the oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) object to the field and sets the oneof case to kCartesian\_waypoint. The message takes ownership of the allocated oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#) object, has\_cartesian\_waypoint\(\) will return true and type\_of\_waypoint\_case\(\) will return kCartesian\_waypoint. If the pointer is NULL, has\_cartesian\_waypoint\(\) will return false and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET. \(The behavior is like calling clear\_type\_of\_waypoint\(\)\)|
|release\_cartesian\_waypoint\(\)|oneof:type\_of\_waypoint [CartesianWaypoint](CartesianWaypoint.md#)\*|void|Returns NULL if oneof case is not kCartesian\_waypoint. If the oneof case is kCartesian\_waypoint, clears the oneof case, releases the ownership of the field and returns the pointer of the type\_of\_waypoint object. After calling this, caller takes the ownership of the allocated type\_of\_waypoint object, has\_cartesian\_waypoint\(\) will return false, cartesian\_waypoint\(\) will return the default value and type\_of\_waypoint\_case\(\) will return TYPE\_OF\_WAYPOINT\_NOT\_SET.|

**Parent topic:** [Base \(C++\)](../../summary_pages/Base.md)

