# class Action

 **Member values** 

|Member name|Data type|Description|Usage|
|-----------|---------|-----------|-----|
|handle| [ActionHandle](ActionHandle.md#)|Reference to the action \(useful when updating an existing action\)|To set handle, you simply assign a value directly to a field within handle. You can also use the parent message's HasField\(\) method to check if a message type field value has been set.|
|name|str|Action friendly name|You can manipulate the field name as if it were a regular field. To clear the value of name and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface.|
|application\_data|str|Application data \(reserved for use by Web App\)|You can manipulate the field application\_data as if it were a regular field. To clear the value of application\_data and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface.|
|send\_twist\_command|oneof:action\_parameters [TwistCommand](TwistCommand.md#)|Control the tool in velocity|You can manipulate the field send\_twist\_command as if it were a regular field. To clear the value of send\_twist\_command and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|send\_wrench\_command|oneof:action\_parameters [WrenchCommand](WrenchCommand.md#)|Control the tool in force \(EXPERIMENTAL\)|You can manipulate the field send\_wrench\_command as if it were a regular field. To clear the value of send\_wrench\_command and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|send\_joint\_speeds|oneof:action\_parameters [JointSpeeds](JointSpeeds.md#)|Action to control each joint speed|You can manipulate the field send\_joint\_speeds as if it were a regular field. To clear the value of send\_joint\_speeds and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|reach\_pose|oneof:action\_parameters [ConstrainedPose](ConstrainedPose.md#)|Reach a pose given Cartesian constraints. This action will be deprecated in a future version and will be replaced by execute\_waypoint\_list.|You can manipulate the field reach\_pose as if it were a regular field. To clear the value of reach\_pose and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|reach\_joint\_angles|oneof:action\_parameters [ConstrainedJointAngles](ConstrainedJointAngles.md#)|Reach a series of joint angles given angular constraints. This action will be deprecated in a future version and will be replaced by execute\_waypoint\_list.|You can manipulate the field reach\_joint\_angles as if it were a regular field. To clear the value of reach\_joint\_angles and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|toggle\_admittance\_mode|oneof:action\_parameters int|Enable or disable the admittance mode|You can manipulate the field toggle\_admittance\_mode as if it were a regular field. To clear the value of toggle\_admittance\_mode and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|snapshot|oneof:action\_parameters [Snapshot](Snapshot.md#)|Take a snapshot of current robot position|You can manipulate the field snapshot as if it were a regular field. To clear the value of snapshot and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|switch\_control\_mapping|oneof:action\_parameters [SwitchControlMapping](SwitchControlMapping.md#)|Switch the active controller map|You can manipulate the field switch\_control\_mapping as if it were a regular field. To clear the value of switch\_control\_mapping and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|navigate\_joints|oneof:action\_parameters int|Select the next actuator to control in a map|You can manipulate the field navigate\_joints as if it were a regular field. To clear the value of navigate\_joints and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|navigate\_mappings|oneof:action\_parameters int|Select a different map|You can manipulate the field navigate\_mappings as if it were a regular field. To clear the value of navigate\_mappings and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|change\_twist|oneof:action\_parameters [ChangeTwist](ChangeTwist.md#)|Change tool twist|You can manipulate the field change\_twist as if it were a regular field. To clear the value of change\_twist and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|change\_joint\_speeds|oneof:action\_parameters [ChangeJointSpeeds](ChangeJointSpeeds.md#)|Change the joint speeds individually|You can manipulate the field change\_joint\_speeds as if it were a regular field. To clear the value of change\_joint\_speeds and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|change\_wrench|oneof:action\_parameters [ChangeWrench](ChangeWrench.md#)|Change the Cartesian force|You can manipulate the field change\_wrench as if it were a regular field. To clear the value of change\_wrench and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|apply\_emergency\_stop|oneof:action\_parameters [EmergencyStop](EmergencyStop.md#)|Apply robot emergency stop|You can manipulate the field apply\_emergency\_stop as if it were a regular field. To clear the value of apply\_emergency\_stop and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|clear\_faults|oneof:action\_parameters [Faults](Faults.md#)|Clear faults. Robot will be able to move if there is no more fault \(see BaseCyclic.BaseFeedback.\[fault\_bank\_a | fault\_bank\_b\]\)|You can manipulate the field clear\_faults as if it were a regular field. To clear the value of clear\_faults and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|delay|oneof:action\_parameters [Delay](Delay.md#)|Apply a delay|You can manipulate the field delay as if it were a regular field. To clear the value of delay and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|execute\_action|oneof:action\_parameters [ActionHandle](ActionHandle.md#)|Execute an existing action|You can manipulate the field execute\_action as if it were a regular field. To clear the value of execute\_action and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|send\_gripper\_command|oneof:action\_parameters [GripperCommand](GripperCommand.md#)|Send a gripper command|You can manipulate the field send\_gripper\_command as if it were a regular field. To clear the value of send\_gripper\_command and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|send\_gpio\_command|oneof:action\_parameters [GpioCommand](GpioCommand.md#)|Send a gpio command \(not implemented yet\)|You can manipulate the field send\_gpio\_command as if it were a regular field. To clear the value of send\_gpio\_command and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|stop\_action|oneof:action\_parameters [Stop](Stop.md#)|Stop movement|You can manipulate the field stop\_action as if it were a regular field. To clear the value of stop\_action and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|play\_pre\_computed\_trajectory|oneof:action\_parameters [PreComputedJointTrajectory](PreComputedJointTrajectory.md#)|Play a pre-computed joint trajectory|You can manipulate the field play\_pre\_computed\_trajectory as if it were a regular field. To clear the value of play\_pre\_computed\_trajectory and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|execute\_sequence|oneof:action\_parameters [SequenceHandle](SequenceHandle.md#)|Execute an existing sequence|You can manipulate the field execute\_sequence as if it were a regular field. To clear the value of execute\_sequence and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|
|execute\_waypoint\_list|oneof:action\_parameters [WaypointList](WaypointList.md#)|Execute a trajectory defined by a series of waypoints|You can manipulate the field execute\_waypoint\_list as if it were a regular field. To clear the value of execute\_waypoint\_list and reset it to the default value for its type, you call the ClearField\(\) method of the Message interface. The message class also has a WhichOneof method that lets you find out which field \(if any\) in the oneof has been set.|

**Parent topic:** [Base \(Python\)](../../summary_pages/Base.md)

