# Enum SafetyIdentifierBankA

## Overview / Purpose

Enumeration SafetyIdentifierBankA

|Enumerator|Value|Description|
|----------|-----|-----------|
|UNSPECIFIED\_ACTUATOR\_SAFETY\_IDENTIFIER\_BANK\_A|0|0x0 - Unspecified actuator safety|
|FOLLOWING\_ERROR|1|0x1 - Following error|
|MAXIMUM\_VELOCITY|2|0x2 - Maximum velocity|
|JOINT\_LIMIT\_HIGH|4|0x4 - Joint position limit high|
|JOINT\_LIMIT\_LOW|8|0x8 - Joint position limit low|
|STRAIN\_GAUGE\_MISMATCH|16|0x10 - Strain gauge mismatch|
|MAXIMUM\_TORQUE|32|0x20 - Maximum torque|
|UNRELIABLE\_ABSOLUTE\_POSITION|64|0x40 - Unreliable absolute position|
|MAGNETIC\_POSITION|128|0x80 - Magnetic position|
|HALL\_POSITION|256|0x100 - Hall position|
|HALL\_SEQUENCE|512|0x200 - Hall sequence|
|INPUT\_ENCODER\_HALL\_MISMATCH|1024|0x400 - Input encoder Hall mismatch|
|INPUT\_ENCODER\_INDEX\_MISMATCH|2048|0x800 - Input encoder index mismatch|
|INPUT\_ENCODER\_MAGNETIC\_MISMATCH|4096|0x1000 - Input encoder magnetic mismatch|
|MAXIMUM\_MOTOR\_CURRENT|8192|0x2000 - Maximum motor current|
|MOTOR\_CURRENT\_MISMATCH|16384|0x4000 - Motor current mismatch|
|MAXIMUM\_VOLTAGE|32768|0x8000 - Maximum voltage|
|MINIMUM\_VOLTAGE|65536|0x10000 - Minimum voltage|
|MAXIMUM\_MOTOR\_TEMPERATURE|131072|0x20000 - Maximum motor temperature|
|MAXIMUM\_CORE\_TEMPERATURE|262144|0x40000 - Maximum core temperature|
|NON\_VOLATILE\_MEMORY\_CORRUPTED|524288|0x80000 - Non-volatile memory corrupted|
|MOTOR\_DRIVER\_FAULT|1048576|0x100000 - Motor driver fault|
|EMERGENCY\_LINE\_ASSERTED|2097152|0x200000 - Emergency line asserted|
|COMMUNICATION\_TICK\_LOST|4194304|0x400000 - Communication tick lost|
|WATCHDOG\_TRIGGERED|8388608|0x800000 - Watchdog triggered|
|UNRELIABLE\_CAPACITIVE\_SENSOR|16777216|0x1000000 - Capacitive sensor is unreliable|
|UNEXPECTED\_GEAR\_RATIO|33554432|0x2000000 - Incorrect gear ratio for detected configuration|
|HALL\_MAGNETIC\_MISMATCH|67108864|0x4000000 - Position mismatch between hall and magnetic sensors|

**Parent topic:** [ActuatorConfig \(Python\)](../../summary_pages/ActuatorConfig.md)

