<!--
* KINOVA (R) KORTEX (TM)
*
* Copyright (c) 2018 Kinova inc. All rights reserved.
*
* This file may be modified and distributed under the
* terms of the BSD 3-Clause license.
*
* Refer to the LICENSE file for details.
*
-->

<h1>KINOVA<sup>®</sup> KORTEX™ API Reference</h1>

<!-- TOC -->
- [How to report a bug](#how-to-report-a-bug)
- [How to submit a change (e.g. Pull Request)](#how-to-submit-a-change-eg-pull-request)
- [How to submit an enhancement request](#how-to-submit-an-enhancement-request)

<!-- TOC -->


<a id="bug-report" name="bug-report"></a>
# How to report a bug

Bugs are reported using GitHub issues. Please use the provided <a href="./template_bug_report.md">template</a> to report a bug - this will help our developers to reproduce the problem.

- <strong>Use a clear and descriptive title</strong> for the issue
- <strong>Short description of the issue</strong> 
- <strong>Provide version numbers </strong> of the Kortex API you're using and of the firmware of your Kortex-enabled device. Any other software and version information you think can be useful can be placed here.
- <strong>Steps to reproduce the issue</strong>, using a numbered list. Each number corresponds to a single step.
- <strong>An example of code </strong> where the problem occurs, to demonstrate the step described above. Code can be pasted in a markdown snippet.
- <strong>Describe the behavior you expected and why</strong>
- <strong>Any other information</strong> you consider useful, such as screenshots, crash reports and CPU profile captures, as well as your thoughts on what could be the problem.

If your bug doesn't apply to the Kortex API, or you're not able to complete your GitHub issues, please contact us via our <a href=https://www.kinovarobotics.com/en/support>website support link.</a>



<a id="submit-a-change" name="submit-a-change"></a>
# How to submit a change (e.g. Pull Request)

To create a pull request please refer to the GitHub help page: <a href=https://help.github.com/articles/creating-a-pull-request> Creating a pull request</a>

Any pull request that doesn't have enough information or can't be easily reviewed will be rejected by Kinova. To make sure your pull request isn't rejected, please complete and include the following list in your pull request description.

- Identify the bug/feature you are implementing
- Description of change
- Possible drawbacks
- Release Notes
- Any other information you find is useful

*Any submitted pull request can be merged, reworked, declined or deleted by Kinova at any time without advance notice*

<a id="submit-a-enhancement-request" name="submit-a-enhancement-request"></a>
# How to submit an enhancement request

Enhancement requests use the GitHub Feature Request. You have to follow the provided <a href="./template_enhancement_request.md">templates</a> to submit an enhancement request. This will help the developers to implement the new feature. Here are the main sections of the provided template.

- Summary, A short description of the requested feature.
- Use cases, Why is this feature needed? What are the use cases covered by the feature?
- Alternative, Do you have an idea how on how best to implement this enhancement?
 If this feature is not implemented, do you have a workaround?
- Possible issues, Anything that could be affected by the new feature.
- Additional content, Any other information you would like us to know about the requested enhancement.