# Learning Stable Polynomial Motion Planning Policies

## Motivation

Imitation learning is a method used to tackle complex motion planning problems by training a policy to imitate an expert's behavior. However, relying solely on the expert's data can result in unsafe behaviors when the robot encounters situations that deviate from the demonstrated trajectories. To address this issue, we propose an approach for learning a stable nonlinear dynamical system as a motion planning policy. We represent the nonlinear dynamical system as a parametric polynomial and jointly learn the coefficients of the polynomial along with a Lyapunov candidate. This results in a motion planning policy that can robustly replicate expert trajectories.

![](fig/plyds/compare_all/baselines_mse_final.png "a title")

## Getting started

This section provides instructions on reproducibility and basic functionalities of the repository.

### Repository structure

To acquire a better understanding of the environment and features, you just need to clone the repository into your local machine. At first glance, the structure of the project appears below.

```bash
    ├── src          # Python source files of the project.
    ├── exp          # Targeted experiments with various planning methods.
    ├── data         # Figures and other data.
    ├── res          # Resources like saved policies.
    ├── sim          # Simulation files with Pybullet.
    ├── lib          # External libraries or reference codes.
    ├── .gitmodules  # Organizing the modules in lib folder.
    ├── LICENSE
    ├── CONTRIBUTING.md
    └── README.md
```

### Dependencies and Conda

All the dependencies for this project are summarized as a Conda environment in [environment.yaml](environment.yaml). The following command should automatically install the entire set of dependencies.

```bash
conda env create -f environment.yml
```

Before running the above, make sure you have Conda installed, or install it from [Anaconda Website](https://conda.io/projects/conda/en/latest/user-guide/install/linux.html).

## Experiments with Handwriting Dataset

The [exp](exp/) folder contains most of the experiments and baselines comparisons. To prepare for running experiments, you need to navigate into the folder and grant Unix executable access to all the Python files or use python to launch them:

```bash
python plyds_learning.py
```

These files utilize the Argparse library, so you can easily check their help instructions to understand their functionality and available command-line options.

```bash
python rlds_training.py -h
```

This option works for any other python file in the folder.


Additionally, within the folder, there is a file named [experiments.bash](exp/experiments.sh) which allows you to reproduce all the plots mentioned in the paper given an integer as the number of trials.

```bash
chmod +x experiments.bash
./experiments.bash 10
```

Keep in mind that this process may take some time as certain baselines require GPU acceleration to speed up computations.

Make sure you are familiar with the command-line interface (CLI) options to save or plot the results, as they play a crucial role in obtaining the desired output. For instance, for PLYDS:

```cmd
usage: plyds_learning.py [-h] [-dsd DS_DEGREE] [-lpfd LPF_DEGREE] [-o OPTIMIZER] [-nd NUM_DEMONSTRATIONS] [-ms MOTION_SHAPE]
                         [-mn MODEL_NAME] [-sp] [-st SET_TOLERANCE] [-so] [-sm] [-sd SAVE_DIR] [-ls]

Polynomial DS experiments CLI interface.

optional arguments:
  -h, --help            show this help message and exit
  -dsd DS_DEGREE, --ds-degree DS_DEGREE
                        Complexity of the polynomial dynamical system.
  -lpfd LPF_DEGREE, --lpf-degree LPF_DEGREE
                        Complexity of the stability Lyapunov function.
  -o OPTIMIZER, --optimizer OPTIMIZER
                        Switch between scipy and cvxpy optimizers.
  -nd NUM_DEMONSTRATIONS, --num-demonstrations NUM_DEMONSTRATIONS
                        Number of additional demonstrations to the original dataset.
  -ms MOTION_SHAPE, --motion-shape MOTION_SHAPE
                        Shape of the trajectories as in LASA dataset, pick from ['G', 'P', 'Sine', 'Worm', 'Angle', 'C', 'N',
                        'DBLine'].
  -mn MODEL_NAME, --model-name MODEL_NAME
                        Name of the trained model.
  -sp, --show-plots     Show extra plots of final result and trajectories.
  -st SET_TOLERANCE, --set-tolerance SET_TOLERANCE
                        Number of trials per demonstrated motion.
  -so, --subspace-optimization
                        Use subspace optimization if activated.
  -sm, --save-model     Keep a copy of the model in the res folder.
  -sd SAVE_DIR, --save-dir SAVE_DIR
                        Optional destination for save/load.
  -ls, --lpf-simplification
                        Use subspace optimization if activated.
```

One can then use [plot_results.py](exp/plot_results.py) or see the output policies stored in the specified directories. Also, the file [batch_learning.py](exp/batch_baselining.py) enables multiple experiments for each of the baselines and PLYDS with just setting the argument.

In general, the experiments output plots of the policy along with the contour plot of Lyapunov candidate and its derivative, and save the acquired policy along with mean and standard deviation of the results for batch experiments.

![](fig/plyds/simulation/3d_illustration.png)

## Kinova Gen3-Lite experiments

Refer to the [dedicated repository](lib/kinova-arm/) for real-world experiments on Kinova arm. Simulation with Kinova Gen3 Lite is also available through PyBullet in the [sim](sim/) folder and some baselines are provided.

## Contributing

Please read [CONTRIBUTING.md](CONTRIBUTING.md) for details on our code of conduct, and the process for submitting **pull requests** to us.

## Citation

Please use the following BibTeX formatted **citation**:
    @article{,
      title={},
      author={},
      journal={},
      year={}
    }

## Authors

* Anonymous -- **maintainer**
* Anonymous

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
