import argparse
import logging
import os, sys
import numpy as np

sys.path.append(os.pardir)
from sos.sos_stability import SymbolicSpaceDS, SymbolicSubspaceDS
from utils.logging_settings import logger

def get_printed_constraints_subspace(max_deg_ds, gx, gy, px, py, tol):
    """ Get printed constraints for subspace optimization.

    Args:
        max_deg_ds (int): Degree of the dynamical system.
        gx (np.ndarray): Optimization param.
        gy (np.ndarray): Optimization param.
        px (np.ndarray): Optimization param.
        py (np.ndarray): Optimization param.
        tol (flpat): Optimization param.

    Returns:
        List[Constraints]: List of cvxpy compatible constraints.
    """

    if max_deg_ds == 2:
        return [gx[0, 0] <= tol, gx[0, 0] >= -tol,
                2*py[0, 0] - (gx[0, 3] + gx[3, 0]) <= tol,
                2*py[0, 0] - (gx[0, 3] + gx[3, 0]) >= -tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) <= tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) >= -tol,
                2*py[0, 2] + 2*py[2, 0] - (gx[0, 4] + gx[3, 3] + gx[4, 0]) <= tol,
                2*py[0, 2] + 2*py[2, 0] - (gx[0, 4] + gx[3, 3] + gx[4, 0]) >= -tol,
                2*px[0, 2] + 2*px[2, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 3] + gx[3, 1]) <= tol,
                2*px[0, 2] + 2*px[2, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 3] + gx[3, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) >= -tol,
                2*py[2, 2] - (gx[3, 4] + gx[4, 3]) <= tol,
                2*py[2, 2] - (gx[3, 4] + gx[4, 3]) >= -tol,
                2*px[2, 2] + 2*py[1, 2] + 2*py[2, 1] - (gx[1, 4] + gx[4, 1]) <= tol,
                2*px[2, 2] + 2*py[1, 2] + 2*py[2, 1] - (gx[1, 4] + gx[4, 1]) >= -tol,
                2*px[1, 2] + 2*px[2, 1] + 2*py[1, 1] - (gx[2, 3] + gx[3, 2]) <= tol,
                2*px[1, 2] + 2*px[2, 1] + 2*py[1, 1] - (gx[2, 3] + gx[3, 2]) >= -tol,
                2*px[1, 1] - (gx[1, 2] + gx[2, 1]) <= tol,
                2*px[1, 1] - (gx[1, 2] + gx[2, 1]) >= -tol,
                gx[4, 4] <= tol, gx[4, 4] >= -tol,
                gx[2, 4] + gx[4, 2] <= tol, gx[2, 4] + gx[4, 2] >= -tol,
                gx[2, 2] <= tol, gx[2, 2] >= -tol,
                gy[0, 0] <= tol, gy[0, 0] >= -tol,
                2*py[0, 0] - (gy[0, 3] + gy[3, 0]) <= tol,
                2*py[0, 0] - (gy[0, 3] + gy[3, 0]) >= -tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) <= tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) >= -tol,
                2*py[0, 2] + 2*py[2, 0] - (gy[0, 4] + gy[3, 3] + gy[4, 0]) <= tol,
                2*py[0, 2] + 2*py[2, 0] - (gy[0, 4] + gy[3, 3] + gy[4, 0]) >= -tol,
                2*px[0, 2] + 2*px[2, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 3] + gy[3, 1]) <= tol,
                2*px[0, 2] + 2*px[2, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 3] + gy[3, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) >= -tol,
                2*py[2, 2] - (gy[3, 4] + gy[4, 3]) <= tol,
                2*py[2, 2] - (gy[3, 4] + gy[4, 3]) >= -tol,
                2*px[2, 2] + 2*py[1, 2] + 2*py[2, 1] - (gy[1, 4] + gy[4, 1]) <= tol,
                2*px[2, 2] + 2*py[1, 2] + 2*py[2, 1] - (gy[1, 4] + gy[4, 1]) >= -tol,
                2*px[1, 2] + 2*px[2, 1] + 2*py[1, 1] - (gy[2, 3] + gy[3, 2]) <= tol,
                2*px[1, 2] + 2*px[2, 1] + 2*py[1, 1] - (gy[2, 3] + gy[3, 2]) >= -tol,
                2*px[1, 1] - (gy[1, 2] + gy[2, 1]) <= tol,
                2*px[1, 1] - (gy[1, 2] + gy[2, 1]) >= -tol,
                gy[4, 4] <= tol, gy[4, 4] >= -tol,
                gy[2, 4] + gy[4, 2] <= tol, gy[2, 4] + gy[4, 2] >= -tol,
                gy[2, 2] <= tol, gy[2, 2] >= -tol,]
    if max_deg_ds == 4:
        return [gx[0, 0] <= tol, gx[0, 0] >= -tol,
                2*py[0, 0] - (gx[0, 4] + gx[4, 0]) <= tol,
                2*py[0, 0] - (gx[0, 4] + gx[4, 0]) >= -tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) <= tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) >= -tol,
                2*py[0, 3] + 2*py[3, 0] - (gx[0, 5] + gx[4, 4] + gx[5, 0]) <= tol,
                2*py[0, 3] + 2*py[3, 0] - (gx[0, 5] + gx[4, 4] + gx[5, 0]) >= -tol,
                2*px[0, 3] + 2*px[3, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 4] + gx[4, 1]) <= tol,
                2*px[0, 3] + 2*px[3, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 4] + gx[4, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) >= -tol,
                2*py[0, 4] + 2*py[3, 3] + 2*py[4, 0] - (gx[0, 6] + gx[4, 5] + gx[5, 4] + gx[6, 0]) <= tol,
                2*py[0, 4] + 2*py[3, 3] + 2*py[4, 0] - (gx[0, 6] + gx[4, 5] + gx[5, 4] + gx[6, 0]) >= -tol,
                2*px[0, 4] + 2*px[3, 3] + 2*px[4, 0] + 2*py[1, 3] + 2*py[3, 1] - (gx[1, 5] + gx[5, 1]) <= tol,
                2*px[0, 4] + 2*px[3, 3] + 2*px[4, 0] + 2*py[1, 3] + 2*py[3, 1] - (gx[1, 5] + gx[5, 1]) >= -tol,
                2*px[1, 3] + 2*px[3, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 4] + gx[4, 2]) <= tol,
                2*px[1, 3] + 2*px[3, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 4] + gx[4, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) >= -tol,
                2*py[3, 4] + 2*py[4, 3] - (gx[4, 6] + gx[5, 5] + gx[6, 4]) <= tol,
                2*py[3, 4] + 2*py[4, 3] - (gx[4, 6] + gx[5, 5] + gx[6, 4]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 4] + 2*py[4, 1] - (gx[1, 6] + gx[6, 1]) <= tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 4] + 2*py[4, 1] - (gx[1, 6] + gx[6, 1]) >= -tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[2, 3] + 2*py[3, 2] - (gx[2, 5] + gx[5, 2]) <= tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[2, 3] + 2*py[3, 2] - (gx[2, 5] + gx[5, 2]) >= -tol,
                2*px[2, 3] + 2*px[3, 2] + 2*py[1, 2] + 2*py[2, 1] - (gx[3, 4] + gx[4, 3]) <= tol,
                2*px[2, 3] + 2*px[3, 2] + 2*py[1, 2] + 2*py[2, 1] - (gx[3, 4] + gx[4, 3]) >= -tol,
                2*px[1, 2] + 2*px[2, 1] - (gx[1, 3] + gx[2, 2] + gx[3, 1]) <= tol,
                2*px[1, 2] + 2*px[2, 1] - (gx[1, 3] + gx[2, 2] + gx[3, 1]) >= -tol,
                2*py[4, 4] - (gx[5, 6] + gx[6, 5]) <= tol,
                2*py[4, 4] - (gx[5, 6] + gx[6, 5]) >= -tol,
                2*py[2, 4] + 2*py[4, 2] - (gx[2, 6] + gx[6, 2]) <= tol,
                2*py[2, 4] + 2*py[4, 2] - (gx[2, 6] + gx[6, 2]) >= -tol,
                2*px[2, 4] + 2*px[4, 2] - (gx[3, 5] + gx[5, 3]) <= tol,
                2*px[2, 4] + 2*px[4, 2] - (gx[3, 5] + gx[5, 3]) >= -tol,
                2*px[2, 2] - (gx[2, 3] + gx[3, 2]) <= tol,
                2*px[2, 2] - (gx[2, 3] + gx[3, 2]) >= -tol,
                gx[6, 6] <= tol, gx[6, 6] >= -tol,
                gx[3, 6] + gx[6, 3] <= tol, gx[3, 6] + gx[6, 3] >= -tol,
                gx[3, 3] <= tol, gx[3, 3] >= -tol,
                gy[0, 0] <= tol, gy[0, 0] >= -tol,
                2*py[0, 0] - (gy[0, 4] + gy[4, 0]) <= tol,
                2*py[0, 0] - (gy[0, 4] + gy[4, 0]) >= -tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) <= tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) >= -tol,
                2*py[0, 3] + 2*py[3, 0] - (gy[0, 5] + gy[4, 4] + gy[5, 0]) <= tol,
                2*py[0, 3] + 2*py[3, 0] - (gy[0, 5] + gy[4, 4] + gy[5, 0]) >= -tol,
                2*px[0, 3] + 2*px[3, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 4] + gy[4, 1]) <= tol,
                2*px[0, 3] + 2*px[3, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 4] + gy[4, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) >= -tol,
                2*py[0, 4] + 2*py[3, 3] + 2*py[4, 0] - (gy[0, 6] + gy[4, 5] + gy[5, 4] + gy[6, 0]) <= tol,
                2*py[0, 4] + 2*py[3, 3] + 2*py[4, 0] - (gy[0, 6] + gy[4, 5] + gy[5, 4] + gy[6, 0]) >= -tol,
                2*px[0, 4] + 2*px[3, 3] + 2*px[4, 0] + 2*py[1, 3] + 2*py[3, 1] - (gy[1, 5] + gy[5, 1]) <= tol,
                2*px[0, 4] + 2*px[3, 3] + 2*px[4, 0] + 2*py[1, 3] + 2*py[3, 1] - (gy[1, 5] + gy[5, 1]) >= -tol,
                2*px[1, 3] + 2*px[3, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 4] + gy[4, 2]) <= tol,
                2*px[1, 3] + 2*px[3, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 4] + gy[4, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) >= -tol,
                2*py[3, 4] + 2*py[4, 3] - (gy[4, 6] + gy[5, 5] + gy[6, 4]) <= tol,
                2*py[3, 4] + 2*py[4, 3] - (gy[4, 6] + gy[5, 5] + gy[6, 4]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 4] + 2*py[4, 1] - (gy[1, 6] + gy[6, 1]) <= tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 4] + 2*py[4, 1] - (gy[1, 6] + gy[6, 1]) >= -tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[2, 3] + 2*py[3, 2] - (gy[2, 5] + gy[5, 2]) <= tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[2, 3] + 2*py[3, 2] - (gy[2, 5] + gy[5, 2]) >= -tol,
                2*px[2, 3] + 2*px[3, 2] + 2*py[1, 2] + 2*py[2, 1] - (gy[3, 4] + gy[4, 3]) <= tol,
                2*px[2, 3] + 2*px[3, 2] + 2*py[1, 2] + 2*py[2, 1] - (gy[3, 4] + gy[4, 3]) >= -tol,
                2*px[1, 2] + 2*px[2, 1] - (gy[1, 3] + gy[2, 2] + gy[3, 1]) <= tol,
                2*px[1, 2] + 2*px[2, 1] - (gy[1, 3] + gy[2, 2] + gy[3, 1]) >= -tol,
                2*py[4, 4] - (gy[5, 6] + gy[6, 5]) <= tol,
                2*py[4, 4] - (gy[5, 6] + gy[6, 5]) >= -tol,
                2*py[2, 4] + 2*py[4, 2] - (gy[2, 6] + gy[6, 2]) <= tol,
                2*py[2, 4] + 2*py[4, 2] - (gy[2, 6] + gy[6, 2]) >= -tol,
                2*px[2, 4] + 2*px[4, 2] - (gy[3, 5] + gy[5, 3]) <= tol,
                2*px[2, 4] + 2*px[4, 2] - (gy[3, 5] + gy[5, 3]) >= -tol,
                2*px[2, 2] - (gy[2, 3] + gy[3, 2]) <= tol,
                2*px[2, 2] - (gy[2, 3] + gy[3, 2]) >= -tol,
                gy[6, 6] <= tol, gy[6, 6] >= -tol,
                gy[3, 6] + gy[6, 3] <= tol, gy[3, 6] + gy[6, 3] >= -tol,
                gy[3, 3] <= tol, gy[3, 3] >= -tol,]
    if max_deg_ds == 6:
        return [gx[0, 0] <= tol, gx[0, 0] >= -tol,
                2*py[0, 0] - (gx[0, 5] + gx[5, 0]) <= tol,
                2*py[0, 0] - (gx[0, 5] + gx[5, 0]) >= -tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) <= tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) >= -tol,
                2*py[0, 4] + 2*py[4, 0] - (gx[0, 6] + gx[5, 5] + gx[6, 0]) <= tol,
                2*py[0, 4] + 2*py[4, 0] - (gx[0, 6] + gx[5, 5] + gx[6, 0]) >= -tol,
                2*px[0, 4] + 2*px[4, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 5] + gx[5, 1]) <= tol,
                2*px[0, 4] + 2*px[4, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 5] + gx[5, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) >= -tol,
                2*py[0, 5] + 2*py[4, 4] + 2*py[5, 0] - (gx[0, 7] + gx[5, 6] + gx[6, 5] + gx[7, 0]) <= tol,
                2*py[0, 5] + 2*py[4, 4] + 2*py[5, 0] - (gx[0, 7] + gx[5, 6] + gx[6, 5] + gx[7, 0]) >= -tol,
                2*px[0, 5] + 2*px[4, 4] + 2*px[5, 0] + 2*py[1, 4] + 2*py[4, 1] - (gx[1, 6] + gx[6, 1]) <= tol,
                2*px[0, 5] + 2*px[4, 4] + 2*px[5, 0] + 2*py[1, 4] + 2*py[4, 1] - (gx[1, 6] + gx[6, 1]) >= -tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 5] + gx[5, 2]) <= tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 5] + gx[5, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) >= -tol,
                2*py[0, 6] + 2*py[4, 5] + 2*py[5, 4] + 2*py[6, 0] - (gx[0, 8] + gx[5, 7] + gx[6, 6] + gx[7, 5] + gx[8, 0]) <= tol,
                2*py[0, 6] + 2*py[4, 5] + 2*py[5, 4] + 2*py[6, 0] - (gx[0, 8] + gx[5, 7] + gx[6, 6] + gx[7, 5] + gx[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[4, 5] + 2*px[5, 4] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gx[1, 7] + gx[7, 1]) <= tol,
                2*px[0, 6] + 2*px[4, 5] + 2*px[5, 4] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gx[1, 7] + gx[7, 1]) >= -tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[2, 4] + 2*py[4, 2] - (gx[2, 6] + gx[6, 2]) <= tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[2, 4] + 2*py[4, 2] - (gx[2, 6] + gx[6, 2]) >= -tol,
                2*px[2, 4] + 2*px[4, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 5] + gx[5, 3]) <= tol,
                2*px[2, 4] + 2*px[4, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 5] + gx[5, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) >= -tol,
                2*py[4, 6] + 2*py[5, 5] + 2*py[6, 4] - (gx[5, 8] + gx[6, 7] + gx[7, 6] + gx[8, 5]) <= tol,
                2*py[4, 6] + 2*py[5, 5] + 2*py[6, 4] - (gx[5, 8] + gx[6, 7] + gx[7, 6] + gx[8, 5]) >= -tol,
                2*px[4, 6] + 2*px[5, 5] + 2*px[6, 4] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) <= tol,
                2*px[4, 6] + 2*px[5, 5] + 2*px[6, 4] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gx[2, 7] + gx[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gx[2, 7] + gx[7, 2]) >= -tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[3, 4] + 2*py[4, 3] - (gx[3, 6] + gx[6, 3]) <= tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[3, 4] + 2*py[4, 3] - (gx[3, 6] + gx[6, 3]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] - (gx[4, 5] + gx[5, 4]) <= tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] - (gx[4, 5] + gx[5, 4]) >= -tol,
                2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] - (gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1]) <= tol,
                2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] - (gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1]) >= -tol,
                2*py[5, 6] + 2*py[6, 5] - (gx[6, 8] + gx[7, 7] + gx[8, 6]) <= tol,
                2*py[5, 6] + 2*py[6, 5] - (gx[6, 8] + gx[7, 7] + gx[8, 6]) >= -tol,
                2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) <= tol,
                2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gx[3, 7] + gx[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gx[3, 7] + gx[7, 3]) >= -tol,
                2*px[3, 5] + 2*px[5, 3] - (gx[4, 6] + gx[6, 4]) <= tol,
                2*px[3, 5] + 2*px[5, 3] - (gx[4, 6] + gx[6, 4]) >= -tol,
                2*px[2, 3] + 2*px[3, 2] - (gx[2, 4] + gx[3, 3] + gx[4, 2]) <= tol,
                2*px[2, 3] + 2*px[3, 2] - (gx[2, 4] + gx[3, 3] + gx[4, 2]) >= -tol,
                2*py[6, 6] - (gx[7, 8] + gx[8, 7]) <= tol,
                2*py[6, 6] - (gx[7, 8] + gx[8, 7]) >= -tol,
                2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) <= tol,
                2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] - (gx[4, 7] + gx[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] - (gx[4, 7] + gx[7, 4]) >= -tol,
                2*px[3, 3] - (gx[3, 4] + gx[4, 3]) <= tol,
                2*px[3, 3] - (gx[3, 4] + gx[4, 3]) >= -tol,
                gx[8, 8] <= tol, gx[8, 8] >= -tol,
                gx[4, 8] + gx[8, 4] <= tol, gx[4, 8] + gx[8, 4] >= -tol,
                gx[4, 4] <= tol, gx[4, 4] >= -tol,
                gy[0, 0] <= tol, gy[0, 0] >= -tol,
                2*py[0, 0] - (gy[0, 5] + gy[5, 0]) <= tol,
                2*py[0, 0] - (gy[0, 5] + gy[5, 0]) >= -tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) <= tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) >= -tol,
                2*py[0, 4] + 2*py[4, 0] - (gy[0, 6] + gy[5, 5] + gy[6, 0]) <= tol,
                2*py[0, 4] + 2*py[4, 0] - (gy[0, 6] + gy[5, 5] + gy[6, 0]) >= -tol,
                2*px[0, 4] + 2*px[4, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 5] + gy[5, 1]) <= tol,
                2*px[0, 4] + 2*px[4, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 5] + gy[5, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) >= -tol,
                2*py[0, 5] + 2*py[4, 4] + 2*py[5, 0] - (gy[0, 7] + gy[5, 6] + gy[6, 5] + gy[7, 0]) <= tol,
                2*py[0, 5] + 2*py[4, 4] + 2*py[5, 0] - (gy[0, 7] + gy[5, 6] + gy[6, 5] + gy[7, 0]) >= -tol,
                2*px[0, 5] + 2*px[4, 4] + 2*px[5, 0] + 2*py[1, 4] + 2*py[4, 1] - (gy[1, 6] + gy[6, 1]) <= tol,
                2*px[0, 5] + 2*px[4, 4] + 2*px[5, 0] + 2*py[1, 4] + 2*py[4, 1] - (gy[1, 6] + gy[6, 1]) >= -tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 5] + gy[5, 2]) <= tol,
                2*px[1, 4] + 2*px[4, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 5] + gy[5, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) >= -tol,
                2*py[0, 6] + 2*py[4, 5] + 2*py[5, 4] + 2*py[6, 0] - (gy[0, 8] + gy[5, 7] + gy[6, 6] + gy[7, 5] + gy[8, 0]) <= tol,
                2*py[0, 6] + 2*py[4, 5] + 2*py[5, 4] + 2*py[6, 0] - (gy[0, 8] + gy[5, 7] + gy[6, 6] + gy[7, 5] + gy[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[4, 5] + 2*px[5, 4] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gy[1, 7] + gy[7, 1]) <= tol,
                2*px[0, 6] + 2*px[4, 5] + 2*px[5, 4] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gy[1, 7] + gy[7, 1]) >= -tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[2, 4] + 2*py[4, 2] - (gy[2, 6] + gy[6, 2]) <= tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[2, 4] + 2*py[4, 2] - (gy[2, 6] + gy[6, 2]) >= -tol,
                2*px[2, 4] + 2*px[4, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 5] + gy[5, 3]) <= tol,
                2*px[2, 4] + 2*px[4, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 5] + gy[5, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) >= -tol,
                2*py[4, 6] + 2*py[5, 5] + 2*py[6, 4] - (gy[5, 8] + gy[6, 7] + gy[7, 6] + gy[8, 5]) <= tol,
                2*py[4, 6] + 2*py[5, 5] + 2*py[6, 4] - (gy[5, 8] + gy[6, 7] + gy[7, 6] + gy[8, 5]) >= -tol,
                2*px[4, 6] + 2*px[5, 5] + 2*px[6, 4] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) <= tol,
                2*px[4, 6] + 2*px[5, 5] + 2*px[6, 4] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gy[2, 7] + gy[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gy[2, 7] + gy[7, 2]) >= -tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[3, 4] + 2*py[4, 3] - (gy[3, 6] + gy[6, 3]) <= tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[3, 4] + 2*py[4, 3] - (gy[3, 6] + gy[6, 3]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] - (gy[4, 5] + gy[5, 4]) <= tol,
                2*px[3, 4] + 2*px[4, 3] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] - (gy[4, 5] + gy[5, 4]) >= -tol,
                2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] - (gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1]) <= tol,
                2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] - (gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1]) >= -tol,
                2*py[5, 6] + 2*py[6, 5] - (gy[6, 8] + gy[7, 7] + gy[8, 6]) <= tol,
                2*py[5, 6] + 2*py[6, 5] - (gy[6, 8] + gy[7, 7] + gy[8, 6]) >= -tol,
                2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) <= tol,
                2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gy[3, 7] + gy[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gy[3, 7] + gy[7, 3]) >= -tol,
                2*px[3, 5] + 2*px[5, 3] - (gy[4, 6] + gy[6, 4]) <= tol,
                2*px[3, 5] + 2*px[5, 3] - (gy[4, 6] + gy[6, 4]) >= -tol,
                2*px[2, 3] + 2*px[3, 2] - (gy[2, 4] + gy[3, 3] + gy[4, 2]) <= tol,
                2*px[2, 3] + 2*px[3, 2] - (gy[2, 4] + gy[3, 3] + gy[4, 2]) >= -tol,
                2*py[6, 6] - (gy[7, 8] + gy[8, 7]) <= tol,
                2*py[6, 6] - (gy[7, 8] + gy[8, 7]) >= -tol,
                2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) <= tol,
                2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] - (gy[4, 7] + gy[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] - (gy[4, 7] + gy[7, 4]) >= -tol,
                2*px[3, 3] - (gy[3, 4] + gy[4, 3]) <= tol,
                2*px[3, 3] - (gy[3, 4] + gy[4, 3]) >= -tol,
                gy[8, 8] <= tol, gy[8, 8] >= -tol,
                gy[4, 8] + gy[8, 4] <= tol, gy[4, 8] + gy[8, 4] >= -tol,
                gy[4, 4] <= tol, gy[4, 4] >= -tol,]
    if max_deg_ds == 8:
        return [gx[0, 0] <= tol, gx[0, 0] >= -tol,
                2*py[0, 0] - (gx[0, 6] + gx[6, 0]) <= tol,
                2*py[0, 0] - (gx[0, 6] + gx[6, 0]) >= -tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) <= tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) >= -tol,
                2*py[0, 5] + 2*py[5, 0] - (gx[0, 7] + gx[6, 6] + gx[7, 0]) <= tol,
                2*py[0, 5] + 2*py[5, 0] - (gx[0, 7] + gx[6, 6] + gx[7, 0]) >= -tol,
                2*px[0, 5] + 2*px[5, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 6] + gx[6, 1]) <= tol,
                2*px[0, 5] + 2*px[5, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 6] + gx[6, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) >= -tol,
                2*py[0, 6] + 2*py[5, 5] + 2*py[6, 0] - (gx[0, 8] + gx[6, 7] + gx[7, 6] + gx[8, 0]) <= tol,
                2*py[0, 6] + 2*py[5, 5] + 2*py[6, 0] - (gx[0, 8] + gx[6, 7] + gx[7, 6] + gx[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[5, 5] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gx[1, 7] + gx[7, 1]) <= tol,
                2*px[0, 6] + 2*px[5, 5] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gx[1, 7] + gx[7, 1]) >= -tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 6] + gx[6, 2]) <= tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 6] + gx[6, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) >= -tol,
                2*py[0, 7] + 2*py[5, 6] + 2*py[6, 5] + 2*py[7, 0] - (gx[0, 9] + gx[6, 8] + gx[7, 7] + gx[8, 6] + gx[9, 0]) <= tol,
                2*py[0, 7] + 2*py[5, 6] + 2*py[6, 5] + 2*py[7, 0] - (gx[0, 9] + gx[6, 8] + gx[7, 7] + gx[8, 6] + gx[9, 0]) >= -tol,
                2*px[0, 7] + 2*px[5, 6] + 2*px[6, 5] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) <= tol,
                2*px[0, 7] + 2*px[5, 6] + 2*px[6, 5] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gx[2, 7] + gx[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gx[2, 7] + gx[7, 2]) >= -tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 6] + gx[6, 3]) <= tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 6] + gx[6, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) >= -tol,
                2*py[0, 8] + 2*py[5, 7] + 2*py[6, 6] + 2*py[7, 5] + 2*py[8, 0] - (gx[0, 10] + gx[6, 9] + gx[7, 8] + gx[8, 7] + gx[9, 6] + gx[10, 0]) <= tol,
                2*py[0, 8] + 2*py[5, 7] + 2*py[6, 6] + 2*py[7, 5] + 2*py[8, 0] - (gx[0, 10] + gx[6, 9] + gx[7, 8] + gx[8, 7] + gx[9, 6] + gx[10, 0]) >= -tol,
                2*px[0, 8] + 2*px[5, 7] + 2*px[6, 6] + 2*px[7, 5] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gx[1, 9] + gx[9, 1]) <= tol,
                2*px[0, 8] + 2*px[5, 7] + 2*px[6, 6] + 2*px[7, 5] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gx[1, 9] + gx[9, 1]) >= -tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) <= tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gx[3, 7] + gx[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gx[3, 7] + gx[7, 3]) >= -tol,
                2*px[3, 5] + 2*px[5, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gx[4, 6] + gx[6, 4]) <= tol,
                2*px[3, 5] + 2*px[5, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gx[4, 6] + gx[6, 4]) >= -tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gx[0, 5] + gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1] + gx[5, 0]) <= tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gx[0, 5] + gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1] + gx[5, 0]) >= -tol,
                2*py[5, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 5] - (gx[6, 10] + gx[7, 9] + gx[8, 8] + gx[9, 7] + gx[10, 6]) <= tol,
                2*py[5, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 5] - (gx[6, 10] + gx[7, 9] + gx[8, 8] + gx[9, 7] + gx[10, 6]) >= -tol,
                2*px[5, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 5] + 2*py[1, 8] + 2*py[8, 1] - (gx[1, 10] + gx[10, 1]) <= tol,
                2*px[5, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 5] + 2*py[1, 8] + 2*py[8, 1] - (gx[1, 10] + gx[10, 1]) >= -tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gx[2, 9] + gx[9, 2]) <= tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gx[2, 9] + gx[9, 2]) >= -tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) <= tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[4, 5] + 2*py[5, 4] - (gx[4, 7] + gx[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[4, 5] + 2*py[5, 4] - (gx[4, 7] + gx[7, 4]) >= -tol,
                2*px[4, 5] + 2*px[5, 4] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] - (gx[5, 6] + gx[6, 5]) <= tol,
                2*px[4, 5] + 2*px[5, 4] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] - (gx[5, 6] + gx[6, 5]) >= -tol,
                2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] - (gx[1, 5] + gx[2, 4] + gx[3, 3] + gx[4, 2] + gx[5, 1]) <= tol,
                2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] - (gx[1, 5] + gx[2, 4] + gx[3, 3] + gx[4, 2] + gx[5, 1]) >= -tol,
                2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] - (gx[7, 10] + gx[8, 9] + gx[9, 8] + gx[10, 7]) <= tol,
                2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] - (gx[7, 10] + gx[8, 9] + gx[9, 8] + gx[10, 7]) >= -tol,
                2*py[2, 8] + 2*py[8, 2] - (gx[2, 10] + gx[10, 2]) <= tol,
                2*py[2, 8] + 2*py[8, 2] - (gx[2, 10] + gx[10, 2]) >= -tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gx[3, 9] + gx[9, 3]) <= tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gx[3, 9] + gx[9, 3]) >= -tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gx[4, 8] + gx[8, 4]) <= tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gx[4, 8] + gx[8, 4]) >= -tol,
                2*px[4, 6] + 2*px[6, 4] - (gx[5, 7] + gx[7, 5]) <= tol,
                2*px[4, 6] + 2*px[6, 4] - (gx[5, 7] + gx[7, 5]) >= -tol,
                2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] - (gx[2, 5] + gx[3, 4] + gx[4, 3] + gx[5, 2]) <= tol,
                2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] - (gx[2, 5] + gx[3, 4] + gx[4, 3] + gx[5, 2]) >= -tol,
                2*py[7, 8] + 2*py[8, 7] - (gx[8, 10] + gx[9, 9] + gx[10, 8]) <= tol,
                2*py[7, 8] + 2*py[8, 7] - (gx[8, 10] + gx[9, 9] + gx[10, 8]) >= -tol,
                2*py[3, 8] + 2*py[8, 3] - (gx[3, 10] + gx[10, 3]) <= tol,
                2*py[3, 8] + 2*py[8, 3] - (gx[3, 10] + gx[10, 3]) >= -tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gx[4, 9] + gx[9, 4]) <= tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gx[4, 9] + gx[9, 4]) >= -tol,
                2*px[4, 7] + 2*px[7, 4] - (gx[5, 8] + gx[8, 5]) <= tol,
                2*px[4, 7] + 2*px[7, 4] - (gx[5, 8] + gx[8, 5]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] - (gx[3, 5] + gx[4, 4] + gx[5, 3]) <= tol,
                2*px[3, 4] + 2*px[4, 3] - (gx[3, 5] + gx[4, 4] + gx[5, 3]) >= -tol,
                2*py[8, 8] - (gx[9, 10] + gx[10, 9]) <= tol,
                2*py[8, 8] - (gx[9, 10] + gx[10, 9]) >= -tol,
                2*py[4, 8] + 2*py[8, 4] - (gx[4, 10] + gx[10, 4]) <= tol,
                2*py[4, 8] + 2*py[8, 4] - (gx[4, 10] + gx[10, 4]) >= -tol,
                2*px[4, 8] + 2*px[8, 4] - (gx[5, 9] + gx[9, 5]) <= tol,
                2*px[4, 8] + 2*px[8, 4] - (gx[5, 9] + gx[9, 5]) >= -tol,
                2*px[4, 4] - (gx[4, 5] + gx[5, 4]) <= tol,
                2*px[4, 4] - (gx[4, 5] + gx[5, 4]) >= -tol,
                gx[10, 10] <= tol, gx[10, 10] >= -tol,
                gx[5, 10] + gx[10, 5] <= tol, gx[5, 10] + gx[10, 5] >= -tol,
                gx[5, 5] <= tol, gx[5, 5] >= -tol,
                gy[0, 0] <= tol, gy[0, 0] >= -tol,
                2*py[0, 0] - (gy[0, 6] + gy[6, 0]) <= tol,
                2*py[0, 0] - (gy[0, 6] + gy[6, 0]) >= -tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) <= tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) >= -tol,
                2*py[0, 5] + 2*py[5, 0] - (gy[0, 7] + gy[6, 6] + gy[7, 0]) <= tol,
                2*py[0, 5] + 2*py[5, 0] - (gy[0, 7] + gy[6, 6] + gy[7, 0]) >= -tol,
                2*px[0, 5] + 2*px[5, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 6] + gy[6, 1]) <= tol,
                2*px[0, 5] + 2*px[5, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 6] + gy[6, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) >= -tol,
                2*py[0, 6] + 2*py[5, 5] + 2*py[6, 0] - (gy[0, 8] + gy[6, 7] + gy[7, 6] + gy[8, 0]) <= tol,
                2*py[0, 6] + 2*py[5, 5] + 2*py[6, 0] - (gy[0, 8] + gy[6, 7] + gy[7, 6] + gy[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[5, 5] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gy[1, 7] + gy[7, 1]) <= tol,
                2*px[0, 6] + 2*px[5, 5] + 2*px[6, 0] + 2*py[1, 5] + 2*py[5, 1] - (gy[1, 7] + gy[7, 1]) >= -tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 6] + gy[6, 2]) <= tol,
                2*px[1, 5] + 2*px[5, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 6] + gy[6, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) >= -tol,
                2*py[0, 7] + 2*py[5, 6] + 2*py[6, 5] + 2*py[7, 0] - (gy[0, 9] + gy[6, 8] + gy[7, 7] + gy[8, 6] + gy[9, 0]) <= tol,
                2*py[0, 7] + 2*py[5, 6] + 2*py[6, 5] + 2*py[7, 0] - (gy[0, 9] + gy[6, 8] + gy[7, 7] + gy[8, 6] + gy[9, 0]) >= -tol,
                2*px[0, 7] + 2*px[5, 6] + 2*px[6, 5] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) <= tol,
                2*px[0, 7] + 2*px[5, 6] + 2*px[6, 5] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gy[2, 7] + gy[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[2, 5] + 2*py[5, 2] - (gy[2, 7] + gy[7, 2]) >= -tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 6] + gy[6, 3]) <= tol,
                2*px[2, 5] + 2*px[5, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 6] + gy[6, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) >= -tol,
                2*py[0, 8] + 2*py[5, 7] + 2*py[6, 6] + 2*py[7, 5] + 2*py[8, 0] - (gy[0, 10] + gy[6, 9] + gy[7, 8] + gy[8, 7] + gy[9, 6] + gy[10, 0]) <= tol,
                2*py[0, 8] + 2*py[5, 7] + 2*py[6, 6] + 2*py[7, 5] + 2*py[8, 0] - (gy[0, 10] + gy[6, 9] + gy[7, 8] + gy[8, 7] + gy[9, 6] + gy[10, 0]) >= -tol,
                2*px[0, 8] + 2*px[5, 7] + 2*px[6, 6] + 2*px[7, 5] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gy[1, 9] + gy[9, 1]) <= tol,
                2*px[0, 8] + 2*px[5, 7] + 2*px[6, 6] + 2*px[7, 5] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gy[1, 9] + gy[9, 1]) >= -tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) <= tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gy[3, 7] + gy[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[3, 5] + 2*py[5, 3] - (gy[3, 7] + gy[7, 3]) >= -tol,
                2*px[3, 5] + 2*px[5, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gy[4, 6] + gy[6, 4]) <= tol,
                2*px[3, 5] + 2*px[5, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gy[4, 6] + gy[6, 4]) >= -tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gy[0, 5] + gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1] + gy[5, 0]) <= tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gy[0, 5] + gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1] + gy[5, 0]) >= -tol,
                2*py[5, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 5] - (gy[6, 10] + gy[7, 9] + gy[8, 8] + gy[9, 7] + gy[10, 6]) <= tol,
                2*py[5, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 5] - (gy[6, 10] + gy[7, 9] + gy[8, 8] + gy[9, 7] + gy[10, 6]) >= -tol,
                2*px[5, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 5] + 2*py[1, 8] + 2*py[8, 1] - (gy[1, 10] + gy[10, 1]) <= tol,
                2*px[5, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 5] + 2*py[1, 8] + 2*py[8, 1] - (gy[1, 10] + gy[10, 1]) >= -tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gy[2, 9] + gy[9, 2]) <= tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gy[2, 9] + gy[9, 2]) >= -tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) <= tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[4, 5] + 2*py[5, 4] - (gy[4, 7] + gy[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[4, 5] + 2*py[5, 4] - (gy[4, 7] + gy[7, 4]) >= -tol,
                2*px[4, 5] + 2*px[5, 4] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] - (gy[5, 6] + gy[6, 5]) <= tol,
                2*px[4, 5] + 2*px[5, 4] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] - (gy[5, 6] + gy[6, 5]) >= -tol,
                2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] - (gy[1, 5] + gy[2, 4] + gy[3, 3] + gy[4, 2] + gy[5, 1]) <= tol,
                2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] - (gy[1, 5] + gy[2, 4] + gy[3, 3] + gy[4, 2] + gy[5, 1]) >= -tol,
                2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] - (gy[7, 10] + gy[8, 9] + gy[9, 8] + gy[10, 7]) <= tol,
                2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] - (gy[7, 10] + gy[8, 9] + gy[9, 8] + gy[10, 7]) >= -tol,
                2*py[2, 8] + 2*py[8, 2] - (gy[2, 10] + gy[10, 2]) <= tol,
                2*py[2, 8] + 2*py[8, 2] - (gy[2, 10] + gy[10, 2]) >= -tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gy[3, 9] + gy[9, 3]) <= tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gy[3, 9] + gy[9, 3]) >= -tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gy[4, 8] + gy[8, 4]) <= tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gy[4, 8] + gy[8, 4]) >= -tol,
                2*px[4, 6] + 2*px[6, 4] - (gy[5, 7] + gy[7, 5]) <= tol,
                2*px[4, 6] + 2*px[6, 4] - (gy[5, 7] + gy[7, 5]) >= -tol,
                2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] - (gy[2, 5] + gy[3, 4] + gy[4, 3] + gy[5, 2]) <= tol,
                2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] - (gy[2, 5] + gy[3, 4] + gy[4, 3] + gy[5, 2]) >= -tol,
                2*py[7, 8] + 2*py[8, 7] - (gy[8, 10] + gy[9, 9] + gy[10, 8]) <= tol,
                2*py[7, 8] + 2*py[8, 7] - (gy[8, 10] + gy[9, 9] + gy[10, 8]) >= -tol,
                2*py[3, 8] + 2*py[8, 3] - (gy[3, 10] + gy[10, 3]) <= tol,
                2*py[3, 8] + 2*py[8, 3] - (gy[3, 10] + gy[10, 3]) >= -tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gy[4, 9] + gy[9, 4]) <= tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gy[4, 9] + gy[9, 4]) >= -tol,
                2*px[4, 7] + 2*px[7, 4] - (gy[5, 8] + gy[8, 5]) <= tol,
                2*px[4, 7] + 2*px[7, 4] - (gy[5, 8] + gy[8, 5]) >= -tol,
                2*px[3, 4] + 2*px[4, 3] - (gy[3, 5] + gy[4, 4] + gy[5, 3]) <= tol,
                2*px[3, 4] + 2*px[4, 3] - (gy[3, 5] + gy[4, 4] + gy[5, 3]) >= -tol,
                2*py[8, 8] - (gy[9, 10] + gy[10, 9]) <= tol,
                2*py[8, 8] - (gy[9, 10] + gy[10, 9]) >= -tol,
                2*py[4, 8] + 2*py[8, 4] - (gy[4, 10] + gy[10, 4]) <= tol,
                2*py[4, 8] + 2*py[8, 4] - (gy[4, 10] + gy[10, 4]) >= -tol,
                2*px[4, 8] + 2*px[8, 4] - (gy[5, 9] + gy[9, 5]) <= tol,
                2*px[4, 8] + 2*px[8, 4] - (gy[5, 9] + gy[9, 5]) >= -tol,
                2*px[4, 4] - (gy[4, 5] + gy[5, 4]) <= tol,
                2*px[4, 4] - (gy[4, 5] + gy[5, 4]) >= -tol,
                gy[10, 10] <= tol, gy[10, 10] >= -tol,
                gy[5, 10] + gy[10, 5] <= tol, gy[5, 10] + gy[10, 5] >= -tol,
                gy[5, 5] <= tol, gy[5, 5] >= -tol,]
    if max_deg_ds == 10:
        return [gx[0, 0] <= tol, gx[0, 0] >= -tol,
                2*py[0, 0] - (gx[0, 7] + gx[7, 0]) <= tol,
                2*py[0, 0] - (gx[0, 7] + gx[7, 0]) >= -tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) <= tol,
                2*px[0, 0] - (gx[0, 1] + gx[1, 0]) >= -tol,
                2*py[0, 6] + 2*py[6, 0] - (gx[0, 8] + gx[7, 7] + gx[8, 0]) <= tol,
                2*py[0, 6] + 2*py[6, 0] - (gx[0, 8] + gx[7, 7] + gx[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[6, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 7] + gx[7, 1]) <= tol,
                2*px[0, 6] + 2*px[6, 0] + 2*py[0, 1] + 2*py[1, 0] - (gx[1, 7] + gx[7, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gx[0, 2] + gx[1, 1] + gx[2, 0]) >= -tol,
                2*py[0, 7] + 2*py[6, 6] + 2*py[7, 0] - (gx[0, 9] + gx[7, 8] + gx[8, 7] + gx[9, 0]) <= tol,
                2*py[0, 7] + 2*py[6, 6] + 2*py[7, 0] - (gx[0, 9] + gx[7, 8] + gx[8, 7] + gx[9, 0]) >= -tol,
                2*px[0, 7] + 2*px[6, 6] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) <= tol,
                2*px[0, 7] + 2*px[6, 6] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gx[1, 8] + gx[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 7] + gx[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gx[2, 7] + gx[7, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gx[0, 3] + gx[1, 2] + gx[2, 1] + gx[3, 0]) >= -tol,
                2*py[0, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 0] - (gx[0, 10] + gx[7, 9] + gx[8, 8] + gx[9, 7] + gx[10, 0]) <= tol,
                2*py[0, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 0] - (gx[0, 10] + gx[7, 9] + gx[8, 8] + gx[9, 7] + gx[10, 0]) >= -tol,
                2*px[0, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gx[1, 9] + gx[9, 1]) <= tol,
                2*px[0, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gx[1, 9] + gx[9, 1]) >= -tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) <= tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gx[2, 8] + gx[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 7] + gx[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gx[3, 7] + gx[7, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gx[0, 4] + gx[1, 3] + gx[2, 2] + gx[3, 1] + gx[4, 0]) >= -tol,
                2*py[0, 9] + 2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] + 2*py[9, 0] - (gx[0, 11] + gx[7, 10] + gx[8, 9] + gx[9, 8] + gx[10, 7] + gx[11, 0]) <= tol,
                2*py[0, 9] + 2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] + 2*py[9, 0] - (gx[0, 11] + gx[7, 10] + gx[8, 9] + gx[9, 8] + gx[10, 7] + gx[11, 0]) >= -tol,
                2*px[0, 9] + 2*px[6, 8] + 2*px[7, 7] + 2*px[8, 6] + 2*px[9, 0] + 2*py[1, 8] + 2*py[8, 1] - (gx[1, 10] + gx[10, 1]) <= tol,
                2*px[0, 9] + 2*px[6, 8] + 2*px[7, 7] + 2*px[8, 6] + 2*px[9, 0] + 2*py[1, 8] + 2*py[8, 1] - (gx[1, 10] + gx[10, 1]) >= -tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gx[2, 9] + gx[9, 2]) <= tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gx[2, 9] + gx[9, 2]) >= -tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) <= tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gx[3, 8] + gx[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gx[4, 7] + gx[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gx[4, 7] + gx[7, 4]) >= -tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gx[0, 5] + gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1] + gx[5, 0]) <= tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gx[0, 5] + gx[1, 4] + gx[2, 3] + gx[3, 2] + gx[4, 1] + gx[5, 0]) >= -tol,
                2*py[0, 10] + 2*py[6, 9] + 2*py[7, 8] + 2*py[8, 7] + 2*py[9, 6] + 2*py[10, 0] - (gx[0, 12] + gx[7, 11] + gx[8, 10] + gx[9, 9] + gx[10, 8] + gx[11, 7] + gx[12, 0]) <= tol,
                2*py[0, 10] + 2*py[6, 9] + 2*py[7, 8] + 2*py[8, 7] + 2*py[9, 6] + 2*py[10, 0] - (gx[0, 12] + gx[7, 11] + gx[8, 10] + gx[9, 9] + gx[10, 8] + gx[11, 7] + gx[12, 0]) >= -tol,
                2*px[0, 10] + 2*px[6, 9] + 2*px[7, 8] + 2*px[8, 7] + 2*px[9, 6] + 2*px[10, 0] + 2*py[1, 9] + 2*py[9, 1] - (gx[1, 11] + gx[11, 1]) <= tol,
                2*px[0, 10] + 2*px[6, 9] + 2*px[7, 8] + 2*px[8, 7] + 2*px[9, 6] + 2*px[10, 0] + 2*py[1, 9] + 2*py[9, 1] - (gx[1, 11] + gx[11, 1]) >= -tol,
                2*px[1, 9] + 2*px[9, 1] + 2*py[2, 8] + 2*py[8, 2] - (gx[2, 10] + gx[10, 2]) <= tol,
                2*px[1, 9] + 2*px[9, 1] + 2*py[2, 8] + 2*py[8, 2] - (gx[2, 10] + gx[10, 2]) >= -tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gx[3, 9] + gx[9, 3]) <= tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gx[3, 9] + gx[9, 3]) >= -tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gx[4, 8] + gx[8, 4]) <= tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gx[4, 8] + gx[8, 4]) >= -tol,
                2*px[4, 6] + 2*px[6, 4] + 2*py[0, 5] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] + 2*py[5, 0] - (gx[5, 7] + gx[7, 5]) <= tol,
                2*px[4, 6] + 2*px[6, 4] + 2*py[0, 5] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] + 2*py[5, 0] - (gx[5, 7] + gx[7, 5]) >= -tol,
                2*px[0, 5] + 2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] + 2*px[5, 0] - (gx[0, 6] + gx[1, 5] + gx[2, 4] + gx[3, 3] + gx[4, 2] + gx[5, 1] + gx[6, 0]) <= tol,
                2*px[0, 5] + 2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] + 2*px[5, 0] - (gx[0, 6] + gx[1, 5] + gx[2, 4] + gx[3, 3] + gx[4, 2] + gx[5, 1] + gx[6, 0]) >= -tol,
                2*py[6, 10] + 2*py[7, 9] + 2*py[8, 8] + 2*py[9, 7] + 2*py[10, 6] - (gx[7, 12] + gx[8, 11] + gx[9, 10] + gx[10, 9] + gx[11, 8] + gx[12, 7]) <= tol,
                2*py[6, 10] + 2*py[7, 9] + 2*py[8, 8] + 2*py[9, 7] + 2*py[10, 6] - (gx[7, 12] + gx[8, 11] + gx[9, 10] + gx[10, 9] + gx[11, 8] + gx[12, 7]) >= -tol,
                2*px[6, 10] + 2*px[7, 9] + 2*px[8, 8] + 2*px[9, 7] + 2*px[10, 6] + 2*py[1, 10] + 2*py[10, 1] - (gx[1, 12] + gx[12, 1]) <= tol,
                2*px[6, 10] + 2*px[7, 9] + 2*px[8, 8] + 2*px[9, 7] + 2*px[10, 6] + 2*py[1, 10] + 2*py[10, 1] - (gx[1, 12] + gx[12, 1]) >= -tol,
                2*px[1, 10] + 2*px[10, 1] + 2*py[2, 9] + 2*py[9, 2] - (gx[2, 11] + gx[11, 2]) <= tol,
                2*px[1, 10] + 2*px[10, 1] + 2*py[2, 9] + 2*py[9, 2] - (gx[2, 11] + gx[11, 2]) >= -tol,
                2*px[2, 9] + 2*px[9, 2] + 2*py[3, 8] + 2*py[8, 3] - (gx[3, 10] + gx[10, 3]) <= tol,
                2*px[2, 9] + 2*px[9, 2] + 2*py[3, 8] + 2*py[8, 3] - (gx[3, 10] + gx[10, 3]) >= -tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gx[4, 9] + gx[9, 4]) <= tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gx[4, 9] + gx[9, 4]) >= -tol,
                2*px[4, 7] + 2*px[7, 4] + 2*py[5, 6] + 2*py[6, 5] - (gx[5, 8] + gx[8, 5]) <= tol,
                2*px[4, 7] + 2*px[7, 4] + 2*py[5, 6] + 2*py[6, 5] - (gx[5, 8] + gx[8, 5]) >= -tol,
                2*px[5, 6] + 2*px[6, 5] + 2*py[1, 5] + 2*py[2, 4] + 2*py[3, 3] + 2*py[4, 2] + 2*py[5, 1] - (gx[6, 7] + gx[7, 6]) <= tol,
                2*px[5, 6] + 2*px[6, 5] + 2*py[1, 5] + 2*py[2, 4] + 2*py[3, 3] + 2*py[4, 2] + 2*py[5, 1] - (gx[6, 7] + gx[7, 6]) >= -tol,
                2*px[1, 5] + 2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] + 2*px[5, 1] - (gx[1, 6] + gx[2, 5] + gx[3, 4] + gx[4, 3] + gx[5, 2] + gx[6, 1]) <= tol,
                2*px[1, 5] + 2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] + 2*px[5, 1] - (gx[1, 6] + gx[2, 5] + gx[3, 4] + gx[4, 3] + gx[5, 2] + gx[6, 1]) >= -tol,
                2*py[7, 10] + 2*py[8, 9] + 2*py[9, 8] + 2*py[10, 7] - (gx[8, 12] + gx[9, 11] + gx[10, 10] + gx[11, 9] + gx[12, 8]) <= tol,
                2*py[7, 10] + 2*py[8, 9] + 2*py[9, 8] + 2*py[10, 7] - (gx[8, 12] + gx[9, 11] + gx[10, 10] + gx[11, 9] + gx[12, 8]) >= -tol,
                2*py[2, 10] + 2*py[10, 2] - (gx[2, 12] + gx[12, 2]) <= tol,
                2*py[2, 10] + 2*py[10, 2] - (gx[2, 12] + gx[12, 2]) >= -tol,
                2*px[2, 10] + 2*px[10, 2] + 2*py[3, 9] + 2*py[9, 3] - (gx[3, 11] + gx[11, 3]) <= tol,
                2*px[2, 10] + 2*px[10, 2] + 2*py[3, 9] + 2*py[9, 3] - (gx[3, 11] + gx[11, 3]) >= -tol,
                2*px[3, 9] + 2*px[9, 3] + 2*py[4, 8] + 2*py[8, 4] - (gx[4, 10] + gx[10, 4]) <= tol,
                2*px[3, 9] + 2*px[9, 3] + 2*py[4, 8] + 2*py[8, 4] - (gx[4, 10] + gx[10, 4]) >= -tol,
                2*px[4, 8] + 2*px[8, 4] + 2*py[5, 7] + 2*py[7, 5] - (gx[5, 9] + gx[9, 5]) <= tol,
                2*px[4, 8] + 2*px[8, 4] + 2*py[5, 7] + 2*py[7, 5] - (gx[5, 9] + gx[9, 5]) >= -tol,
                2*px[5, 7] + 2*px[7, 5] - (gx[6, 8] + gx[8, 6]) <= tol,
                2*px[5, 7] + 2*px[7, 5] - (gx[6, 8] + gx[8, 6]) >= -tol,
                2*px[2, 5] + 2*px[3, 4] + 2*px[4, 3] + 2*px[5, 2] - (gx[2, 6] + gx[3, 5] + gx[4, 4] + gx[5, 3] + gx[6, 2]) <= tol,
                2*px[2, 5] + 2*px[3, 4] + 2*px[4, 3] + 2*px[5, 2] - (gx[2, 6] + gx[3, 5] + gx[4, 4] + gx[5, 3] + gx[6, 2]) >= -tol,
                2*py[8, 10] + 2*py[9, 9] + 2*py[10, 8] - (gx[9, 12] + gx[10, 11] + gx[11, 10] + gx[12, 9]) <= tol,
                2*py[8, 10] + 2*py[9, 9] + 2*py[10, 8] - (gx[9, 12] + gx[10, 11] + gx[11, 10] + gx[12, 9]) >= -tol,
                2*py[3, 10] + 2*py[10, 3] - (gx[3, 12] + gx[12, 3]) <= tol,
                2*py[3, 10] + 2*py[10, 3] - (gx[3, 12] + gx[12, 3]) >= -tol,
                2*px[3, 10] + 2*px[10, 3] + 2*py[4, 9] + 2*py[9, 4] - (gx[4, 11] + gx[11, 4]) <= tol,
                2*px[3, 10] + 2*px[10, 3] + 2*py[4, 9] + 2*py[9, 4] - (gx[4, 11] + gx[11, 4]) >= -tol,
                2*px[4, 9] + 2*px[9, 4] + 2*py[5, 8] + 2*py[8, 5] - (gx[5, 10] + gx[10, 5]) <= tol,
                2*px[4, 9] + 2*px[9, 4] + 2*py[5, 8] + 2*py[8, 5] - (gx[5, 10] + gx[10, 5]) >= -tol,
                2*px[5, 8] + 2*px[8, 5] - (gx[6, 9] + gx[9, 6]) <= tol,
                2*px[5, 8] + 2*px[8, 5] - (gx[6, 9] + gx[9, 6]) >= -tol,
                2*px[3, 5] + 2*px[4, 4] + 2*px[5, 3] - (gx[3, 6] + gx[4, 5] + gx[5, 4] + gx[6, 3]) <= tol,
                2*px[3, 5] + 2*px[4, 4] + 2*px[5, 3] - (gx[3, 6] + gx[4, 5] + gx[5, 4] + gx[6, 3]) >= -tol,
                2*py[9, 10] + 2*py[10, 9] - (gx[10, 12] + gx[11, 11] + gx[12, 10]) <= tol,
                2*py[9, 10] + 2*py[10, 9] - (gx[10, 12] + gx[11, 11] + gx[12, 10]) >= -tol,
                2*py[4, 10] + 2*py[10, 4] - (gx[4, 12] + gx[12, 4]) <= tol,
                2*py[4, 10] + 2*py[10, 4] - (gx[4, 12] + gx[12, 4]) >= -tol,
                2*px[4, 10] + 2*px[10, 4] + 2*py[5, 9] + 2*py[9, 5] - (gx[5, 11] + gx[11, 5]) <= tol,
                2*px[4, 10] + 2*px[10, 4] + 2*py[5, 9] + 2*py[9, 5] - (gx[5, 11] + gx[11, 5]) >= -tol,
                2*px[5, 9] + 2*px[9, 5] - (gx[6, 10] + gx[10, 6]) <= tol,
                2*px[5, 9] + 2*px[9, 5] - (gx[6, 10] + gx[10, 6]) >= -tol,
                2*px[4, 5] + 2*px[5, 4] - (gx[4, 6] + gx[5, 5] + gx[6, 4]) <= tol,
                2*px[4, 5] + 2*px[5, 4] - (gx[4, 6] + gx[5, 5] + gx[6, 4]) >= -tol,
                2*py[10, 10] - (gx[11, 12] + gx[12, 11]) <= tol,
                2*py[10, 10] - (gx[11, 12] + gx[12, 11]) >= -tol,
                2*py[5, 10] + 2*py[10, 5] - (gx[5, 12] + gx[12, 5]) <= tol,
                2*py[5, 10] + 2*py[10, 5] - (gx[5, 12] + gx[12, 5]) >= -tol,
                2*px[5, 10] + 2*px[10, 5] - (gx[6, 11] + gx[11, 6]) <= tol,
                2*px[5, 10] + 2*px[10, 5] - (gx[6, 11] + gx[11, 6]) >= -tol,
                2*px[5, 5] - (gx[5, 6] + gx[6, 5]) <= tol,
                2*px[5, 5] - (gx[5, 6] + gx[6, 5]) >= -tol,
                gx[12, 12] <= tol, gx[12, 12] >= -tol,
                gx[6, 12] + gx[12, 6] <= tol, gx[6, 12] + gx[12, 6] >= -tol,
                gx[6, 6] <= tol, gx[6, 6] >= -tol,
                gy[0, 0] <= tol, gy[0, 0] >= -tol,
                2*py[0, 0] - (gy[0, 7] + gy[7, 0]) <= tol,
                2*py[0, 0] - (gy[0, 7] + gy[7, 0]) >= -tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) <= tol,
                2*px[0, 0] - (gy[0, 1] + gy[1, 0]) >= -tol,
                2*py[0, 6] + 2*py[6, 0] - (gy[0, 8] + gy[7, 7] + gy[8, 0]) <= tol,
                2*py[0, 6] + 2*py[6, 0] - (gy[0, 8] + gy[7, 7] + gy[8, 0]) >= -tol,
                2*px[0, 6] + 2*px[6, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 7] + gy[7, 1]) <= tol,
                2*px[0, 6] + 2*px[6, 0] + 2*py[0, 1] + 2*py[1, 0] - (gy[1, 7] + gy[7, 1]) >= -tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) <= tol,
                2*px[0, 1] + 2*px[1, 0] - (gy[0, 2] + gy[1, 1] + gy[2, 0]) >= -tol,
                2*py[0, 7] + 2*py[6, 6] + 2*py[7, 0] - (gy[0, 9] + gy[7, 8] + gy[8, 7] + gy[9, 0]) <= tol,
                2*py[0, 7] + 2*py[6, 6] + 2*py[7, 0] - (gy[0, 9] + gy[7, 8] + gy[8, 7] + gy[9, 0]) >= -tol,
                2*px[0, 7] + 2*px[6, 6] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) <= tol,
                2*px[0, 7] + 2*px[6, 6] + 2*px[7, 0] + 2*py[1, 6] + 2*py[6, 1] - (gy[1, 8] + gy[8, 1]) >= -tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 7] + gy[7, 2]) <= tol,
                2*px[1, 6] + 2*px[6, 1] + 2*py[0, 2] + 2*py[1, 1] + 2*py[2, 0] - (gy[2, 7] + gy[7, 2]) >= -tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) <= tol,
                2*px[0, 2] + 2*px[1, 1] + 2*px[2, 0] - (gy[0, 3] + gy[1, 2] + gy[2, 1] + gy[3, 0]) >= -tol,
                2*py[0, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 0] - (gy[0, 10] + gy[7, 9] + gy[8, 8] + gy[9, 7] + gy[10, 0]) <= tol,
                2*py[0, 8] + 2*py[6, 7] + 2*py[7, 6] + 2*py[8, 0] - (gy[0, 10] + gy[7, 9] + gy[8, 8] + gy[9, 7] + gy[10, 0]) >= -tol,
                2*px[0, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gy[1, 9] + gy[9, 1]) <= tol,
                2*px[0, 8] + 2*px[6, 7] + 2*px[7, 6] + 2*px[8, 0] + 2*py[1, 7] + 2*py[7, 1] - (gy[1, 9] + gy[9, 1]) >= -tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) <= tol,
                2*px[1, 7] + 2*px[7, 1] + 2*py[2, 6] + 2*py[6, 2] - (gy[2, 8] + gy[8, 2]) >= -tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 7] + gy[7, 3]) <= tol,
                2*px[2, 6] + 2*px[6, 2] + 2*py[0, 3] + 2*py[1, 2] + 2*py[2, 1] + 2*py[3, 0] - (gy[3, 7] + gy[7, 3]) >= -tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) <= tol,
                2*px[0, 3] + 2*px[1, 2] + 2*px[2, 1] + 2*px[3, 0] - (gy[0, 4] + gy[1, 3] + gy[2, 2] + gy[3, 1] + gy[4, 0]) >= -tol,
                2*py[0, 9] + 2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] + 2*py[9, 0] - (gy[0, 11] + gy[7, 10] + gy[8, 9] + gy[9, 8] + gy[10, 7] + gy[11, 0]) <= tol,
                2*py[0, 9] + 2*py[6, 8] + 2*py[7, 7] + 2*py[8, 6] + 2*py[9, 0] - (gy[0, 11] + gy[7, 10] + gy[8, 9] + gy[9, 8] + gy[10, 7] + gy[11, 0]) >= -tol,
                2*px[0, 9] + 2*px[6, 8] + 2*px[7, 7] + 2*px[8, 6] + 2*px[9, 0] + 2*py[1, 8] + 2*py[8, 1] - (gy[1, 10] + gy[10, 1]) <= tol,
                2*px[0, 9] + 2*px[6, 8] + 2*px[7, 7] + 2*px[8, 6] + 2*px[9, 0] + 2*py[1, 8] + 2*py[8, 1] - (gy[1, 10] + gy[10, 1]) >= -tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gy[2, 9] + gy[9, 2]) <= tol,
                2*px[1, 8] + 2*px[8, 1] + 2*py[2, 7] + 2*py[7, 2] - (gy[2, 9] + gy[9, 2]) >= -tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) <= tol,
                2*px[2, 7] + 2*px[7, 2] + 2*py[3, 6] + 2*py[6, 3] - (gy[3, 8] + gy[8, 3]) >= -tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gy[4, 7] + gy[7, 4]) <= tol,
                2*px[3, 6] + 2*px[6, 3] + 2*py[0, 4] + 2*py[1, 3] + 2*py[2, 2] + 2*py[3, 1] + 2*py[4, 0] - (gy[4, 7] + gy[7, 4]) >= -tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gy[0, 5] + gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1] + gy[5, 0]) <= tol,
                2*px[0, 4] + 2*px[1, 3] + 2*px[2, 2] + 2*px[3, 1] + 2*px[4, 0] - (gy[0, 5] + gy[1, 4] + gy[2, 3] + gy[3, 2] + gy[4, 1] + gy[5, 0]) >= -tol,
                2*py[0, 10] + 2*py[6, 9] + 2*py[7, 8] + 2*py[8, 7] + 2*py[9, 6] + 2*py[10, 0] - (gy[0, 12] + gy[7, 11] + gy[8, 10] + gy[9, 9] + gy[10, 8] + gy[11, 7] + gy[12, 0]) <= tol,
                2*py[0, 10] + 2*py[6, 9] + 2*py[7, 8] + 2*py[8, 7] + 2*py[9, 6] + 2*py[10, 0] - (gy[0, 12] + gy[7, 11] + gy[8, 10] + gy[9, 9] + gy[10, 8] + gy[11, 7] + gy[12, 0]) >= -tol,
                2*px[0, 10] + 2*px[6, 9] + 2*px[7, 8] + 2*px[8, 7] + 2*px[9, 6] + 2*px[10, 0] + 2*py[1, 9] + 2*py[9, 1] - (gy[1, 11] + gy[11, 1]) <= tol,
                2*px[0, 10] + 2*px[6, 9] + 2*px[7, 8] + 2*px[8, 7] + 2*px[9, 6] + 2*px[10, 0] + 2*py[1, 9] + 2*py[9, 1] - (gy[1, 11] + gy[11, 1]) >= -tol,
                2*px[1, 9] + 2*px[9, 1] + 2*py[2, 8] + 2*py[8, 2] - (gy[2, 10] + gy[10, 2]) <= tol,
                2*px[1, 9] + 2*px[9, 1] + 2*py[2, 8] + 2*py[8, 2] - (gy[2, 10] + gy[10, 2]) >= -tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gy[3, 9] + gy[9, 3]) <= tol,
                2*px[2, 8] + 2*px[8, 2] + 2*py[3, 7] + 2*py[7, 3] - (gy[3, 9] + gy[9, 3]) >= -tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gy[4, 8] + gy[8, 4]) <= tol,
                2*px[3, 7] + 2*px[7, 3] + 2*py[4, 6] + 2*py[6, 4] - (gy[4, 8] + gy[8, 4]) >= -tol,
                2*px[4, 6] + 2*px[6, 4] + 2*py[0, 5] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] + 2*py[5, 0] - (gy[5, 7] + gy[7, 5]) <= tol,
                2*px[4, 6] + 2*px[6, 4] + 2*py[0, 5] + 2*py[1, 4] + 2*py[2, 3] + 2*py[3, 2] + 2*py[4, 1] + 2*py[5, 0] - (gy[5, 7] + gy[7, 5]) >= -tol,
                2*px[0, 5] + 2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] + 2*px[5, 0] - (gy[0, 6] + gy[1, 5] + gy[2, 4] + gy[3, 3] + gy[4, 2] + gy[5, 1] + gy[6, 0]) <= tol,
                2*px[0, 5] + 2*px[1, 4] + 2*px[2, 3] + 2*px[3, 2] + 2*px[4, 1] + 2*px[5, 0] - (gy[0, 6] + gy[1, 5] + gy[2, 4] + gy[3, 3] + gy[4, 2] + gy[5, 1] + gy[6, 0]) >= -tol,
                2*py[6, 10] + 2*py[7, 9] + 2*py[8, 8] + 2*py[9, 7] + 2*py[10, 6] - (gy[7, 12] + gy[8, 11] + gy[9, 10] + gy[10, 9] + gy[11, 8] + gy[12, 7]) <= tol,
                2*py[6, 10] + 2*py[7, 9] + 2*py[8, 8] + 2*py[9, 7] + 2*py[10, 6] - (gy[7, 12] + gy[8, 11] + gy[9, 10] + gy[10, 9] + gy[11, 8] + gy[12, 7]) >= -tol,
                2*px[6, 10] + 2*px[7, 9] + 2*px[8, 8] + 2*px[9, 7] + 2*px[10, 6] + 2*py[1, 10] + 2*py[10, 1] - (gy[1, 12] + gy[12, 1]) <= tol,
                2*px[6, 10] + 2*px[7, 9] + 2*px[8, 8] + 2*px[9, 7] + 2*px[10, 6] + 2*py[1, 10] + 2*py[10, 1] - (gy[1, 12] + gy[12, 1]) >= -tol,
                2*px[1, 10] + 2*px[10, 1] + 2*py[2, 9] + 2*py[9, 2] - (gy[2, 11] + gy[11, 2]) <= tol,
                2*px[1, 10] + 2*px[10, 1] + 2*py[2, 9] + 2*py[9, 2] - (gy[2, 11] + gy[11, 2]) >= -tol,
                2*px[2, 9] + 2*px[9, 2] + 2*py[3, 8] + 2*py[8, 3] - (gy[3, 10] + gy[10, 3]) <= tol,
                2*px[2, 9] + 2*px[9, 2] + 2*py[3, 8] + 2*py[8, 3] - (gy[3, 10] + gy[10, 3]) >= -tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gy[4, 9] + gy[9, 4]) <= tol,
                2*px[3, 8] + 2*px[8, 3] + 2*py[4, 7] + 2*py[7, 4] - (gy[4, 9] + gy[9, 4]) >= -tol,
                2*px[4, 7] + 2*px[7, 4] + 2*py[5, 6] + 2*py[6, 5] - (gy[5, 8] + gy[8, 5]) <= tol,
                2*px[4, 7] + 2*px[7, 4] + 2*py[5, 6] + 2*py[6, 5] - (gy[5, 8] + gy[8, 5]) >= -tol,
                2*px[5, 6] + 2*px[6, 5] + 2*py[1, 5] + 2*py[2, 4] + 2*py[3, 3] + 2*py[4, 2] + 2*py[5, 1] - (gy[6, 7] + gy[7, 6]) <= tol,
                2*px[5, 6] + 2*px[6, 5] + 2*py[1, 5] + 2*py[2, 4] + 2*py[3, 3] + 2*py[4, 2] + 2*py[5, 1] - (gy[6, 7] + gy[7, 6]) >= -tol,
                2*px[1, 5] + 2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] + 2*px[5, 1] - (gy[1, 6] + gy[2, 5] + gy[3, 4] + gy[4, 3] + gy[5, 2] + gy[6, 1]) <= tol,
                2*px[1, 5] + 2*px[2, 4] + 2*px[3, 3] + 2*px[4, 2] + 2*px[5, 1] - (gy[1, 6] + gy[2, 5] + gy[3, 4] + gy[4, 3] + gy[5, 2] + gy[6, 1]) >= -tol,
                2*py[7, 10] + 2*py[8, 9] + 2*py[9, 8] + 2*py[10, 7] - (gy[8, 12] + gy[9, 11] + gy[10, 10] + gy[11, 9] + gy[12, 8]) <= tol,
                2*py[7, 10] + 2*py[8, 9] + 2*py[9, 8] + 2*py[10, 7] - (gy[8, 12] + gy[9, 11] + gy[10, 10] + gy[11, 9] + gy[12, 8]) >= -tol,
                2*py[2, 10] + 2*py[10, 2] - (gy[2, 12] + gy[12, 2]) <= tol,
                2*py[2, 10] + 2*py[10, 2] - (gy[2, 12] + gy[12, 2]) >= -tol,
                2*px[2, 10] + 2*px[10, 2] + 2*py[3, 9] + 2*py[9, 3] - (gy[3, 11] + gy[11, 3]) <= tol,
                2*px[2, 10] + 2*px[10, 2] + 2*py[3, 9] + 2*py[9, 3] - (gy[3, 11] + gy[11, 3]) >= -tol,
                2*px[3, 9] + 2*px[9, 3] + 2*py[4, 8] + 2*py[8, 4] - (gy[4, 10] + gy[10, 4]) <= tol,
                2*px[3, 9] + 2*px[9, 3] + 2*py[4, 8] + 2*py[8, 4] - (gy[4, 10] + gy[10, 4]) >= -tol,
                2*px[4, 8] + 2*px[8, 4] + 2*py[5, 7] + 2*py[7, 5] - (gy[5, 9] + gy[9, 5]) <= tol,
                2*px[4, 8] + 2*px[8, 4] + 2*py[5, 7] + 2*py[7, 5] - (gy[5, 9] + gy[9, 5]) >= -tol,
                2*px[5, 7] + 2*px[7, 5] - (gy[6, 8] + gy[8, 6]) <= tol,
                2*px[5, 7] + 2*px[7, 5] - (gy[6, 8] + gy[8, 6]) >= -tol,
                2*px[2, 5] + 2*px[3, 4] + 2*px[4, 3] + 2*px[5, 2] - (gy[2, 6] + gy[3, 5] + gy[4, 4] + gy[5, 3] + gy[6, 2]) <= tol,
                2*px[2, 5] + 2*px[3, 4] + 2*px[4, 3] + 2*px[5, 2] - (gy[2, 6] + gy[3, 5] + gy[4, 4] + gy[5, 3] + gy[6, 2]) >= -tol,
                2*py[8, 10] + 2*py[9, 9] + 2*py[10, 8] - (gy[9, 12] + gy[10, 11] + gy[11, 10] + gy[12, 9]) <= tol,
                2*py[8, 10] + 2*py[9, 9] + 2*py[10, 8] - (gy[9, 12] + gy[10, 11] + gy[11, 10] + gy[12, 9]) >= -tol,
                2*py[3, 10] + 2*py[10, 3] - (gy[3, 12] + gy[12, 3]) <= tol,
                2*py[3, 10] + 2*py[10, 3] - (gy[3, 12] + gy[12, 3]) >= -tol,
                2*px[3, 10] + 2*px[10, 3] + 2*py[4, 9] + 2*py[9, 4] - (gy[4, 11] + gy[11, 4]) <= tol,
                2*px[3, 10] + 2*px[10, 3] + 2*py[4, 9] + 2*py[9, 4] - (gy[4, 11] + gy[11, 4]) >= -tol,
                2*px[4, 9] + 2*px[9, 4] + 2*py[5, 8] + 2*py[8, 5] - (gy[5, 10] + gy[10, 5]) <= tol,
                2*px[4, 9] + 2*px[9, 4] + 2*py[5, 8] + 2*py[8, 5] - (gy[5, 10] + gy[10, 5]) >= -tol,
                2*px[5, 8] + 2*px[8, 5] - (gy[6, 9] + gy[9, 6]) <= tol,
                2*px[5, 8] + 2*px[8, 5] - (gy[6, 9] + gy[9, 6]) >= -tol,
                2*px[3, 5] + 2*px[4, 4] + 2*px[5, 3] - (gy[3, 6] + gy[4, 5] + gy[5, 4] + gy[6, 3]) <= tol,
                2*px[3, 5] + 2*px[4, 4] + 2*px[5, 3] - (gy[3, 6] + gy[4, 5] + gy[5, 4] + gy[6, 3]) >= -tol,
                2*py[9, 10] + 2*py[10, 9] - (gy[10, 12] + gy[11, 11] + gy[12, 10]) <= tol,
                2*py[9, 10] + 2*py[10, 9] - (gy[10, 12] + gy[11, 11] + gy[12, 10]) >= -tol,
                2*py[4, 10] + 2*py[10, 4] - (gy[4, 12] + gy[12, 4]) <= tol,
                2*py[4, 10] + 2*py[10, 4] - (gy[4, 12] + gy[12, 4]) >= -tol,
                2*px[4, 10] + 2*px[10, 4] + 2*py[5, 9] + 2*py[9, 5] - (gy[5, 11] + gy[11, 5]) <= tol,
                2*px[4, 10] + 2*px[10, 4] + 2*py[5, 9] + 2*py[9, 5] - (gy[5, 11] + gy[11, 5]) >= -tol,
                2*px[5, 9] + 2*px[9, 5] - (gy[6, 10] + gy[10, 6]) <= tol,
                2*px[5, 9] + 2*px[9, 5] - (gy[6, 10] + gy[10, 6]) >= -tol,
                2*px[4, 5] + 2*px[5, 4] - (gy[4, 6] + gy[5, 5] + gy[6, 4]) <= tol,
                2*px[4, 5] + 2*px[5, 4] - (gy[4, 6] + gy[5, 5] + gy[6, 4]) >= -tol,
                2*py[10, 10] - (gy[11, 12] + gy[12, 11]) <= tol,
                2*py[10, 10] - (gy[11, 12] + gy[12, 11]) >= -tol,
                2*py[5, 10] + 2*py[10, 5] - (gy[5, 12] + gy[12, 5]) <= tol,
                2*py[5, 10] + 2*py[10, 5] - (gy[5, 12] + gy[12, 5]) >= -tol,
                2*px[5, 10] + 2*px[10, 5] - (gy[6, 11] + gy[11, 6]) <= tol,
                2*px[5, 10] + 2*px[10, 5] - (gy[6, 11] + gy[11, 6]) >= -tol,
                2*px[5, 5] - (gy[5, 6] + gy[6, 5]) <= tol,
                2*px[5, 5] - (gy[5, 6] + gy[6, 5]) >= -tol,
                gy[12, 12] <= tol, gy[12, 12] >= -tol,
                gy[6, 12] + gy[12, 6] <= tol, gy[6, 12] + gy[12, 6] >= -tol,
                gy[6, 6] <= tol, gy[6, 6] >= -tol,]

    raise NotImplementedError("Constraints must be generated seperately and added above!")

def get_printed_constraints_space(max_deg_ds, g, p, tol):
    """ Get printed constraints for space optimization.

    Args:
        max_deg_ds (int): Degree of the dynamical system.
        g (np.ndarray): Optimization param.
        p (np.ndarray): Optimization param.
        tol (flpat): Optimization param.

    Returns:
        List[Constraints]: List of cvxpy compatible constraints.
    """
    if max_deg_ds == 2:
        return [g[0, 0] <= tol, g[0, 0] >= -tol,
                2*p[0, 1] - (g[0, 3] + g[3, 0]) <= tol,
                2*p[0, 1] - (g[0, 3] + g[3, 0]) >= -tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) <= tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) >= -tol,
                2*p[1, 1] - (g[0, 4] + g[3, 3] + g[4, 0]) <= tol,
                2*p[1, 1] - (g[0, 4] + g[3, 3] + g[4, 0]) >= -tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 3] + g[3, 1]) <= tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 3] + g[3, 1]) >= -tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) <= tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) >= -tol,
                2*p[3, 1] - (g[3, 4] + g[4, 3]) <= tol,
                2*p[3, 1] - (g[3, 4] + g[4, 3]) >= -tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 4] + g[4, 1]) <= tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 4] + g[4, 1]) >= -tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 3] + g[3, 2]) <= tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 3] + g[3, 2]) >= -tol,
                2*p[5, 0] - (g[1, 2] + g[2, 1]) <= tol,
                2*p[5, 0] - (g[1, 2] + g[2, 1]) >= -tol,
                g[4, 4] <= tol, g[4, 4] >= -tol,
                g[2, 4] + g[4, 2] <= tol, g[2, 4] + g[4, 2] >= -tol,
                g[2, 2] <= tol, g[2, 2] >= -tol,]
    if max_deg_ds == 4:
        return [g[0, 0] <= tol, g[0, 0] >= -tol,
                2*p[0, 1] - (g[0, 4] + g[4, 0]) <= tol,
                2*p[0, 1] - (g[0, 4] + g[4, 0]) >= -tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) <= tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) >= -tol,
                2*p[1, 1] - (g[0, 5] + g[4, 4] + g[5, 0]) <= tol,
                2*p[1, 1] - (g[0, 5] + g[4, 4] + g[5, 0]) >= -tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 4] + g[4, 1]) <= tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 4] + g[4, 1]) >= -tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) <= tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) >= -tol,
                2*p[3, 1] - (g[0, 6] + g[4, 5] + g[5, 4] + g[6, 0]) <= tol,
                2*p[3, 1] - (g[0, 6] + g[4, 5] + g[5, 4] + g[6, 0]) >= -tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 5] + g[5, 1]) <= tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 5] + g[5, 1]) >= -tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 4] + g[4, 2]) <= tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 4] + g[4, 2]) >= -tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) <= tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) >= -tol,
                2*p[6, 1] - (g[4, 6] + g[5, 5] + g[6, 4]) <= tol,
                2*p[6, 1] - (g[4, 6] + g[5, 5] + g[6, 4]) >= -tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 6] + g[6, 1]) <= tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 6] + g[6, 1]) >= -tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 5] + g[5, 2]) <= tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 5] + g[5, 2]) >= -tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 4] + g[4, 3]) <= tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 4] + g[4, 3]) >= -tol,
                2*p[9, 0] - (g[1, 3] + g[2, 2] + g[3, 1]) <= tol,
                2*p[9, 0] - (g[1, 3] + g[2, 2] + g[3, 1]) >= -tol,
                2*p[10, 1] - (g[5, 6] + g[6, 5]) <= tol,
                2*p[10, 1] - (g[5, 6] + g[6, 5]) >= -tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 6] + g[6, 2]) <= tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 6] + g[6, 2]) >= -tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 5] + g[5, 3]) <= tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 5] + g[5, 3]) >= -tol,
                2*p[14, 0] - (g[2, 3] + g[3, 2]) <= tol,
                2*p[14, 0] - (g[2, 3] + g[3, 2]) >= -tol,
                g[6, 6] <= tol, g[6, 6] >= -tol,
                g[3, 6] + g[6, 3] <= tol, g[3, 6] + g[6, 3] >= -tol,
                g[3, 3] <= tol, g[3, 3] >= -tol,]
    if max_deg_ds == 6:
        return [g[0, 0] <= tol, g[0, 0] >= -tol,
                2*p[0, 1] - (g[0, 5] + g[5, 0]) <= tol,
                2*p[0, 1] - (g[0, 5] + g[5, 0]) >= -tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) <= tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) >= -tol,
                2*p[1, 1] - (g[0, 6] + g[5, 5] + g[6, 0]) <= tol,
                2*p[1, 1] - (g[0, 6] + g[5, 5] + g[6, 0]) >= -tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 5] + g[5, 1]) <= tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 5] + g[5, 1]) >= -tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) <= tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) >= -tol,
                2*p[3, 1] - (g[0, 7] + g[5, 6] + g[6, 5] + g[7, 0]) <= tol,
                2*p[3, 1] - (g[0, 7] + g[5, 6] + g[6, 5] + g[7, 0]) >= -tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 6] + g[6, 1]) <= tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 6] + g[6, 1]) >= -tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 5] + g[5, 2]) <= tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 5] + g[5, 2]) >= -tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) <= tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) >= -tol,
                2*p[6, 1] - (g[0, 8] + g[5, 7] + g[6, 6] + g[7, 5] + g[8, 0]) <= tol,
                2*p[6, 1] - (g[0, 8] + g[5, 7] + g[6, 6] + g[7, 5] + g[8, 0]) >= -tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 7] + g[7, 1]) <= tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 7] + g[7, 1]) >= -tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 6] + g[6, 2]) <= tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 6] + g[6, 2]) >= -tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 5] + g[5, 3]) <= tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 5] + g[5, 3]) >= -tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) <= tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) >= -tol,
                2*p[10, 1] - (g[5, 8] + g[6, 7] + g[7, 6] + g[8, 5]) <= tol,
                2*p[10, 1] - (g[5, 8] + g[6, 7] + g[7, 6] + g[8, 5]) >= -tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 8] + g[8, 1]) <= tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 8] + g[8, 1]) >= -tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 7] + g[7, 2]) <= tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 7] + g[7, 2]) >= -tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 6] + g[6, 3]) <= tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 6] + g[6, 3]) >= -tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 5] + g[5, 4]) <= tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 5] + g[5, 4]) >= -tol,
                2*p[14, 0] - (g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1]) <= tol,
                2*p[14, 0] - (g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1]) >= -tol,
                2*p[15, 1] - (g[6, 8] + g[7, 7] + g[8, 6]) <= tol,
                2*p[15, 1] - (g[6, 8] + g[7, 7] + g[8, 6]) >= -tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 8] + g[8, 2]) <= tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 8] + g[8, 2]) >= -tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 7] + g[7, 3]) <= tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 7] + g[7, 3]) >= -tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 6] + g[6, 4]) <= tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 6] + g[6, 4]) >= -tol,
                2*p[20, 0] - (g[2, 4] + g[3, 3] + g[4, 2]) <= tol,
                2*p[20, 0] - (g[2, 4] + g[3, 3] + g[4, 2]) >= -tol,
                2*p[21, 1] - (g[7, 8] + g[8, 7]) <= tol,
                2*p[21, 1] - (g[7, 8] + g[8, 7]) >= -tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 8] + g[8, 3]) <= tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 8] + g[8, 3]) >= -tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 7] + g[7, 4]) <= tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 7] + g[7, 4]) >= -tol,
                2*p[27, 0] - (g[3, 4] + g[4, 3]) <= tol,
                2*p[27, 0] - (g[3, 4] + g[4, 3]) >= -tol,
                g[8, 8] <= tol, g[8, 8] >= -tol,
                g[4, 8] + g[8, 4] <= tol, g[4, 8] + g[8, 4] >= -tol,
                g[4, 4] <= tol, g[4, 4] >= -tol,]
    if max_deg_ds == 8:
        return [g[0, 0] <= tol, g[0, 0] >= -tol,
                2*p[0, 1] - (g[0, 6] + g[6, 0]) <= tol,
                2*p[0, 1] - (g[0, 6] + g[6, 0]) >= -tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) <= tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) >= -tol,
                2*p[1, 1] - (g[0, 7] + g[6, 6] + g[7, 0]) <= tol,
                2*p[1, 1] - (g[0, 7] + g[6, 6] + g[7, 0]) >= -tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 6] + g[6, 1]) <= tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 6] + g[6, 1]) >= -tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) <= tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) >= -tol,
                2*p[3, 1] - (g[0, 8] + g[6, 7] + g[7, 6] + g[8, 0]) <= tol,
                2*p[3, 1] - (g[0, 8] + g[6, 7] + g[7, 6] + g[8, 0]) >= -tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 7] + g[7, 1]) <= tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 7] + g[7, 1]) >= -tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 6] + g[6, 2]) <= tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 6] + g[6, 2]) >= -tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) <= tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) >= -tol,
                2*p[6, 1] - (g[0, 9] + g[6, 8] + g[7, 7] + g[8, 6] + g[9, 0]) <= tol,
                2*p[6, 1] - (g[0, 9] + g[6, 8] + g[7, 7] + g[8, 6] + g[9, 0]) >= -tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 8] + g[8, 1]) <= tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 8] + g[8, 1]) >= -tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 7] + g[7, 2]) <= tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 7] + g[7, 2]) >= -tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 6] + g[6, 3]) <= tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 6] + g[6, 3]) >= -tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) <= tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) >= -tol,
                2*p[10, 1] - (g[0, 10] + g[6, 9] + g[7, 8] + g[8, 7] + g[9, 6] + g[10, 0]) <= tol,
                2*p[10, 1] - (g[0, 10] + g[6, 9] + g[7, 8] + g[8, 7] + g[9, 6] + g[10, 0]) >= -tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 9] + g[9, 1]) <= tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 9] + g[9, 1]) >= -tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 8] + g[8, 2]) <= tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 8] + g[8, 2]) >= -tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 7] + g[7, 3]) <= tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 7] + g[7, 3]) >= -tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 6] + g[6, 4]) <= tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 6] + g[6, 4]) >= -tol,
                2*p[14, 0] - (g[0, 5] + g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1] + g[5, 0]) <= tol,
                2*p[14, 0] - (g[0, 5] + g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1] + g[5, 0]) >= -tol,
                2*p[15, 1] - (g[6, 10] + g[7, 9] + g[8, 8] + g[9, 7] + g[10, 6]) <= tol,
                2*p[15, 1] - (g[6, 10] + g[7, 9] + g[8, 8] + g[9, 7] + g[10, 6]) >= -tol,
                2*p[15, 0] + 2*p[16, 1] - (g[1, 10] + g[10, 1]) <= tol,
                2*p[15, 0] + 2*p[16, 1] - (g[1, 10] + g[10, 1]) >= -tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 9] + g[9, 2]) <= tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 9] + g[9, 2]) >= -tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 8] + g[8, 3]) <= tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 8] + g[8, 3]) >= -tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 7] + g[7, 4]) <= tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 7] + g[7, 4]) >= -tol,
                2*p[19, 0] + 2*p[20, 1] - (g[5, 6] + g[6, 5]) <= tol,
                2*p[19, 0] + 2*p[20, 1] - (g[5, 6] + g[6, 5]) >= -tol,
                2*p[20, 0] - (g[1, 5] + g[2, 4] + g[3, 3] + g[4, 2] + g[5, 1]) <= tol,
                2*p[20, 0] - (g[1, 5] + g[2, 4] + g[3, 3] + g[4, 2] + g[5, 1]) >= -tol,
                2*p[21, 1] - (g[7, 10] + g[8, 9] + g[9, 8] + g[10, 7]) <= tol,
                2*p[21, 1] - (g[7, 10] + g[8, 9] + g[9, 8] + g[10, 7]) >= -tol,
                2*p[22, 0] + 2*p[23, 1] - (g[2, 10] + g[10, 2]) <= tol,
                2*p[22, 0] + 2*p[23, 1] - (g[2, 10] + g[10, 2]) >= -tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 9] + g[9, 3]) <= tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 9] + g[9, 3]) >= -tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 8] + g[8, 4]) <= tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 8] + g[8, 4]) >= -tol,
                2*p[25, 0] + 2*p[26, 1] - (g[5, 7] + g[7, 5]) <= tol,
                2*p[25, 0] + 2*p[26, 1] - (g[5, 7] + g[7, 5]) >= -tol,
                2*p[27, 0] - (g[2, 5] + g[3, 4] + g[4, 3] + g[5, 2]) <= tol,
                2*p[27, 0] - (g[2, 5] + g[3, 4] + g[4, 3] + g[5, 2]) >= -tol,
                2*p[28, 1] - (g[8, 10] + g[9, 9] + g[10, 8]) <= tol,
                2*p[28, 1] - (g[8, 10] + g[9, 9] + g[10, 8]) >= -tol,
                2*p[30, 0] + 2*p[31, 1] - (g[3, 10] + g[10, 3]) <= tol,
                2*p[30, 0] + 2*p[31, 1] - (g[3, 10] + g[10, 3]) >= -tol,
                2*p[31, 0] + 2*p[32, 1] - (g[4, 9] + g[9, 4]) <= tol,
                2*p[31, 0] + 2*p[32, 1] - (g[4, 9] + g[9, 4]) >= -tol,
                2*p[32, 0] + 2*p[33, 1] - (g[5, 8] + g[8, 5]) <= tol,
                2*p[32, 0] + 2*p[33, 1] - (g[5, 8] + g[8, 5]) >= -tol,
                2*p[35, 0] - (g[3, 5] + g[4, 4] + g[5, 3]) <= tol,
                2*p[35, 0] - (g[3, 5] + g[4, 4] + g[5, 3]) >= -tol,
                2*p[36, 1] - (g[9, 10] + g[10, 9]) <= tol,
                2*p[36, 1] - (g[9, 10] + g[10, 9]) >= -tol,
                2*p[39, 0] + 2*p[40, 1] - (g[4, 10] + g[10, 4]) <= tol,
                2*p[39, 0] + 2*p[40, 1] - (g[4, 10] + g[10, 4]) >= -tol,
                2*p[40, 0] + 2*p[41, 1] - (g[5, 9] + g[9, 5]) <= tol,
                2*p[40, 0] + 2*p[41, 1] - (g[5, 9] + g[9, 5]) >= -tol,
                2*p[44, 0] - (g[4, 5] + g[5, 4]) <= tol,
                2*p[44, 0] - (g[4, 5] + g[5, 4]) >= -tol,
                g[10, 10] <= tol, g[10, 10] >= -tol,
                g[5, 10] + g[10, 5] <= tol, g[5, 10] + g[10, 5] >= -tol,
                g[5, 5] <= tol, g[5, 5] >= -tol,]
    if max_deg_ds == 10:
        return [g[0, 0] <= tol, g[0, 0] >= -tol,
                2*p[0, 1] - (g[0, 7] + g[7, 0]) <= tol,
                2*p[0, 1] - (g[0, 7] + g[7, 0]) >= -tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) <= tol,
                2*p[0, 0] - (g[0, 1] + g[1, 0]) >= -tol,
                2*p[1, 1] - (g[0, 8] + g[7, 7] + g[8, 0]) <= tol,
                2*p[1, 1] - (g[0, 8] + g[7, 7] + g[8, 0]) >= -tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 7] + g[7, 1]) <= tol,
                2*p[1, 0] + 2*p[2, 1] - (g[1, 7] + g[7, 1]) >= -tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) <= tol,
                2*p[2, 0] - (g[0, 2] + g[1, 1] + g[2, 0]) >= -tol,
                2*p[3, 1] - (g[0, 9] + g[7, 8] + g[8, 7] + g[9, 0]) <= tol,
                2*p[3, 1] - (g[0, 9] + g[7, 8] + g[8, 7] + g[9, 0]) >= -tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 8] + g[8, 1]) <= tol,
                2*p[3, 0] + 2*p[4, 1] - (g[1, 8] + g[8, 1]) >= -tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 7] + g[7, 2]) <= tol,
                2*p[4, 0] + 2*p[5, 1] - (g[2, 7] + g[7, 2]) >= -tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) <= tol,
                2*p[5, 0] - (g[0, 3] + g[1, 2] + g[2, 1] + g[3, 0]) >= -tol,
                2*p[6, 1] - (g[0, 10] + g[7, 9] + g[8, 8] + g[9, 7] + g[10, 0]) <= tol,
                2*p[6, 1] - (g[0, 10] + g[7, 9] + g[8, 8] + g[9, 7] + g[10, 0]) >= -tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 9] + g[9, 1]) <= tol,
                2*p[6, 0] + 2*p[7, 1] - (g[1, 9] + g[9, 1]) >= -tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 8] + g[8, 2]) <= tol,
                2*p[7, 0] + 2*p[8, 1] - (g[2, 8] + g[8, 2]) >= -tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 7] + g[7, 3]) <= tol,
                2*p[8, 0] + 2*p[9, 1] - (g[3, 7] + g[7, 3]) >= -tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) <= tol,
                2*p[9, 0] - (g[0, 4] + g[1, 3] + g[2, 2] + g[3, 1] + g[4, 0]) >= -tol,
                2*p[10, 1] - (g[0, 11] + g[7, 10] + g[8, 9] + g[9, 8] + g[10, 7] + g[11, 0]) <= tol,
                2*p[10, 1] - (g[0, 11] + g[7, 10] + g[8, 9] + g[9, 8] + g[10, 7] + g[11, 0]) >= -tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 10] + g[10, 1]) <= tol,
                2*p[10, 0] + 2*p[11, 1] - (g[1, 10] + g[10, 1]) >= -tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 9] + g[9, 2]) <= tol,
                2*p[11, 0] + 2*p[12, 1] - (g[2, 9] + g[9, 2]) >= -tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 8] + g[8, 3]) <= tol,
                2*p[12, 0] + 2*p[13, 1] - (g[3, 8] + g[8, 3]) >= -tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 7] + g[7, 4]) <= tol,
                2*p[13, 0] + 2*p[14, 1] - (g[4, 7] + g[7, 4]) >= -tol,
                2*p[14, 0] - (g[0, 5] + g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1] + g[5, 0]) <= tol,
                2*p[14, 0] - (g[0, 5] + g[1, 4] + g[2, 3] + g[3, 2] + g[4, 1] + g[5, 0]) >= -tol,
                2*p[15, 1] - (g[0, 12] + g[7, 11] + g[8, 10] + g[9, 9] + g[10, 8] + g[11, 7] + g[12, 0]) <= tol,
                2*p[15, 1] - (g[0, 12] + g[7, 11] + g[8, 10] + g[9, 9] + g[10, 8] + g[11, 7] + g[12, 0]) >= -tol,
                2*p[15, 0] + 2*p[16, 1] - (g[1, 11] + g[11, 1]) <= tol,
                2*p[15, 0] + 2*p[16, 1] - (g[1, 11] + g[11, 1]) >= -tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 10] + g[10, 2]) <= tol,
                2*p[16, 0] + 2*p[17, 1] - (g[2, 10] + g[10, 2]) >= -tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 9] + g[9, 3]) <= tol,
                2*p[17, 0] + 2*p[18, 1] - (g[3, 9] + g[9, 3]) >= -tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 8] + g[8, 4]) <= tol,
                2*p[18, 0] + 2*p[19, 1] - (g[4, 8] + g[8, 4]) >= -tol,
                2*p[19, 0] + 2*p[20, 1] - (g[5, 7] + g[7, 5]) <= tol,
                2*p[19, 0] + 2*p[20, 1] - (g[5, 7] + g[7, 5]) >= -tol,
                2*p[20, 0] - (g[0, 6] + g[1, 5] + g[2, 4] + g[3, 3] + g[4, 2] + g[5, 1] + g[6, 0]) <= tol,
                2*p[20, 0] - (g[0, 6] + g[1, 5] + g[2, 4] + g[3, 3] + g[4, 2] + g[5, 1] + g[6, 0]) >= -tol,
                2*p[21, 1] - (g[7, 12] + g[8, 11] + g[9, 10] + g[10, 9] + g[11, 8] + g[12, 7]) <= tol,
                2*p[21, 1] - (g[7, 12] + g[8, 11] + g[9, 10] + g[10, 9] + g[11, 8] + g[12, 7]) >= -tol,
                2*p[21, 0] + 2*p[22, 1] - (g[1, 12] + g[12, 1]) <= tol,
                2*p[21, 0] + 2*p[22, 1] - (g[1, 12] + g[12, 1]) >= -tol,
                2*p[22, 0] + 2*p[23, 1] - (g[2, 11] + g[11, 2]) <= tol,
                2*p[22, 0] + 2*p[23, 1] - (g[2, 11] + g[11, 2]) >= -tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 10] + g[10, 3]) <= tol,
                2*p[23, 0] + 2*p[24, 1] - (g[3, 10] + g[10, 3]) >= -tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 9] + g[9, 4]) <= tol,
                2*p[24, 0] + 2*p[25, 1] - (g[4, 9] + g[9, 4]) >= -tol,
                2*p[25, 0] + 2*p[26, 1] - (g[5, 8] + g[8, 5]) <= tol,
                2*p[25, 0] + 2*p[26, 1] - (g[5, 8] + g[8, 5]) >= -tol,
                2*p[26, 0] + 2*p[27, 1] - (g[6, 7] + g[7, 6]) <= tol,
                2*p[26, 0] + 2*p[27, 1] - (g[6, 7] + g[7, 6]) >= -tol,
                2*p[27, 0] - (g[1, 6] + g[2, 5] + g[3, 4] + g[4, 3] + g[5, 2] + g[6, 1]) <= tol,
                2*p[27, 0] - (g[1, 6] + g[2, 5] + g[3, 4] + g[4, 3] + g[5, 2] + g[6, 1]) >= -tol,
                2*p[28, 1] - (g[8, 12] + g[9, 11] + g[10, 10] + g[11, 9] + g[12, 8]) <= tol,
                2*p[28, 1] - (g[8, 12] + g[9, 11] + g[10, 10] + g[11, 9] + g[12, 8]) >= -tol,
                2*p[29, 0] + 2*p[30, 1] - (g[2, 12] + g[12, 2]) <= tol,
                2*p[29, 0] + 2*p[30, 1] - (g[2, 12] + g[12, 2]) >= -tol,
                2*p[30, 0] + 2*p[31, 1] - (g[3, 11] + g[11, 3]) <= tol,
                2*p[30, 0] + 2*p[31, 1] - (g[3, 11] + g[11, 3]) >= -tol,
                2*p[31, 0] + 2*p[32, 1] - (g[4, 10] + g[10, 4]) <= tol,
                2*p[31, 0] + 2*p[32, 1] - (g[4, 10] + g[10, 4]) >= -tol,
                2*p[32, 0] + 2*p[33, 1] - (g[5, 9] + g[9, 5]) <= tol,
                2*p[32, 0] + 2*p[33, 1] - (g[5, 9] + g[9, 5]) >= -tol,
                2*p[33, 0] + 2*p[34, 1] - (g[6, 8] + g[8, 6]) <= tol,
                2*p[33, 0] + 2*p[34, 1] - (g[6, 8] + g[8, 6]) >= -tol,
                2*p[35, 0] - (g[2, 6] + g[3, 5] + g[4, 4] + g[5, 3] + g[6, 2]) <= tol,
                2*p[35, 0] - (g[2, 6] + g[3, 5] + g[4, 4] + g[5, 3] + g[6, 2]) >= -tol,
                2*p[36, 1] - (g[9, 12] + g[10, 11] + g[11, 10] + g[12, 9]) <= tol,
                2*p[36, 1] - (g[9, 12] + g[10, 11] + g[11, 10] + g[12, 9]) >= -tol,
                2*p[38, 0] + 2*p[39, 1] - (g[3, 12] + g[12, 3]) <= tol,
                2*p[38, 0] + 2*p[39, 1] - (g[3, 12] + g[12, 3]) >= -tol,
                2*p[39, 0] + 2*p[40, 1] - (g[4, 11] + g[11, 4]) <= tol,
                2*p[39, 0] + 2*p[40, 1] - (g[4, 11] + g[11, 4]) >= -tol,
                2*p[40, 0] + 2*p[41, 1] - (g[5, 10] + g[10, 5]) <= tol,
                2*p[40, 0] + 2*p[41, 1] - (g[5, 10] + g[10, 5]) >= -tol,
                2*p[41, 0] + 2*p[42, 1] - (g[6, 9] + g[9, 6]) <= tol,
                2*p[41, 0] + 2*p[42, 1] - (g[6, 9] + g[9, 6]) >= -tol,
                2*p[44, 0] - (g[3, 6] + g[4, 5] + g[5, 4] + g[6, 3]) <= tol,
                2*p[44, 0] - (g[3, 6] + g[4, 5] + g[5, 4] + g[6, 3]) >= -tol,
                2*p[45, 1] - (g[10, 12] + g[11, 11] + g[12, 10]) <= tol,
                2*p[45, 1] - (g[10, 12] + g[11, 11] + g[12, 10]) >= -tol,
                2*p[48, 0] + 2*p[49, 1] - (g[4, 12] + g[12, 4]) <= tol,
                2*p[48, 0] + 2*p[49, 1] - (g[4, 12] + g[12, 4]) >= -tol,
                2*p[49, 0] + 2*p[50, 1] - (g[5, 11] + g[11, 5]) <= tol,
                2*p[49, 0] + 2*p[50, 1] - (g[5, 11] + g[11, 5]) >= -tol,
                2*p[50, 0] + 2*p[51, 1] - (g[6, 10] + g[10, 6]) <= tol,
                2*p[50, 0] + 2*p[51, 1] - (g[6, 10] + g[10, 6]) >= -tol,
                2*p[54, 0] - (g[4, 6] + g[5, 5] + g[6, 4]) <= tol,
                2*p[54, 0] - (g[4, 6] + g[5, 5] + g[6, 4]) >= -tol,
                2*p[55, 1] - (g[11, 12] + g[12, 11]) <= tol,
                2*p[55, 1] - (g[11, 12] + g[12, 11]) >= -tol,
                2*p[59, 0] + 2*p[60, 1] - (g[5, 12] + g[12, 5]) <= tol,
                2*p[59, 0] + 2*p[60, 1] - (g[5, 12] + g[12, 5]) >= -tol,
                2*p[60, 0] + 2*p[61, 1] - (g[6, 11] + g[11, 6]) <= tol,
                2*p[60, 0] + 2*p[61, 1] - (g[6, 11] + g[11, 6]) >= -tol,
                2*p[65, 0] - (g[5, 6] + g[6, 5]) <= tol,
                2*p[65, 0] - (g[5, 6] + g[6, 5]) >= -tol,
                g[12, 12] <= tol, g[12, 12] >= -tol,
                g[6, 12] + g[12, 6] <= tol, g[6, 12] + g[12, 6] >= -tol,
                g[6, 6] <= tol, g[6, 6] >= -tol,]

    raise NotImplementedError("Constraints must be generated seperately and added above!")

def print_constraints_subspace(ds_deg):
    """ Print cvxpy compatible constratints from originally developed sos_stability object.

    Args:
        ds_deg (int): Degree of dynamical system.
        lpf_deg (int, optional): Degree of the Lyapunov function. Defaults to 2.
    """

    # build the sos handler based on degrees
    sos_stability = SymbolicSubspaceDS(ds_deg=ds_deg, lpf_deg=2, dim=2, simplify_lpf=True)
    sos_stability.arrange_constraints()

    for c in sos_stability.sos_params["cons_x"] + sos_stability.sos_params["cons_y"]:
        if len(c) == 1:
            print(f'{c[0]} <= tol, {c[0]} >= -tol,')
        else:
            print(f'{c[0]} - ({c[1]}) <= tol, \n{c[0]} - ({c[1]}) >= -tol,')


def print_constraints_space(ds_deg: int, lpf_deg: int = 2):
    """ Print cvxpy compatible constratints from originally developed sos_stability object.

    Args:
        ds_deg (int): Degree of dynamical system.
        lpf_deg (int, optional): Degree of the Lyapunov function. Defaults to 2.
    """

    # build the sos handler based on degrees
    sos_stability = SymbolicSpaceDS(ds_deg=ds_deg, lpf_deg=lpf_deg, dim=2, simplify_lpf=True)
    sos_stability.arrange_constraints()

    for c in sos_stability.sos_params["cons"]:
        if len(c) == 1:
            print(f'{c[0]} <= tol, {c[0]} >= -tol,')
        else:
            print(f'{c[0]} - ({c[1]}) <= tol, \n{c[0]} - ({c[1]}) >= -tol,')


def main():
    parser = argparse.ArgumentParser(description='Print constraints for CVXPY CLI interface')
    parser.add_argument('-dsd', '--ds-degree', type=int, default=2,
        help='Complexity of the polynomial dynamical system')
    parser.add_argument('-so', '--subspace-optimization', action='store_true', default=False,
        help='Print subspace opt constraints')
    args = parser.parse_args()

    logger.setLevel(logging.CRITICAL)

    if args.subspace_optimization:
        print_constraints_subspace(ds_deg=args.ds_degree)
    else:
        print_constraints_space(ds_deg=args.ds_degree)

if __name__ == '__main__':
    main()