#!/bin/bash

trials=$1

# # seds
# ./batch_baselining.py -pl SEDS -sp -nt $trials -mn original -sd res/seds_batch_original

# gail (different dataset sizes)
./batch_baselining.py -pl GAIL -nd 1 -sp -nt 5 -sd res/gail_batch_dataset1
./batch_baselining.py -pl GAIL -nd 8 -sp -nt 5 -sd res/gail_batch_dataset8
./batch_baselining.py -pl GAIL -nd 50 -sp -nt 5 -sd res/gail_batch_dataset50
./batch_baselining.py -pl GAIL -nd 100 -sp -nt 5 -sd res/gail_batch_dataset100

./batch_baselining.py -pl GAIL -nd 8 -neb 40 -ntg 100000 -sp -nt 4 -sd res/gail_batch_original8
./batch_baselining.py -pl GAIL -nd 50 -neb 40 -ntg 100000 -sp -nt 4 -sd res/gail_batch_original50


# # bc (different dataset sizes)
./batch_baselining.py -pl BC -neb 50 -nd 1 -sp -nt $trials -sd res/bc_batch_dataset1
./batch_baselining.py -pl BC -neb 50 -nd 8 -sp -nt $trials -sd res/bc_batch_dataset8
./batch_baselining.py -pl BC -neb 50 -nd 50 -sp -nt $trials -sd res/bc_batch_dataset50
./batch_baselining.py -pl BC -neb 50 -nd 100 -sp -nt $trials -sd res/bc_batch_dataset100

# # bc (various learning time)
./batch_baselining.py -pl BC -neb 100 -nd 50 -sp -nt 5 -sd res/bc_batch_100epochs50dems
./batch_baselining.py -pl BC -neb 2   -nd 50 -sp -nt 5 -sd res/bc_batch_2epochs50dems
./batch_baselining.py -pl BC -neb 100 -nd 8 -sp -nt 5 -sd res/bc_batch_100epochs8dems
./batch_baselining.py -pl BC -neb 2   -nd 8 -sp -nt 5 -sd res/bc_batch_2epochs8dems

# # plyds
# ./batch_baselining.py -pl PLYDS -sp -dsd 6 -st 8 -so -nt $trials -sd res/plyds_batch_original

# # plyds (various degrees)
# ./batch_baselining.py -pl PLYDS -sp -dsd 2 -st 8 -so -nt $trials -sd res/plyds_batch_degree2
# ./batch_baselining.py -pl PLYDS -sp -dsd 4 -st 8 -so -nt $trials -sd res/plyds_batch_degree4
# ./batch_baselining.py -pl PLYDS -sp -dsd 6 -st 8 -so -nt $trials -sd res/plyds_batch_degree6

# # plyds (different dataset sizes)
# ./batch_baselining.py -pl PLYDS -sp -dsd 4 -st 8 -so -nt $trials -nd 1 -sd res/plyds_batch_dataset1
# ./batch_baselining.py -pl PLYDS -sp -dsd 4 -st 8 -so -nt $trials -nd 3 -sd res/plyds_batch_dataset3
# ./batch_baselining.py -pl PLYDS -sp -dsd 4 -st 8 -so -nt $trials -nd 5 -sd res/plyds_batch_dataset5
# ./batch_baselining.py -pl PLYDS -sp -dsd 4 -st 8 -so -nt $trials -nd 7 -sd res/plyds_batch_dataset7

# # gail (reduced dataset)
# # bc (reduced dataset)

# # seds (reduced datasets)
# ./batch_baselining.py -pl SEDS -sp -nt 5 -mn original -nd 1 -sd res/seds_batch_dataset1
# ./batch_baselining.py -pl SEDS -sp -nt 5 -mn original -nd 3 -sd res/seds_batch_dataset3
# ./batch_baselining.py -pl SEDS -sp -nt 5 -mn original -nd 5 -sd res/seds_batch_dataset5
