# Introduction

In the demo files, we have included a demonstration of our proposed **TSANet**.  **The complete code will be made publicly available after the paper is accepted.**  Our **Submission Number: 9614**.

# Installation

**Notice: You could use your own environments when running the code, just make sure pytorch and requirements of Step.3 are installed.**

**Step 0.** Download and install Miniconda from the [official website](https://docs.conda.io/en/latest/miniconda.html).

**Step 1.** Create a conda environment and activate it.

```
conda create --name tsanet python=3.8 -y
conda activate tsanet
```

**Step 2.** Install PyTorch following [official instructions](https://pytorch.org/get-started/locally/), e.g.

```
conda install pytorch torchvision -c pytorch
```

**Step 3.** Install Mamba following [official instructions](https://github.com/state-spaces/mamba), e.g.

```
* Linux
* NVIDIA GPU
* PyTorch 1.12+
* CUDA 11.6+

pip install mamba-ssm
```

**Step 4.** Install other requirements

```
pip install argparse tqdm scikit-image opencv-python einops timm thop random-fourier-features-pytorch
```

# Testing


## Run testing

Set the input path and weights path when running the test script.

```
python test.py --input_path ./input --save_path ./output 
```
