# Full list of variants provided

Here is a list of models that can be imported from `src`:

## ViT-Lite

<table style="width:100%">
    <thead>
        <tr>
            <td><b>Model</b></td>
            <td><b>Resolution</b></td>
            <td><b>PE</b></td>
            <td><b>Name</b></td>
            <td><b>Pretrained Weights</b></td>
            <td><b>Config</b></td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td rowspan=2>ViT-2/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>vit_2_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>vit_2_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>ViT-4/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>vit_4_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>vit_4_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>ViT-6/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>vit_6_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>vit_6_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>ViT-7/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>vit_7_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>vit_7_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
</tbody>
</table>

## CVT

<table style="width:100%">
    <thead>
        <tr>
            <td><b>Model</b></td>
            <td><b>Resolution</b></td>
            <td><b>PE</b></td>
            <td><b>Name</b></td>
            <td><b>Pretrained Weights</b></td>
            <td><b>Config</b></td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td rowspan=2>CVT-2/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cvt_2_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cvt_2_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CVT-4/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cvt_4_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cvt_4_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CVT-6/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cvt_6_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cvt_6_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CVT-7/4</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cvt_7_4_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cvt_7_4_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
</tbody>
</table>

## CCT

<table style="width:100%">
    <thead>
        <tr>
            <td><b>Model</b></td>
            <td><b>Resolution</b></td>
            <td><b>PE</b></td>
            <td><b>Name</b></td>
            <td><b>Pretrained Weights</b></td>
            <td><b>Config</b></td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td rowspan=2>CCT-2/3x2</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cct_2_3x2_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_2_3x2_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CCT-4/3x2</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cct_4_3x2_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_4_3x2_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CCT-6/3x1</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cct_6_3x1_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_6_3x1_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CCT-6/3x2</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cct_6_3x2_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_6_3x2_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=2>CCT-7/3x2</td>
            <td rowspan=2>32x32</td>
            <td>Learnable</td>
            <td><code>cct_7_3x2_32</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_7_3x2_32_sine</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td rowspan=4>CCT-7/3x1</td>
            <td rowspan=4>32x32</td>
            <td>Learnable</td>
            <td><code>cct_7_3x1_32</code></td>
            <td>CIFAR-10/300 Epochs</td>
            <td><code>pretrained/cct_7-3x1_cifar10_300epochs.yml</code></td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_7_3x1_32_sine</code></td>
            <td>CIFAR-10/5000 Epochs</td>
            <td><code>pretrained/cct_7-3x1_cifar10_5000epochs.yml</code></td>
        </tr>
        <tr>
            <td>Learnable</td>
            <td><code>cct_7_3x1_32_c100</code></td>
            <td>CIFAR-100/300 Epochs</td>
            <td><code>pretrained/cct_7-3x1_cifar100_300epochs.yml</code></td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_7_3x1_32_sine_c100</code></td>
            <td>CIFAR-100/5000 Epochs</td>
            <td><code>pretrained/cct_7-3x1_cifar100_5000epochs.yml</code></td>
        </tr>
        <tr>
            <td rowspan=2>CCT-7/7x2</td>
            <td rowspan=2>224x224</td>
            <td>Learnable</td>
            <td><code>cct_7_7x2_224</code></td>
            <td>-</td>
            <td>-</td>
        </tr>
        <tr>
            <td>Sinusoidal</td>
            <td><code>cct_7_7x2_224_sine</code></td>
            <td>Flowers-102/300 Epochs</td>
            <td><code>pretrained/cct_7-7x2_flowers102.yml</code></td>
        </tr>
        <tr>
            <td rowspan=3>CCT-14/7x2</td>
            <td>224x224</td>
            <td rowspan=3>Learnable</td>
            <td><code>cct_14_7x2_224</code></td>
            <td>ImageNet-1k/300 Epochs</td>
            <td><code>pretrained/cct_14-7x2_imagenet.yml</code></td>
        </tr>
        <tr>
            <td>384x384</td>
            <td><code>cct_14_7x2_384</code></td>
            <td>ImageNet-1k/Finetuned/30 Epochs</td>
            <td><code>finetuned/cct_14-7x2_imagenet384.yml</code></td>
        </tr>
        <tr>
            <td>384x384</td>
            <td><code>cct_14_7x2_384_fl</code></td>
            <td>Flowers102/Finetuned/300 Epochs</td>
            <td><code>finetuned/cct_14-7x2_flowers102.yml</code></td>
        </tr>
    </tbody>
</table>