set -e
# cotraining
TORCH_DISTRIBUTED_DEBUG=INFO CUDA_VISIBLE_DEVICES=3 CUDA_BLOCKING_LAUNCH=1 python -m torch.distributed.launch --nproc_per_node 1 --master_port $RANDOM \
    train_dist_mod.py --num_point 50000 --num_decoder_layers 6 \
    --use_color \
    --weight_decay 0.0005 \
    --data_root ./dataset/language_grounding/scans/ \
    --log_dir ./logs/debug --val_freq 5 --batch_size 128 --save_freq 100 --max_freq 200 \
    --size_cls_agnostic --use_hungarian --print_freq 10  \
    --lr_backbone=1e-4 --text_encoder_lr=1e-5 \
    --no_sa_vis --no_sa_lang \
    --use_soft_token_loss --use_contrastive_align \
    --dataset sr3d --test_dataset sr3d \
    --eval --use_gt_box --use_gt_class \
    --use_gt_grounder --detect_intermediate \
    --checkpoint_path ./dataset/language_grounding/imp_checkpoints/featureless_gt_box_class_epoch40.pth --debug --visualize \
    --filter_relations --apply_classifiers