"""ScanNet object classes and relation vocabulary."""

SCANNET_OBJECTS = [
    'air mattress',
    'airplane',
    'alarm',
    'alarm clock',
    'armchair',
    'baby mobile',
    'backpack',
    'bag',
    'bag of coffee beans',
    'ball',
    'banana holder',
    'bananas',
    'banister',
    'banner',
    'bar',
    'barricade',
    'barrier',
    'baseball cap',
    'basket',
    'bath products',
    'bath walls',
    'bathrobe',
    'bathroom cabinet',
    'bathroom counter',
    'bathroom stall',
    'bathroom stall door',
    'bathroom vanity',
    'bathtub',
    'battery disposal jar',
    'beachball',
    'beanbag chair',
    'bear',
    'bed',
    'beer bottles',
    'bench',
    'bicycle',
    'bike lock',
    'bike pump',
    'bin',
    'binder',
    'binders',
    'blackboard',
    'blackboard eraser',
    'blanket',
    'blinds',
    'block',
    'board',
    'boards',
    'boat',
    'boiler',
    'book',
    'book rack',
    'books',
    'bookshelf',
    'bookshelves',
    'boots',
    'bottle',
    'bottles',
    'bowl',
    'box',
    'boxes',
    'boxes of paper',
    'breakfast bar',
    'briefcase',
    'broom',
    'bucket',
    'buddha',
    'bulletin board',
    'bunk bed',
    'bycicle',
    'cabinet',
    'cabinet door',
    'cabinet doors',
    'cabinets',
    'cable',
    'calendar',
    'can',
    'candle',
    'canopy',
    'cap',
    'car',
    'card',
    'cardboard',
    'carpet',
    'carseat',
    'cart',
    'carton',
    'case',
    'case of water bottles',
    'cat litter box',
    'cd case',
    'cd cases',
    'ceiling',
    'ceiling fan',
    'ceiling lamp',
    'ceiling light',
    'chain',
    'chair',
    'chandelier',
    'changing station',
    'chest',
    'clip',
    'clock',
    'closet',
    'closet ceiling',
    'closet door',
    'closet doorframe',
    'closet doors',
    'closet floor',
    'closet rod',
    'closet shelf',
    'closet wall',
    'closet walls',
    'closet wardrobe',
    'cloth',
    'clothes',
    'clothes dryer',
    'clothes dryers',
    'clothes hanger',
    'clothes hangers',
    'clothing',
    'clothing rack',
    'coat',
    'coat rack',
    'coatrack',
    'coffee bean bag',
    'coffee box',
    'coffee kettle',
    'coffee maker',
    'coffee mug',
    'coffee table',
    'column',
    'compost bin',
    'computer tower',
    'conditioner bottle',
    'cone',
    'contact lens solution bottle',
    'container',
    'controller',
    'cooking pan',
    'cooking pot',
    'cooler',
    'copier',
    'cosmetic bag',
    'couch',
    'couch cushions',
    'counter',
    'cover',
    'covered box',
    'crate',
    'crib',
    'crutches',
    'cup',
    'cups',
    'curtain',
    'curtain rod',
    'curtains',
    'cushion',
    'cutting board',
    'dart board',
    'decoration',
    'desk',
    'desk lamp',
    'diaper bin',
    'dining table',
    'dish rack',
    'dishwasher',
    'dishwashing soap bottle',
    'dispenser',
    'display',
    'display case',
    'display rack',
    'display sign',
    'divider',
    'doll',
    'dollhouse',
    'dolly',
    'door',
    'door wall',
    'doorframe',
    'doors',
    'drawer',
    'dress rack',
    'dresser',
    'drum set',
    'dryer sheets',
    'drying rack',
    'duffel bag',
    'dumbbell',
    'dumbbell plates',
    'dumbell',
    'dustpan',
    'easel',
    'electric panel',
    'elevator',
    'elliptical machine',
    'end table',
    'envelope',
    'exercise ball',
    'exercise bike',
    'exercise machine',
    'exit sign',
    'fan',
    'faucet',
    'file cabinet',
    'file cabinets',
    'file organizer',
    'film light',
    'fire alarm',
    'fire extinguisher',
    'fire hose',
    'fire sprinkler',
    'fireplace',
    'fish',
    'flag',
    'flip flops',
    'floor',
    'flower stand',
    'flowerpot',
    'folded boxes',
    'folded chair',
    'folded chairs',
    'folded ladder',
    'folded table',
    'folder',
    'food bag',
    'food container',
    'foosball table',
    'footrest',
    'footstool',
    'frame',
    'frying pan',
    'furnace',
    'furniture',
    'fuse box',
    'futon',
    'gaming wheel',
    'garage door',
    'garbage bag',
    'glass',
    'glass doors',
    'globe',
    'golf bag',
    'grab bar',
    'grocery bag',
    'guitar',
    'guitar case',
    'hair brush',
    'hair dryer',
    'hamper',
    'hand dryer',
    'hand rail',
    'hand sanitzer dispenser',
    'hand towel',
    'handicap bar',
    'handrail',
    'hanging',
    'hat',
    'hatrack',
    'headboard',
    'headphones',
    'heater',
    'helmet',
    'hose',
    'hoverboard',
    'humidifier',
    'ikea bag',
    'instrument case',
    'ipad',
    'iron',
    'ironing board',
    'jacket',
    'jar',
    'jewelry box',
    'kettle',
    'keyboard',
    'keyboard piano',
    'kinect',
    'kitchen apron',
    'kitchen cabinet',
    'kitchen cabinets',
    'kitchen counter',
    'kitchen island',
    'kitchen mixer',
    'kitchenaid mixer',
    'knife block',
    'ladder',
    'lamp',
    'lamp base',
    'laptop',
    'laundry bag',
    'laundry basket',
    'laundry detergent',
    'laundry hamper',
    'ledge',
    'legs',
    'light',
    'light switch',
    'loft bed',
    'loofa',
    'lotion',
    'lotion bottle',
    'luggage',
    'luggage rack',
    'luggage stand',
    'lunch box',
    'machine',
    'magazine',
    'magazine rack',
    'mail',
    'mail tray',
    'mail trays',
    'mailbox',
    'mailboxes',
    'map',
    'massage chair',
    'mat',
    'mattress',
    'medal',
    'media center',
    'messenger bag',
    'metronome',
    'microwave',
    'mini fridge',
    'mirror',
    'mirror doors',
    'monitor',
    'mop',
    'mouse',
    'mouthwash bottle',
    'mug',
    'music book',
    'music stand',
    'nerf gun',
    'night lamp',
    'night light',
    'nightstand',
    'notepad',
    'object',
    'office chair',
    'open kitchen cabinet',
    'organizer',
    'organizer shelf',
    'ottoman',
    'oven',
    'oven mitt',
    'painting',
    'pantry shelf',
    'pantry wall',
    'pantry walls',
    'pants',
    'paper',
    'paper bag',
    'paper cutter',
    'paper organizer',
    'paper shredder',
    'paper towel',
    'paper towel dispenser',
    'paper towel roll',
    'paper towel rolls',
    'paper tray',
    'papers',
    'pen holder',
    'person',
    'piano',
    'piano bench',
    'picture',
    'pictures',
    'pillar',
    'pillow',
    'pillows',
    'ping pong paddle',
    'ping pong table',
    'pipe',
    'pipes',
    'pitcher',
    'pizza box',
    'pizza boxes',
    'plant',
    'plastic bin',
    'plastic container',
    'plastic containers',
    'plastic storage bin',
    'plate',
    'plates',
    'platform',
    'plunger',
    'podium',
    'pool table',
    'postcard',
    'poster',
    'poster cutter',
    'poster printer',
    'poster tube',
    'pot',
    'potted plant',
    'power outlet',
    'power strip',
    'printer',
    'projector',
    'projector screen',
    'purse',
    'quadcopter',
    'rack',
    'rack stand',
    'radiator',
    'rail',
    'railing',
    'range hood',
    'recliner chair',
    'recycling bin',
    'refrigerator',
    'remote',
    'rice cooker',
    'rocking chair',
    'rod',
    'rolled poster',
    'roomba',
    'rope',
    'round table',
    'rug',
    'salt',
    'santa',
    'scale',
    'scanner',
    'screen',
    'seat',
    'sewing machine',
    'shampoo',
    'shampoo bottle',
    'shaving cream',
    'shelf',
    'shirt',
    'shoe',
    'shoe rack',
    'shoes',
    'shopping bag',
    'shorts',
    'shower',
    'shower control valve',
    'shower curtain',
    'shower curtain rod',
    'shower door',
    'shower doors',
    'shower faucet handle',
    'shower floor',
    'shower head',
    'shower wall',
    'shower walls',
    'shredder',
    'side table',
    'sign',
    'sink',
    'sleeping bag',
    'sliding door',
    'sliding wood door',
    'slipper',
    'slippers',
    'smoke detector',
    'soap',
    'soap bar',
    'soap bottle',
    'soap dish',
    'soap dispenser',
    'sock',
    'socks',
    'soda can',
    'soda stream',
    'sofa',
    'sofa bed',
    'sofa chair',
    'speaker',
    'sponge',
    'spray bottle',
    'stack of chairs',
    'stack of cups',
    'stack of folded chairs',
    'stacks of cups',
    'stair',
    'stair rail',
    'staircase',
    'stairs',
    'stand',
    'stapler',
    'star',
    'statue',
    'step',
    'step stool',
    'stepladder',
    'stepstool',
    'stick',
    'sticker',
    'stool',
    'stools',
    'storage bin',
    'storage box',
    'storage container',
    'storage organizer',
    'storage shelf',
    'stove',
    'stovetop',
    'structure',
    'studio light',
    'stuffed animal',
    'subwoofer',
    'suitcase',
    'suitcases',
    'sweater',
    'swiffer',
    'switch',
    'table',
    'table lamp',
    'tank',
    'tap',
    'tape',
    'tea kettle',
    'teapot',
    'teddy bear',
    'telephone',
    'telescope',
    'tennis racket',
    'tennis racket bag',
    'thermos',
    'thermostat',
    'tire',
    'tissue box',
    'toaster',
    'toaster oven',
    'toilet',
    'toilet brush',
    'toilet flush button',
    'toilet paper',
    'toilet paper dispenser',
    'toilet paper holder',
    'toilet paper rolls',
    'toilet seat cover dispenser',
    'toiletry',
    'toolbox',
    'toothbrush',
    'toothpaste',
    'towel',
    'towel rack',
    'towels',
    'toy dinosaur',
    'traffic cone',
    'trash bag',
    'trash bin',
    'trash can',
    'tray',
    'tray rack',
    'tripod',
    'trolley',
    'trunk',
    'tube',
    'tupperware',
    'tv',
    'tv stand',
    'umbrella',
    'urinal',
    'vacuum cleaner',
    'vase',
    'vending machine',
    'vent',
    'wall',
    'wall hanging',
    'wall lamp',
    'wall mounted coat rack',
    'wardrobe',
    'wardrobe cabinet',
    'wardrobe closet',
    'washcloth',
    'washing machine',
    'washing machines',
    'water bottle',
    'water cooler',
    'water fountain',
    'water heater',
    'water pitcher',
    'water softener',
    'wet floor sign',
    'wheel',
    'whiteboard',
    'whiteboard eraser',
    'wig',
    'window',
    'windowsill',
    'workbench',
    'xbox controller',
    'yoga mat'
]
UNIQUE_SR3D_OBJECTS = [
    'armchair',
    'backpack',
    'bag',
    'bar',
    'bathroom stall',
    'bathroom stall door',
    'bathroom vanity',
    'bathtub',
    'bed',
    'bench',
    'blackboard',
    'blanket',
    'blinds',
    'board',
    'book',
    'bookshelf',
    'bottle',
    'box',
    'bulletin board',
    'cabinet',
    'cart',
    'chair',
    'closet',
    'clothes',
    'clothes dryer',
    'clothing',
    'coffee maker',
    'coffee table',
    'computer tower',
    'copier',
    'couch',
    'counter',
    'cup',
    'curtain',
    'desk',
    'door',
    'dresser',
    'end table',
    'file cabinet',
    'fireplace',
    'keyboard',
    'kitchen cabinet',
    'kitchen counter',
    'ladder',
    'lamp',
    'laptop',
    'laundry hamper',
    'light',
    'microwave',
    'mirror',
    'monitor',
    'mouse',
    'nightstand',
    'office chair',
    'ottoman',
    'oven',
    'paper towel dispenser',
    'person',
    'piano',
    'picture',
    'pillow',
    'pipe',
    'plant',
    'printer',
    'projector screen',
    'rack',
    'radiator',
    'rail',
    'recycling bin',
    'refrigerator',
    'shelf',
    'shoes',
    'shower',
    'sign',
    'sink',
    'soap dish',
    'sofa chair',
    'stairs',
    'stool',
    'storage bin',
    'stove',
    'suitcase',
    'table',
    'telephone',
    'toilet',
    'toilet paper',
    'towel',
    'trash can',
    'tv',
    'tv stand',
    'wardrobe closet',
    'washing machine',
    'water cooler',
    'whiteboard',
    'window'
]

SR3D_OBJECTS = [
    'armchair',
    'backpack',
    'bag',
    'bar',
    'bathroom stall',
    'bathroom stall door',
    'bathroom vanity',
    'bathtub',
    'bed',
    'bench',
    'blackboard',
    'blanket',
    'blinds',
    'board',
    'book',
    'books',
    'bookshelf',
    'bottle',
    'box',
    'bulletin board',
    'cabinet',
    'cabinets',
    'cart',
    'chair',
    'closet',
    'clothes',
    'clothes dryer',
    'clothing',
    'coffee maker',
    'coffee table',
    'computer tower',
    'copier',
    'couch',
    'counter',
    'cup',
    'curtain',
    'desk',
    'door',
    'doors',
    'dresser',
    'end table',
    'file cabinet',
    'fireplace',
    'keyboard',
    'kitchen cabinet',
    'kitchen cabinets',
    'kitchen counter',
    'ladder',
    'lamp',
    'laptop',
    'laundry hamper',
    'light',
    'microwave',
    'mirror',
    'monitor',
    'mouse',
    'nightstand',
    'office chair',
    'ottoman',
    'oven',
    'paper towel dispenser',
    'person',
    'piano',
    'picture',
    'pillow',
    'pipe',
    'plant',
    'printer',
    'projector screen',
    'rack',
    'radiator',
    'rail',
    'recycling bin',
    'refrigerator',
    'shelf',
    'shoes',
    'shower',
    'sign',
    'sink',
    'soap dish',
    'sofa chair',
    'staircase',
    'stairs',
    'stool',
    'storage bin',
    'stove',
    'suitcase',
    'table',
    'telephone',
    'toilet',
    'toilet paper',
    'towel',
    'trash can',
    'tv',
    'tv stand',
    'wardrobe closet',
    'washing machine',
    'water cooler',
    'whiteboard',
    'window'
]

RELATIONS = [
    'above',
    'behind',
    'below',
    'beneath',
    'beside',
    'between',
    'close to',
    'closer to',
    'far away from',
    'far from',
    'farthest from',
    'in front of',
    'in the center of',
    'in the middle of',
    'lying on',
    'near',
    'next to',
    'on',
    'on the back of',
    'on the left of',
    'on the left side of',
    'on the right of',
    'on the right side of',
    'on top',
    'on top of',
    'over',
    'supporting',
    'to the left of',
    'to the right of',
    'under',
    'underneath'
]
PROXIMITY_CLOSE_RELS = [
    'beside',
    'close to',
    'closer to',
    'near',
    'next to'
]
PROXIMITY_FAR_RELS = [
    'far away from',
    'far from',
    'farthest from'
]
BETWEENS = [
    'between',
    'in the center of',
    'in the middle of'
]
VIEW_DEP_RELS = [
    'behind',
    'in front of',
    'on the back of',
    'on the left of',
    'on the left side of',
    'on the right of',
    'on the right side of',
    'to the left of',
    'to the right of'
]
OTHER_RELS = [
    'above',
    'below',
    'beneath',
    'lying on',
    'on',
    'on top',
    'on top of',
    'over',
    'supporting',
    'under',
    'underneath'
]
VIEWS = [
    'back',
    'front'
]

REL_ALIASES = {
    'above': 'above',
    'behind': 'behind',
    'below': 'below',
    'beneath': 'below',
    'beside': 'near',
    'between': 'between',
    'close to': 'near',
    'closer to': 'near',
    'far away from': 'far from',
    'far from': 'far from',
    'farthest from': 'far from',
    'in front of': 'in front of',
    'in the center of': 'between',
    'in the middle of': 'between',
    'lying on': 'on',
    'near': 'near',
    'next to': 'near',
    'on': 'on',
    'on the back of': 'behind',
    'on the left of': 'on the left of',
    'on the left side of': 'on the left of',
    'on the right of': 'on the right of',
    'on the right side of': 'on the right of',
    'on top': 'on',
    'on top of': 'on',
    'over': 'above',
    'supporting': 'below',
    'to the left of': 'on the left of',
    'to the right of': 'on the right of',
    'under': 'below',
    'underneath': 'below'
}
UNIQUE_RELATIONS = [
    'above',
    'behind',
    'below',
    'near',
    'between',
    'far from',
    'in front of',
    'on',
    'on the left of',
    'on the right of'
]

UNIQUE_PROXIMITY_CLOSE_RELS = [
    'near',
]
UNIQUE_PROXIMITY_FAR_RELS = [
    'far from',
]
UNIQUE_BETWEENS = [
    'between',
]
UNIQUE_VIEW_DEP_RELS = [
    'behind',
    'in front of',
    'on the left of',
    'on the right of',
]
UNIQUE_OTHER_RELS = [
    'above',
    'below',
    'on',
]
