set -e
## shaping plots
python ./train_gcdkm.py --get-shaped --dataset cora
python ./train_gcdkm.py --get-shaped --dataset roman-empire

## hyperparam searches
for dataset in "cora" "chameleon" "squirrel" "pubmed" "citeseer" "roman-empire" "minesweeper" "tolokers" "amazon-ratings" "arxiv" "reddit"; do
    python ./train_gcdkm.py --kipf-grid-search --dataset $dataset
done
for dataset in "cora" "chameleon" "squirrel" "pubmed" "citeseer" "roman-empire" "minesweeper" "tolokers" "amazon-ratings" "arxiv" "reddit"; do
    python ./train_gcdkm.py --arch-grid-search --dataset $dataset
done
for dataset in "cora" "chameleon" "squirrel" "pubmed" "citeseer" "roman-empire" "minesweeper" "tolokers" "amazon-ratings" "arxiv" "reddit"; do
    python ./train_gcdkm.py --center-search --dataset $dataset
done
for dataset in "cora" "chameleon" "squirrel" "pubmed" "citeseer" "roman-empire" "minesweeper" "tolokers" "amazon-ratings" "arxiv" "reddit"; do
    python ./train_gcdkm.py --Pi-search --dataset $dataset
done
for dataset in "cora" "chameleon" "squirrel" "pubmed" "citeseer" "roman-empire" "minesweeper" "tolokers" "amazon-ratings" "arxiv" "reddit"; do
    python ./train_gcdkm.py --final-acc --dataset $dataset
done
