planetoid_datasets = ['cora', 'citeseer', 'pubmed']
wikipedia_datasets = ['chameleon', 'squirrel']
heterophilous_datasets = ['tolokers', 'minesweeper', 'amazon-ratings', 'roman-empire']
bigger_datasets = ['reddit', 'arxiv']
all_datasets = planetoid_datasets + wikipedia_datasets + heterophilous_datasets + bigger_datasets

dataset_to_default_split = {x: 'public' for x in planetoid_datasets}
dataset_to_default_split = {**dataset_to_default_split, **{x: 'test-0-0' for x in wikipedia_datasets}}
dataset_to_default_split = {**dataset_to_default_split, **{x: 'test-0-0' for x in heterophilous_datasets}}
dataset_to_default_split = {**dataset_to_default_split, **{x: 'test-0-0' for x in bigger_datasets}}

correct_names = {'cora': 'Cora', 'citeseer': 'CiteSeer', 'pubmed': 'PubMed',
                 'chameleon': 'chameleon', 'squirrel': 'squirrel',
                 'roman-empire': 'roman-empire', 'tolokers': 'tolokers',
                 'minesweeper': 'minesweeper', 'amazon-ratings': 'amazon-ratings',
                 'reddit': 'reddit',
                 'arxiv': 'arxiv'}

plot_names = {
    'cora': 'Cora', 'citeseer': 'Citeseer', 'pubmed': 'Pubmed',
    'chameleon': 'Chameleon', 'squirrel': 'Squirrel',
    'roman-empire': 'Roman Empire', 'tolokers': 'Tolokers',
    'minesweeper': 'Minesweeper', 'amazon-ratings': 'Amazon Ratings',
    'reddit': 'Reddit', 'arxiv': 'Arxiv'
}
homophily_map = {
    'cora': 0.81, 'pubmed': 0.8, 'reddit': 0.76,
    'citeseer': 0.74, 'minesweeper':0.68, 'arxiv': 0.65,
    'tolokers': 0.6, 'amazon-ratings': 0.38, 'chameleon': 0.24,
    'squirrel':0.22, 'roman-empire':0.05
}

best_kipf =  {
 'amazon-ratings': {'dof': 0.01, 'mixup_scheme': 'fixed-full'},
 'arxiv': {'dof': 0.01, 'mixup_scheme': 'fixed-full'},
 'chameleon': {'dof': 0.1, 'mixup_scheme': 'fixed-indep'},
 'citeseer': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'},
 'cora': {'dof': 1000.0, 'mixup_scheme': 'fixed-indep'},
 'minesweeper': {'dof': 10.0, 'mixup_scheme': 'fixed-indep'},
 'pubmed': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'},
 'reddit': {'dof': 10.0, 'mixup_scheme': 'fixed-full'},
 'roman-empire': {'dof': 10.0, 'mixup_scheme': 'fixed-full'},
 'squirrel': {'dof': 0.01, 'mixup_scheme': 'fixed-full'},
 'tolokers': {'dof': 1.0, 'mixup_scheme': 'fixed-full'}
}
best_nngp_kipf = {
 'amazon-ratings': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'arxiv': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'chameleon': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'citeseer': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'},
 'cora': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'},
 'minesweeper': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'pubmed': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'},
 'reddit': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'roman-empire': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'squirrel': {'dof': 'inf', 'mixup_scheme': 'fixed-full'},
 'tolokers': {'dof': 'inf', 'mixup_scheme': 'fixed-indep'}
 }


best_arch = {
 'amazon-ratings': {'adj_lambda': 0.0, 'model': 'kipf'},
 'arxiv': {'adj_lambda': 0.0, 'model': 'res'},
 'chameleon': {'adj_lambda': 0.0, 'model': 'kipf'},
 'citeseer': {'adj_lambda': 0.0, 'model': 'kipf'},
 'cora': {'adj_lambda': 0.1, 'model': 'kipf'},
 'minesweeper': {'adj_lambda': 0.0, 'model': 'res'},
 'pubmed': {'adj_lambda': 0.0, 'model': 'kipf'},
 'reddit': {'adj_lambda': 0.0, 'model': 'kipfres'},
 'roman-empire': {'adj_lambda': 0.0, 'model': 'kipfres'},
#  'squirrel': {'adj_lambda': 0.0, 'model': 'res'},
 'squirrel': {'model': 'kipf', 'adj_lambda': 0.}, ## use second best model, kipf
                                                  ## for numerical stability reasons
 'tolokers': {'adj_lambda': 0.0, 'model': 'res'}
}

best_nngp_arch = {
 'amazon-ratings': {'adj_lambda': 0.0, 'model': 'kipf'},
 'arxiv': {'adj_lambda': 0.1, 'model': 'kipf'},
 'chameleon': {'adj_lambda': 0.0, 'model': 'kipf'},
 'citeseer': {'adj_lambda': 0.0, 'model': 'kipf'},
 'cora': {'adj_lambda': 0.1, 'model': 'kipf'},
 'minesweeper': {'adj_lambda': 0.0, 'model': 'kipfres'},
 'pubmed': {'adj_lambda': 0.0, 'model': 'kipf'},
 'reddit': {'adj_lambda': 0.0, 'model': 'kipf'},
 'roman-empire': {'adj_lambda': 0.0, 'model': 'kipfres'},
 'squirrel': {'adj_lambda': 0.5, 'model': 'kipf'},
 'tolokers': {'adj_lambda': 0.0, 'model': 'kipfres'}
}

best_center = {
 'amazon-ratings': {'center': 'batch', 'center_learned': True},
 'arxiv': {'center': 'batch', 'center_learned': True},
 'chameleon': {'center': 'batch', 'center_learned': True},
 'citeseer': {'center': 'id', 'center_learned': False},
 'cora': {'center': 'id', 'center_learned': False},
 'minesweeper': {'center': 'batch', 'center_learned': False},
 'pubmed': {'center': 'id', 'center_learned': False},
 'reddit': {'center': 'batch', 'center_learned': True},
 'roman-empire': {'center': 'batch', 'center_learned': False},
 'squirrel': {'center': 'batch', 'center_learned': True},
 'tolokers': {'center': 'id', 'center_learned': False}
}

best_nngp_center = {
 'amazon-ratings': {'center': 'batch', 'center_learned': True},
 'arxiv': {'center': 'batch', 'center_learned': True},
 'chameleon': {'center': 'batch', 'center_learned': True},
 'citeseer': {'center': 'id', 'center_learned': False},
 'cora': {'center': 'id', 'center_learned': False},
 'minesweeper': {'center': 'id', 'center_learned': True},
 'pubmed': {'center': 'id', 'center_learned': False},
 'reddit': {'center': 'batch', 'center_learned': True},
 'roman-empire': {'center': 'batch', 'center_learned': True},
 'squirrel': {'center': 'id', 'center_learned': False},
 'tolokers': {'center': 'batch', 'center_learned': True}
}

best_Pi = {
 'amazon-ratings': {'Pi': 400},
 'arxiv': {'Pi': 300},
 'chameleon': {'Pi': 100},
 'citeseer': {'Pi': 400},
 'cora': {'Pi': 100},
 'minesweeper': {'Pi': 200},
 'pubmed': {'Pi': 400},
 'reddit': {'Pi': 400},
 'roman-empire': {'Pi': 300},
 'squirrel': {'Pi': 400},
 'tolokers': {'Pi': 50}
}

best_nngp_Pi = {
 'amazon-ratings': {'Pi': 400},
 'arxiv': {'Pi': 400},
 'chameleon': {'Pi': 400},
 'citeseer': {'Pi': 400},
 'cora': {'Pi': 100},
 'minesweeper': {'Pi': 300},
 'pubmed': {'Pi': 400},
 'reddit': {'Pi': 400},
 'roman-empire': {'Pi': 400},
 'squirrel': {'Pi': 400},
 'tolokers': {'Pi': 300}}

best_gcn = {
    'reddit': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'minesweeper': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
    'roman-empire': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'squirrel': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'tolokers': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'chameleon': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
    'pubmed': {'normalize_features': True, 'norm': 'none', 'dropout': 0.5, 'nhidden': 100, 'model': 'kipfgcn'},
    'citeseer': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 100, 'model': 'kipfgcn'},
    'amazon-ratings': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'arxiv': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.5, 'nhidden': 200, 'model': 'gcn'},
    'cora': {'normalize_features': True, 'norm': 'none', 'dropout': 0.5, 'nhidden': 100, 'model': 'kipfgcn'}
}

best_gcn_no_dropout = {
 'reddit': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
 'minesweeper': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
 'roman-empire': {'normalize_features': False, 'norm': 'none', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
 'squirrel': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 100, 'model': 'gcn'},
 'tolokers': {'normalize_features': False, 'norm': 'none', 'dropout': 0.0, 'nhidden': 100, 'model': 'gcn'},
 'chameleon': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 200, 'model': 'gcn'},
 'pubmed': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 100, 'model': 'kipfgcn'},
 'citeseer': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 100, 'model': 'kipfgcn'},
 'amazon-ratings': {'normalize_features': False, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 200, 'model': 'kipfgcn'},
 'arxiv': {'normalize_features': True, 'norm': 'batch', 'dropout': 0.0, 'nhidden': 200, 'model': 'kipfgcn'},
 'cora': {'normalize_features': True, 'norm': 'none', 'dropout': 0.0, 'nhidden': 100, 'model': 'kipfgcn'},
}