import ray
from typing import Tuple
import shutil
import tempfile

from envs.hollow_knight.env_wrapper import HKEnv, IndependentActionSpace, LocalAbstractHKEnv


def build_hollow_knight_env(boss_name, obs_size, target_fps) -> Tuple[LocalAbstractHKEnv, IndependentActionSpace]:
    temp_dir = tempfile.mkdtemp()
    shutil.copytree('.', temp_dir, ignore=shutil.ignore_patterns(
        "atari-labeling-tools", "human_play", "runs", "archive_runs",
        "feature_extractor", "segmentation_masks",  "eval_videos", "tmp", "*.log", "*.ipynb", "*.sh", "*.h5",
        ".git"
    ), dirs_exist_ok=True) # TODO: perhaps should select what to copy rather than what to ignore
    ray.init(runtime_env={"working_dir": temp_dir})

    env = HKEnv.remote(boss_name=boss_name, obs_size=obs_size, target_fps=target_fps)
    local_env_wrapper = LocalAbstractHKEnv(env)
    action_space = IndependentActionSpace(["w", "a", "s", "d", "j", "k", "l", "i"]) # TODO: sync with HKEnv?
    return local_env_wrapper, action_space